/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.as3;

import flash.util.Trace;
import flex2.compiler.CompilationUnit;
import flex2.compiler.Source;
import flex2.compiler.Transcoder;
import flex2.compiler.TranscoderException;
import flex2.compiler.common.LocalFilePathResolver;
import flex2.compiler.common.PathResolver;
import flex2.compiler.common.SinglePathResolver;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.util.MimeMappings;
import flex2.compiler.util.ThreadLocalToolkit;
import java.util.Iterator;
import java.util.Map;

public class EmbedUtil {
    static final /* synthetic */ boolean $assertionsDisabled;

    public static Transcoder.TranscodingResults transcode(Transcoder[] transcoders, CompilationUnit unit, String className, Map args, int line, int col, boolean generateCode) throws TranscoderException {
        PathResolver context = new PathResolver();
        Transcoder.TranscodingResults results = null;
        Source source = unit.getSource();
        if (!args.containsKey("_resolvedSource")) {
            String embedSource = (String)args.get("source");
            if (embedSource != null && embedSource.charAt(0) == '/') {
                Object owner;
                VirtualFile pathRoot = source.getPathRoot();
                if (pathRoot != null) {
                    context.addSinglePathResolver(pathRoot);
                }
                if ((owner = source.getOwner()) instanceof SinglePathResolver) {
                    context.addSinglePathResolver((SinglePathResolver)owner);
                }
            } else {
                VirtualFile backingFile;
                if (args.containsKey("_file")) {
                    VirtualFile contextFile;
                    String path = (String)args.get("_file");
                    String pathSep = (String)args.get("_pathsep");
                    if ("true".equals(pathSep)) {
                        path = path.replace('/', '\\');
                    }
                    if ((contextFile = LocalFilePathResolver.getSingleton().resolve(path)) != null && !contextFile.getName().equals(source.getName())) {
                        context.addSinglePathResolver(contextFile);
                    }
                }
                if ((backingFile = source.getBackingFile()) != null) {
                    context.addSinglePathResolver(backingFile);
                }
            }
            context.addSinglePathResolver(ThreadLocalToolkit.getPathResolver());
        }
        if (unit.getAssets().get(className) == null) {
            results = EmbedUtil.transcode(transcoders, className, args, line, col, generateCode, source, context);
            if (results != null && results.defineTag != null) {
                unit.getAssets().add(className, results.assetSource, results.defineTag, results.modified);
            }
        } else if (!$assertionsDisabled) {
            throw new AssertionError((Object)("Asset already added for " + className));
        }
        return results;
    }

    public static Transcoder.TranscodingResults transcode(Transcoder[] transcoders, String className, Map args, int line, int col, boolean generateCode, Source s, PathResolver context) throws TranscoderException {
        String request = EmbedUtil.formatTranscodeRequest(args);
        Transcoder.TranscodingResults results = null;
        String mimeType = (String)args.get("mimeType");
        String origin = (String)args.get("_file");
        String pathSep = (String)args.get("_pathsep");
        if ("true".equals(pathSep)) {
            origin = origin.replace('/', '\\');
        }
        String nameForReporting = "";
        long mem = -1L;
        if (Trace.embed) {
            Trace.trace((String)("Transcoding " + request));
            if (ThreadLocalToolkit.getBenchmark() != null) {
                ThreadLocalToolkit.getBenchmark().startTime("Transcoded " + request);
                mem = ThreadLocalToolkit.getBenchmark().peakMemoryUsage(false);
            }
        }
        try {
            if (s != null) {
                if (origin == null) {
                    origin = s.getName();
                }
                nameForReporting = s.getNameForReporting();
            }
            if (mimeType == null && args.containsKey("source")) {
                String source = (String)args.get("source");
                mimeType = MimeMappings.getMimeType(source);
            }
            if (mimeType == null) {
                TranscoderException.UnrecognizedExtension e = new TranscoderException.UnrecognizedExtension(request);
                e.path = nameForReporting;
                e.line = line;
                e.column = col;
                ThreadLocalToolkit.log(e);
                return null;
            }
            Transcoder t = EmbedUtil.getTranscoder(transcoders, mimeType);
            if (t == null) {
                TranscoderException.NoMatchingTranscoder e = new TranscoderException.NoMatchingTranscoder(mimeType);
                e.path = nameForReporting;
                e.line = line;
                ThreadLocalToolkit.log(e);
            } else {
                if (!args.containsKey("symbol") && !args.containsKey("exportSymbol")) {
                    args.put("exportSymbol", className);
                }
                results = t.transcode(context, args, className, generateCode);
            }
        }
        catch (TranscoderException te) {
            te.path = origin;
            te.line = line;
            te.column = col;
            throw te;
        }
        if (Trace.embed) {
            if (ThreadLocalToolkit.getBenchmark() != null) {
                ThreadLocalToolkit.getBenchmark().stopTime("Transcoded " + request);
            }
            if (mem != -1L && ThreadLocalToolkit.getBenchmark() != null) {
                long endMem = ThreadLocalToolkit.getBenchmark().peakMemoryUsage(false);
                Trace.trace((String)("Increase in peak memory from transcoding: " + (endMem - mem) + " MB"));
            }
        }
        return results;
    }

    public static Transcoder getTranscoder(Transcoder[] transcoders, String mimeType) {
        if (!$assertionsDisabled && transcoders == null) {
            throw new AssertionError();
        }
        for (int i = 0; i < transcoders.length; ++i) {
            if (!transcoders[i].isSupported(mimeType)) continue;
            return transcoders[i];
        }
        return null;
    }

    public static String formatTranscodeRequest(Map args) {
        String s = (String)args.get("source");
        if (s != null) {
            return s;
        }
        s = "[";
        Iterator it = args.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e = it.next();
            s = s + e.getKey() + "='" + e.getValue() + "'";
            if (!it.hasNext()) continue;
            s = s + ", ";
        }
        s = s + "]";
        return s;
    }

    static {
        $assertionsDisabled = !EmbedUtil.class.desiredAssertionStatus();
    }
}

