/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler;

import flash.localization.LocalizationManager;
import flash.swf.Frame;
import flash.swf.Movie;
import flash.swf.MovieDecoder;
import flash.swf.MovieEncoder;
import flash.swf.TagDecoder;
import flash.swf.TagEncoder;
import flash.swf.TagHandler;
import flash.swf.tags.DefineTag;
import flash.swf.types.Rect;
import flex2.compiler.CompilationUnit;
import flex2.compiler.Context;
import flex2.compiler.FileSpec;
import flex2.compiler.ResourceBundlePath;
import flex2.compiler.ResourceContainer;
import flex2.compiler.Source;
import flex2.compiler.SourceList;
import flex2.compiler.SourcePath;
import flex2.compiler.common.PathResolver;
import flex2.compiler.io.DeletedFile;
import flex2.compiler.io.FileUtil;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.IntegerPool;
import flex2.compiler.util.LocalLogger;
import flex2.compiler.util.MultiName;
import flex2.compiler.util.QName;
import flex2.compiler.util.ThreadLocalToolkit;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

final class PersistenceStore {
    private static final int major_version = 2;
    private static final int minor_version = 27;
    private final RandomAccessFile file;
    private final ArrayKey key;
    static final /* synthetic */ boolean $assertionsDisabled;

    PersistenceStore(RandomAccessFile file) {
        if (!$assertionsDisabled && file == null) {
            throw new AssertionError();
        }
        this.file = file;
        this.key = new ArrayKey();
    }

    int write(FileSpec fileSpec, SourceList sourceList, SourcePath sourcePath, ResourceContainer resources, ResourceBundlePath bundlePath, int checksum, String description) throws IOException {
        HashMap pool = new HashMap();
        ByteArrayOutputStream fs = new ByteArrayOutputStream();
        ByteArrayOutputStream sl = new ByteArrayOutputStream();
        ByteArrayOutputStream sp = new ByteArrayOutputStream();
        ByteArrayOutputStream rbp = new ByteArrayOutputStream();
        ByteArrayOutputStream src = new ByteArrayOutputStream();
        ByteArrayOutputStream cu = new ByteArrayOutputStream();
        ByteArrayOutputStream cp = new ByteArrayOutputStream();
        ByteArrayOutputStream h = new ByteArrayOutputStream();
        this.writeHeader(checksum, description, h);
        if (fileSpec != null) {
            this.writeFileSpec(fileSpec, pool, fs);
        }
        if (sourceList != null) {
            this.writeSourceList(sourceList, pool, sl);
        }
        if (sourcePath != null) {
            this.writeSourcePath(sourcePath, pool, sp);
        }
        if (bundlePath != null) {
            this.writeSourcePath(bundlePath, pool, rbp);
        }
        Collection c1 = fileSpec == null ? Collections.EMPTY_LIST : fileSpec.sources();
        Collection c2 = sourceList == null ? Collections.EMPTY_LIST : sourceList.sources();
        Map c3 = sourcePath == null ? Collections.EMPTY_MAP : sourcePath.sources();
        Collection c4 = resources == null ? Collections.EMPTY_LIST : resources.sources();
        Map c5 = bundlePath == null ? Collections.EMPTY_MAP : bundlePath.sources();
        int src_count = c1.size() + c2.size() + c3.size() + c4.size() + c5.size();
        this.writeCompilationUnits(c1, pool, src, cu);
        this.writeCompilationUnits(c2, pool, src, cu);
        this.writeCompilationUnits(c3.values(), pool, src, cu);
        this.writeCompilationUnits(c5.values(), pool, src, cu);
        this.writeCompilationUnits(c4, pool, src, cu);
        this.writeConstantPool(pool, cp);
        this.file.write(h.toByteArray());
        this.file.writeInt(cp.size());
        this.file.write(cp.toByteArray());
        this.file.writeInt(fs.size());
        this.file.write(fs.toByteArray());
        this.file.writeInt(sl.size());
        this.file.write(sl.toByteArray());
        this.file.writeInt(sp.size());
        this.file.write(sp.toByteArray());
        this.file.writeInt(rbp.size());
        this.file.write(rbp.toByteArray());
        this.file.writeInt(src_count);
        this.file.writeInt(src.size());
        this.file.writeInt(cu.size());
        this.file.write(src.toByteArray());
        this.file.write(cu.toByteArray());
        return src_count;
    }

    private void writeHeader(int checksum, String description, OutputStream out) throws IOException {
        this.writeU32(out, 2);
        this.writeU32(out, 27);
        this.writeU32(out, checksum);
        byte[] b = description.getBytes("UTF8");
        this.writeU32(out, b.length);
        this.writeBytes(out, b);
    }

    private void writeConstantPool(Map pool, OutputStream out) throws IOException {
        TreeMap map = new TreeMap();
        Iterator i = pool.keySet().iterator();
        while (i.hasNext()) {
            Object key = i.next();
            Object value = pool.get(key);
            map.put(value, key);
        }
        this.writeU32(out, map.size());
        i = map.keySet().iterator();
        while (i.hasNext()) {
            int j;
            byte[] b;
            Object value = map.get(i.next());
            if (value instanceof String) {
                this.writeU8(out, 1);
                b = ((String)value).getBytes("UTF8");
                this.writeU32(out, b.length);
                this.writeBytes(out, b);
                continue;
            }
            if (value instanceof ArrayKey) {
                int size;
                this.writeU8(out, 2);
                String[] a = ((ArrayKey)value).a1;
                this.writeU32(out, a == null ? 0 : a.length);
                int n = size = a == null ? 0 : a.length;
                for (j = 0; j < size; ++j) {
                    this.writeU32(out, this.addString(pool, a[j]));
                }
                continue;
            }
            if (value instanceof byte[]) {
                this.writeU8(out, 3);
                b = (byte[])value;
                this.writeU32(out, b.length);
                if (b.length <= 0) continue;
                this.writeBytes(out, b);
                continue;
            }
            if (value instanceof QName) {
                this.writeU8(out, 4);
                QName qName = (QName)value;
                this.writeU32(out, this.addString(pool, qName.getNamespace()));
                this.writeU32(out, this.addString(pool, qName.getLocalPart()));
                continue;
            }
            if (value instanceof MultiName) {
                this.writeU8(out, 5);
                MultiName multiName = (MultiName)value;
                this.writeU32(out, this.addStrings(pool, multiName.namespaceURI));
                this.writeU32(out, this.addString(pool, multiName.localPart));
                continue;
            }
            if (value instanceof flex2.compiler.abc.MetaData) {
                this.writeU8(out, 6);
                flex2.compiler.abc.MetaData md = (flex2.compiler.abc.MetaData)value;
                this.writeU32(out, this.addString(pool, md.getID()));
                this.writeU32(out, md.count());
                int count = md.count();
                for (j = 0; j < count; ++j) {
                    String key = md.getKey(j);
                    String val = md.getValue(j);
                    this.writeU32(out, this.addString(pool, key == null ? "" : key));
                    this.writeU32(out, this.addString(pool, val));
                }
                continue;
            }
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }
    }

    private void writeFileSpec(FileSpec fileSpec, Map pool, OutputStream fs) throws IOException {
        String[] mimeTypes = fileSpec.getMimeTypes();
        Collection sources = fileSpec.sources();
        this.writeU32(fs, mimeTypes.length);
        int length = mimeTypes.length;
        for (int i = 0; i < length; ++i) {
            this.writeU32(fs, this.addString(pool, mimeTypes[i]));
        }
        this.writeU32(fs, sources.size());
        Iterator i = sources.iterator();
        while (i.hasNext()) {
            Source s = (Source)i.next();
            this.writeU32(fs, this.addString(pool, s.getName()));
        }
    }

    private void writeSourceList(SourceList sourceList, Map pool, OutputStream sl) throws IOException {
        int i;
        String[] mimeTypes = sourceList.getMimeTypes();
        List paths = sourceList.getPaths();
        Collection sources = sourceList.sources();
        this.writeU32(sl, mimeTypes.length);
        int length = mimeTypes.length;
        for (i = 0; i < length; ++i) {
            this.writeU32(sl, this.addString(pool, mimeTypes[i]));
        }
        this.writeU32(sl, paths.size());
        length = paths.size();
        for (i = 0; i < length; ++i) {
            this.writeU32(sl, this.addString(pool, FileUtil.getCanonicalPath((File)paths.get(i))));
        }
        this.writeU32(sl, sources.size());
        Iterator i2 = sources.iterator();
        while (i2.hasNext()) {
            Source s = (Source)i2.next();
            this.writeU32(sl, this.addString(pool, s.getName()));
        }
    }

    private void writeSourcePath(SourcePath sourcePath, Map pool, OutputStream sp) throws IOException {
        int i;
        String[] mimeTypes = sourcePath.getMimeTypes();
        List paths = sourcePath.getPaths();
        Map sources = sourcePath.sources();
        this.writeU32(sp, mimeTypes.length);
        int length = mimeTypes.length;
        for (i = 0; i < length; ++i) {
            this.writeU32(sp, this.addString(pool, mimeTypes[i]));
        }
        this.writeU32(sp, paths.size());
        length = paths.size();
        for (i = 0; i < length; ++i) {
            this.writeU32(sp, this.addString(pool, FileUtil.getCanonicalPath((File)paths.get(i))));
        }
        this.writeU32(sp, sources.size());
        Iterator i2 = sources.keySet().iterator();
        while (i2.hasNext()) {
            String className = (String)i2.next();
            Source s = (Source)sources.get(className);
            this.writeU32(sp, this.addString(pool, className));
            this.writeU32(sp, this.addString(pool, s.getName()));
        }
    }

    private void writeCompilationUnits(Collection sources, Map pool, OutputStream src, OutputStream cu) throws IOException {
        Iterator i = sources.iterator();
        while (i.hasNext()) {
            Source s = (Source)i.next();
            this.writeSource(s, pool, src);
            CompilationUnit u = s.getCompilationUnit();
            if (u == null) continue;
            this.writeCompilationUnit(u, pool, cu);
        }
    }

    private void writeSource(Source s, Map pool, OutputStream src) throws IOException {
        int size;
        this.writeU32(src, this.addString(pool, s.getName()));
        this.writeU32(src, this.addString(pool, s.getRelativePath()));
        if (s.isFileSpecOwner()) {
            this.writeU8(src, 0);
        } else if (s.isSourceListOwner()) {
            this.writeU8(src, 1);
            this.writeU32(src, this.addString(pool, s.getPathRoot().getName()));
        } else if (s.isSourcePathOwner()) {
            this.writeU8(src, 2);
            this.writeU32(src, this.addString(pool, s.getPathRoot().getName()));
        } else if (s.isResourceContainerOwner()) {
            this.writeU8(src, 3);
        } else {
            this.writeU8(src, 4);
            this.writeU32(src, this.addString(pool, s.getPathRoot().getName()));
        }
        this.writeU8(src, s.isInternal() ? 1 : 0);
        this.writeU8(src, s.isRoot() ? 1 : 0);
        this.writeU8(src, s.isDebuggable() ? 1 : 0);
        this.writeU8(src, s.getCompilationUnit() != null ? 1 : 0);
        this.writeLong(src, s.getFileTime());
        this.writeU32(src, s.getFileIncludeSize());
        Iterator j = s.getFileIncludes();
        while (j.hasNext()) {
            VirtualFile f = (VirtualFile)j.next();
            this.writeU32(src, this.addString(pool, f.getName()));
            this.writeLong(src, s.getFileIncludeTime(f));
        }
        List warnings = null;
        if (s.getLogger() != null && (warnings = s.getLogger().getWarnings()) != null) {
            this.writeU32(src, warnings.size());
        } else {
            this.writeU32(src, 0);
        }
        int n = size = warnings == null ? 0 : warnings.size();
        for (int i = 0; i < size; ++i) {
            LocalLogger.Warning w = (LocalLogger.Warning)warnings.get(i);
            this.writeU32(src, this.addString(pool, w.path == null ? "" : w.path));
            this.writeU32(src, this.addString(pool, w.warning == null ? "" : w.warning));
            this.writeU32(src, this.addString(pool, w.source == null ? "" : w.source));
            this.writeU32(src, w.line == null ? -1 : w.line);
            this.writeU32(src, w.col == null ? -1 : w.col);
            this.writeU32(src, w.errorCode == null ? -1 : w.errorCode);
        }
    }

    private void writeCompilationUnit(CompilationUnit u, Map pool, OutputStream cu) throws IOException {
        QName qName;
        MultiName multiName;
        this.writeU32(cu, this.addBytes(pool, u.bytes.toByteArray()));
        this.writeU32(cu, u.getWorkflow());
        this.writeU32(cu, u.getState());
        this.writeU32(cu, u.topLevelDefinitions.size());
        Iterator i = u.topLevelDefinitions.iterator();
        while (i.hasNext()) {
            this.writeU32(cu, this.addQName(pool, (QName)i.next()));
        }
        this.writeU32(cu, u.inheritanceHistory.size());
        i = u.inheritanceHistory.keySet().iterator();
        while (i.hasNext()) {
            multiName = (MultiName)i.next();
            qName = (QName)u.inheritanceHistory.get(multiName);
            this.writeU32(cu, this.addMultiName(pool, multiName));
            this.writeU32(cu, this.addQName(pool, qName));
        }
        this.writeU32(cu, u.typeHistory.size());
        i = u.typeHistory.keySet().iterator();
        while (i.hasNext()) {
            multiName = (MultiName)i.next();
            qName = (QName)u.typeHistory.get(multiName);
            this.writeU32(cu, this.addMultiName(pool, multiName));
            this.writeU32(cu, this.addQName(pool, qName));
        }
        this.writeU32(cu, u.namespaceHistory.size());
        i = u.namespaceHistory.keySet().iterator();
        while (i.hasNext()) {
            multiName = (MultiName)i.next();
            qName = (QName)u.namespaceHistory.get(multiName);
            this.writeU32(cu, this.addMultiName(pool, multiName));
            this.writeU32(cu, this.addQName(pool, qName));
        }
        this.writeU32(cu, u.expressionHistory.size());
        i = u.expressionHistory.keySet().iterator();
        while (i.hasNext()) {
            multiName = (MultiName)i.next();
            qName = (QName)u.expressionHistory.get(multiName);
            this.writeU32(cu, this.addMultiName(pool, multiName));
            this.writeU32(cu, this.addQName(pool, qName));
        }
        if (u.auxGenerateInfo != null && u.auxGenerateInfo.size() > 0) {
            this.writeU8(cu, 1);
            String baseLoaderClass = (String)u.auxGenerateInfo.get("baseLoaderClass");
            this.writeU32(cu, this.addString(pool, baseLoaderClass == null ? "" : baseLoaderClass));
            String generateLoaderClass = (String)u.auxGenerateInfo.get("generateLoaderClass");
            this.writeU32(cu, this.addString(pool, generateLoaderClass == null ? "" : generateLoaderClass));
            String className = (String)u.auxGenerateInfo.get("windowClass");
            this.writeU32(cu, this.addString(pool, className == null ? "" : className));
            String preLoader = (String)u.auxGenerateInfo.get("preloaderClass");
            this.writeU32(cu, this.addString(pool, preLoader == null ? "" : preLoader));
            Boolean usePreloader = (Boolean)u.auxGenerateInfo.get("usePreloader");
            this.writeU8(cu, usePreloader != false ? 1 : 0);
            Map rootAttributeMap = (Map)u.auxGenerateInfo.get("rootAttributes");
            this.writeU32(cu, rootAttributeMap.size());
            Iterator i2 = rootAttributeMap.keySet().iterator();
            while (i2.hasNext()) {
                String key = (String)i2.next();
                String value = (String)rootAttributeMap.get(key);
                if (value != null) {
                    this.writeU32(cu, this.addString(pool, key));
                    this.writeU32(cu, this.addString(pool, value));
                    continue;
                }
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)(key + " can't be null."));
                }
            }
        } else {
            this.writeU8(cu, 0);
        }
        this.writeAssets(u, pool, cu);
    }

    private void writeAssets(CompilationUnit u, Map pool, OutputStream cu) throws IOException {
        int size = u.getAssets().count();
        this.writeU32(cu, size);
        if (size > 0) {
            Movie movie = new Movie();
            movie.version = 9;
            movie.size = new Rect(2000, 2000);
            movie.framerate = 12;
            Frame frame = new Frame();
            movie.frames = new ArrayList();
            movie.frames.add(frame);
            this.writeU32(cu, u.getAssets().count());
            Iterator i = u.getAssets().names();
            while (i.hasNext()) {
                String className = (String)i.next();
                VirtualFile path = u.getAssets().getPath(className);
                DefineTag asset = u.getAssets().get(className);
                long ts = u.getAssets().getCreationTime(className);
                this.writeU32(cu, this.addString(pool, className));
                if (path != null) {
                    this.writeU32(cu, this.addString(pool, path.getName()));
                } else {
                    this.writeU32(cu, this.addString(pool, ""));
                }
                this.writeLong(cu, ts);
                frame.addSymbolClass(className, asset);
                if (asset.name == null) continue;
                frame.addExport(asset);
            }
            TagEncoder handler = new TagEncoder();
            MovieEncoder encoder = new MovieEncoder((TagHandler)handler);
            encoder.export(movie);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            handler.writeTo((OutputStream)baos);
            this.writeU32(cu, baos.size());
            this.writeBytes(cu, baos.toByteArray());
        }
    }

    int read(FileSpec fileSpec, SourceList sourceList, SourcePath sourcePath, ResourceContainer resources, ResourceBundlePath bundlePath, int checksum) throws IOException {
        if (!this.readVersion()) {
            LocalizationManager l10n = ThreadLocalToolkit.getLocalizationManager();
            throw new IOException(l10n.getLocalizedTextString((Object)new ObsoleteCacheFileFormat()));
        }
        if (!this.readChecksum(checksum)) {
            return -1;
        }
        Object[] pool = this.readConstantPool();
        if (!this.readFileSpec(pool, fileSpec)) {
            return -2;
        }
        if (!this.readSourceList(pool, sourceList)) {
            return -3;
        }
        if (!this.readSourcePath(pool, sourcePath)) {
            return -4;
        }
        if (!this.readSourcePath(pool, bundlePath)) {
            return -5;
        }
        int count = this.readCompilationUnits(pool, fileSpec, sourceList, sourcePath, resources, bundlePath);
        resources.refresh();
        return count;
    }

    private boolean readVersion() throws IOException {
        int major = this.readU32();
        int minor = this.readU32();
        return major == 2 && minor == 27;
    }

    private boolean readChecksum(int checksum) throws IOException {
        int targetChecksum = this.readU32();
        new String(this.readBytes(this.readU32()));
        return checksum == targetChecksum;
    }

    private Object[] readConstantPool() throws IOException {
        this.readU32();
        Object[] pool = new Object[this.readU32()];
        block8: for (int i = 0; i < pool.length; ++i) {
            switch (this.readU8()) {
                case 1: {
                    pool[i] = new String(this.readBytes(this.readU32()), "UTF8");
                    continue block8;
                }
                case 2: {
                    String[] strings = new String[this.readU32()];
                    for (int j = 0; j < strings.length; ++j) {
                        strings[j] = (String)pool[this.readU32()];
                    }
                    pool[i] = strings;
                    continue block8;
                }
                case 3: {
                    pool[i] = this.readBytes(this.readU32());
                    continue block8;
                }
                case 4: {
                    pool[i] = new QName((String)pool[this.readU32()], (String)pool[this.readU32()]);
                    continue block8;
                }
                case 5: {
                    pool[i] = new MultiName((String[])pool[this.readU32()], (String)pool[this.readU32()]);
                    continue block8;
                }
                case 6: {
                    MetaData md = new MetaData((String)pool[this.readU32()], this.readU32());
                    for (int j = 0; j < md.count(); ++j) {
                        String key = (String)pool[this.readU32()];
                        if (key.length() > 0) {
                            md.setKeyValue(j, key, (String)pool[this.readU32()]);
                            continue;
                        }
                        md.setValue(j, (String)pool[this.readU32()]);
                    }
                    pool[i] = md;
                    continue block8;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    continue block8;
                }
            }
        }
        return pool;
    }

    private boolean readFileSpec(Object[] pool, FileSpec fileSpec) throws IOException {
        int size = this.readU32();
        if (size > 0 && fileSpec == null) {
            LocalizationManager l10n = ThreadLocalToolkit.getLocalizationManager();
            throw new IOException(l10n.getLocalizedTextString((Object)new NoFileSpec()));
        }
        if (size == 0) {
            return true;
        }
        int length = this.readU32();
        String[] mimeTypes = new String[length];
        for (int i = 0; i < length; ++i) {
            mimeTypes[i] = (String)pool[this.readU32()];
        }
        length = this.readU32();
        String[] sources = new String[length];
        for (int i = 0; i < length; ++i) {
            sources[i] = (String)pool[this.readU32()];
        }
        String[] targetMimeTypes = fileSpec.getMimeTypes();
        length = targetMimeTypes.length;
        if (length == mimeTypes.length) {
            for (int i = 0; i < length; ++i) {
                if (mimeTypes[i].equals(targetMimeTypes[i])) continue;
                return false;
            }
        } else {
            return false;
        }
        Collection c = fileSpec.sources();
        if (c.size() == sources.length) {
            Iterator it = c.iterator();
            for (int i = 0; it.hasNext() && i < sources.length; ++i) {
                Source s = (Source)it.next();
                if (s.getName().equals(sources[i])) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private boolean readSourceList(Object[] pool, SourceList sourceList) throws IOException {
        int size = this.readU32();
        if (size > 0 && sourceList == null) {
            LocalizationManager l10n = ThreadLocalToolkit.getLocalizationManager();
            throw new IOException(l10n.getLocalizedTextString((Object)new NoSourceList()));
        }
        if (size == 0) {
            return true;
        }
        int length = this.readU32();
        String[] mimeTypes = new String[length];
        for (int i = 0; i < length; ++i) {
            mimeTypes[i] = (String)pool[this.readU32()];
        }
        length = this.readU32();
        String[] paths = new String[length];
        for (int i = 0; i < length; ++i) {
            paths[i] = (String)pool[this.readU32()];
        }
        length = this.readU32();
        String[] sources = new String[length];
        for (int i = 0; i < length; ++i) {
            sources[i] = (String)pool[this.readU32()];
        }
        String[] targetMimeTypes = sourceList.getMimeTypes();
        length = targetMimeTypes.length;
        if (length == mimeTypes.length) {
            for (int i = 0; i < length; ++i) {
                if (mimeTypes[i].equals(targetMimeTypes[i])) continue;
                return false;
            }
        } else {
            return false;
        }
        Collection c = sourceList.sources();
        if (c.size() == sources.length) {
            Iterator it = c.iterator();
            for (int i = 0; it.hasNext() && i < sources.length; ++i) {
                Source s = (Source)it.next();
                if (s.getName().equals(sources[i])) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private boolean readSourcePath(Object[] pool, SourcePath sourcePath) throws IOException {
        int size = this.readU32();
        if (size > 0 && sourcePath == null) {
            LocalizationManager l10n = ThreadLocalToolkit.getLocalizationManager();
            throw new IOException(l10n.getLocalizedTextString((Object)new NoSourcePath()));
        }
        if (size == 0) {
            return true;
        }
        int length = this.readU32();
        String[] mimeTypes = new String[length];
        for (int i = 0; i < length; ++i) {
            mimeTypes[i] = (String)pool[this.readU32()];
        }
        length = this.readU32();
        String[] paths = new String[length];
        for (int i = 0; i < length; ++i) {
            paths[i] = (String)pool[this.readU32()];
        }
        length = this.readU32();
        String[] sources = new String[length];
        String[] classNames = new String[length];
        for (int i = 0; i < length; ++i) {
            classNames[i] = (String)pool[this.readU32()];
            sources[i] = (String)pool[this.readU32()];
        }
        String[] targetMimeTypes = sourcePath.getMimeTypes();
        length = targetMimeTypes.length;
        if (length == mimeTypes.length) {
            for (int i = 0; i < length; ++i) {
                if (mimeTypes[i].equals(targetMimeTypes[i])) continue;
                return false;
            }
        } else {
            return false;
        }
        List targetPaths = sourcePath.getPaths();
        length = targetPaths.size();
        if (length == paths.length) {
            for (int i = 0; i < length; ++i) {
                if (paths[i].equals(FileUtil.getCanonicalPath((File)targetPaths.get(i)))) continue;
                return false;
            }
        } else {
            return false;
        }
        Map c = sourcePath.sources();
        if (!$assertionsDisabled && c.size() != 0) {
            throw new AssertionError();
        }
        for (int i = 0; i < classNames.length; ++i) {
            c.put(classNames[i], sources[i]);
        }
        return true;
    }

    private int readCompilationUnits(Object[] pool, FileSpec fileSpec, SourceList sourceList, SourcePath sourcePath, ResourceContainer resources, ResourceBundlePath bundlePath) throws IOException {
        String fileName;
        String className;
        int src_count = this.readU32();
        int src_size = this.readU32();
        int cu_size = this.readU32();
        ByteArrayInputStream src_in = new ByteArrayInputStream(this.readBytes(src_size));
        ByteArrayInputStream cu_in = new ByteArrayInputStream(this.readBytes(cu_size));
        Map m = sourcePath.sources();
        HashMap<String, String> mappings = new HashMap<String, String>();
        HashMap<String, String> rbMappings = new HashMap<String, String>();
        Iterator i = m.keySet().iterator();
        while (i.hasNext()) {
            className = (String)i.next();
            fileName = (String)m.get(className);
            mappings.put(fileName, className);
        }
        m.clear();
        m = bundlePath.sources();
        i = m.keySet().iterator();
        while (i.hasNext()) {
            className = (String)i.next();
            fileName = (String)m.get(className);
            rbMappings.put(fileName, className);
        }
        m.clear();
        for (int i2 = 0; i2 < src_count; ++i2) {
            this.readCompilationUnit(pool, mappings, rbMappings, src_in, cu_in, fileSpec, sourceList, sourcePath, resources, bundlePath);
        }
        return src_count;
    }

    private void readCompilationUnit(Object[] pool, Map mappings, Map rbMappings, InputStream src_in, InputStream cu_in, FileSpec fileSpec, SourceList sourceList, SourcePath sourcePath, ResourceContainer resources, ResourceBundlePath bundlePath) throws IOException {
        String className;
        Iterator i;
        PathResolver resolver = ThreadLocalToolkit.getPathResolver();
        String name = (String)pool[this.readU32(src_in)];
        String relativePath = (String)pool[this.readU32(src_in)];
        int owner = this.readU8(src_in);
        VirtualFile pathRoot = null;
        if (owner == 1 || owner == 2 || owner == 4) {
            pathRoot = resolver.resolve((String)pool[this.readU32(src_in)]);
        }
        boolean isInternal = this.readU8(src_in) == 1;
        boolean isRoot = this.readU8(src_in) == 1;
        boolean isDebuggable = this.readU8(src_in) == 1;
        boolean hasUnit = this.readU8(src_in) == 1;
        long fileTime = this.readLong(src_in);
        int size = this.readU32(src_in);
        HashSet<VirtualFile> includes = new HashSet<VirtualFile>(1);
        HashMap<VirtualFile, Long> includeTimes = new HashMap<VirtualFile, Long>(1);
        for (int i2 = 0; i2 < size; ++i2) {
            String fileName = (String)pool[this.readU32(src_in)];
            VirtualFile f = resolver.resolve(fileName);
            long ts = this.readLong(src_in);
            if (f == null) {
                f = new DeletedFile(fileName);
            }
            includes.add(f);
            includeTimes.put(f, new Long(ts));
        }
        size = this.readU32(src_in);
        LocalLogger logger = size == 0 ? null : new LocalLogger(null);
        for (int i3 = 0; i3 < size; ++i3) {
            String source;
            String warning;
            String path = (String)pool[this.readU32(src_in)];
            if (path.length() == 0) {
                path = null;
            }
            if ((warning = (String)pool[this.readU32(src_in)]).length() == 0) {
                warning = null;
            }
            if ((source = (String)pool[this.readU32(src_in)]).length() == 0) {
                source = null;
            }
            int line = this.readU32(src_in);
            int col = this.readU32(src_in);
            int errorCode = this.readU32(src_in);
            logger.recordWarning(path, line == -1 ? null : IntegerPool.getNumber(line), col == -1 ? null : IntegerPool.getNumber(col), warning, source, errorCode == -1 ? null : IntegerPool.getNumber(errorCode));
        }
        byte[] abc = hasUnit ? (byte[])pool[this.readU32(cu_in)] : null;
        Source s = null;
        if (owner == 0) {
            Collection c = fileSpec.sources();
            i = c.iterator();
            while (i.hasNext()) {
                s = (Source)i.next();
                if (!s.getName().equals(name)) continue;
                Source.populateSource(s, fileTime, pathRoot, relativePath, fileSpec, isInternal, isRoot, isDebuggable, includes, includeTimes, logger);
                break;
            }
        } else if (owner == 1) {
            Collection c = sourceList.sources();
            i = c.iterator();
            while (i.hasNext()) {
                s = (Source)i.next();
                if (!s.getName().equals(name)) continue;
                Source.populateSource(s, fileTime, pathRoot, relativePath, sourceList, isInternal, isRoot, isDebuggable, includes, includeTimes, logger);
                break;
            }
        } else if (owner == 2) {
            Map c = sourcePath.sources();
            className = (String)mappings.get(name);
            if (className != null) {
                VirtualFile f = resolver.resolve(name);
                if (f == null) {
                    f = new DeletedFile(name);
                }
                s = Source.newSource(f, fileTime, pathRoot, relativePath, sourcePath, isInternal, isRoot, isDebuggable, includes, includeTimes, logger);
                c.put(className, s);
            } else if (!$assertionsDisabled) {
                throw new AssertionError((Object)name);
            }
        } else if (owner == 3) {
            if (resources == null) {
                LocalizationManager l10n = ThreadLocalToolkit.getLocalizationManager();
                throw new IOException(l10n.getLocalizedTextString((Object)new NoResourceContainer()));
            }
            s = Source.newSource(abc, name, fileTime, pathRoot, relativePath, resources, isInternal, isRoot, isDebuggable, includes, includeTimes, logger);
            resources.addResource(s);
        } else {
            Map c = bundlePath.sources();
            className = (String)rbMappings.get(name);
            if (className != null) {
                VirtualFile f = resolver.resolve(name);
                if (f == null) {
                    f = new DeletedFile(name);
                }
                s = Source.newSource(f, fileTime, pathRoot, relativePath, bundlePath, isInternal, isRoot, isDebuggable, includes, includeTimes, logger);
                c.put(className, s);
            } else if (!$assertionsDisabled) {
                throw new AssertionError((Object)name);
            }
        }
        if (logger != null) {
            logger.setSource(s);
        }
        if (hasUnit) {
            boolean hasAuxGenerateInfo;
            int i4;
            CompilationUnit u = s.newCompilationUnit(null, new Context());
            u.bytes.addAll(abc);
            u.setWorkflow(this.readU32(cu_in));
            u.setState(this.readU32(cu_in));
            size = this.readU32(cu_in);
            for (i4 = 0; i4 < size; ++i4) {
                u.topLevelDefinitions.add(pool[this.readU32(cu_in)]);
            }
            size = this.readU32(cu_in);
            for (i4 = 0; i4 < size; ++i4) {
                MultiName mName = (MultiName)pool[this.readU32(cu_in)];
                QName qName = (QName)pool[this.readU32(cu_in)];
                u.inheritanceHistory.put(mName, qName);
                u.inheritance.add(qName);
            }
            size = this.readU32(cu_in);
            for (i4 = 0; i4 < size; ++i4) {
                MultiName mName = (MultiName)pool[this.readU32(cu_in)];
                QName qName = (QName)pool[this.readU32(cu_in)];
                u.typeHistory.put(mName, qName);
                u.types.add(qName);
            }
            size = this.readU32(cu_in);
            for (i4 = 0; i4 < size; ++i4) {
                MultiName mName = (MultiName)pool[this.readU32(cu_in)];
                QName qName = (QName)pool[this.readU32(cu_in)];
                u.namespaceHistory.put(mName, qName);
                u.namespaces.add(qName);
            }
            size = this.readU32(cu_in);
            for (i4 = 0; i4 < size; ++i4) {
                MultiName mName = (MultiName)pool[this.readU32(cu_in)];
                QName qName = (QName)pool[this.readU32(cu_in)];
                u.expressionHistory.put(mName, qName);
                u.expressions.add(qName);
            }
            boolean bl = hasAuxGenerateInfo = this.readU8(cu_in) == 1;
            if (hasAuxGenerateInfo) {
                u.auxGenerateInfo = new HashMap();
                String baseLoaderClass = (String)pool[this.readU32(cu_in)];
                u.auxGenerateInfo.put("baseLoaderClass", baseLoaderClass.length() > 0 ? baseLoaderClass : null);
                String generateLoaderClass = (String)pool[this.readU32(cu_in)];
                u.auxGenerateInfo.put("generateLoaderClass", generateLoaderClass.length() > 0 ? generateLoaderClass : null);
                String className2 = (String)pool[this.readU32(cu_in)];
                u.auxGenerateInfo.put("windowClass", className2.length() > 0 ? className2 : null);
                String preLoader = (String)pool[this.readU32(cu_in)];
                u.auxGenerateInfo.put("preloaderClass", preLoader.length() > 0 ? preLoader : null);
                u.auxGenerateInfo.put("usePreloader", new Boolean(this.readU8(cu_in) == 1));
                HashMap<String, String> rootAttributeMap = new HashMap<String, String>();
                u.auxGenerateInfo.put("rootAttributes", rootAttributeMap);
                size = this.readU32(cu_in);
                for (int i5 = 0; i5 < size; ++i5) {
                    String key = (String)pool[this.readU32(cu_in)];
                    String value = (String)pool[this.readU32(cu_in)];
                    rootAttributeMap.put(key, value);
                }
            }
            this.readAssets(pool, u, cu_in);
        }
    }

    private void readAssets(Object[] pool, CompilationUnit u, InputStream cu_in) throws IOException {
        int size = this.readU32(cu_in);
        if (size > 0) {
            int assetCount = this.readU32(cu_in);
            HashMap<String, VirtualFile> assetPaths = new HashMap<String, VirtualFile>();
            HashMap<String, Long> assetCreationTimes = new HashMap<String, Long>();
            PathResolver resolver = ThreadLocalToolkit.getPathResolver();
            for (int i = 0; i < assetCount; ++i) {
                String className = (String)pool[this.readU32(cu_in)];
                String pathName = (String)pool[this.readU32(cu_in)];
                VirtualFile f = null;
                if (pathName.length() == 0) {
                    f = null;
                } else {
                    f = resolver.resolve(pathName);
                    if (f == null) {
                        f = new DeletedFile(pathName);
                    }
                }
                assetPaths.put(className, f);
                assetCreationTimes.put(className, new Long(this.readLong(cu_in)));
            }
            int swfSize = this.readU32(cu_in);
            ByteArrayInputStream in = new ByteArrayInputStream(this.readBytes(cu_in, swfSize));
            Movie movie = new Movie();
            MovieDecoder movieDecoder = new MovieDecoder(movie);
            TagDecoder tagDecoder = new TagDecoder((InputStream)in);
            tagDecoder.parse((TagHandler)movieDecoder);
            Iterator frames = movie.frames.iterator();
            while (frames.hasNext()) {
                Frame frame = (Frame)frames.next();
                Iterator it = frame.symbolClass.class2tag.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry e = it.next();
                    String className = (String)e.getKey();
                    DefineTag tag = (DefineTag)e.getValue();
                    u.getAssets().add(className, (VirtualFile)assetPaths.get(className), tag, (Long)assetCreationTimes.get(className));
                }
            }
        }
    }

    private int addObject(Map pool, Object obj) {
        if (!$assertionsDisabled && obj == null) {
            throw new AssertionError();
        }
        Integer index = (Integer)pool.get(obj);
        if (index == null) {
            index = IntegerPool.getNumber(pool.size());
            pool.put(obj, index);
        }
        return index;
    }

    private int addBytes(Map pool, byte[] b) {
        return this.addObject(pool, b);
    }

    private int addString(Map pool, String s) {
        return this.addObject(pool, s);
    }

    private int addStrings(Map pool, String[] array) {
        if (!$assertionsDisabled && array == null) {
            throw new AssertionError();
        }
        ArrayKey.access$002(this.key, array);
        Integer index = (Integer)pool.get(this.key);
        if (index == null) {
            int size = array.length;
            for (int i = 0; i < size; ++i) {
                this.addString(pool, array[i]);
            }
            index = IntegerPool.getNumber(pool.size());
            pool.put(new ArrayKey(array), index);
        }
        return index;
    }

    private int addQName(Map pool, QName qName) {
        if (!$assertionsDisabled && qName == null) {
            throw new AssertionError();
        }
        Integer index = (Integer)pool.get(qName);
        if (index == null) {
            this.addString(pool, qName.getNamespace());
            this.addString(pool, qName.getLocalPart());
            index = IntegerPool.getNumber(pool.size());
            pool.put(qName, index);
        }
        return index;
    }

    private int addMultiName(Map pool, MultiName multiName) {
        if (!$assertionsDisabled && multiName == null) {
            throw new AssertionError();
        }
        Integer index = (Integer)pool.get(multiName);
        if (index == null) {
            this.addStrings(pool, multiName.namespaceURI);
            this.addString(pool, multiName.localPart);
            index = IntegerPool.getNumber(pool.size());
            pool.put(multiName, index);
        }
        return index;
    }

    private int addMetaData(Map pool, flex2.compiler.abc.MetaData md) {
        if (!$assertionsDisabled && md == null) {
            throw new AssertionError();
        }
        Integer index = (Integer)pool.get(md);
        if (index == null) {
            this.addString(pool, md.getID());
            int count = md.count();
            for (int j = 0; j < count; ++j) {
                String key = md.getKey(j);
                String val = md.getValue(j);
                this.addString(pool, key == null ? "" : key);
                this.addString(pool, val);
            }
            index = IntegerPool.getNumber(pool.size());
            pool.put(md, index);
        }
        return index;
    }

    private void writeBytes(OutputStream out, byte[] b) throws IOException {
        out.write(b);
    }

    private void writeLong(OutputStream out, long num) throws IOException {
        out.write((int)(num >>> 56) & 0xFF);
        out.write((int)(num >>> 48) & 0xFF);
        out.write((int)(num >>> 40) & 0xFF);
        out.write((int)(num >>> 32) & 0xFF);
        out.write((int)(num >>> 24) & 0xFF);
        out.write((int)(num >>> 16) & 0xFF);
        out.write((int)(num >>> 8) & 0xFF);
        out.write((int)num & 0xFF);
    }

    private void writeU32(OutputStream out, int num) throws IOException {
        out.write(num >>> 24 & 0xFF);
        out.write(num >>> 16 & 0xFF);
        out.write(num >>> 8 & 0xFF);
        out.write(num & 0xFF);
    }

    private void writeU8(OutputStream out, int num) throws IOException {
        out.write(num & 0xFF);
    }

    private byte[] readBytes(int length) throws IOException {
        byte[] b = new byte[length];
        this.file.readFully(b);
        return b;
    }

    private int readU32() throws IOException {
        return this.file.readInt();
    }

    private int readU8() throws IOException {
        return this.file.read();
    }

    private byte[] readBytes(InputStream in, int length) throws IOException {
        byte[] b = new byte[length];
        int size = 0;
        int start = 0;
        int len = length - size;
        while ((size = in.read(b, start, len)) != -1 && start + size < length) {
            start += size;
            len -= size;
        }
        return b;
    }

    private long readLong(InputStream in) throws IOException {
        return ((long)this.readU32(in) << 32) + ((long)this.readU32(in) & 0xFFFFFFFFL);
    }

    private int readU32(InputStream in) throws IOException {
        return (in.read() << 24) + (in.read() << 16) + (in.read() << 8) + in.read();
    }

    private int readU8(InputStream in) throws IOException {
        return in.read();
    }

    static {
        $assertionsDisabled = !PersistenceStore.class.desiredAssertionStatus();
    }

    public static class NoResourceContainer
    extends CompilerMessage.CompilerInfo {
    }

    public static class NoSourcePath
    extends CompilerMessage.CompilerInfo {
    }

    public static class NoSourceList
    extends CompilerMessage.CompilerInfo {
    }

    public static class NoFileSpec
    extends CompilerMessage.CompilerInfo {
    }

    public static class ObsoleteCacheFileFormat
    extends CompilerMessage.CompilerInfo {
    }

    public final class MetaData
    implements flex2.compiler.abc.MetaData {
        private String id;
        private String[] keys;
        private String[] values;

        public MetaData(String id, int count) {
            this.id = id;
            this.keys = new String[count];
            this.values = new String[count];
        }

        public String getID() {
            return this.id;
        }

        public void setValue(int index, String value) {
            this.values[index] = value;
        }

        public void setKeyValue(int index, String key, String value) {
            this.keys[index] = key;
            this.values[index] = value;
        }

        public String getKey(int index) {
            if (index < 0 || index >= this.count()) {
                throw new ArrayIndexOutOfBoundsException();
            }
            return this.keys[index];
        }

        public String getValue(String key) {
            int length = this.count();
            for (int i = 0; i < length; ++i) {
                if (!key.equals(this.keys[i])) continue;
                return this.values[i];
            }
            return null;
        }

        public String getValue(int index) {
            if (index < 0 || index >= this.count()) {
                throw new ArrayIndexOutOfBoundsException();
            }
            return this.values[index];
        }

        public Map getValueMap() {
            HashMap<String, String> result = new HashMap<String, String>();
            int length = this.count();
            for (int i = 0; i < length; ++i) {
                result.put(this.keys[i], this.values[i]);
            }
            return result;
        }

        public int count() {
            return this.values != null ? this.values.length : 0;
        }
    }

    private class ArrayKey {
        private String[] a1;

        ArrayKey() {
        }

        ArrayKey(String[] array) {
            this.a1 = array;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof ArrayKey) {
                String[] a2 = ((ArrayKey)obj).a1;
                if (this.a1 == a2) {
                    return true;
                }
                if (this.a1.length != a2.length) {
                    return false;
                }
                int size = this.a1.length;
                for (int i = 0; i < size; ++i) {
                    if (this.a1[i].equals(a2[i])) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            int c = 0;
            int size = this.a1.length;
            for (int i = 0; i < size; ++i) {
                c = i == 0 ? this.a1[i].hashCode() : c ^ this.a1[i].hashCode();
            }
            return c;
        }

        static /* synthetic */ String[] access$002(ArrayKey x0, String[] x1) {
            x0.a1 = x1;
            return x1;
        }
    }
}

