/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler;

import flex2.compiler.Assets;
import flex2.compiler.Context;
import flex2.compiler.Source;
import flex2.compiler.abc.MetaData;
import flex2.compiler.css.Styles;
import flex2.compiler.css.StylesContainer;
import flex2.compiler.util.MultiNameMap;
import flex2.compiler.util.MultiNameSet;
import flex2.compiler.util.QName;
import flex2.compiler.util.QNameList;
import flex2.compiler.util.QNameSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import macromedia.asc.util.ByteList;

public final class CompilationUnit {
    public static final int Empty = 0;
    public static final int SyntaxTree = 1;
    public static final int abc = 2;
    public static final int Done = 4;
    static final String COMPILATION_UNIT = CompilationUnit.class.getName();
    private Source source;
    private Object syntaxTree;
    private Context context;
    private Assets assets;
    private int state;
    private int workflow;
    public ByteList bytes;
    public Set metadata;
    public MetaData swfMetaData;
    public MetaData iconFile;
    public String loaderClass;
    public String loaderClassBase;
    public Set extraClasses;
    private Map generatedSources;
    public Map auxGenerateInfo;
    private Set accessibilityClasses;
    public Map licensedClassReqs;
    public Map remoteClassAliases;
    public Map effectTriggers;
    public Set mixins;
    public Set resourceBundles;
    public Set resourceBundleHistory;
    public QNameList topLevelDefinitions;
    public MultiNameSet inheritance;
    public MultiNameSet types;
    public MultiNameSet expressions;
    public MultiNameSet namespaces;
    public Set importPackageStatements;
    public QNameSet importDefinitionStatements;
    public MultiNameMap inheritanceHistory;
    public MultiNameMap typeHistory;
    public MultiNameMap namespaceHistory;
    public MultiNameMap expressionHistory;
    public Styles styles;
    private StylesContainer stylesContainer;
    public boolean hasTypeInfo;
    public Object typeInfo;
    public Map classTable;
    public int checkBits = 0;

    CompilationUnit(Source source, Object syntaxTree, Context context) {
        this.source = source;
        this.syntaxTree = syntaxTree;
        this.context = context;
        this.reset();
    }

    void resetKeepTypeInfo() {
        this.assets = new Assets();
        this.state = 0;
        this.workflow = 0;
        if (this.bytes == null) {
            this.bytes = new ByteList();
        } else {
            this.bytes.clear();
        }
        if (this.metadata == null) {
            this.metadata = new HashSet();
        } else {
            this.metadata.clear();
        }
        this.swfMetaData = null;
        this.iconFile = null;
        this.loaderClass = null;
        if (this.extraClasses == null) {
            this.extraClasses = new HashSet();
        } else {
            this.extraClasses.clear();
        }
        this.generatedSources = null;
        this.auxGenerateInfo = null;
        this.accessibilityClasses = null;
        if (this.remoteClassAliases == null) {
            this.remoteClassAliases = new HashMap(1);
        } else {
            this.remoteClassAliases.clear();
        }
        if (this.licensedClassReqs == null) {
            this.licensedClassReqs = new HashMap(1);
        } else {
            this.licensedClassReqs.clear();
        }
        if (this.effectTriggers == null) {
            this.effectTriggers = new HashMap(1);
        } else {
            this.effectTriggers.clear();
        }
        this.mixins = new HashSet(2);
        if (this.resourceBundles == null) {
            this.resourceBundles = new HashSet(1);
            this.resourceBundleHistory = new HashSet(1);
        } else {
            this.resourceBundles.clear();
            this.resourceBundleHistory.clear();
        }
        if (this.topLevelDefinitions == null) {
            this.topLevelDefinitions = new QNameList(this.source.isSourcePathOwner() || this.source.isSourceListOwner() ? 1 : 8);
        } else {
            this.topLevelDefinitions.clear();
        }
        if (this.inheritance == null) {
            this.inheritance = new MultiNameSet(1, 2);
            this.types = new MultiNameSet(3, 8);
            this.expressions = new MultiNameSet(4, 8);
            this.namespaces = new MultiNameSet(2, 2);
            this.importPackageStatements = new HashSet(16);
            this.importDefinitionStatements = new QNameSet(16);
            this.inheritanceHistory = new MultiNameMap(2);
            this.typeHistory = new MultiNameMap(8);
            this.expressionHistory = new MultiNameMap(8);
            this.namespaceHistory = new MultiNameMap(2);
        } else {
            this.inheritance.clear();
            this.types.clear();
            this.expressions.clear();
            this.namespaces.clear();
            this.importPackageStatements.clear();
            this.importDefinitionStatements.clear();
            this.inheritanceHistory.clear();
            this.typeHistory.clear();
            this.expressionHistory.clear();
            this.namespaceHistory.clear();
        }
        if (this.styles == null) {
            this.styles = new Styles(2);
        } else {
            this.styles.clear();
        }
        this.checkBits = 0;
    }

    void reset() {
        this.resetKeepTypeInfo();
        this.removeTypeInfo();
    }

    void removeTypeInfo() {
        this.hasTypeInfo = false;
        this.typeInfo = null;
        if (this.classTable == null) {
            this.classTable = new HashMap(this.source.isSourcePathOwner() || this.source.isSourceListOwner() ? 4 : 8);
        } else {
            this.classTable.clear();
        }
    }

    public boolean isRoot() {
        return this.source.isRoot();
    }

    public void addGeneratedSource(QName defName, Source source) {
        if (this.generatedSources == null) {
            this.generatedSources = new HashMap();
        }
        this.generatedSources.put(defName, source);
    }

    public void addGeneratedSources(Map generatedSources) {
        if (generatedSources != null) {
            if (this.generatedSources == null) {
                this.generatedSources = new HashMap();
            }
            this.generatedSources.putAll(generatedSources);
        }
    }

    public void clearGeneratedSources() {
        this.generatedSources = null;
    }

    public Map getGeneratedSources() {
        return this.generatedSources;
    }

    public Source getSource() {
        return this.source;
    }

    void setState(int flag) {
        this.state |= flag;
        if (flag == 2) {
            this.syntaxTree = null;
            this.source.disconnectLogger();
            Map misc = (Map)this.context.getAttribute("SwcScript.misc");
            if (misc != null) {
                misc.put(COMPILATION_UNIT, this);
            }
        } else if (flag == 4) {
            this.hasTypeInfo = this.typeInfo != null;
            this.context.clear();
            this.metadata.clear();
            this.source.clearSourceFragments();
        }
    }

    int getState() {
        return this.state;
    }

    public boolean isBytecodeAvailable() {
        return (this.state & 2) != 0;
    }

    public boolean isDone() {
        return (this.state & 4) != 0;
    }

    void setWorkflow(int flag) {
        this.workflow |= flag;
    }

    int getWorkflow() {
        return this.workflow;
    }

    public Object getSyntaxTree() {
        return this.syntaxTree;
    }

    public void setSyntaxTree(Object syntaxTree) {
        this.syntaxTree = syntaxTree;
    }

    public Context getContext() {
        return this.context;
    }

    public Assets getAssets() {
        return this.assets;
    }

    public void addAccessibilityClasses(CompilationUnit u) {
        if (u.accessibilityClasses != null) {
            if (this.accessibilityClasses == null) {
                this.accessibilityClasses = new HashSet();
            }
            this.accessibilityClasses.addAll(u.accessibilityClasses);
        }
    }

    public void addAccessibilityClass(MetaData metadata) {
        String accessibilityClass;
        if (this.accessibilityClasses == null) {
            this.accessibilityClasses = new HashSet();
        }
        if (!this.accessibilityClasses.contains(accessibilityClass = metadata.getValue("implementation"))) {
            this.accessibilityClasses.add(accessibilityClass);
        }
    }

    public Set getAccessibilityClasses() {
        return this.accessibilityClasses;
    }

    public byte[] getByteCodes() {
        return this.bytes.toByteArray(false);
    }

    public StylesContainer getStylesContainer() {
        return this.stylesContainer;
    }

    public void setStylesContainer(StylesContainer stylesContainer) {
        this.stylesContainer = stylesContainer;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CompilationUnit) {
            return ((CompilationUnit)obj).getSource() == this.getSource();
        }
        return false;
    }
}

