/*
 * Decompiled with CFR 0.152.
 */
package flash.css;

import flash.css.Logger;
import flash.css.Rule;
import flash.css.RuleList;
import flash.css.StyleDocumentHandler;
import flash.css.StyleParserErrorTranslator;
import flash.fonts.FontManager;
import flash.util.FileUtils;
import flash.util.Trace;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.batik.css.parser.Parser;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.CSSParseException;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.ErrorHandler;
import org.w3c.css.sac.InputSource;

public class StyleParser {
    private int ruleIndex;
    private RuleList rules;
    private String cssPath;
    private boolean errorsExist;
    private String mxmlPath;
    private int mxmlLineNumber;
    private Logger messageHandler;
    private FontManager fontManager;
    private Parser parser;

    public StyleParser(String cssPath, InputStream inputStream, Logger handler, FontManager fontManager) {
        block2: {
            this.ruleIndex = 0;
            this.rules = new RuleList();
            this.errorsExist = false;
            this.cssPath = cssPath;
            this.fontManager = fontManager;
            try {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
                String charsetName = FileUtils.consumeBOM((InputStream)bufferedInputStream, null);
                this.init(new InputStreamReader((InputStream)bufferedInputStream, charsetName), handler);
            }
            catch (IOException ioException) {
                handler.logError(cssPath, -1, ioException.getLocalizedMessage());
                if (!Trace.css && !Trace.error) break block2;
                ioException.printStackTrace();
            }
        }
    }

    public StyleParser(String mxmlPath, int mxmlLineNumber, Reader reader, Logger handler, FontManager fontManager) {
        this.ruleIndex = 0;
        this.rules = new RuleList();
        this.errorsExist = false;
        this.mxmlPath = mxmlPath;
        this.mxmlLineNumber = mxmlLineNumber - 1;
        this.fontManager = fontManager;
        this.init(reader, handler);
    }

    public StyleParser(String cssPath, Reader reader, Logger handler, FontManager fontManager) {
        this.ruleIndex = 0;
        this.rules = new RuleList();
        this.errorsExist = false;
        this.cssPath = cssPath;
        this.fontManager = fontManager;
        this.init(reader, handler);
    }

    private void init(Reader reader, final Logger handler) {
        block2: {
            try {
                this.messageHandler = handler;
                ErrorHandler errorHandler = new ErrorHandler(){

                    public void error(CSSParseException exception) throws CSSException {
                        if (StyleParser.this.mxmlPath != null) {
                            handler.logError(StyleParser.this.mxmlPath, StyleParser.this.mxmlLineNumber + exception.getLineNumber(), StyleParserErrorTranslator.getUserFriendlyErrror(exception.getMessage()));
                            StyleParser.this.errorsExist = true;
                        } else {
                            handler.logError(StyleParser.this.cssPath, exception.getLineNumber(), StyleParserErrorTranslator.getUserFriendlyErrror(exception.getMessage()));
                            StyleParser.this.errorsExist = true;
                        }
                    }

                    public void fatalError(CSSParseException exception) throws CSSException {
                        if (StyleParser.this.mxmlPath != null) {
                            handler.logError(StyleParser.this.mxmlPath, StyleParser.this.mxmlLineNumber + exception.getLineNumber(), StyleParserErrorTranslator.getUserFriendlyErrror(exception.getMessage()));
                            StyleParser.this.errorsExist = true;
                        } else {
                            handler.logError(StyleParser.this.cssPath, exception.getLineNumber(), StyleParserErrorTranslator.getUserFriendlyErrror(exception.getMessage()));
                            StyleParser.this.errorsExist = true;
                        }
                    }

                    public void warning(CSSParseException exception) throws CSSException {
                        if (StyleParser.this.mxmlPath != null) {
                            handler.logWarning(StyleParser.this.mxmlPath, StyleParser.this.mxmlLineNumber + exception.getLineNumber(), StyleParserErrorTranslator.getUserFriendlyErrror(exception.getMessage()));
                        } else {
                            handler.logWarning(StyleParser.this.cssPath, exception.getLineNumber(), StyleParserErrorTranslator.getUserFriendlyErrror(exception.getMessage()));
                        }
                    }
                };
                this.parser = new Parser();
                this.parser.setDocumentHandler((DocumentHandler)new StyleDocumentHandler(this));
                this.parser.setErrorHandler(errorHandler);
                this.parser.parseStyleSheet(new InputSource(reader));
            }
            catch (Exception exception) {
                String path = this.mxmlPath != null ? this.mxmlPath : this.cssPath;
                handler.logError(path, -1, StyleParserErrorTranslator.getUserFriendlyErrror(exception.getLocalizedMessage()));
                if (!Trace.css && !Trace.error) break block2;
                exception.printStackTrace();
            }
        }
    }

    public boolean errorsExist() {
        return this.errorsExist;
    }

    public int getLineNumber() {
        int lineNumber = this.mxmlLineNumber;
        return lineNumber += this.parser.getLineNumber();
    }

    int getMxmlLineNumber() {
        return this.mxmlLineNumber;
    }

    public String getPath() {
        String path = this.mxmlPath;
        if (path == null) {
            path = this.cssPath;
        }
        return path;
    }

    public void addRule(Rule rule) {
        this.rules.add(rule);
    }

    public RuleList getRules() {
        return this.rules;
    }

    public Rule parseRule() {
        return this.rules.get(this.ruleIndex++);
    }

    public FontManager getFontManager() {
        return this.fontManager;
    }

    public void warning(CSSException cssException) {
        if ((Trace.css || Trace.error) && cssException.getException() != null) {
            cssException.getException().printStackTrace();
        }
        if (this.mxmlPath != null) {
            int lineNumber = this.parser.getLineNumber();
            this.messageHandler.logWarning(this.mxmlPath, this.mxmlLineNumber + lineNumber, StyleParserErrorTranslator.getUserFriendlyErrror(cssException.getMessage()));
        } else {
            int lineNumber = this.parser.getLineNumber();
            this.messageHandler.logWarning(this.cssPath, lineNumber, StyleParserErrorTranslator.getUserFriendlyErrror(cssException.getMessage()));
        }
    }

    public void error(CSSException cssException) {
        if ((Trace.css || Trace.error) && cssException.getException() != null) {
            cssException.getException().printStackTrace();
        }
        if (this.mxmlPath != null) {
            int lineNumber = this.parser.getLineNumber();
            this.messageHandler.logError(this.mxmlPath, this.mxmlLineNumber + lineNumber, StyleParserErrorTranslator.getUserFriendlyErrror(cssException.getMessage()));
        } else {
            int lineNumber = this.parser.getLineNumber();
            this.messageHandler.logError(this.cssPath, lineNumber, StyleParserErrorTranslator.getUserFriendlyErrror(cssException.getMessage()));
        }
    }
}

