/*
 * Decompiled with CFR 0.152.
 */
package flash.css;

import flash.css.Descriptor;
import flash.css.LocalSource;
import flash.css.Rule;
import flash.css.StyleDeclaration;
import flash.css.StyleParser;
import flash.css.URLSource;
import flash.util.Trace;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.ThreadLocalToolkit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.LexicalUnit;

public class FontFaceRule
extends Rule {
    private String family = null;
    private int style = -1;
    private List locations = null;
    private Map embedParams = null;

    public FontFaceRule(String path, int lineNumber) {
        super((short)5, path, lineNumber);
        this.declaration = new StyleDeclaration(this, path, lineNumber);
    }

    public Map getEmbedParams() {
        return this.embedParams;
    }

    public void initialize(StyleParser parser) {
        String flashType;
        long start = 0L;
        if (Trace.font) {
            start = System.currentTimeMillis();
        }
        String alias = this.getFamily();
        List locations = this.getLocations();
        this.embedParams = new HashMap();
        this.embedParams.put("mimeType", "application/x-font");
        if (locations == null && alias != null) {
            this.embedParams.put("fontName", alias);
            this.embedParams.put("systemFont", alias);
        } else if (alias != null) {
            this.embedParams.put("fontName", alias);
            if (locations.size() == 1) {
                Object source = locations.get(0);
                if (source instanceof URLSource) {
                    URLSource urlSource = (URLSource)source;
                    this.embedParams.put("source", urlSource.getValue());
                    if (urlSource.getValue().toLowerCase().endsWith(".swf")) {
                        this.embedParams.put("mimeType", "application/x-shockwave-flash");
                    }
                } else {
                    LocalSource localSource = (LocalSource)source;
                    this.embedParams.put("systemFont", localSource.getValue());
                }
            } else {
                this.embedParams.put("sourceList", locations);
            }
        }
        String unicodeRange = this.getUnicodeRange();
        if (unicodeRange != null) {
            this.embedParams.put("unicodeRange", unicodeRange);
        }
        if ((flashType = this.getFlashType()) != null) {
            this.embedParams.put("flashType", flashType);
        }
        this.checkForIgnoredDescriptors(parser);
        if (Trace.font) {
            Trace.trace((String)("Font '" + alias + "' initialized in " + (System.currentTimeMillis() - start) + " ms.\n"));
        }
        if (this.isBold()) {
            this.embedParams.put("fontWeight", "bold");
        }
        if (this.isItalic()) {
            this.embedParams.put("fontStyle", "italic");
        }
    }

    private String getFlashType() {
        String flashType = null;
        Descriptor flashTypeDesc = this.declaration.getPropertyValue("flash-type");
        if (flashTypeDesc == null) {
            flashTypeDesc = this.declaration.getPropertyValue("flashType");
        }
        if (flashTypeDesc != null) {
            flashType = flashTypeDesc.getIdentAsString();
        }
        return flashType;
    }

    public String getFamily() {
        if (this.family == null) {
            Descriptor f = this.declaration.getPropertyValue("font-family");
            if (f == null) {
                f = this.declaration.getPropertyValue("fontFamily");
            }
            if (f != null) {
                this.family = f.getIdentAsString();
            }
        }
        return this.family;
    }

    public List getLocations() {
        if (this.locations == null) {
            Descriptor src = this.declaration.getPropertyValue("src");
            ArrayList<Object> result = null;
            if (src != null) {
                result = new ArrayList<Object>(2);
                for (LexicalUnit lu = src.getValue(); lu != null; lu = lu.getNextLexicalUnit()) {
                    if (lu.getLexicalUnitType() == 41) {
                        result.add(new LocalSource(lu.getParameters().getStringValue().trim()));
                        continue;
                    }
                    if (lu.getLexicalUnitType() != 24) continue;
                    result.add(new URLSource(lu.getStringValue()));
                }
            }
            this.locations = result;
        }
        return this.locations;
    }

    public String formatFontStyle() {
        Descriptor s = this.declaration.getPropertyValue("font-style");
        if (s == null) {
            s = this.declaration.getPropertyValue("fontStyle");
        }
        return s == null ? "" : "fontStyle='" + s + "'";
    }

    public String formatFontWeight() {
        Descriptor w = this.declaration.getPropertyValue("font-weight");
        if (w == null) {
            w = this.declaration.getPropertyValue("fontWeight");
        }
        return w == null ? "" : "fontWeight='" + w + "'";
    }

    public int getFontStyle() {
        if (this.style < 0) {
            StringTokenizer weights;
            String thisWeight;
            StringTokenizer styles;
            String thisStyle;
            Descriptor w;
            this.style = 0;
            Descriptor s = this.declaration.getPropertyValue("font-style");
            if (s == null) {
                s = this.declaration.getPropertyValue("fontStyle");
            }
            if ((w = this.declaration.getPropertyValue("font-weight")) == null) {
                w = this.declaration.getPropertyValue("fontWeight");
            }
            if (s != null && FontFaceRule.isItalic(thisStyle = ((String)(styles = new StringTokenizer(s.getIdentAsString(), ",")).nextElement()).trim().toLowerCase())) {
                this.style += 2;
            }
            if (w != null && FontFaceRule.isBold(thisWeight = ((String)(weights = new StringTokenizer(w.getIdentAsString(), ",")).nextElement()).trim().toLowerCase())) {
                ++this.style;
            }
        }
        return this.style;
    }

    public boolean isBold() {
        if (this.style < 0) {
            this.getFontStyle();
        }
        return this.style == 1 || this.style == 3;
    }

    public boolean isItalic() {
        if (this.style < 0) {
            this.getFontStyle();
        }
        return this.style == 2 || this.style == 3;
    }

    public static boolean isItalic(String value) {
        boolean italic = false;
        if (value != null) {
            String ital = value.trim().toLowerCase();
            if (ital.startsWith("\"") && (ital = ital.substring(1)).endsWith("\"")) {
                ital = ital.substring(0, ital.length() - 1);
            }
            if (ital.equals("italic") || ital.equals("oblique")) {
                italic = true;
            }
        }
        return italic;
    }

    public static boolean isBold(String value) {
        boolean bold = false;
        if (value != null) {
            String b = value.trim().toLowerCase();
            if (b.startsWith("\"") && (b = b.substring(1)).endsWith("\"")) {
                b = b.substring(0, b.length() - 1);
            }
            if (b.startsWith("bold")) {
                bold = true;
            } else {
                try {
                    int w = Integer.parseInt(b);
                    if (w >= 700) {
                        bold = true;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return bold;
    }

    public String getUnicodeRange() {
        Descriptor property = this.declaration.getPropertyValue("unicode-range");
        if (property == null) {
            property = this.declaration.getPropertyValue("unicodeRange");
        }
        if (property != null) {
            String unicodeRange = property.getIdentAsString();
            int semicolon = (unicodeRange = unicodeRange.trim()).indexOf(";");
            if (semicolon != -1) {
                unicodeRange = unicodeRange.substring(0, semicolon);
            }
            return unicodeRange;
        }
        return null;
    }

    private void checkForIgnoredDescriptors(StyleParser parser) {
        String descriptor = null;
        if (this.declaration.getPropertyValue("font-size") != null) {
            descriptor = "font-size";
        } else if (this.declaration.getPropertyValue("fontSize") != null) {
            descriptor = "fontSize";
        } else if (this.declaration.getPropertyValue("panose-1") != null) {
            descriptor = "panose-1";
        } else if (this.declaration.getPropertyValue("stemv") != null) {
            descriptor = "stemv";
        } else if (this.declaration.getPropertyValue("stemh") != null) {
            descriptor = "stemh";
        } else if (this.declaration.getPropertyValue("slope") != null) {
            descriptor = "slope";
        } else if (this.declaration.getPropertyValue("cap-height") != null) {
            descriptor = "cap-height";
        } else if (this.declaration.getPropertyValue("capHeight") != null) {
            descriptor = "capHeight";
        } else if (this.declaration.getPropertyValue("x-height") != null) {
            descriptor = "x-height";
        } else if (this.declaration.getPropertyValue("xHeight") != null) {
            descriptor = "xHeight";
        } else if (this.declaration.getPropertyValue("ascent") != null) {
            descriptor = "ascent";
        } else if (this.declaration.getPropertyValue("descent") != null) {
            descriptor = "descent";
        } else if (this.declaration.getPropertyValue("widths") != null) {
            descriptor = "widths";
        } else if (this.declaration.getPropertyValue("bbox") != null) {
            descriptor = "bbox";
        } else if (this.declaration.getPropertyValue("definition-src") != null) {
            descriptor = "definition-src";
        } else if (this.declaration.getPropertyValue("definitionSrc") != null) {
            descriptor = "definitionSrc";
        } else if (this.declaration.getPropertyValue("baseline") != null) {
            descriptor = "baseline";
        } else if (this.declaration.getPropertyValue("centerline") != null) {
            descriptor = "centerline";
        } else if (this.declaration.getPropertyValue("mathline") != null) {
            descriptor = "mathline";
        } else if (this.declaration.getPropertyValue("topline") != null) {
            descriptor = "topline";
        }
        if (descriptor != null) {
            IgnoredDescriptor ignoredDescriptor = new IgnoredDescriptor(descriptor);
            String text = ThreadLocalToolkit.getLocalizationManager().getLocalizedTextString((Object)ignoredDescriptor);
            parser.warning(new CSSException(CSSException.SAC_UNSPECIFIED_ERR, text, null));
        }
    }

    public static FontFaceRule getRule(Collection rules, String family, boolean bold, boolean italic) {
        Iterator it = rules.iterator();
        while (it.hasNext()) {
            FontFaceRule ffr = (FontFaceRule)it.next();
            if (!family.equals(ffr.getFamily()) || bold != ffr.isBold() || italic != ffr.isItalic()) continue;
            return ffr;
        }
        return null;
    }

    public static boolean hasFamily(Collection rules, String family) {
        Iterator it = rules.iterator();
        while (it.hasNext()) {
            FontFaceRule ffr = (FontFaceRule)it.next();
            if (!family.equals(ffr.getFamily())) continue;
            return true;
        }
        return false;
    }

    public static class UnicodeRangeNotSupported
    extends CompilerMessage.CompilerError {
    }

    public static class IgnoredDescriptor
    extends CompilerMessage.CompilerError {
        public String descriptor;

        public IgnoredDescriptor(String descriptor) {
            this.descriptor = descriptor;
        }
    }
}

