/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.fxg.dom;

import com.adobe.fxg.FXGException;
import com.adobe.fxg.FXGVersion;
import com.adobe.fxg.dom.FXGNode;
import com.adobe.fxg.util.FXGLog;
import com.adobe.internal.fxg.dom.AbstractFXGNode;
import com.adobe.internal.fxg.dom.DOMParserHelper;
import com.adobe.internal.fxg.dom.FilterNode;
import com.adobe.internal.fxg.dom.GraphicContext;
import com.adobe.internal.fxg.dom.MaskPropertyNode;
import com.adobe.internal.fxg.dom.MaskableNode;
import com.adobe.internal.fxg.dom.MaskingNode;
import com.adobe.internal.fxg.dom.transforms.ColorTransformNode;
import com.adobe.internal.fxg.dom.transforms.MatrixNode;
import com.adobe.internal.fxg.dom.types.BlendMode;
import com.adobe.internal.fxg.dom.types.MaskType;
import com.adobe.internal.fxg.types.FXGMatrix;
import java.util.ArrayList;
import java.util.List;

public abstract class GraphicContentNode
extends AbstractFXGNode
implements MaskableNode {
    protected String id = "undefined";
    public boolean visible = true;
    public double x = 0.0;
    public double y = 0.0;
    public double scaleX = 1.0;
    public double scaleY = 1.0;
    public double rotation = 0.0;
    public double alpha = 1.0;
    public BlendMode blendMode = BlendMode.AUTO;
    public MaskType maskType = MaskType.CLIP;
    public boolean luminosityClip = false;
    public boolean luminosityInvert = false;
    protected boolean translateSet;
    protected boolean scaleSet;
    protected boolean rotationSet;
    protected boolean alphaSet;
    protected boolean maskTypeSet;
    public boolean isPartofClipMask = false;
    public List<FilterNode> filters;
    public MaskingNode mask;
    public MatrixNode matrix;
    public ColorTransformNode colorTransform;
    private GraphicContext parentGraphicContext;

    public String getId() {
        return this.id;
    }

    public void setId(String value) {
        this.id = value;
    }

    public void addChild(FXGNode child) {
        if (child instanceof FilterNode) {
            if (this.filters == null) {
                this.filters = new ArrayList<FilterNode>();
            }
            this.filters.add((FilterNode)child);
        } else if (child instanceof MaskPropertyNode) {
            this.mask = ((MaskPropertyNode)child).mask;
            if (this.mask instanceof GraphicContentNode) {
                ((GraphicContentNode)((Object)this.mask)).setParentGraphicContext(this.createGraphicContext());
            }
        } else if (child instanceof MatrixNode) {
            if (this.translateSet || this.scaleSet || this.rotationSet) {
                throw new FXGException(child.getStartLine(), child.getStartColumn(), "InvalidChildMatrixNode", new Object[0]);
            }
            this.matrix = (MatrixNode)child;
        } else if (child instanceof ColorTransformNode) {
            if (this.alphaSet) {
                throw new FXGException(child.getStartLine(), child.getStartColumn(), "InvalidChildColorTransformNode", new Object[0]);
            }
            this.colorTransform = (ColorTransformNode)child;
        } else {
            super.addChild(child);
        }
    }

    public void setAttribute(String name, String value) {
        if ("x".equals(name)) {
            this.x = DOMParserHelper.parseDouble(this, value, name);
            this.translateSet = true;
        } else if ("y".equals(name)) {
            this.y = DOMParserHelper.parseDouble(this, value, name);
            this.translateSet = true;
        } else if ("rotation".equals(name)) {
            this.rotation = DOMParserHelper.parseDouble(this, value, name);
            this.rotationSet = true;
        } else if ("scaleX".equals(name)) {
            this.scaleX = DOMParserHelper.parseDouble(this, value, name);
            this.scaleSet = true;
        } else if ("scaleY".equals(name)) {
            this.scaleY = DOMParserHelper.parseDouble(this, value, name);
            this.scaleSet = true;
        } else if ("alpha".equals(name)) {
            this.alpha = DOMParserHelper.parseDouble(this, value, name, 0.0, 1.0, this.alpha);
            this.alphaSet = true;
        } else if ("blendMode".equals(name)) {
            this.blendMode = this.parseBlendMode(this, value, this.blendMode);
        } else if ("visible".equals(name)) {
            this.visible = DOMParserHelper.parseBoolean(this, value, name);
        } else if ("id".equals(name)) {
            this.id = value;
        } else if ("maskType".equals(name)) {
            this.maskType = DOMParserHelper.parseMaskType(this, value, name, this.maskType);
            if (this.isForMobile() && this.maskType == MaskType.LUMINOSITY) {
                FXGLog.getLogger().log(30000, "MobileUnsupportedLuminosityMask", null, this.getDocumentName(), this.startLine, this.startColumn);
                this.maskTypeSet = false;
            } else {
                this.maskTypeSet = true;
            }
        } else {
            if (this.getFileVersion().equalTo(FXGVersion.v1_0)) {
                throw new FXGException(this.getStartLine(), this.getStartColumn(), "InvalidNodeAttribute", name, this.getNodeName());
            }
            if ("luminosityClip".equals(name)) {
                this.luminosityClip = DOMParserHelper.parseBoolean(this, value, name);
            } else if ("luminosityInvert".equals(name)) {
                this.luminosityInvert = DOMParserHelper.parseBoolean(this, value, name);
            } else {
                super.setAttribute(name, value);
            }
        }
    }

    public MaskingNode getMask() {
        return this.mask;
    }

    public MaskType getMaskType() {
        return this.maskType;
    }

    public boolean getLuminosityClip() {
        return this.luminosityClip;
    }

    public boolean getLuminosityInvert() {
        return this.luminosityInvert;
    }

    public GraphicContext createGraphicContext() {
        GraphicContext graphicContext = new GraphicContext();
        if (this.parentGraphicContext != null) {
            graphicContext.scalingGrid = this.parentGraphicContext.scalingGrid;
        }
        FXGMatrix transform = graphicContext.getTransform();
        if (this.matrix != null) {
            FXGMatrix t = new FXGMatrix(this.matrix);
            transform.concat(t);
        } else {
            if (this.scaleSet) {
                transform.scale(this.scaleX, this.scaleY);
            }
            if (this.rotationSet) {
                transform.rotate(this.rotation);
            }
            if (this.translateSet) {
                transform.translate(this.x, this.y);
            }
        }
        if (this.colorTransform != null) {
            graphicContext.colorTransform = this.colorTransform;
        } else if (this.alphaSet) {
            if (graphicContext.colorTransform == null) {
                graphicContext.colorTransform = new ColorTransformNode();
            }
            graphicContext.colorTransform.alphaMultiplier = this.alpha;
        }
        graphicContext.blendMode = this.blendMode;
        if (this.filters != null) {
            if (this.isForMobile()) {
                FXGLog.getLogger().log(30000, "MobileBitmapFilters", null, this.getDocumentName(), this.getStartLine(), this.getStartColumn());
            }
            graphicContext.addFilters(this.filters);
        }
        if (this.maskTypeSet) {
            graphicContext.maskType = this.maskType;
        } else if (this.parentGraphicContext != null) {
            graphicContext.maskType = this.parentGraphicContext.maskType;
        }
        return graphicContext;
    }

    public void setParentGraphicContext(GraphicContext context) {
        this.parentGraphicContext = context;
    }

    protected BlendMode parseBlendMode(FXGNode node, String value, BlendMode defMode) {
        if (this.isForMobile() && ("alpha".equals(value) || "darken".equals(value) || "difference".equals(value) || "erase".equals(value) || "hardlight".equals(value) || "invert".equals(value) || "layer".equals(value) || "lighten".equals(value) || "overlay".equals(value) || "screen".equals(value) || "subtract".equals(value))) {
            FXGLog.getLogger().log(30000, "MobileUnsupportedNativeBlendMode", null, ((AbstractFXGNode)node).getDocumentName(), node.getStartLine(), node.getStartColumn(), value);
        }
        if ("add".equals(value)) {
            return BlendMode.ADD;
        }
        if ("alpha".equals(value)) {
            return BlendMode.ALPHA;
        }
        if ("darken".equals(value)) {
            return BlendMode.DARKEN;
        }
        if ("difference".equals(value)) {
            return BlendMode.DIFFERENCE;
        }
        if ("erase".equals(value)) {
            return BlendMode.ERASE;
        }
        if ("hardlight".equals(value)) {
            return BlendMode.HARDLIGHT;
        }
        if ("invert".equals(value)) {
            return BlendMode.INVERT;
        }
        if ("layer".equals(value)) {
            return BlendMode.LAYER;
        }
        if ("lighten".equals(value)) {
            return BlendMode.LIGHTEN;
        }
        if ("multiply".equals(value)) {
            return BlendMode.MULTIPLY;
        }
        if ("normal".equals(value)) {
            return BlendMode.NORMAL;
        }
        if ("overlay".equals(value)) {
            return BlendMode.OVERLAY;
        }
        if ("screen".equals(value)) {
            return BlendMode.SCREEN;
        }
        if ("subtract".equals(value)) {
            return BlendMode.SUBTRACT;
        }
        if (this.getFileVersion().equalTo(FXGVersion.v1_0)) {
            throw new FXGException(this.getStartLine(), this.getStartColumn(), "UnknownBlendMode", value);
        }
        if (this.isForMobile() && this.getCompilerVersion().equalTo(FXGVersion.v2_0) && ("colordodge".equals(value) || "colorburn".equals(value) || "exclusion".equals(value) || "softlight".equals(value) || "hue".equals(value) || "saturation".equals(value) || "color".equals(value) || "luminosity".equals(value))) {
            FXGLog.getLogger().log(30000, "MobileUnsupportedPBBlendMode", null, ((AbstractFXGNode)node).getDocumentName(), node.getStartLine(), node.getStartColumn(), value);
            return BlendMode.NORMAL;
        }
        if ("colordodge".equals(value)) {
            return BlendMode.COLORDODGE;
        }
        if ("colorburn".equals(value)) {
            return BlendMode.COLORBURN;
        }
        if ("exclusion".equals(value)) {
            return BlendMode.EXCLUSION;
        }
        if ("softlight".equals(value)) {
            return BlendMode.SOFTLIGHT;
        }
        if ("hue".equals(value)) {
            return BlendMode.HUE;
        }
        if ("saturation".equals(value)) {
            return BlendMode.SATURATION;
        }
        if ("color".equals(value)) {
            return BlendMode.COLOR;
        }
        if ("luminosity".equals(value)) {
            return BlendMode.LUMINOSITY;
        }
        if ("auto".equals(value)) {
            return BlendMode.AUTO;
        }
        if (!this.isVersionGreaterThanCompiler()) {
            throw new FXGException(this.getStartLine(), this.getStartColumn(), "UnknownBlendMode", value);
        }
        FXGLog.getLogger().log(30000, "UnknownBlendMode", null, this.getDocumentName(), this.startLine, this.startColumn, value);
        return defMode;
    }

    public void convertTransformAttrToMatrix() {
        try {
            MatrixNode matrixNode = (MatrixNode)MatrixNode.class.newInstance();
            FXGMatrix matrix = FXGMatrix.convertToMatrix(this.scaleX, this.scaleY, this.rotation, this.x, this.y);
            matrix.setMatrixNodeValue(matrixNode);
            this.resetTransformAttr();
            this.addChild(matrixNode);
        }
        catch (Throwable t) {
            throw new FXGException(this.mask.getStartLine(), this.mask.getStartColumn(), "InvalidChildMatrixNode", t, new Object[0]);
        }
    }

    private void resetTransformAttr() {
        this.x = 0.0;
        this.y = 0.0;
        this.scaleX = 1.0;
        this.scaleY = 1.0;
        this.rotation = 0.0;
        this.translateSet = false;
        this.scaleSet = false;
        this.rotationSet = false;
    }
}

