/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fxg.swf;

import com.adobe.fxg.FXGException;
import com.adobe.fxg.FXGTranscoder;
import com.adobe.fxg.dom.FXGNode;
import com.adobe.fxg.util.FXGLog;
import com.adobe.fxg.util.FXGResourceResolver;
import com.adobe.internal.fxg.dom.AbstractShapeNode;
import com.adobe.internal.fxg.dom.BitmapGraphicNode;
import com.adobe.internal.fxg.dom.DefinitionNode;
import com.adobe.internal.fxg.dom.EllipseNode;
import com.adobe.internal.fxg.dom.FillNode;
import com.adobe.internal.fxg.dom.FilterNode;
import com.adobe.internal.fxg.dom.GradientEntryNode;
import com.adobe.internal.fxg.dom.GraphicContentNode;
import com.adobe.internal.fxg.dom.GraphicContext;
import com.adobe.internal.fxg.dom.GraphicNode;
import com.adobe.internal.fxg.dom.GroupDefinitionNode;
import com.adobe.internal.fxg.dom.GroupNode;
import com.adobe.internal.fxg.dom.LineNode;
import com.adobe.internal.fxg.dom.MaskableNode;
import com.adobe.internal.fxg.dom.MaskingNode;
import com.adobe.internal.fxg.dom.PathNode;
import com.adobe.internal.fxg.dom.PlaceObjectNode;
import com.adobe.internal.fxg.dom.RectNode;
import com.adobe.internal.fxg.dom.RichTextNode;
import com.adobe.internal.fxg.dom.StrokeNode;
import com.adobe.internal.fxg.dom.TextGraphicNode;
import com.adobe.internal.fxg.dom.fills.BitmapFillNode;
import com.adobe.internal.fxg.dom.fills.LinearGradientFillNode;
import com.adobe.internal.fxg.dom.fills.RadialGradientFillNode;
import com.adobe.internal.fxg.dom.fills.SolidColorFillNode;
import com.adobe.internal.fxg.dom.filters.AbstractFilterNode;
import com.adobe.internal.fxg.dom.filters.BevelFilterNode;
import com.adobe.internal.fxg.dom.filters.BlurFilterNode;
import com.adobe.internal.fxg.dom.filters.ColorMatrixFilterNode;
import com.adobe.internal.fxg.dom.filters.DropShadowFilterNode;
import com.adobe.internal.fxg.dom.filters.GlowFilterNode;
import com.adobe.internal.fxg.dom.filters.GradientBevelFilterNode;
import com.adobe.internal.fxg.dom.filters.GradientGlowFilterNode;
import com.adobe.internal.fxg.dom.strokes.AbstractStrokeNode;
import com.adobe.internal.fxg.dom.strokes.LinearGradientStrokeNode;
import com.adobe.internal.fxg.dom.strokes.RadialGradientStrokeNode;
import com.adobe.internal.fxg.dom.strokes.SolidColorStrokeNode;
import com.adobe.internal.fxg.dom.transforms.ColorTransformNode;
import com.adobe.internal.fxg.dom.transforms.MatrixNode;
import com.adobe.internal.fxg.dom.types.BevelType;
import com.adobe.internal.fxg.dom.types.BlendMode;
import com.adobe.internal.fxg.dom.types.Caps;
import com.adobe.internal.fxg.dom.types.InterpolationMethod;
import com.adobe.internal.fxg.dom.types.Joints;
import com.adobe.internal.fxg.dom.types.MaskType;
import com.adobe.internal.fxg.dom.types.ScaleMode;
import com.adobe.internal.fxg.dom.types.ScalingGrid;
import com.adobe.internal.fxg.dom.types.SpreadMethod;
import com.adobe.internal.fxg.dom.types.Winding;
import com.adobe.internal.fxg.swf.ImageHelper;
import com.adobe.internal.fxg.swf.ShapeHelper;
import com.adobe.internal.fxg.swf.TypeHelper;
import com.adobe.internal.fxg.types.FXGMatrix;
import flash.swf.builder.types.PathIteratorWrapper;
import flash.swf.builder.types.ShapeBuilder;
import flash.swf.builder.types.ShapeIterator;
import flash.swf.tags.DefineBits;
import flash.swf.tags.DefineScalingGrid;
import flash.swf.tags.DefineShape;
import flash.swf.tags.DefineSprite;
import flash.swf.tags.DefineTag;
import flash.swf.tags.PlaceObject;
import flash.swf.types.BevelFilter;
import flash.swf.types.BlurFilter;
import flash.swf.types.CXForm;
import flash.swf.types.CXFormWithAlpha;
import flash.swf.types.ColorMatrixFilter;
import flash.swf.types.DropShadowFilter;
import flash.swf.types.FillStyle;
import flash.swf.types.Filter;
import flash.swf.types.FocalGradient;
import flash.swf.types.GlowFilter;
import flash.swf.types.GradRecord;
import flash.swf.types.Gradient;
import flash.swf.types.GradientBevelFilter;
import flash.swf.types.GradientGlowFilter;
import flash.swf.types.LineStyle;
import flash.swf.types.Matrix;
import flash.swf.types.Rect;
import flash.swf.types.Shape;
import flash.swf.types.ShapeRecord;
import flash.swf.types.ShapeWithStyle;
import flash.swf.types.TagList;
import java.awt.geom.Ellipse2D;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FXG2SWFTranscoder
implements FXGTranscoder {
    protected HashMap<String, DefineSprite> definitions;
    protected Stack<DefineSprite> spriteStack = new Stack();
    protected FXGResourceResolver resourceResolver;
    protected int spriteCount;
    protected static Random random = new Random();

    public FXG2SWFTranscoder newInstance() {
        return new FXG2SWFTranscoder();
    }

    @Override
    public void setResourceResolver(FXGResourceResolver resolver) {
        this.resourceResolver = resolver;
    }

    @Override
    public Object transcode(FXGNode fxgNode) {
        GraphicNode node = (GraphicNode)fxgNode;
        DefineSprite sprite = this.createDefineSprite("Graphic");
        this.spriteStack.push(sprite);
        if (node.mask != null) {
            this.mask(node, sprite);
        }
        if (node.definesScaleGrid()) {
            DefineScalingGrid grid = this.createDefineScalingGrid(node.getScalingGrid());
            grid.scalingTarget = sprite;
            sprite.scalingGrid = grid;
        }
        if (node.children != null) {
            this.graphicContentNodes(node.children);
        }
        this.spriteStack.pop();
        return sprite;
    }

    private PlaceObject bitmapWithClip(DefineBits imageTag, BitmapGraphicNode node) {
        GraphicContext context = node.createGraphicContext();
        List<FilterNode> filters = null;
        if (context.filters != null) {
            filters = context.filters;
            context.filters = null;
            DefineSprite filterSprite = this.createDefineSprite("MaskFilter");
            this.spriteStack.push(filterSprite);
        }
        DefineSprite imageSprite = this.createDefineSprite("BitmapGraphic");
        this.spriteStack.push(imageSprite);
        DefineSprite clipSprite = this.createDefineSprite("BitmapGraphic_Clip");
        this.spriteStack.push(clipSprite);
        double width = (double)imageTag.width < node.width ? (double)imageTag.width : node.width;
        double height = (double)imageTag.height < node.height ? (double)imageTag.height : node.height;
        List<ShapeRecord> shapeRecords = ShapeHelper.rectangle(0.0, 0.0, width, height);
        DefineShape clipShape = this.createDefineShape(null, shapeRecords, new SolidColorFillNode(), null, context.getTransform(), new Winding[0]);
        this.placeObject((DefineTag)clipShape, new GraphicContext());
        this.spriteStack.pop();
        PlaceObject po3clip = this.placeObject((DefineTag)clipSprite, context);
        po3clip.setClipDepth(po3clip.depth + 1);
        DefineShape imageShape = ImageHelper.createShapeForImage(imageTag, node);
        this.placeObject((DefineTag)imageShape, context);
        this.spriteStack.pop();
        PlaceObject po3 = this.placeObject((DefineTag)imageSprite, new GraphicContext());
        if (filters != null) {
            DefineSprite sprite = this.spriteStack.pop();
            GraphicContext gc = new GraphicContext();
            gc.filters = filters;
            PlaceObject poFilter = this.placeObject((DefineTag)sprite, gc);
            return poFilter;
        }
        return po3;
    }

    protected PlaceObject bitmap(BitmapGraphicNode node) {
        GraphicContext context = node.createGraphicContext();
        String source = this.parseSource(node.source);
        if (source == null) {
            throw new FXGException(node.getStartLine(), node.getStartColumn(), "MissingSourceAttribute", new Object[0]);
        }
        DefineBits imageTag = this.createDefineBits(node, source);
        if (node.visible && !node.isPartofClipMask) {
            ScalingGrid scalingGrid = context.scalingGrid;
            if (scalingGrid != null) {
                Rect grid = TypeHelper.rect(scalingGrid.scaleGridLeft, scalingGrid.scaleGridTop, scalingGrid.scaleGridRight, scalingGrid.scaleGridBottom);
                DefineShape imageShape = ImageHelper.create9SlicedShape(imageTag, grid, Double.NaN, Double.NaN);
                PlaceObject po3 = this.placeObject((DefineTag)imageShape, context);
                return po3;
            }
            if (ImageHelper.bitmapImageNeedsClipping(imageTag, node)) {
                PlaceObject p03 = this.bitmapWithClip(imageTag, node);
                return p03;
            }
            DefineShape imageShape = ImageHelper.createShapeForImage(imageTag, node);
            PlaceObject po3 = this.placeObject((DefineTag)imageShape, context);
            return po3;
        }
        if (!ImageHelper.bitmapImageNeedsClipping(imageTag, node)) {
            double width = Double.isNaN(node.width) ? (double)imageTag.width : node.width;
            double height = Double.isNaN(node.height) ? (double)imageTag.height : node.height;
            List<ShapeRecord> shapeRecords = ShapeHelper.rectangle(0.0, 0.0, width, height);
            DefineShape shape = this.createDefineShape(null, shapeRecords, new SolidColorFillNode(), null, context.getTransform(), new Winding[0]);
            PlaceObject po3 = this.placeObject((DefineTag)shape, context);
            return po3;
        }
        double width = (double)imageTag.width < node.width || Double.isNaN(node.width) ? (double)imageTag.width : node.width;
        double height = (double)imageTag.height < node.height || Double.isNaN(node.height) ? (double)imageTag.height : node.height;
        List<ShapeRecord> shapeRecords = ShapeHelper.rectangle(0.0, 0.0, width, height);
        DefineShape shape = this.createDefineShape(null, shapeRecords, new SolidColorFillNode(), null, context.getTransform(), new Winding[0]);
        PlaceObject po3 = this.placeObject((DefineTag)shape, context);
        return po3;
    }

    protected void graphicContentNodes(List<GraphicContentNode> nodes) {
        if (nodes == null) {
            return;
        }
        for (GraphicContentNode node : nodes) {
            this.graphicContentNode(node);
        }
    }

    protected PlaceObject graphicContentNode(GraphicContentNode node) {
        PlaceObject po3 = null;
        if (!node.visible) {
            ColorTransformNode ct = new ColorTransformNode();
            ct.alphaMultiplier = 0.0;
            ct.alphaOffset = 0.0;
            ct.blueMultiplier = 1.0;
            ct.blueOffset = 0.0;
            ct.greenMultiplier = 1.0;
            ct.greenOffset = 0.0;
            ct.redMultiplier = 1.0;
            ct.redOffset = 0.0;
            node.colorTransform = ct;
            if (node instanceof AbstractShapeNode) {
                AbstractShapeNode shapeNode = (AbstractShapeNode)node;
                shapeNode.fill = null;
                shapeNode.stroke = null;
            }
        }
        if (node instanceof GroupNode) {
            this.group((GroupNode)node);
        } else {
            if (node.blendMode == BlendMode.AUTO) {
                node.blendMode = BlendMode.NORMAL;
            }
            List<FilterNode> filters = null;
            if (node.mask != null) {
                if (node.filters != null) {
                    filters = node.filters;
                    node.filters = null;
                    DefineSprite filterSprite = this.createDefineSprite("MaskFilter");
                    this.spriteStack.push(filterSprite);
                }
                DefineSprite parentSprite = this.spriteStack.peek();
                this.mask(node, parentSprite);
            }
            if (node instanceof EllipseNode) {
                po3 = this.ellipse((EllipseNode)node);
            } else if (node instanceof LineNode) {
                po3 = this.line((LineNode)node);
            } else if (node instanceof PathNode) {
                po3 = this.path((PathNode)node);
            } else if (node instanceof RectNode) {
                po3 = this.rect((RectNode)node);
            } else if (node instanceof PlaceObjectNode) {
                po3 = this.placeObjectInstance((PlaceObjectNode)node);
            } else if (node instanceof BitmapGraphicNode) {
                po3 = this.bitmap((BitmapGraphicNode)node);
            } else if (node instanceof TextGraphicNode) {
                po3 = this.text((TextGraphicNode)node);
            } else if (node instanceof RichTextNode) {
                po3 = this.richtext((RichTextNode)node);
            }
            if (filters != null) {
                DefineSprite sprite = this.spriteStack.pop();
                GraphicContext gc = new GraphicContext();
                gc.filters = filters;
                PlaceObject poFilter = this.placeObject((DefineTag)sprite, gc);
                return poFilter;
            }
        }
        return po3;
    }

    protected PlaceObject ellipse(EllipseNode node) {
        Ellipse2D.Double ellipse = new Ellipse2D.Double(0.0, 0.0, node.width, node.height);
        ShapeBuilder builder = new ShapeBuilder();
        PathIteratorWrapper iterator = new PathIteratorWrapper(ellipse.getPathIterator(null));
        builder.processShape((ShapeIterator)iterator);
        Shape shape = builder.build();
        return this.placeDefineShape(node, shape.shapeRecords, node.fill, node.stroke, node.createGraphicContext(), new Winding[0]);
    }

    protected PlaceObject group(GroupNode node) {
        DefineSprite sprite;
        if (node.blendMode == BlendMode.AUTO) {
            if (node.alpha == 0.0 || node.alpha == 1.0) {
                node.blendMode = BlendMode.NORMAL;
            } else if (node.isForMobile()) {
                FXGLog.getLogger().log(30000, "MobileSemiTransparentBlendMode", null, node.getDocumentName(), node.getStartLine(), node.getStartColumn());
                node.blendMode = BlendMode.NORMAL;
            } else {
                node.blendMode = BlendMode.LAYER;
            }
        }
        DefineSprite groupSprite = this.createDefineSprite("Group");
        GraphicContext context = node.createGraphicContext();
        if (node.definesScaleGrid()) {
            DefineScalingGrid grid = this.createDefineScalingGrid(context.scalingGrid);
            grid.scalingTarget = groupSprite;
            groupSprite.scalingGrid = grid;
        }
        PlaceObject po3 = this.placeObject((DefineTag)groupSprite, context);
        this.spriteStack.push(groupSprite);
        List<FilterNode> filters = null;
        if (node.mask != null) {
            filters = node.filters;
            if (filters == null) {
                List<GraphicContentNode> children = node.children;
                if (children != null) {
                    GraphicContentNode gcNodeI;
                    int i;
                    GraphicContentNode gcNode0 = children.get(0);
                    filters = gcNode0.filters;
                    if (filters != null) {
                        for (i = 1; i < children.size() && filters != null; ++i) {
                            gcNodeI = children.get(i);
                            if (gcNodeI.filters == filters) continue;
                            filters = null;
                        }
                    }
                    if (filters != null) {
                        for (i = 0; i < children.size(); ++i) {
                            gcNodeI = children.get(i);
                            gcNodeI.filters = null;
                        }
                    }
                }
            } else {
                node.filters = null;
            }
            if (filters != null) {
                DefineSprite filterSprite = this.createDefineSprite("MaskFilter");
                this.spriteStack.push(filterSprite);
            }
            sprite = this.spriteStack.peek();
            this.mask(node, sprite);
        }
        if (node.children != null) {
            this.graphicContentNodes(node.children);
        }
        if (filters != null) {
            sprite = this.spriteStack.pop();
            GraphicContext gc = new GraphicContext();
            gc.filters = filters;
            PlaceObject poFilter = this.placeObject((DefineTag)sprite, gc);
            return poFilter;
        }
        this.spriteStack.pop();
        return po3;
    }

    protected PlaceObject line(LineNode node) {
        List<ShapeRecord> shapeRecords = ShapeHelper.line(node.xFrom, node.yFrom, node.xTo, node.yTo);
        GraphicContext context = node.createGraphicContext();
        PlaceObject po3 = this.placeDefineShape(node, shapeRecords, node.fill, node.stroke, context, new Winding[0]);
        return po3;
    }

    protected PlaceObject mask(MaskableNode node, DefineSprite parentSprite) {
        PlaceObject po3 = null;
        MaskingNode mask = node.getMask();
        if (mask instanceof GroupNode) {
            if (!(node instanceof GroupNode) && !(node instanceof GraphicNode)) {
                FXGMatrix nodeMatrix = null;
                MatrixNode matrixNodeShape = ((GraphicContentNode)node).matrix;
                nodeMatrix = matrixNodeShape == null ? FXGMatrix.convertToMatrix(((GraphicContentNode)node).scaleX, ((GraphicContentNode)node).scaleY, ((GraphicContentNode)node).rotation, ((GraphicContentNode)node).x, ((GraphicContentNode)node).y) : new FXGMatrix(matrixNodeShape);
                MatrixNode matrixNodeMasking = ((GraphicContentNode)((Object)mask)).matrix;
                if (matrixNodeMasking == null) {
                    ((GraphicContentNode)((Object)mask)).convertTransformAttrToMatrix();
                    matrixNodeMasking = ((GraphicContentNode)((Object)mask)).matrix;
                }
                FXGMatrix maskMatrix = new FXGMatrix(matrixNodeMasking);
                maskMatrix.concat(nodeMatrix);
                maskMatrix.setMatrixNodeValue(matrixNodeMasking);
            }
            this.markLeafNodesAsMask(node, (GroupNode)mask);
            po3 = this.group((GroupNode)mask);
        } else if (mask instanceof PlaceObjectNode) {
            po3 = this.placeObjectInstance((PlaceObjectNode)mask);
        }
        if (po3 != null) {
            int clipDepth = 1;
            if (node instanceof GroupNode) {
                GroupNode group = (GroupNode)node;
                if (group.children != null) {
                    clipDepth = parentSprite.depthCounter + group.children.size();
                }
            } else if (node instanceof GraphicNode) {
                GraphicNode graphic = (GraphicNode)node;
                if (graphic.children != null) {
                    clipDepth = parentSprite.depthCounter + graphic.children.size();
                }
            } else {
                clipDepth = po3.depth + 1;
            }
            po3.setClipDepth(clipDepth);
            if (node.getMaskType() == MaskType.ALPHA) {
                po3.setCacheAsBitmap(true);
            }
        }
        return po3;
    }

    protected PlaceObject path(PathNode node) {
        List<ShapeRecord> shapeRecords = ShapeHelper.path(node, node.fill != null);
        GraphicContext context = node.createGraphicContext();
        Winding[] winding = new Winding[]{node.winding};
        PlaceObject po3 = this.placeDefineShape(node, shapeRecords, node.fill, node.stroke, context, winding);
        return po3;
    }

    protected void setPixelBenderBlendMode(PlaceObject po, BlendMode blendMode) {
    }

    protected void setAlphaMask(PlaceObject po) {
        po.setCacheAsBitmap(true);
    }

    protected void setLuminosityMask(PlaceObject po) {
    }

    protected PlaceObject placeObject(DefineTag symbol, GraphicContext context) {
        DefineSprite sprite = this.spriteStack.peek();
        PlaceObject po3 = new PlaceObject(70);
        po3.setRef(symbol);
        po3.depth = ++sprite.depthCounter;
        if (context.blendMode != null) {
            if (!context.blendMode.needsPixelBenderSupport()) {
                int blendMode = this.createBlendMode(context.blendMode);
                po3.setBlendMode(blendMode);
            } else {
                this.setPixelBenderBlendMode(po3, context.blendMode);
            }
        }
        if (context.filters != null) {
            List<Filter> filters = this.createFilters(context.filters);
            po3.setFilterList(filters);
        }
        Matrix matrix = context.getTransform().toSWFMatrix();
        po3.setMatrix(matrix);
        if (context.colorTransform != null) {
            ColorTransformNode t = context.colorTransform;
            CXFormWithAlpha cx = TypeHelper.cxFormWithAlpha(t.alphaMultiplier, t.redMultiplier, t.greenMultiplier, t.blueMultiplier, t.alphaOffset, t.redOffset, t.greenOffset, t.blueOffset);
            po3.setCxform((CXForm)cx);
        }
        if (context.maskType == MaskType.ALPHA) {
            this.setAlphaMask(po3);
        } else if (context.maskType == MaskType.LUMINOSITY) {
            this.setLuminosityMask(po3);
        }
        sprite.tagList.placeObject3(po3);
        return po3;
    }

    protected PlaceObject rect(RectNode node) {
        GraphicContext context = node.createGraphicContext();
        List<ShapeRecord> shapeRecords = node.radiusX != 0.0 || node.radiusY != 0.0 || !Double.isNaN(node.topLeftRadiusX) || !Double.isNaN(node.topLeftRadiusY) || !Double.isNaN(node.topRightRadiusX) || !Double.isNaN(node.topRightRadiusY) || !Double.isNaN(node.bottomLeftRadiusX) || !Double.isNaN(node.bottomLeftRadiusY) || !Double.isNaN(node.bottomRightRadiusX) || !Double.isNaN(node.bottomRightRadiusY) ? ShapeHelper.rectangle(0.0, 0.0, node.width, node.height, node.radiusX, node.radiusY, node.topLeftRadiusX, node.topLeftRadiusY, node.topRightRadiusX, node.topRightRadiusY, node.bottomLeftRadiusX, node.bottomLeftRadiusY, node.bottomRightRadiusX, node.bottomRightRadiusY) : ShapeHelper.rectangle(0.0, 0.0, node.width, node.height);
        PlaceObject po3 = this.placeDefineShape(node, shapeRecords, node.fill, node.stroke, context, new Winding[0]);
        return po3;
    }

    protected PlaceObject text(TextGraphicNode node) {
        return null;
    }

    protected PlaceObject richtext(RichTextNode node) {
        return null;
    }

    protected PlaceObject placeObjectInstance(PlaceObjectNode node) {
        DefineSprite definitionSprite;
        String definitionName = node.getNodeName();
        if (this.definitions == null) {
            this.definitions = new HashMap();
        }
        if ((definitionSprite = this.definitions.get(definitionName)) == null) {
            definitionSprite = this.createDefineSprite("Definition");
            FXG2SWFTranscoder graphics = this.newInstance();
            graphics.setResourceResolver(this.resourceResolver);
            this.definitions.put(definitionName, definitionSprite);
            graphics.definitions = this.definitions;
            graphics.definition(node.definition, definitionSprite);
        }
        PlaceObject po3 = this.placeObject((DefineTag)definitionSprite, node.createGraphicContext());
        return po3;
    }

    protected void definition(DefinitionNode node, DefineSprite definitionSprite) {
        GroupDefinitionNode groupDefinition = node.groupDefinition;
        if (groupDefinition == null) {
            throw new FXGException(node.getStartLine(), node.getStartColumn(), "MissingGroupChildNode", new Object[0]);
        }
        this.spriteStack.push(definitionSprite);
        if (groupDefinition.definesScaleGrid()) {
            definitionSprite.scalingGrid = this.createDefineScalingGrid(groupDefinition.getScalingGrid());
            definitionSprite.scalingGrid.scalingTarget = definitionSprite;
        }
        this.graphicContentNodes(groupDefinition.children);
        this.spriteStack.pop();
    }

    protected DefineBits createDefineBits(FXGNode node, String source) {
        try {
            InputStream stream = this.resourceResolver.openStream(source);
            DefineBits imageTag = ImageHelper.createDefineBits(stream, ImageHelper.guessMimeType(source));
            return imageTag;
        }
        catch (IOException ioe) {
            throw new FXGException(node.getStartLine(), node.getStartColumn(), "ErrorEmbeddingImage", ioe.getMessage(), source);
        }
    }

    protected DefineScalingGrid createDefineScalingGrid(ScalingGrid grid) {
        DefineScalingGrid scalingGrid = new DefineScalingGrid();
        scalingGrid.rect = TypeHelper.rect(grid.scaleGridLeft, grid.scaleGridTop, grid.scaleGridRight, grid.scaleGridBottom);
        return scalingGrid;
    }

    protected DefineSprite createDefineSprite(String name) {
        DefineSprite sprite = new DefineSprite();
        sprite.tagList = new TagList();
        sprite.framecount = 1;
        if (name == null) {
            name = "";
        }
        sprite.name = name + random.nextInt();
        return sprite;
    }

    protected DefineShape createDefineShape(AbstractShapeNode node, List<ShapeRecord> shapeRecords, FillNode fill, StrokeNode stroke, FXGMatrix transform, Winding ... windings) {
        Rect shapeBounds;
        Rect edgeBounds = node == null ? ShapeHelper.getBounds(shapeRecords, null, (AbstractStrokeNode)stroke) : node.getBounds(shapeRecords, null);
        ShapeWithStyle sws = new ShapeWithStyle();
        sws.shapeRecords = shapeRecords;
        int lineStyleIndex = stroke == null ? 0 : 1;
        int fillStyle0Index = fill == null ? 0 : 1;
        int fillStyle1Index = 0;
        if (windings.length > 0) {
            ShapeHelper.setPathStyles(shapeRecords, lineStyleIndex, fillStyle0Index, fillStyle1Index);
        } else {
            ShapeHelper.setStyles(shapeRecords, lineStyleIndex, fillStyle0Index, fillStyle1Index);
        }
        if (fill != null) {
            FillStyle fillStyle = this.createFillStyle(fill, edgeBounds);
            sws.fillstyles = new ArrayList(1);
            sws.fillstyles.add(fillStyle);
        }
        if (stroke != null) {
            LineStyle ls = this.createGenericLineStyle((AbstractStrokeNode)stroke);
            shapeBounds = node == null ? ShapeHelper.getBounds(shapeRecords, ls, (AbstractStrokeNode)stroke) : node.getBounds(shapeRecords, ls);
            LineStyle lineStyle = this.createLineStyle(stroke, shapeBounds);
            sws.linestyles = new ArrayList();
            sws.linestyles.add(lineStyle);
        } else {
            shapeBounds = edgeBounds;
        }
        DefineShape defineShape4 = new DefineShape(83);
        defineShape4.shapeWithStyle = sws;
        defineShape4.bounds = shapeBounds;
        defineShape4.edgeBounds = edgeBounds;
        if (fill != null && windings.length > 0) {
            Winding windingValue = windings[0];
            defineShape4.usesFillWindingRule = windingValue == Winding.NON_ZERO;
        }
        return defineShape4;
    }

    protected PlaceObject placeDefineShape(AbstractShapeNode node, List<ShapeRecord> shapeRecords, FillNode fill, StrokeNode stroke, GraphicContext context, Winding ... windings) {
        if (node != null && fill != null && !node.isPartofClipMask && ImageHelper.isBitmapFillWithClip(fill)) {
            BitmapFillNode fillNode = (BitmapFillNode)fill;
            Rect edgeBounds = node.getBounds(shapeRecords, null);
            String source = this.parseSource(fillNode.source);
            if (source == null) {
                throw new FXGException(fill.getStartLine(), fill.getStartColumn(), "MissingSourceAttribute", new Object[0]);
            }
            DefineBits imageTag = this.createDefineBits(fill, source);
            List<FilterNode> filters = null;
            if (context.filters != null) {
                filters = context.filters;
                context.filters = null;
                DefineSprite filterSprite = this.createDefineSprite("MaskFilter");
                this.spriteStack.push(filterSprite);
            }
            DefineSprite imageSprite = this.createDefineSprite("BitmapFill");
            this.spriteStack.push(imageSprite);
            DefineSprite clipSprite = this.createDefineSprite("BitmapFill_Clip");
            this.spriteStack.push(clipSprite);
            List<ShapeRecord> clipRectRecords = ShapeHelper.rectangle(0.0, 0.0, imageTag.width, imageTag.height);
            DefineShape clipShape = this.createDefineShape(null, clipRectRecords, new SolidColorFillNode(), null, context.getTransform(), new Winding[0]);
            FXGMatrix bitmapMatrix = TypeHelper.bitmapFillMatrix(fillNode, imageTag, edgeBounds);
            FXGMatrix clipMatrix = new FXGMatrix(bitmapMatrix.a, bitmapMatrix.b, bitmapMatrix.c, bitmapMatrix.d, 0.0, 0.0);
            clipMatrix.scale(0.05, 0.05);
            clipMatrix.translate(bitmapMatrix.tx, bitmapMatrix.ty);
            GraphicContext clipContext = new GraphicContext();
            clipContext.setTransform(clipMatrix);
            this.placeObject((DefineTag)clipShape, clipContext);
            this.spriteStack.pop();
            clipContext.setTransform(context.getTransform());
            PlaceObject po3clip = this.placeObject((DefineTag)clipSprite, clipContext);
            po3clip.setClipDepth(po3clip.depth + 1);
            ShapeWithStyle sws = new ShapeWithStyle();
            sws.shapeRecords = shapeRecords;
            int lineStyleIndex = 0;
            int fillStyle0Index = 1;
            int fillStyle1Index = 0;
            if (windings.length > 0) {
                ShapeHelper.setPathStyles(shapeRecords, lineStyleIndex, fillStyle0Index, fillStyle1Index);
            } else {
                ShapeHelper.setStyles(shapeRecords, lineStyleIndex, fillStyle0Index, fillStyle1Index);
            }
            FillStyle fillStyle = this.createFillStyle(fill, edgeBounds);
            sws.fillstyles = new ArrayList(1);
            sws.fillstyles.add(fillStyle);
            DefineShape imageShape = new DefineShape(83);
            imageShape.shapeWithStyle = sws;
            imageShape.bounds = edgeBounds;
            imageShape.edgeBounds = edgeBounds;
            if (fill != null && windings.length > 0) {
                Winding windingValue = windings[0];
                imageShape.usesFillWindingRule = windingValue == Winding.NON_ZERO;
            }
            PlaceObject po3 = this.placeObject((DefineTag)imageShape, context);
            if (stroke != null) {
                ArrayList<ShapeRecord> shapeRecords2 = new ArrayList<ShapeRecord>(shapeRecords);
                Collections.copy(shapeRecords2, shapeRecords);
                ShapeWithStyle swsStroke = new ShapeWithStyle();
                swsStroke.shapeRecords = shapeRecords2;
                lineStyleIndex = 1;
                fillStyle0Index = 0;
                fillStyle1Index = 0;
                ShapeHelper.replaceStyles(shapeRecords2, lineStyleIndex, fillStyle0Index, fillStyle1Index);
                AbstractStrokeNode strokeNode = (AbstractStrokeNode)stroke;
                LineStyle ls = this.createGenericLineStyle(strokeNode);
                Rect shapeBounds = node.getBounds(shapeRecords2, ls);
                LineStyle lineStyle = this.createLineStyle(stroke, shapeBounds);
                swsStroke.linestyles = new ArrayList(1);
                swsStroke.linestyles.add(lineStyle);
                DefineShape strokeShape = new DefineShape(83);
                strokeShape.shapeWithStyle = swsStroke;
                strokeShape.bounds = shapeBounds;
                strokeShape.edgeBounds = edgeBounds;
                po3 = this.placeObject((DefineTag)strokeShape, context);
            }
            this.spriteStack.pop();
            po3 = this.placeObject((DefineTag)imageSprite, new GraphicContext());
            if (filters != null) {
                DefineSprite sprite = this.spriteStack.pop();
                GraphicContext gc = new GraphicContext();
                gc.filters = filters;
                PlaceObject poFilter = this.placeObject((DefineTag)sprite, gc);
                return poFilter;
            }
            return po3;
        }
        DefineShape shape = this.createDefineShape(node, shapeRecords, fill, stroke, context.getTransform(), windings);
        PlaceObject po3 = this.placeObject((DefineTag)shape, context);
        return po3;
    }

    protected FillStyle createFillStyle(FillNode fill, Rect bounds) {
        if (fill instanceof SolidColorFillNode) {
            return this.createFillStyle((SolidColorFillNode)fill);
        }
        if (fill instanceof LinearGradientFillNode) {
            return this.createFillStyle((LinearGradientFillNode)fill, bounds);
        }
        if (fill instanceof RadialGradientFillNode) {
            return this.createFillStyle((RadialGradientFillNode)fill, bounds);
        }
        if (fill instanceof BitmapFillNode) {
            return this.createFillStyle((BitmapFillNode)fill, bounds);
        }
        return null;
    }

    protected FillStyle createFillStyle(SolidColorFillNode fill) {
        FillStyle fs = new FillStyle();
        fs.color = TypeHelper.colorARGB(fill.color, fill.alpha);
        fs.type = 0;
        return fs;
    }

    protected FillStyle createFillStyle(BitmapFillNode fill, Rect bounds) {
        FillStyle fs = new FillStyle();
        fs.type = ImageHelper.bitmapFillModeIsRepeat(fill) ? 64 : 65;
        String sourceFormatted = this.parseSource(fill.source);
        if (sourceFormatted == null) {
            throw new FXGException(fill.getStartLine(), fill.getStartColumn(), "MissingSourceAttribute", new Object[0]);
        }
        DefineBits img = this.createDefineBits(fill, sourceFormatted);
        fs.bitmap = img;
        fs.matrix = TypeHelper.bitmapFillMatrix(fill, img, bounds).toSWFMatrix();
        return fs;
    }

    protected FillStyle createFillStyle(LinearGradientFillNode node, Rect bounds) {
        FillStyle fs = new FillStyle();
        fs.type = 16;
        fs.matrix = TypeHelper.linearGradientMatrix(node, bounds);
        Gradient gradient = new Gradient();
        this.populateGradient(gradient, node.entries, node.interpolationMethod, node.spreadMethod);
        fs.gradient = gradient;
        return fs;
    }

    protected FillStyle createFillStyle(LinearGradientStrokeNode node, Rect bounds) {
        FillStyle fs = new FillStyle();
        fs.type = 16;
        fs.matrix = TypeHelper.linearGradientMatrix(node, bounds);
        Gradient gradient = new Gradient();
        this.populateGradient(gradient, node.entries, node.interpolationMethod, node.spreadMethod);
        fs.gradient = gradient;
        return fs;
    }

    protected FillStyle createFillStyle(RadialGradientFillNode node, Rect bounds) {
        FillStyle fs = new FillStyle();
        fs.type = 19;
        fs.matrix = TypeHelper.radialGradientMatrix(node, bounds);
        FocalGradient gradient = new FocalGradient();
        this.populateGradient((Gradient)gradient, node.entries, node.interpolationMethod, node.spreadMethod);
        gradient.focalPoint = (float)node.focalPointRatio;
        fs.gradient = gradient;
        return fs;
    }

    protected FillStyle createFillStyle(RadialGradientStrokeNode node, Rect bounds) {
        FillStyle fs = new FillStyle();
        fs.type = 19;
        fs.matrix = TypeHelper.radialGradientMatrix(node, bounds);
        FocalGradient gradient = new FocalGradient();
        this.populateGradient((Gradient)gradient, node.entries, node.interpolationMethod, node.spreadMethod);
        gradient.focalPoint = (float)node.focalPointRatio;
        fs.gradient = gradient;
        return fs;
    }

    protected LineStyle createLineStyle(StrokeNode stroke, Rect bounds) {
        if (stroke instanceof SolidColorStrokeNode) {
            return this.createLineStyle((SolidColorStrokeNode)stroke);
        }
        if (stroke instanceof LinearGradientStrokeNode) {
            return this.createLineStyle((LinearGradientStrokeNode)stroke, bounds);
        }
        if (stroke instanceof RadialGradientStrokeNode) {
            return this.createLineStyle((RadialGradientStrokeNode)stroke, bounds);
        }
        return null;
    }

    private LineStyle createGenericLineStyle(AbstractStrokeNode stroke) {
        int startCapStyle;
        LineStyle ls = new LineStyle();
        ls.width = (int)StrictMath.rint(stroke.getWeight() * 20.0);
        int flags = 0;
        int endCapStyle = startCapStyle = this.createCaps(stroke.caps);
        int jointStyle = this.createJoints(stroke.joints);
        int noHorizonalScale = 1;
        int noVerticalScale = 1;
        if (stroke.scaleMode == ScaleMode.VERTICAL || stroke.scaleMode == ScaleMode.NONE) {
            flags |= noHorizonalScale << 1;
        }
        if (stroke.scaleMode == ScaleMode.HORIZONTAL || stroke.scaleMode == ScaleMode.NONE) {
            flags |= noVerticalScale << 2;
        }
        flags |= jointStyle << 4;
        flags |= startCapStyle << 6;
        if (stroke.pixelHinting) {
            flags |= 1;
        }
        flags |= endCapStyle << 8;
        if (jointStyle == 2) {
            ls.miterLimit = TypeHelper.fixed8(stroke.miterLimit);
        }
        ls.flags = flags;
        return ls;
    }

    protected LineStyle createLineStyle(SolidColorStrokeNode stroke) {
        LineStyle ls = this.createGenericLineStyle(stroke);
        ls.color = TypeHelper.colorARGB(stroke.color, stroke.alpha);
        return ls;
    }

    protected LineStyle createLineStyle(LinearGradientStrokeNode stroke, Rect bounds) {
        LineStyle ls = this.createGenericLineStyle(stroke);
        ls.fillStyle = this.createFillStyle(stroke, bounds);
        int hasFillStyle = 1;
        ls.flags |= hasFillStyle << 3;
        return ls;
    }

    protected LineStyle createLineStyle(RadialGradientStrokeNode stroke, Rect edgeBounds) {
        LineStyle ls = this.createGenericLineStyle(stroke);
        ls.fillStyle = this.createFillStyle(stroke, edgeBounds);
        int hasFillStyle = 1;
        ls.flags |= hasFillStyle << 3;
        return ls;
    }

    protected int createCaps(Caps value) {
        if (value != null) {
            return value.ordinal();
        }
        return Caps.NONE.ordinal();
    }

    protected int createJoints(Joints value) {
        if (value != null) {
            return value.ordinal();
        }
        return Joints.ROUND.ordinal();
    }

    protected int createSpreadMode(SpreadMethod value) {
        return value.ordinal();
    }

    protected int createBlendMode(BlendMode value) {
        return value.ordinal();
    }

    protected int createInterpolationMode(InterpolationMethod value) {
        return value.ordinal();
    }

    protected List<Filter> createFilters(List<FilterNode> list) {
        ArrayList<Filter> filters = new ArrayList<Filter>(list.size());
        for (FilterNode f : list) {
            BevelFilter filter;
            AbstractFilterNode node;
            if (f instanceof BevelFilterNode) {
                node = (BevelFilterNode)f;
                filter = this.createBevelFilter((BevelFilterNode)node);
                filters.add((Filter)filter);
                continue;
            }
            if (f instanceof BlurFilterNode) {
                node = (BlurFilterNode)f;
                filter = this.createBlurFilter((BlurFilterNode)node);
                filters.add((Filter)filter);
                continue;
            }
            if (f instanceof ColorMatrixFilterNode) {
                node = (ColorMatrixFilterNode)f;
                filter = new ColorMatrixFilter();
                filter.values = ((ColorMatrixFilterNode)node).matrix;
                filters.add((Filter)filter);
                continue;
            }
            if (f instanceof DropShadowFilterNode) {
                node = (DropShadowFilterNode)f;
                filter = this.createDropShadowFilter((DropShadowFilterNode)node);
                filters.add((Filter)filter);
                continue;
            }
            if (f instanceof GlowFilterNode) {
                node = (GlowFilterNode)f;
                filter = this.createGlowFilter((GlowFilterNode)node);
                filters.add((Filter)filter);
                continue;
            }
            if (f instanceof GradientBevelFilterNode) {
                node = (GradientBevelFilterNode)f;
                filter = this.createGradientBevelFilter((GradientBevelFilterNode)node);
                filters.add((Filter)filter);
                continue;
            }
            if (!(f instanceof GradientGlowFilterNode)) continue;
            node = (GradientGlowFilterNode)f;
            filter = this.createGradientGlowFilter((GradientGlowFilterNode)node);
            filters.add((Filter)filter);
        }
        return filters;
    }

    protected BevelFilter createBevelFilter(BevelFilterNode node) {
        BevelFilter filter = new BevelFilter();
        filter.angle = TypeHelper.fixed(node.angle * Math.PI / 180.0);
        filter.blurX = TypeHelper.fixed(node.blurX);
        filter.blurY = TypeHelper.fixed(node.blurY);
        filter.distance = TypeHelper.fixed(node.distance);
        filter.strength = TypeHelper.fixed8(node.strength);
        filter.shadowColor = TypeHelper.colorARGB(node.shadowColor, node.shadowAlpha);
        filter.highlightColor = TypeHelper.colorARGB(node.highlightColor, node.highlightAlpha);
        filter.flags = node.quality;
        if (node.type == BevelType.FULL) {
            filter.flags |= 0x10;
        }
        filter.flags |= 0x20;
        if (node.knockout) {
            filter.flags |= 0x40;
        }
        if (node.type == BevelType.INNER) {
            filter.flags |= 0x80;
        }
        return filter;
    }

    protected BlurFilter createBlurFilter(BlurFilterNode node) {
        BlurFilter filter = new BlurFilter();
        filter.blurX = TypeHelper.fixed(node.blurX);
        filter.blurY = TypeHelper.fixed(node.blurY);
        filter.passes = node.quality << 3;
        return filter;
    }

    protected DropShadowFilter createDropShadowFilter(DropShadowFilterNode node) {
        DropShadowFilter filter = new DropShadowFilter();
        filter.color = TypeHelper.colorARGB(node.color, node.alpha);
        filter.angle = TypeHelper.fixed(node.angle * Math.PI / 180.0);
        filter.blurX = TypeHelper.fixed(node.blurX);
        filter.blurY = TypeHelper.fixed(node.blurY);
        filter.distance = TypeHelper.fixed(node.distance);
        filter.strength = TypeHelper.fixed8(node.strength);
        filter.flags = node.quality;
        if (!node.hideObject) {
            filter.flags |= 0x20;
        }
        if (node.knockout) {
            filter.flags |= 0x40;
        }
        if (node.inner) {
            filter.flags |= 0x80;
        }
        return filter;
    }

    protected GlowFilter createGlowFilter(GlowFilterNode node) {
        GlowFilter filter = new GlowFilter();
        filter.color = TypeHelper.colorARGB(node.color, node.alpha);
        filter.blurX = TypeHelper.fixed(node.blurX);
        filter.blurY = TypeHelper.fixed(node.blurY);
        filter.strength = TypeHelper.fixed8(node.strength);
        filter.flags = node.quality;
        filter.flags |= 0x20;
        if (node.knockout) {
            filter.flags |= 0x40;
        }
        if (node.inner) {
            filter.flags |= 0x80;
        }
        return filter;
    }

    protected GradientBevelFilter createGradientBevelFilter(GradientBevelFilterNode node) {
        GradientBevelFilter filter = new GradientBevelFilter();
        if (node.entries != null) {
            byte count = (byte)node.entries.size();
            filter.numcolors = count;
            filter.gradientColors = new int[count];
            filter.gradientRatio = new int[count];
            GradRecord[] records = this.createGradRecords(node.entries);
            for (int i = 0; i < records.length; ++i) {
                GradRecord record = records[i];
                filter.gradientColors[i] = record.color;
                filter.gradientRatio[i] = record.ratio;
            }
        }
        filter.angle = TypeHelper.fixed(node.angle * Math.PI / 180.0);
        filter.blurX = TypeHelper.fixed(node.blurX);
        filter.blurY = TypeHelper.fixed(node.blurY);
        filter.distance = TypeHelper.fixed(node.distance);
        filter.strength = TypeHelper.fixed8(node.strength);
        filter.flags = node.quality;
        if (node.type == BevelType.FULL) {
            filter.flags |= 0x10;
        }
        filter.flags |= 0x20;
        if (node.knockout) {
            filter.flags |= 0x40;
        }
        if (node.type == BevelType.INNER) {
            filter.flags |= 0x80;
        }
        return filter;
    }

    protected GradientGlowFilter createGradientGlowFilter(GradientGlowFilterNode node) {
        GradientGlowFilter filter = new GradientGlowFilter();
        if (node.entries != null) {
            byte count = (byte)node.entries.size();
            filter.numcolors = count;
            filter.gradientColors = new int[count];
            filter.gradientRatio = new int[count];
            GradRecord[] records = this.createGradRecords(node.entries);
            for (int i = 0; i < records.length; ++i) {
                GradRecord record = records[i];
                filter.gradientColors[i] = record.color;
                filter.gradientRatio[i] = record.ratio;
            }
        }
        filter.angle = TypeHelper.fixed(node.angle * Math.PI / 180.0);
        filter.blurX = TypeHelper.fixed(node.blurX);
        filter.blurY = TypeHelper.fixed(node.blurY);
        filter.distance = TypeHelper.fixed(node.distance);
        filter.strength = TypeHelper.fixed8(node.strength);
        filter.flags = node.quality;
        filter.flags |= 0x20;
        if (node.knockout) {
            filter.flags |= 0x40;
        }
        if (node.inner) {
            filter.flags |= 0x80;
        }
        return filter;
    }

    protected void populateGradient(Gradient gradient, List<GradientEntryNode> entries, InterpolationMethod interpolation, SpreadMethod spread) {
        gradient.records = this.createGradRecords(entries);
        if (interpolation != null) {
            gradient.interpolationMode = this.createInterpolationMode(interpolation);
        }
        if (spread != null) {
            gradient.spreadMode = this.createSpreadMode(spread);
        }
    }

    protected GradRecord[] createGradRecords(List<GradientEntryNode> entries) {
        int count = entries.size();
        GradRecord[] records = new GradRecord[count];
        double previousRatio = 0.0;
        for (int currentIndex = 0; currentIndex < count; ++currentIndex) {
            GradientEntryNode entry = entries.get(currentIndex);
            double thisRatio = entry.ratio;
            if (Double.isNaN(thisRatio)) {
                if (currentIndex == 0) {
                    thisRatio = 0.0;
                } else if (currentIndex == count - 1) {
                    thisRatio = 1.0;
                } else {
                    int entryGap;
                    double nextRatio = 1.0;
                    int nextIndex = count - 1;
                    for (int i = currentIndex; i < count; ++i) {
                        GradientEntryNode nextEntry = entries.get(i);
                        if (Double.isNaN(nextEntry.ratio)) continue;
                        nextRatio = nextEntry.ratio;
                        nextIndex = i;
                        break;
                    }
                    thisRatio = (entryGap = nextIndex - (currentIndex - 1)) > 0 ? previousRatio + (nextRatio - previousRatio) / (double)entryGap : previousRatio;
                }
            }
            GradRecord record = new GradRecord();
            record.color = TypeHelper.colorARGB(entry.color, entry.alpha);
            record.ratio = TypeHelper.gradientRatio(thisRatio);
            records[currentIndex] = record;
            previousRatio = thisRatio;
        }
        return records;
    }

    protected String parseSource(String source) {
        if (source != null && (source = source.trim()).startsWith("@Embed(")) {
            if ((source = source.substring(7).trim()).endsWith(")")) {
                source = source.substring(0, source.length() - 1).trim();
            }
            if (source.charAt(0) == '\'' && source.charAt(source.length() - 1) == '\'') {
                source = source.substring(1, source.length() - 1).trim();
            }
        }
        return source;
    }

    private void markLeafNodesAsMask(MaskableNode maskableNode, GroupNode mask) {
        if (mask == null || mask.children == null) {
            return;
        }
        for (GraphicContentNode gcNode : mask.children) {
            if (gcNode instanceof GroupNode) {
                this.markLeafNodesAsMask(maskableNode, (GroupNode)gcNode);
                continue;
            }
            if (maskableNode.getMaskType() != MaskType.CLIP) continue;
            gcNode.isPartofClipMask = true;
        }
    }
}

