/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.fxg.swf;

import com.adobe.internal.fxg.dom.ScalableGradientNode;
import com.adobe.internal.fxg.dom.fills.BitmapFillNode;
import com.adobe.internal.fxg.dom.transforms.MatrixNode;
import com.adobe.internal.fxg.swf.types.FXGMatrix;
import flash.swf.types.CXFormWithAlpha;
import flash.swf.types.Matrix;
import flash.swf.types.Rect;
import java.awt.geom.AffineTransform;

public class TypeHelper {
    public static Rect rect(double minX, double minY, double maxX, double maxY) {
        Rect rect = new Rect();
        rect.xMin = (int)(minX * 20.0);
        rect.yMin = (int)(minY * 20.0);
        rect.xMax = (int)(maxX * 20.0);
        rect.yMax = (int)(maxY * 20.0);
        return rect;
    }

    public static Rect rect(double width, double height) {
        Rect rect = new Rect();
        rect.xMax = (int)(width * 20.0);
        rect.yMax = (int)(height * 20.0);
        return rect;
    }

    public static Matrix matrix(AffineTransform at, boolean clockwiseRotation) {
        Matrix matrix = new Matrix();
        matrix.scaleX = (int)(at.getScaleX() * 65536.0);
        matrix.scaleY = (int)(at.getScaleY() * 65536.0);
        if (matrix.scaleX != 0 || matrix.scaleY != 0) {
            matrix.hasScale = true;
        }
        if (clockwiseRotation) {
            matrix.rotateSkew0 = (int)(at.getShearX() * 65536.0);
            matrix.rotateSkew1 = (int)(at.getShearY() * 65536.0);
        } else {
            matrix.rotateSkew0 = (int)(at.getShearY() * 65536.0);
            matrix.rotateSkew1 = (int)(at.getShearX() * 65536.0);
        }
        if (matrix.rotateSkew0 != 0 || matrix.rotateSkew1 != 0) {
            matrix.hasRotate = true;
            if ((at.getType() & 0x18) != 0) {
                matrix.hasScale = true;
            }
        }
        matrix.translateX = (int)(at.getTranslateX() * 20.0);
        matrix.translateY = (int)(at.getTranslateY() * 20.0);
        return matrix;
    }

    public static Matrix radialGradientMatrix(double width, double height, ScalableGradientNode node) {
        double degrees;
        MatrixNode mtxNode = node.getMatrixNode();
        AffineTransform atFromMatrixNode = null;
        if (mtxNode != null) {
            atFromMatrixNode = mtxNode.toAffineTransform();
        }
        double w = !Double.isNaN(node.getScaleX()) ? node.getScaleX() : width;
        double h = !Double.isNaN(node.getScaleY()) ? node.getScaleY() : height;
        double tx = !Double.isNaN(node.getX()) ? node.getX() : width / 2.0;
        double ty = !Double.isNaN(node.getY()) ? node.getY() : height / 2.0;
        double sx = w * 20.0 / 32768.0;
        double sy = h * 20.0 / 32768.0;
        for (degrees = node.getRotation(); degrees < 0.0; degrees += 360.0) {
        }
        if (degrees > 180.0) {
            degrees -= 360.0;
        }
        double theta = degrees / 180.0 * Math.PI;
        AffineTransform at = new AffineTransform();
        at.translate(tx, ty);
        at.scale(sx, sy);
        if (degrees % 360.0 == 0.0) {
            return TypeHelper.matrix(at, true);
        }
        at.rotate(-theta);
        at.translate(-tx, -ty);
        if (atFromMatrixNode != null) {
            at.concatenate(atFromMatrixNode);
        }
        return TypeHelper.matrix(at, true);
    }

    public static Matrix linearGradientMatrix(ScalableGradientNode gradient, Rect pathBounds) {
        double width = (pathBounds.xMax - pathBounds.xMin) / 20;
        double height = (pathBounds.yMax - pathBounds.yMin) / 20;
        double scaleX = gradient.getScaleX();
        double rotation = gradient.getRotation();
        double offsetX = gradient.getX();
        double offsetY = gradient.getY();
        if (Double.isNaN(scaleX)) {
            if (rotation % 90.0 != 0.0) {
                double normalizedAngle = rotation % 360.0;
                if (normalizedAngle < 0.0) {
                    normalizedAngle += 360.0;
                }
                if ((normalizedAngle %= 180.0) > 90.0) {
                    normalizedAngle = 180.0 - normalizedAngle;
                }
                double side = width;
                double hypotenuse = Math.sqrt(width * width + height * height);
                double hypotenuseAngle = Math.acos(width / hypotenuse) * 180.0 / Math.PI;
                if (normalizedAngle > hypotenuseAngle) {
                    normalizedAngle = 90.0 - normalizedAngle;
                    side = height;
                }
                scaleX = side / Math.cos(normalizedAngle / 180.0 * Math.PI);
            } else {
                scaleX = rotation % 180.0 == 0.0 ? width : height;
            }
        }
        FXGMatrix matrix = new FXGMatrix();
        if (!Double.isNaN(offsetX) && Double.isNaN(offsetY)) {
            offsetY = 0.0;
        }
        if (Double.isNaN(offsetX) && !Double.isNaN(offsetY)) {
            offsetX = 0.0;
        }
        if (!Double.isNaN(offsetX) && !Double.isNaN(offsetY)) {
            matrix.translate(819.0, 819.0);
        }
        if (Double.isNaN(offsetX)) {
            offsetX = width / 2.0;
        }
        if (Double.isNaN(offsetY)) {
            offsetY = height / 2.0;
        }
        scaleX = Math.max(scaleX, 2.0);
        scaleX = scaleX * 20.0 / 32768.0;
        matrix.scale(scaleX, 1.0);
        if (!Double.isNaN(rotation)) {
            matrix.rotate(rotation);
        }
        matrix.translate(offsetX, offsetY);
        return matrix.toSWFMatrix();
    }

    public static Matrix bitmapFillMatrix(BitmapFillNode fill) {
        MatrixNode mtxNode = fill.getMatrix();
        AffineTransform atFromMatrixNode = null;
        if (mtxNode != null) {
            atFromMatrixNode = mtxNode.toAffineTransform();
            return TypeHelper.matrix(atFromMatrixNode, true);
        }
        Matrix matrix = new Matrix();
        matrix.translateX = (int)(fill.x * 20.0);
        matrix.translateY = (int)(fill.y * 20.0);
        if (fill.rotation != 0.0) {
            int degrees;
            for (degrees = (int)fill.rotation; degrees < 0; degrees += 360) {
            }
            if (degrees >= 180) {
                degrees -= 180;
            }
            double theta = (double)degrees / 180.0 * Math.PI;
            double sin = Math.sin(theta);
            double cos = Math.cos(theta);
            if (theta != 0.0) {
                matrix.hasRotate = true;
            }
            matrix.scaleX = (int)(cos * 20.0 * 65536.0 * fill.scaleX);
            matrix.scaleY = (int)(cos * 20.0 * 65536.0 * fill.scaleY);
            matrix.rotateSkew0 = (int)(sin * 20.0 * 65536.0 * fill.scaleX);
            matrix.rotateSkew1 = -((int)(sin * 20.0 * 65536.0 * fill.scaleY));
            matrix.hasScale = true;
        } else {
            matrix.scaleX = (int)(1310720.0 * fill.scaleX);
            matrix.scaleY = (int)(1310720.0 * fill.scaleY);
            matrix.hasScale = true;
        }
        return matrix;
    }

    public static CXFormWithAlpha cxFormWithAlpha(double alphaMultiplier) {
        CXFormWithAlpha c = new CXFormWithAlpha();
        c.hasMult = true;
        c.alphaMultTerm = TypeHelper.fixed8(alphaMultiplier);
        return c;
    }

    public static CXFormWithAlpha cxFormWithAlpha(double alphaMultiplier, double redMultiplier, double greenMultiplier, double blueMultiplier, double alphaOffset, double redOffset, double greenOffset, double blueOffset) {
        CXFormWithAlpha c = new CXFormWithAlpha();
        c.alphaMultTerm = TypeHelper.fixed8(alphaMultiplier);
        c.redMultTerm = TypeHelper.fixed8(redMultiplier);
        c.greenMultTerm = TypeHelper.fixed8(greenMultiplier);
        c.blueMultTerm = TypeHelper.fixed8(blueMultiplier);
        c.alphaAddTerm = (int)(alphaOffset * 255.0);
        c.redAddTerm = (int)(redOffset * 255.0);
        c.greenAddTerm = (int)(greenOffset * 255.0);
        c.blueAddTerm = (int)(blueOffset * 255.0);
        if (c.alphaAddTerm > 0 || c.redAddTerm > 0 || c.greenAddTerm > 0 || c.blueAddTerm > 0) {
            c.hasAdd = true;
        }
        if (c.alphaMultTerm > 0 || c.redMultTerm > 0 || c.greenMultTerm > 0 || c.blueMultTerm > 0) {
            c.hasMult = true;
        }
        return c;
    }

    public static int gradientRatio(double ratio) {
        return (int)StrictMath.rint(ratio * 255.0);
    }

    public static int colorARGB(int color, double alpha) {
        int rgb = color & 0xFFFFFF;
        int a = (int)StrictMath.rint(alpha * 255.0);
        int argb = rgb | a << 24;
        return argb;
    }

    public static int fixed(double value) {
        return (int)(value * 65536.0);
    }

    public static int fixed8(double value) {
        return (int)(value * 256.0) & 0xFFFF;
    }
}

