/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.fxg.sax;

import com.adobe.fxg.FXGException;
import com.adobe.fxg.dom.FXGNode;
import com.adobe.internal.fxg.dom.BitmapGraphicNode;
import com.adobe.internal.fxg.dom.DefinitionNode;
import com.adobe.internal.fxg.dom.DelegateNode;
import com.adobe.internal.fxg.dom.EllipseNode;
import com.adobe.internal.fxg.dom.GradientEntryNode;
import com.adobe.internal.fxg.dom.GraphicNode;
import com.adobe.internal.fxg.dom.GroupDefinitionNode;
import com.adobe.internal.fxg.dom.GroupNode;
import com.adobe.internal.fxg.dom.LibraryNode;
import com.adobe.internal.fxg.dom.LineNode;
import com.adobe.internal.fxg.dom.MaskPropertyNode;
import com.adobe.internal.fxg.dom.PathNode;
import com.adobe.internal.fxg.dom.RectNode;
import com.adobe.internal.fxg.dom.TextGraphicNode;
import com.adobe.internal.fxg.dom.TextNode;
import com.adobe.internal.fxg.dom.fills.BitmapFillNode;
import com.adobe.internal.fxg.dom.fills.LinearGradientFillNode;
import com.adobe.internal.fxg.dom.fills.RadialGradientFillNode;
import com.adobe.internal.fxg.dom.fills.SolidColorFillNode;
import com.adobe.internal.fxg.dom.filters.BevelFilterNode;
import com.adobe.internal.fxg.dom.filters.BlurFilterNode;
import com.adobe.internal.fxg.dom.filters.ColorMatrixFilterNode;
import com.adobe.internal.fxg.dom.filters.DropShadowFilterNode;
import com.adobe.internal.fxg.dom.filters.GlowFilterNode;
import com.adobe.internal.fxg.dom.filters.GradientBevelFilterNode;
import com.adobe.internal.fxg.dom.filters.GradientGlowFilterNode;
import com.adobe.internal.fxg.dom.strokes.LinearGradientStrokeNode;
import com.adobe.internal.fxg.dom.strokes.RadialGradientStrokeNode;
import com.adobe.internal.fxg.dom.strokes.SolidColorStrokeNode;
import com.adobe.internal.fxg.dom.text.BRNode;
import com.adobe.internal.fxg.dom.text.CDATANode;
import com.adobe.internal.fxg.dom.text.ParagraphNode;
import com.adobe.internal.fxg.dom.text.SpanNode;
import com.adobe.internal.fxg.dom.transforms.ColorTransformNode;
import com.adobe.internal.fxg.dom.transforms.MatrixNode;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FXGSAXScanner
extends DefaultHandler {
    private static final String FXG_GROUP_DEFINITION_ELEMENT = "[GroupDefinition]";
    private GraphicNode root;
    private Stack<FXGNode> stack;
    private int skippedElementCount;
    private Locator locator;
    private int startLine = 0;
    private int startColumn = 0;
    private Map<String, Set<String>> skippedElementsByURI;
    private final Map<String, Map<String, Class<? extends FXGNode>>> elementNodesByURI = new HashMap<String, Map<String, Class<? extends FXGNode>>>(1);
    private static Map<String, Class<? extends FXGNode>> DEFAULT_FXG_1_0_NODES = new HashMap<String, Class<? extends FXGNode>>();

    public FXGSAXScanner() {
        this.skippedElementsByURI = new HashMap<String, Set<String>>(1);
        HashSet<String> skippedElements = new HashSet<String>(1);
        skippedElements.add("Private");
        this.skippedElementsByURI.put("http://ns.adobe.com/fxg/2008", skippedElements);
    }

    public FXGNode getRootNode() {
        return this.root;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void startDocument() throws SAXException {
        this.stack = new Stack();
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if (this.isSkippedElement(uri, localName)) {
            ++this.skippedElementCount;
        }
        if (this.inSkippedElement()) {
            return;
        }
        this.startLine = this.locator.getLineNumber();
        this.startColumn = this.locator.getColumnNumber();
        FXGNode parent = null;
        if (this.stack.size() > 0) {
            parent = this.stack.peek();
        }
        if (this.isFXGNamespace(uri) && parent instanceof DefinitionNode && "Group".equals(localName)) {
            localName = FXG_GROUP_DEFINITION_ELEMENT;
        }
        FXGNode node = this.createNode(uri, localName);
        for (int i = 0; i < attributes.getLength(); ++i) {
            String attributeURI = attributes.getURI(i);
            if (attributeURI != null && attributeURI != "" && !this.isFXGNamespace(attributeURI)) continue;
            String attributeName = attributes.getLocalName(i);
            String attributeValue = attributes.getValue(i);
            node.setAttribute(attributeName, attributeValue);
        }
        if (parent != null) {
            if (node instanceof DelegateNode) {
                DelegateNode propertyNode = (DelegateNode)node;
                propertyNode.setName(localName);
                propertyNode.setDelegate(parent);
            } else {
                parent.addChild(node);
            }
        } else if (node instanceof GraphicNode) {
            this.root = (GraphicNode)node;
        } else {
            throw new FXGException(this.startLine, this.startColumn, "InvalidFXGRootNode", new Object[0]);
        }
        node.setDocumentNode(this.root);
        this.stack.push(node);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.stack != null && this.stack.size() > 0 && !this.inSkippedElement()) {
            FXGNode node = this.stack.peek();
            String content = new String(ch, start, length);
            if (!(node instanceof TextNode)) {
                content = content.trim();
            }
            if (content.length() > 0) {
                CDATANode cdata = new CDATANode();
                cdata.content = content;
                this.assignNodeLocation(cdata);
                node.addChild(cdata);
            }
        }
        this.startLine = this.locator.getLineNumber();
        this.startColumn = this.locator.getColumnNumber();
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if (this.isSkippedElement(uri, localName)) {
            --this.skippedElementCount;
        } else if (!this.inSkippedElement()) {
            this.stack.pop();
        }
        this.startLine = this.locator.getLineNumber();
        this.startColumn = this.locator.getColumnNumber();
    }

    public int getStartLine() {
        return this.startLine;
    }

    public int getStartColumn() {
        return this.startColumn;
    }

    protected boolean isFXGNamespace(String uri) {
        return "http://ns.adobe.com/fxg/2008".equals(uri);
    }

    protected void skipElement(String uri, String localName) {
        if (localName == null) {
            return;
        }
        Set<String> skippedElements = this.skippedElementsByURI.get(uri);
        if (skippedElements == null) {
            skippedElements = new HashSet<String>(1);
            this.skippedElementsByURI.put(uri, skippedElements);
        }
        skippedElements.add(localName);
    }

    protected boolean isSkippedElement(String uri, String localName) {
        Set<String> skippedElements = this.skippedElementsByURI.get(uri);
        return skippedElements != null && skippedElements.contains(localName);
    }

    protected FXGNode createNode(String uri, String localName) {
        FXGNode node = null;
        try {
            Map<String, Class<? extends FXGNode>> elementNodes = this.getElementNodes(uri);
            if (elementNodes != null) {
                Class<? extends FXGNode> nodeClass = elementNodes.get(localName);
                if (nodeClass != null) {
                    node = nodeClass.newInstance();
                } else if (this.root != null) {
                    node = this.root.getDefinitionInstance(localName);
                }
            }
        }
        catch (Throwable t) {
            throw new FXGException(this.startLine, this.startColumn, "ErrorScanningFXG", t, new Object[0]);
        }
        if (node == null) {
            throw new FXGException(this.startLine, this.startColumn, "UnknownElement", uri, localName);
        }
        this.assignNodeLocation(node);
        return node;
    }

    protected void registerElementNode(String uri, String localName, Class<? extends FXGNode> nodeClass) {
        Map<String, Class<? extends FXGNode>> elementNodes = this.elementNodesByURI.get(uri);
        if (elementNodes == null) {
            if ("http://ns.adobe.com/fxg/2008".equals(uri)) {
                elementNodes = new HashMap<String, Class<? extends FXGNode>>(DEFAULT_FXG_1_0_NODES.size() + 4);
                elementNodes.putAll(DEFAULT_FXG_1_0_NODES);
            } else {
                elementNodes = new HashMap<String, Class<? extends FXGNode>>(4);
            }
            this.elementNodesByURI.put(uri, elementNodes);
        }
        elementNodes.put(localName, nodeClass);
    }

    private boolean inSkippedElement() {
        return this.skippedElementCount > 0;
    }

    private void assignNodeLocation(FXGNode node) {
        if (node != null) {
            node.setStartLine(this.startLine);
            node.setStartColumn(this.startColumn);
            node.setEndLine(this.locator.getLineNumber());
            node.setEndColumn(this.locator.getColumnNumber());
        }
    }

    private Map<String, Class<? extends FXGNode>> getElementNodes(String uri) {
        Map<String, Class<? extends FXGNode>> elementNodes = this.elementNodesByURI.get(uri);
        if (elementNodes == null && "http://ns.adobe.com/fxg/2008".equals(uri)) {
            return DEFAULT_FXG_1_0_NODES;
        }
        return elementNodes;
    }

    static {
        DEFAULT_FXG_1_0_NODES.put("Graphic", GraphicNode.class);
        DEFAULT_FXG_1_0_NODES.put("Definition", DefinitionNode.class);
        DEFAULT_FXG_1_0_NODES.put("Library", LibraryNode.class);
        DEFAULT_FXG_1_0_NODES.put("BevelFilter", BevelFilterNode.class);
        DEFAULT_FXG_1_0_NODES.put("BitmapFill", BitmapFillNode.class);
        DEFAULT_FXG_1_0_NODES.put("BitmapGraphic", BitmapGraphicNode.class);
        DEFAULT_FXG_1_0_NODES.put("BlurFilter", BlurFilterNode.class);
        DEFAULT_FXG_1_0_NODES.put("br", BRNode.class);
        DEFAULT_FXG_1_0_NODES.put("ColorMatrixFilter", ColorMatrixFilterNode.class);
        DEFAULT_FXG_1_0_NODES.put("ColorTransform", ColorTransformNode.class);
        DEFAULT_FXG_1_0_NODES.put("DropShadowFilter", DropShadowFilterNode.class);
        DEFAULT_FXG_1_0_NODES.put("Ellipse", EllipseNode.class);
        DEFAULT_FXG_1_0_NODES.put("GlowFilter", GlowFilterNode.class);
        DEFAULT_FXG_1_0_NODES.put("GradientEntry", GradientEntryNode.class);
        DEFAULT_FXG_1_0_NODES.put("GradientBevelFilter", GradientBevelFilterNode.class);
        DEFAULT_FXG_1_0_NODES.put("GradientGlowFilter", GradientGlowFilterNode.class);
        DEFAULT_FXG_1_0_NODES.put("Group", GroupNode.class);
        DEFAULT_FXG_1_0_NODES.put("Line", LineNode.class);
        DEFAULT_FXG_1_0_NODES.put("LinearGradient", LinearGradientFillNode.class);
        DEFAULT_FXG_1_0_NODES.put("LinearGradientStroke", LinearGradientStrokeNode.class);
        DEFAULT_FXG_1_0_NODES.put("Matrix", MatrixNode.class);
        DEFAULT_FXG_1_0_NODES.put("p", ParagraphNode.class);
        DEFAULT_FXG_1_0_NODES.put("Path", PathNode.class);
        DEFAULT_FXG_1_0_NODES.put("RadialGradient", RadialGradientFillNode.class);
        DEFAULT_FXG_1_0_NODES.put("RadialGradientStroke", RadialGradientStrokeNode.class);
        DEFAULT_FXG_1_0_NODES.put("Rect", RectNode.class);
        DEFAULT_FXG_1_0_NODES.put("SolidColor", SolidColorFillNode.class);
        DEFAULT_FXG_1_0_NODES.put("SolidColorStroke", SolidColorStrokeNode.class);
        DEFAULT_FXG_1_0_NODES.put("span", SpanNode.class);
        DEFAULT_FXG_1_0_NODES.put("TextGraphic", TextGraphicNode.class);
        DEFAULT_FXG_1_0_NODES.put("Transform", DelegateNode.class);
        DEFAULT_FXG_1_0_NODES.put("colorTransform", DelegateNode.class);
        DEFAULT_FXG_1_0_NODES.put("content", DelegateNode.class);
        DEFAULT_FXG_1_0_NODES.put("fill", DelegateNode.class);
        DEFAULT_FXG_1_0_NODES.put("filters", DelegateNode.class);
        DEFAULT_FXG_1_0_NODES.put("mask", MaskPropertyNode.class);
        DEFAULT_FXG_1_0_NODES.put("matrix", DelegateNode.class);
        DEFAULT_FXG_1_0_NODES.put("stroke", DelegateNode.class);
        DEFAULT_FXG_1_0_NODES.put("transform", DelegateNode.class);
        DEFAULT_FXG_1_0_NODES.put(FXG_GROUP_DEFINITION_ELEMENT, GroupDefinitionNode.class);
    }
}

