/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.fxg.dom.fills;

import com.adobe.fxg.FXGException;
import com.adobe.fxg.dom.FXGNode;
import com.adobe.internal.fxg.dom.GradientEntryNode;
import com.adobe.internal.fxg.dom.ScalableGradientNode;
import com.adobe.internal.fxg.dom.fills.AbstractFillNode;
import com.adobe.internal.fxg.dom.transforms.MatrixNode;
import com.adobe.internal.fxg.dom.types.InterpolationMethod;
import com.adobe.internal.fxg.dom.types.SpreadMethod;
import java.util.ArrayList;
import java.util.List;

public class RadialGradientFillNode
extends AbstractFillNode
implements ScalableGradientNode {
    private static final double FOCAL_MIN_INCLUSIVE = -1.0;
    private static final double FOCAL_MAX_INCLUSIVE = 1.0;
    public double x = Double.NaN;
    public double y = Double.NaN;
    public double scaleX = Double.NaN;
    public double scaleY = Double.NaN;
    public double rotation = 0.0;
    public SpreadMethod spreadMethod = SpreadMethod.PAD;
    public InterpolationMethod interpolationMethod = InterpolationMethod.RGB;
    public double focalPointRatio;
    private boolean translateSet;
    private boolean scaleSet;
    private boolean rotationSet;
    public MatrixNode matrix;
    public List<GradientEntryNode> entries;

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getScaleX() {
        return this.scaleX;
    }

    public double getScaleY() {
        return this.scaleY;
    }

    public double getRotation() {
        return this.rotation;
    }

    public MatrixNode getMatrixNode() {
        return this.matrix;
    }

    public boolean isLinear() {
        return false;
    }

    public void addChild(FXGNode child) {
        if (child instanceof MatrixNode) {
            if (this.translateSet || this.scaleSet || this.rotationSet) {
                throw new FXGException(child.getStartLine(), child.getStartColumn(), "InvalidChildMatrixNode", new Object[0]);
            }
            this.matrix = (MatrixNode)child;
        } else if (child instanceof GradientEntryNode) {
            if (this.entries == null) {
                this.entries = new ArrayList<GradientEntryNode>(4);
            } else if (this.entries.size() >= 16) {
                throw new FXGException(child.getStartLine(), child.getStartColumn(), "InvalidRadialGradientNumElements", new Object[0]);
            }
            this.entries.add((GradientEntryNode)child);
        } else {
            super.addChild(child);
        }
    }

    public String getNodeName() {
        return "RadialGradient";
    }

    public void setAttribute(String name, String value) {
        if ("x".equals(name)) {
            this.x = this.parseDouble(value);
            this.translateSet = true;
        } else if ("y".equals(name)) {
            this.y = this.parseDouble(value);
            this.translateSet = true;
        } else if ("rotation".equals(name)) {
            this.rotation = this.parseDouble(value);
            this.rotationSet = true;
        } else if ("scaleX".equals(name)) {
            this.scaleX = this.parseDouble(value);
            this.scaleSet = true;
        } else if ("scaleY".equals(name)) {
            this.scaleY = this.parseDouble(value);
            this.scaleSet = true;
        } else if ("spreadMethod".equals(name)) {
            this.spreadMethod = this.parseSpreadMethod(value);
        } else if ("interpolationMethod".equals(name)) {
            this.interpolationMethod = this.parseInterpolationMethod(value);
        } else if ("focalPointRatio".equals(name)) {
            this.focalPointRatio = this.parseDouble(value, -1.0, 1.0);
        } else {
            super.setAttribute(name, value);
        }
    }
}

