/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.fxg.dom;

import com.adobe.fxg.FXGException;
import com.adobe.fxg.dom.FXGNode;
import com.adobe.internal.fxg.dom.GraphicContentNode;
import com.adobe.internal.fxg.dom.TextNode;
import com.adobe.internal.fxg.dom.text.AbstractCharacterTextNode;
import com.adobe.internal.fxg.dom.text.BRNode;
import com.adobe.internal.fxg.dom.text.CDATANode;
import com.adobe.internal.fxg.dom.text.ParagraphNode;
import com.adobe.internal.fxg.dom.text.SpanNode;
import com.adobe.internal.fxg.dom.types.Kerning;
import com.adobe.internal.fxg.dom.types.LineBreak;
import com.adobe.internal.fxg.dom.types.WhiteSpaceCollapse;
import java.util.ArrayList;
import java.util.List;

public class TextGraphicNode
extends GraphicContentNode {
    public double width = 0.0;
    public double height = 0.0;
    public double paddingLeft = 0.0;
    public double paddingRight = 0.0;
    public double paddingBottom = 0.0;
    public double paddingTop = 0.0;
    public String fontFamily = "Times New Roman";
    public double fontSize = 12.0;
    public String fontStyle = "normal";
    public String fontWeight = "normal";
    public double lineHeight = 120.0;
    public String textDecoration = "none";
    public WhiteSpaceCollapse whiteSpaceCollapse = WhiteSpaceCollapse.PRESERVE;
    public LineBreak lineBreak = LineBreak.TOFIT;
    public boolean lineThrough = false;
    public double tracking = 0.0;
    public Kerning kerning = Kerning.AUTO;
    public double textAlpha = 1.0;
    public int color = -16777216;
    public String textAlign = "left";
    public String textAlignLast = "left";
    public double textIndent = 0.0;
    public double marginLeft = 0.0;
    public double marginRight = 0.0;
    public double marginTop = 0.0;
    public double marginBottom = 0.0;
    public String direction = "ltr";
    public String blockProgression = "tb";
    private boolean contiguous = false;
    public List<TextNode> content;

    public void addChild(FXGNode child) {
        if (child instanceof ParagraphNode || child instanceof BRNode || child instanceof SpanNode || child instanceof CDATANode) {
            if (this.content == null) {
                this.content = new ArrayList<TextNode>();
                this.contiguous = true;
            }
            if (!this.contiguous) {
                throw new FXGException(child.getStartLine(), child.getStartColumn(), "InvalidTextGraphicContent", new Object[0]);
            }
            this.content.add((TextNode)child);
        } else {
            super.addChild(child);
            this.contiguous = false;
        }
    }

    public String getNodeName() {
        return "TextGraphic";
    }

    public void setAttribute(String name, String value) {
        if ("width".equals(name)) {
            this.width = this.parseDouble(value);
            return;
        }
        if ("height".equals(name)) {
            this.height = this.parseDouble(value);
            return;
        }
        if ("paddingLeft".equals(name)) {
            this.paddingLeft = this.parseDouble(value);
            return;
        }
        if ("paddingRight".equals(name)) {
            this.paddingRight = this.parseDouble(value);
            return;
        }
        if ("paddingBottom".equals(name)) {
            this.paddingBottom = this.parseDouble(value);
            return;
        }
        if ("paddingTop".equals(name)) {
            this.paddingTop = this.parseDouble(value);
            return;
        }
        if ("fontFamily".equals(name)) {
            this.fontFamily = value;
            return;
        }
        if ("fontSize".equals(name)) {
            this.fontSize = this.parseDouble(value);
            return;
        }
        if ("fontStyle".equals(name)) {
            this.fontStyle = value;
            return;
        }
        if ("fontWeight".equals(name)) {
            this.fontWeight = value;
            return;
        }
        if ("lineHeight".equals(name)) {
            this.lineHeight = this.parsePercent(value);
            return;
        }
        if ("textDecoration".equals(name)) {
            this.textDecoration = value;
            return;
        }
        if ("whiteSpaceCollapse".equals(name)) {
            this.whiteSpaceCollapse = AbstractCharacterTextNode.getWhiteSpaceCollapse(this, value);
            return;
        }
        if ("lineBreak".equals(name)) {
            this.lineBreak = AbstractCharacterTextNode.getLineBreak(this, value);
            return;
        }
        if ("tracking".equals(name)) {
            this.tracking = this.parsePercent(value);
            return;
        }
        if ("kerning".equals(name)) {
            this.kerning = AbstractCharacterTextNode.getKerning(this, value);
            return;
        }
        if ("textAlpha".equals(name)) {
            this.textAlpha = this.parseDouble(value, 0.0, 1.0);
            return;
        }
        if ("color".equals(name)) {
            this.color = this.parseRGB(value);
            return;
        }
        if ("textAlign".equals(name)) {
            this.textAlign = value;
            return;
        }
        if ("textAlignLast".equals(name)) {
            this.textAlignLast = value;
            return;
        }
        if ("textIndent".equals(name)) {
            this.textIndent = this.parseDouble(value);
            return;
        }
        if ("marginLeft".equals(name)) {
            this.marginLeft = this.parseDouble(value);
            return;
        }
        if ("marginRight".equals(name)) {
            this.marginRight = this.parseDouble(value);
            return;
        }
        if ("marginTop".equals(name)) {
            this.marginTop = this.parseDouble(value);
            return;
        }
        if ("marginBottom".equals(name)) {
            this.marginBottom = this.parseDouble(value);
            return;
        }
        if ("direction".equals(name)) {
            this.direction = value;
            return;
        }
        if ("blockProgression".equals(name)) {
            this.blockProgression = value;
            return;
        }
        if ("x".equals(name)) {
            this.x = this.parseDouble(value);
            this.translateSet = true;
            return;
        }
        if ("y".equals(name)) {
            this.y = this.parseDouble(value);
            this.translateSet = true;
            return;
        }
        if ("rotation".equals(name)) {
            this.rotation = this.parseDouble(value);
            this.rotationSet = true;
            return;
        }
        if ("scaleX".equals(name)) {
            this.scaleX = this.parseDouble(value);
            this.scaleSet = true;
            return;
        }
        if ("scaleY".equals(name)) {
            this.scaleY = this.parseDouble(value);
            this.scaleSet = true;
            return;
        }
        if ("alpha".equals(name)) {
            this.alpha = this.parseDouble(value, 0.0, 1.0);
            this.alphaSet = true;
            return;
        }
        if ("blendMode".equals(name)) {
            this.blendMode = this.parseBlendMode(value);
            this.blendModeSet = true;
            return;
        }
        if ("maskType".equals(name)) {
            this.maskType = this.parseMaskType(value);
            this.maskTypeSet = true;
            return;
        }
        if ("visible".equals(name)) {
            this.visible = this.parseBoolean(value);
            return;
        }
        if ("lineThrough".equals(name)) {
            this.lineThrough = this.parseBoolean(value);
            return;
        }
        if ("id".equals(name)) {
            return;
        }
        throw new FXGException(this.getStartLine(), this.getStartColumn(), "InvalidNodeAttribute", name, this.getNodeName());
    }
}

