/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.fxg.dom.transforms;

import com.adobe.fxg.FXGException;
import com.adobe.internal.fxg.dom.transforms.AbstractTransformNode;

public class ColorTransformNode
extends AbstractTransformNode
implements Cloneable {
    private static final double MIN_OFFSET_INCLUSIVE = -255.0;
    private static final double MAX_OFFSET_INCLUSIVE = 255.0;
    public double alphaMultiplier = 1.0;
    public double redMultiplier = 1.0;
    public double blueMultiplier = 1.0;
    public double greenMultiplier = 1.0;
    public double alphaOffset = 0.0;
    public double redOffset = 0.0;
    public double blueOffset = 0.0;
    public double greenOffset = 0.0;

    public String getNodeName() {
        return "ColorTransform";
    }

    public void setAttribute(String name, String value) {
        if ("alphaMultiplier".equals(name)) {
            this.alphaMultiplier = this.parseDouble(value);
        } else if ("redMultiplier".equals(name)) {
            this.redMultiplier = this.parseDouble(value);
        } else if ("blueMultiplier".equals(name)) {
            this.blueMultiplier = this.parseDouble(value);
        } else if ("greenMultiplier".equals(name)) {
            this.greenMultiplier = this.parseDouble(value);
        } else if ("alphaOffset".equals(name)) {
            this.alphaOffset = this.parseDouble(value, -255.0, 255.0, this.alphaOffset);
        } else if ("redOffset".equals(name)) {
            this.redOffset = this.parseDouble(value, -255.0, 255.0, this.redOffset);
        } else if ("blueOffset".equals(name)) {
            this.blueOffset = this.parseDouble(value, -255.0, 255.0, this.blueOffset);
        } else if ("greenOffset".equals(name)) {
            this.greenOffset = this.parseDouble(value, -255.0, 255.0, this.greenOffset);
        }
    }

    public Object clone() {
        ColorTransformNode copy = null;
        try {
            copy = (ColorTransformNode)super.clone();
            copy.alphaMultiplier = this.alphaMultiplier;
            copy.redMultiplier = this.redMultiplier;
            copy.blueMultiplier = this.blueMultiplier;
            copy.greenMultiplier = this.greenMultiplier;
            copy.alphaOffset = this.alphaOffset;
            copy.redOffset = this.redOffset;
            copy.blueOffset = this.blueOffset;
            copy.greenOffset = this.greenOffset;
        }
        catch (CloneNotSupportedException e) {
            throw new FXGException(this.getStartLine(), this.getStartColumn(), "InternalProcessingError", e, new Object[0]);
        }
        return copy;
    }
}

