/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.fxg.dom.richtext;

import com.adobe.fxg.FXGException;
import com.adobe.fxg.dom.FXGNode;
import com.adobe.internal.fxg.dom.CDATANode;
import com.adobe.internal.fxg.dom.TextNode;
import com.adobe.internal.fxg.dom.richtext.AbstractRichTextLeafNode;
import com.adobe.internal.fxg.dom.richtext.AbstractRichTextNode;
import com.adobe.internal.fxg.dom.richtext.BRNode;
import com.adobe.internal.fxg.dom.richtext.ImgNode;
import com.adobe.internal.fxg.dom.richtext.LinkActiveFormatNode;
import com.adobe.internal.fxg.dom.richtext.LinkHoverFormatNode;
import com.adobe.internal.fxg.dom.richtext.LinkNormalFormatNode;
import com.adobe.internal.fxg.dom.richtext.SpanNode;
import com.adobe.internal.fxg.dom.richtext.TCYNode;
import com.adobe.internal.fxg.dom.richtext.TabNode;
import com.adobe.internal.fxg.dom.types.LinkTarget;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkNode
extends AbstractRichTextLeafNode {
    public String href;
    public LinkTarget target = LinkTarget._SELF;
    public LinkNormalFormatNode linkNormalFormat = null;
    public LinkHoverFormatNode linkHoverFormat = null;
    public LinkActiveFormatNode linkActiveFormat = null;
    protected List<TextNode> properties;

    @Override
    public List<TextNode> getTextProperties() {
        return this.properties;
    }

    @Override
    public String getNodeName() {
        return "a";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void addChild(FXGNode child) {
        if (child instanceof LinkNormalFormatNode) {
            if (this.linkNormalFormat != null) throw new FXGException(this.getStartLine(), this.getStartColumn(), "MultipleLinkFormatElements", new Object[0]);
            this.linkNormalFormat = (LinkNormalFormatNode)child;
            this.addProperty(this.linkNormalFormat);
        } else if (child instanceof LinkHoverFormatNode) {
            if (this.linkHoverFormat != null) throw new FXGException(this.getStartLine(), this.getStartColumn(), "MultipleLinkFormatElements", new Object[0]);
            this.linkHoverFormat = (LinkHoverFormatNode)child;
            this.addProperty(this.linkHoverFormat);
        } else if (child instanceof LinkActiveFormatNode) {
            if (this.linkActiveFormat != null) throw new FXGException(this.getStartLine(), this.getStartColumn(), "MultipleLinkFormatElements", new Object[0]);
            this.linkActiveFormat = (LinkActiveFormatNode)child;
            this.addProperty(this.linkActiveFormat);
        } else if (child instanceof SpanNode || child instanceof BRNode || child instanceof TabNode || child instanceof ImgNode || child instanceof TCYNode || child instanceof CDATANode) {
            if (this.content == null) {
                this.content = new ArrayList();
            }
            this.content.add((TextNode)child);
        } else {
            super.addChild(child);
            return;
        }
        if (!(child instanceof AbstractRichTextNode)) return;
        ((AbstractRichTextNode)child).setParent(this);
    }

    protected void addProperty(TextNode node) {
        if (this.properties == null) {
            this.properties = new ArrayList<TextNode>(3);
        }
        this.properties.add(node);
    }

    @Override
    public void setAttribute(String name, String value) {
        if ("href".equals(name)) {
            this.href = value;
        } else if ("target".equals(name)) {
            this.target = LinkNode.getLinkTarget(this, value);
        } else {
            super.setAttribute(name, value);
            return;
        }
        this.rememberAttribute(name, value);
    }

    public static LinkTarget getLinkTarget(FXGNode node, String value) {
        if ("_self".equals(value)) {
            return LinkTarget._SELF;
        }
        if ("_blank".equals(value)) {
            return LinkTarget._BLANK;
        }
        if ("_parent".equals(value)) {
            return LinkTarget._PARENT;
        }
        if ("_top".equals(value)) {
            return LinkTarget._TOP;
        }
        throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownLinkTarget", value);
    }
}

