/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.fxg.dom.richtext;

import com.adobe.fxg.FXGException;
import com.adobe.fxg.dom.FXGNode;
import com.adobe.internal.fxg.dom.richtext.AbstractRichTextLeafNode;
import com.adobe.internal.fxg.dom.types.Direction;
import com.adobe.internal.fxg.dom.types.JustificationRule;
import com.adobe.internal.fxg.dom.types.JustificationStyle;
import com.adobe.internal.fxg.dom.types.LeadingModel;
import com.adobe.internal.fxg.dom.types.NumberInherit;
import com.adobe.internal.fxg.dom.types.TextAlign;
import com.adobe.internal.fxg.dom.types.TextJustify;

public abstract class AbstractRichParagraphNode
extends AbstractRichTextLeafNode {
    public TextAlign textAlign = TextAlign.START;
    public TextAlign textAlignLast = TextAlign.START;
    public double textIndent = 0.0;
    public NumberInherit paragraphStartIndent = NumberInherit.newInstance(0.0);
    public NumberInherit paragraphEndIndent = NumberInherit.newInstance(0.0);
    public NumberInherit paragraphSpaceBefore = NumberInherit.newInstance(0.0);
    public NumberInherit paragraphSpaceAfter = NumberInherit.newInstance(0.0);
    public Direction direction = Direction.LTR;
    public JustificationRule justificationRule = JustificationRule.AUTO;
    public JustificationStyle justificationStyle = JustificationStyle.PRIORITIZELEASTADJUSTMENT;
    public TextJustify textJustify = TextJustify.INTERWORD;
    public LeadingModel leadingModel = LeadingModel.AUTO;
    public String tabStops = "";

    public void setAttribute(String name, String value) {
        if ("textAlign".equals(name)) {
            this.textAlign = AbstractRichParagraphNode.getTextAlign(this, value);
        } else if ("textAlignLast".equals(name)) {
            this.textAlignLast = AbstractRichParagraphNode.getTextAlign(this, value);
        } else if ("textIndent".equals(name)) {
            this.textIndent = this.parseDouble(value);
        } else if ("paragraphStartIndent".equals(name)) {
            this.paragraphStartIndent = this.getNumberInherit(this, value);
        } else if ("paragraphEndIndent".equals(name)) {
            this.paragraphEndIndent = this.getNumberInherit(this, value);
        } else if ("paragraphSpaceBefore".equals(name)) {
            this.paragraphSpaceBefore = this.getNumberInherit(this, value);
        } else if ("paragraphSpaceAfter".equals(name)) {
            this.paragraphSpaceAfter = this.getNumberInherit(this, value);
        } else if ("direction".equals(name)) {
            this.direction = AbstractRichParagraphNode.getDirection(this, value);
        } else if ("justificationRule".equals(name)) {
            this.justificationRule = AbstractRichParagraphNode.getJustificationRule(this, value);
        } else if ("justificationStyle".equals(name)) {
            this.justificationStyle = AbstractRichParagraphNode.getJustificationStyle(this, value);
        } else if ("textJustify".equals(name)) {
            this.textJustify = AbstractRichParagraphNode.getTextJustify(this, value);
        } else if ("leadingModel".equals(name)) {
            this.leadingModel = AbstractRichParagraphNode.getLeadingModel(this, value);
        } else if ("tabStops".equals(name)) {
            this.tabStops = value;
        } else {
            super.setAttribute(name, value);
            return;
        }
        this.rememberAttribute(name, value);
    }

    public static TextAlign getTextAlign(FXGNode node, String value) {
        if ("start".equals(value)) {
            return TextAlign.START;
        }
        if ("end".equals(value)) {
            return TextAlign.END;
        }
        if ("left".equals(value)) {
            return TextAlign.LEFT;
        }
        if ("center".equals(value)) {
            return TextAlign.CENTER;
        }
        if ("right".equals(value)) {
            return TextAlign.RIGHT;
        }
        if ("justify".equals(value)) {
            return TextAlign.JUSTIFY;
        }
        throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownTextAlign", value);
    }

    public static Direction getDirection(FXGNode node, String value) {
        if ("ltr".equals(value)) {
            return Direction.LTR;
        }
        if ("rtl".equals(value)) {
            return Direction.RTL;
        }
        throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownDirection", value);
    }

    public static JustificationRule getJustificationRule(FXGNode node, String value) {
        if ("auto".equals(value)) {
            return JustificationRule.AUTO;
        }
        if ("space".equals(value)) {
            return JustificationRule.SPACE;
        }
        if ("eastAsian".equals(value)) {
            return JustificationRule.EASTASIAN;
        }
        throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownJustificationRule", value);
    }

    public static JustificationStyle getJustificationStyle(FXGNode node, String value) {
        if ("auto".equals(value)) {
            return JustificationStyle.AUTO;
        }
        if ("auto".equals(value)) {
            return JustificationStyle.PRIORITIZELEASTADJUSTMENT;
        }
        if ("pushInKinsoku".equals(value)) {
            return JustificationStyle.PUSHINKINSOKU;
        }
        if ("pushOutOnly".equals(value)) {
            return JustificationStyle.PUSHOUTONLY;
        }
        throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownJustificationStyle", value);
    }

    public static TextJustify getTextJustify(FXGNode node, String value) {
        if ("interWord".equals(value)) {
            return TextJustify.INTERWORD;
        }
        if ("distribute".equals(value)) {
            return TextJustify.DISTRIBUTE;
        }
        throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownTextJustify", value);
    }

    public static LeadingModel getLeadingModel(FXGNode node, String value) {
        if ("auto".equals(value)) {
            return LeadingModel.AUTO;
        }
        if ("romanUp".equals(value)) {
            return LeadingModel.ROMANUP;
        }
        if ("ideographicTopUp".equals(value)) {
            return LeadingModel.IDEOGRAPHICTOPUP;
        }
        if ("ideographicCenterUp".equals(value)) {
            return LeadingModel.IDEOGRAPHICCENTERUP;
        }
        if ("ascentDescentUp".equals(value)) {
            return LeadingModel.ASCENTDESCENTUP;
        }
        if ("ideographicTopDown".equals(value)) {
            return LeadingModel.IDEOGRAPHICTOPDOWN;
        }
        if ("ideographicCenterDown".equals(value)) {
            return LeadingModel.IDEOGRAPHICCENTERDOWN;
        }
        throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownLeadingModel", value);
    }

    private NumberInherit getNumberInherit(FXGNode node, String value) {
        try {
            return NumberInherit.newInstance(this.parseDouble(value));
        }
        catch (NumberFormatException e) {
            if ("inherit".equals(value)) {
                return NumberInherit.newInstance(NumberInherit.NumberInheritAsEnum.INHERIT);
            }
            throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownNumberInherit", value);
        }
    }
}

