/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.fxg.dom;

import com.adobe.fxg.FXGException;
import com.adobe.fxg.dom.FXGNode;
import com.adobe.fxg.util.FXGLog;
import com.adobe.internal.fxg.dom.CDATANode;
import com.adobe.internal.fxg.dom.GraphicContentNode;
import com.adobe.internal.fxg.dom.TextNode;
import com.adobe.internal.fxg.dom.richtext.AbstractRichTextNode;
import com.adobe.internal.fxg.dom.richtext.BRNode;
import com.adobe.internal.fxg.dom.richtext.DivNode;
import com.adobe.internal.fxg.dom.richtext.FormatNode;
import com.adobe.internal.fxg.dom.richtext.ImgNode;
import com.adobe.internal.fxg.dom.richtext.LinkActiveFormatNode;
import com.adobe.internal.fxg.dom.richtext.LinkHoverFormatNode;
import com.adobe.internal.fxg.dom.richtext.LinkNode;
import com.adobe.internal.fxg.dom.richtext.LinkNormalFormatNode;
import com.adobe.internal.fxg.dom.richtext.ParagraphNode;
import com.adobe.internal.fxg.dom.richtext.SpanNode;
import com.adobe.internal.fxg.dom.richtext.TCYNode;
import com.adobe.internal.fxg.dom.richtext.TabNode;
import com.adobe.internal.fxg.dom.types.AlignmentBaseline;
import com.adobe.internal.fxg.dom.types.BaselineOffset;
import com.adobe.internal.fxg.dom.types.BaselineShift;
import com.adobe.internal.fxg.dom.types.BlockProgression;
import com.adobe.internal.fxg.dom.types.BreakOpportunity;
import com.adobe.internal.fxg.dom.types.ColorWithEnum;
import com.adobe.internal.fxg.dom.types.DigitCase;
import com.adobe.internal.fxg.dom.types.DigitWidth;
import com.adobe.internal.fxg.dom.types.Direction;
import com.adobe.internal.fxg.dom.types.DominantBaseline;
import com.adobe.internal.fxg.dom.types.FontStyle;
import com.adobe.internal.fxg.dom.types.FontWeight;
import com.adobe.internal.fxg.dom.types.JustificationRule;
import com.adobe.internal.fxg.dom.types.JustificationStyle;
import com.adobe.internal.fxg.dom.types.Kerning;
import com.adobe.internal.fxg.dom.types.LeadingModel;
import com.adobe.internal.fxg.dom.types.LigatureLevel;
import com.adobe.internal.fxg.dom.types.LineBreak;
import com.adobe.internal.fxg.dom.types.NumberAuto;
import com.adobe.internal.fxg.dom.types.NumberInherit;
import com.adobe.internal.fxg.dom.types.TextAlign;
import com.adobe.internal.fxg.dom.types.TextDecoration;
import com.adobe.internal.fxg.dom.types.TextJustify;
import com.adobe.internal.fxg.dom.types.TextRotation;
import com.adobe.internal.fxg.dom.types.TypographicCase;
import com.adobe.internal.fxg.dom.types.VerticalAlign;
import com.adobe.internal.fxg.dom.types.WhiteSpaceCollapse;
import com.adobe.internal.fxg.swf.TextHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RichTextNode
extends GraphicContentNode
implements TextNode {
    protected static final double FONTSIZE_MIN_INCLUSIVE = 1.0;
    protected static final double FONTSIZE_MAX_INCLUSIVE = 720.0;
    public double width = 0.0;
    public double height = 0.0;
    public BlockProgression blockProgression = BlockProgression.TB;
    public NumberInherit paddingLeft = NumberInherit.newInstance(0.0);
    public NumberInherit paddingRight = NumberInherit.newInstance(0.0);
    public NumberInherit paddingTop = NumberInherit.newInstance(0.0);
    public NumberInherit paddingBottom = NumberInherit.newInstance(0.0);
    public LineBreak lineBreak = LineBreak.TOFIT;
    public NumberInherit columnGap = NumberInherit.newInstance(20.0);
    public NumberAuto columnCount = NumberAuto.newInstance(NumberAuto.NumberAutoAsEnum.AUTO);
    public NumberAuto columnWidth = NumberAuto.newInstance(NumberAuto.NumberAutoAsEnum.AUTO);
    public BaselineOffset firstBaselineOffset = BaselineOffset.newInstance(BaselineOffset.BaselineOffsetAsEnum.AUTO);
    public VerticalAlign verticalAlign = VerticalAlign.TOP;
    public TextAlign textAlign = TextAlign.START;
    public TextAlign textAlignLast = TextAlign.START;
    public double textIndent = 0.0;
    public NumberInherit paragraphStartIndent = NumberInherit.newInstance(0.0);
    public NumberInherit paragraphEndIndent = NumberInherit.newInstance(0.0);
    public NumberInherit paragraphSpaceBefore = NumberInherit.newInstance(0.0);
    public NumberInherit paragraphSpaceAfter = NumberInherit.newInstance(0.0);
    public Direction direction = Direction.LTR;
    public JustificationRule justificationRule = JustificationRule.AUTO;
    public JustificationStyle justificationStyle = JustificationStyle.PRIORITIZELEASTADJUSTMENT;
    public TextJustify textJustify = TextJustify.INTERWORD;
    public LeadingModel leadingModel = LeadingModel.AUTO;
    public String tabStops = "";
    public String format = "";
    public String fontFamily = "Arial";
    public double fontSize = 12.0;
    public FontStyle fontStyle = FontStyle.NORMAL;
    public FontWeight fontWeight = FontWeight.NORMAL;
    public Kerning kerning = Kerning.AUTO;
    public double lineHeight = 120.0;
    public TextDecoration textDecoration = TextDecoration.NONE;
    public boolean lineThrough = false;
    public int color = -16777216;
    public double textAlpha = 1.0;
    public WhiteSpaceCollapse whiteSpaceCollapse = WhiteSpaceCollapse.COLLAPSE;
    public NumberInherit backgroundAlpha = NumberInherit.newInstance(1.0);
    public ColorWithEnum backgroundColor = ColorWithEnum.newInstance(ColorWithEnum.ColorEnum.TRANSPARENT);
    public BaselineShift baselineShift = BaselineShift.newInstance(0.0);
    public BreakOpportunity breakOpportunity = BreakOpportunity.AUTO;
    public DigitCase digitCase = DigitCase.DEFAULT;
    public DigitWidth digitWidth = DigitWidth.DEFAULT;
    public DominantBaseline dominantBaseline = DominantBaseline.AUTO;
    public AlignmentBaseline alignmentBaseline = AlignmentBaseline.USEDOMINANTBASELINE;
    public LigatureLevel ligatureLevel = LigatureLevel.COMMON;
    public String locale = "en";
    public TypographicCase typographicCase = TypographicCase.DEFAULT;
    public double trackingLeft = 0.0;
    public double trackingRight = 0.0;
    public TextRotation textRotation = TextRotation.AUTO;
    public LinkNormalFormatNode linkNormalFormat = null;
    public LinkHoverFormatNode linkHoverFormat = null;
    public LinkActiveFormatNode linkActiveFormat = null;
    public Map<String, FormatNode> formatNodeMap = null;
    private boolean contiguous = false;
    protected Map<String, String> textAttributes;
    protected List<TextNode> content;
    protected List<TextNode> properties;

    @Override
    public Map<String, String> getTextAttributes() {
        return this.textAttributes;
    }

    @Override
    public List<TextNode> getTextChildren() {
        return this.content;
    }

    @Override
    public List<TextNode> getTextProperties() {
        return this.properties;
    }

    protected void rememberAttribute(String name, String value) {
        if (this.textAttributes == null) {
            this.textAttributes = new HashMap<String, String>(4);
        }
        this.textAttributes.put(name, value);
    }

    public void addContentChild(FXGNode child) {
        if (child instanceof ParagraphNode || child instanceof DivNode || child instanceof SpanNode || child instanceof BRNode || child instanceof TabNode || child instanceof TCYNode || child instanceof LinkNode || child instanceof ImgNode || child instanceof CDATANode) {
            if (child instanceof LinkNode && ((LinkNode)child).href == null) {
                throw new FXGException(this.getStartLine(), this.getStartColumn(), "MissingHref", new Object[0]);
            }
            if (this.content == null) {
                this.content = new ArrayList<TextNode>();
                this.contiguous = true;
            }
            if (!this.contiguous) {
                throw new FXGException(child.getStartLine(), child.getStartColumn(), "InvalidRichTextContent", new Object[0]);
            }
            this.content.add((TextNode)child);
        }
        if (child instanceof AbstractRichTextNode) {
            ((AbstractRichTextNode)child).setParent(this);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void addChild(FXGNode child) {
        if (child instanceof LinkNormalFormatNode) {
            if (this.linkNormalFormat != null) throw new FXGException(this.getStartLine(), this.getStartColumn(), "MultipleLinkFormatElements", new Object[0]);
            this.linkNormalFormat = (LinkNormalFormatNode)child;
            this.addProperty(this.linkNormalFormat);
        } else if (child instanceof LinkHoverFormatNode) {
            if (this.linkHoverFormat != null) throw new FXGException(this.getStartLine(), this.getStartColumn(), "MultipleLinkFormatElements", new Object[0]);
            this.linkHoverFormat = (LinkHoverFormatNode)child;
            this.addProperty(this.linkHoverFormat);
        } else if (child instanceof LinkActiveFormatNode) {
            if (this.linkActiveFormat != null) throw new FXGException(this.getStartLine(), this.getStartColumn(), "MultipleLinkFormatElements", new Object[0]);
            this.linkActiveFormat = (LinkActiveFormatNode)child;
            this.addProperty(this.linkActiveFormat);
        } else if (child instanceof FormatNode) {
            this.addFormatNode((FormatNode)child);
        } else {
            if (child instanceof CDATANode) {
                if (!TextHelper.ignorableWhitespace(((CDATANode)child).content)) throw new FXGException(child.getStartLine(), child.getStartColumn(), "InvalidRichTextContent", new Object[0]);
                return;
            }
            super.addChild(child);
            this.contiguous = false;
            return;
        }
        if (!(child instanceof AbstractRichTextNode)) return;
        ((AbstractRichTextNode)child).setParent(this);
    }

    protected void addProperty(TextNode node) {
        if (this.properties == null) {
            this.properties = new ArrayList<TextNode>(5);
        }
        this.properties.add(node);
    }

    protected void addFormatNode(FormatNode node) {
        String nodeName;
        if (this.formatNodeMap == null) {
            this.formatNodeMap = new HashMap<String, FormatNode>(2);
        }
        if ((nodeName = node.name) == null || nodeName.trim().equals("")) {
            FXGLog.getLogger().log(30000, "IgnoredFormatNode", null, this.getDocumentName(), this.startLine, this.startColumn);
            return;
        }
        if (this.formatNodeMap.containsKey(nodeName)) {
            FXGLog.getLogger().log(30000, "DuplicateFormatNode", null, this.getDocumentName(), this.startLine, this.startColumn);
            this.properties.remove(this.formatNodeMap.get(nodeName));
            this.formatNodeMap.remove(nodeName);
        }
        this.formatNodeMap.put(nodeName, node);
        this.addProperty(node);
    }

    @Override
    public String getNodeName() {
        return "RichText";
    }

    @Override
    public void setAttribute(String name, String value) {
        if ("width".equals(name)) {
            this.width = this.parseDouble(value);
        } else if ("height".equals(name)) {
            this.height = this.parseDouble(value);
        } else if ("blockProgression".equals(name)) {
            this.blockProgression = RichTextNode.getBlockProgression(this, value);
        } else if ("paddingLeft".equals(name)) {
            this.paddingLeft = this.getNumberInherit(this, value);
        } else if ("paddingRight".equals(name)) {
            this.paddingRight = this.getNumberInherit(this, value);
        } else if ("paddingTop".equals(name)) {
            this.paddingTop = this.getNumberInherit(this, value);
        } else if ("paddingBottom".equals(name)) {
            this.paddingBottom = this.getNumberInherit(this, value);
        } else if ("lineBreak".equals(name)) {
            this.lineBreak = RichTextNode.getLineBreak(this, value);
        } else if ("columnGap".equals(name)) {
            this.columnGap = this.getNumberInherit(this, value);
        } else if ("columnCount".equals(name)) {
            this.columnCount = this.getNumberAutoInt(this, value);
        } else if ("columnWidth".equals(name)) {
            this.columnWidth = this.getNumberAutoDbl(this, value);
        } else if ("firstBaselineOffset".equals(name)) {
            this.firstBaselineOffset = this.getFirstBaselineOffset(this, value);
        } else if ("verticalAlign".equals(name)) {
            this.verticalAlign = RichTextNode.getVerticalAlign(this, value);
        } else if ("textAlign".equals(name)) {
            this.textAlign = RichTextNode.getTextAlign(this, value);
        } else if ("textAlignLast".equals(name)) {
            this.textAlignLast = RichTextNode.getTextAlign(this, value);
        } else if ("textIndent".equals(name)) {
            this.textIndent = this.parseDouble(value);
        } else if ("paragraphStartIndent".equals(name)) {
            this.paragraphStartIndent = this.getNumberInherit(this, value);
        } else if ("paragraphEndIndent".equals(name)) {
            this.paragraphEndIndent = this.getNumberInherit(this, value);
        } else if ("paragraphSpaceBefore".equals(name)) {
            this.paragraphSpaceBefore = this.getNumberInherit(this, value);
        } else if ("paragraphSpaceAfter".equals(name)) {
            this.paragraphSpaceAfter = this.getNumberInherit(this, value);
        } else if ("direction".equals(name)) {
            this.direction = RichTextNode.getDirection(this, value);
        } else if ("justificationRule".equals(name)) {
            this.justificationRule = RichTextNode.getJustificationRule(this, value);
        } else if ("justificationStyle".equals(name)) {
            this.justificationStyle = RichTextNode.getJustificationStyle(this, value);
        } else if ("textJustify".equals(name)) {
            this.textJustify = RichTextNode.getTextJustify(this, value);
        } else if ("leadingModel".equals(name)) {
            this.leadingModel = RichTextNode.getLeadingModel(this, value);
        } else if ("tabStops".equals(name)) {
            this.tabStops = value;
        } else if ("format".equals(name)) {
            this.format = value;
        } else if ("fontFamily".equals(name)) {
            this.fontFamily = value;
        } else if ("fontSize".equals(name)) {
            this.fontSize = this.parseDouble(value, 1.0, 720.0, this.fontSize);
        } else if ("fontStyle".equals(name)) {
            this.fontStyle = RichTextNode.getFontStyle(this, value);
        } else if ("fontWeight".equals(name)) {
            this.fontWeight = RichTextNode.getFontWeight(this, value);
        } else if ("kerning".equals(name)) {
            this.kerning = RichTextNode.getKerning(this, value);
        } else if ("lineHeight".equals(name)) {
            this.lineHeight = this.parsePercent(value);
        } else if ("textDecoration".equals(name)) {
            this.textDecoration = RichTextNode.getTextDecoration(this, value);
        } else if ("lineThrough".equals(name)) {
            this.lineThrough = this.parseBoolean(value);
        } else if ("color".equals(name)) {
            this.color = this.parseRGB(value, this.color);
        } else if ("textAlpha".equals(name)) {
            this.textAlpha = this.parseDouble(value, 0.0, 1.0, this.textAlpha);
        } else if ("whiteSpaceCollapse".equals(name)) {
            this.whiteSpaceCollapse = RichTextNode.getWhiteSpaceCollapse(this, value);
        } else if ("backgroundAlpha".equals(name)) {
            this.backgroundAlpha = this.getAlphaInherit(this, value, 0.0, 1.0, this.backgroundAlpha.getNumberInheritAsDbl());
        } else if ("backgroundColor".equals(name)) {
            this.backgroundColor = this.getColorWithEnum(this, value);
        } else if ("baselineShift".equals(name)) {
            this.baselineShift = this.getBaselineShift(this, value);
        } else if ("breakOpportunity".equals(name)) {
            this.breakOpportunity = RichTextNode.getBreakOpportunity(this, value);
        } else if ("digitCase".equals(name)) {
            this.digitCase = RichTextNode.getDigitCase(this, value);
        } else if ("digitWidth".equals(name)) {
            this.digitWidth = RichTextNode.getDigitWidth(this, value);
        } else if ("dominantBaseline".equals(name)) {
            this.dominantBaseline = RichTextNode.getDominantBaseline(this, value);
        } else if ("alignmentBaseline".equals(name)) {
            this.alignmentBaseline = RichTextNode.getAlignmentBaseline(this, value);
        } else if ("ligatureLevel".equals(name)) {
            this.ligatureLevel = RichTextNode.getLigatureLevel(this, value);
        } else if ("locale".equals(name)) {
            this.locale = value;
        } else if ("typographicCase".equals(name)) {
            this.typographicCase = RichTextNode.getTypographicCase(this, value);
        } else if ("trackingLeft".equals(name)) {
            this.trackingLeft = this.parsePercent(value);
        } else if ("trackingRight".equals(name)) {
            this.trackingRight = this.parsePercent(value);
        } else if ("textRotation".equals(name)) {
            this.textRotation = this.getTextRotation(this, value);
        } else if (!"id".equals(name)) {
            super.setAttribute(name, value);
        }
        this.rememberAttribute(name, value);
    }

    public static BlockProgression getBlockProgression(FXGNode node, String value) {
        if ("tb".equals(value)) {
            return BlockProgression.TB;
        }
        if ("rl".equals(value)) {
            return BlockProgression.RL;
        }
        throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownBlockProgression", value);
    }

    public static LineBreak getLineBreak(FXGNode node, String value) {
        if ("toFit".equals(value)) {
            return LineBreak.TOFIT;
        }
        if ("explicit".equals(value)) {
            return LineBreak.EXPLICIT;
        }
        if ("inherit".equals(value)) {
            return LineBreak.INHERIT;
        }
        throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownLineBreak", value);
    }

    private BaselineOffset getFirstBaselineOffset(FXGNode node, String value) {
        if ("auto".equals(value)) {
            return BaselineOffset.newInstance(BaselineOffset.BaselineOffsetAsEnum.AUTO);
        }
        if ("ascent".equals(value)) {
            return BaselineOffset.newInstance(BaselineOffset.BaselineOffsetAsEnum.ASCENT);
        }
        if ("lineHeight".equals(value)) {
            return BaselineOffset.newInstance(BaselineOffset.BaselineOffsetAsEnum.LINEHEIGHT);
        }
        try {
            return BaselineOffset.newInstance(this.parseDouble(value));
        }
        catch (NumberFormatException e) {
            throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownBaselineOffset", value);
        }
    }

    public static VerticalAlign getVerticalAlign(FXGNode node, String value) {
        if ("top".equals(value)) {
            return VerticalAlign.TOP;
        }
        if ("bottom".equals(value)) {
            return VerticalAlign.BOTTOM;
        }
        if ("middle".equals(value)) {
            return VerticalAlign.MIDDLE;
        }
        if ("justify".equals(value)) {
            return VerticalAlign.JUSTIFY;
        }
        if ("inherit".equals(value)) {
            return VerticalAlign.INHERIT;
        }
        throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownVerticalAlign", value);
    }

    private NumberAuto getNumberAutoDbl(FXGNode node, String value) {
        try {
            return NumberAuto.newInstance(this.parseDouble(value));
        }
        catch (NumberFormatException e) {
            if ("auto".equals(value)) {
                return NumberAuto.newInstance(NumberAuto.NumberAutoAsEnum.AUTO);
            }
            if ("inherit".equals(value)) {
                return NumberAuto.newInstance(NumberAuto.NumberAutoAsEnum.INHERIT);
            }
            throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownNumberAuto", value);
        }
    }

    private NumberAuto getNumberAutoInt(FXGNode node, String value) {
        try {
            return NumberAuto.newInstance(this.parseInt(value));
        }
        catch (NumberFormatException e) {
            if ("auto".equals(value)) {
                return NumberAuto.newInstance(NumberAuto.NumberAutoAsEnum.AUTO);
            }
            if ("inherit".equals(value)) {
                return NumberAuto.newInstance(NumberAuto.NumberAutoAsEnum.INHERIT);
            }
            throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownNumberAuto", value);
        }
    }

    public static TextAlign getTextAlign(FXGNode node, String value) {
        if ("start".equals(value)) {
            return TextAlign.START;
        }
        if ("end".equals(value)) {
            return TextAlign.END;
        }
        if ("left".equals(value)) {
            return TextAlign.LEFT;
        }
        if ("center".equals(value)) {
            return TextAlign.CENTER;
        }
        if ("right".equals(value)) {
            return TextAlign.RIGHT;
        }
        if ("justify".equals(value)) {
            return TextAlign.JUSTIFY;
        }
        throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownTextAlign", value);
    }

    public static Direction getDirection(FXGNode node, String value) {
        if ("ltr".equals(value)) {
            return Direction.LTR;
        }
        if ("rtl".equals(value)) {
            return Direction.RTL;
        }
        throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownDirection", value);
    }

    public static JustificationRule getJustificationRule(FXGNode node, String value) {
        if ("auto".equals(value)) {
            return JustificationRule.AUTO;
        }
        if ("space".equals(value)) {
            return JustificationRule.SPACE;
        }
        if ("eastAsian".equals(value)) {
            return JustificationRule.EASTASIAN;
        }
        throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownJustificationRule", value);
    }

    public static JustificationStyle getJustificationStyle(FXGNode node, String value) {
        if ("auto".equals(value)) {
            return JustificationStyle.AUTO;
        }
        if ("auto".equals(value)) {
            return JustificationStyle.PRIORITIZELEASTADJUSTMENT;
        }
        if ("pushInKinsoku".equals(value)) {
            return JustificationStyle.PUSHINKINSOKU;
        }
        if ("pushOutOnly".equals(value)) {
            return JustificationStyle.PUSHOUTONLY;
        }
        throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownJustificationStyle", value);
    }

    public static TextJustify getTextJustify(FXGNode node, String value) {
        if ("interWord".equals(value)) {
            return TextJustify.INTERWORD;
        }
        if ("distribute".equals(value)) {
            return TextJustify.DISTRIBUTE;
        }
        throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownTextJustify", value);
    }

    public static LeadingModel getLeadingModel(FXGNode node, String value) {
        if ("auto".equals(value)) {
            return LeadingModel.AUTO;
        }
        if ("romanUp".equals(value)) {
            return LeadingModel.ROMANUP;
        }
        if ("ideographicTopUp".equals(value)) {
            return LeadingModel.IDEOGRAPHICTOPUP;
        }
        if ("ideographicCenterUp".equals(value)) {
            return LeadingModel.IDEOGRAPHICCENTERUP;
        }
        if ("ascentDescentUp".equals(value)) {
            return LeadingModel.ASCENTDESCENTUP;
        }
        if ("ideographicTopDown".equals(value)) {
            return LeadingModel.IDEOGRAPHICTOPDOWN;
        }
        if ("ideographicCenterDown".equals(value)) {
            return LeadingModel.IDEOGRAPHICCENTERDOWN;
        }
        throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownLeadingModel", value);
    }

    private NumberInherit getNumberInherit(FXGNode node, String value) {
        try {
            return NumberInherit.newInstance(this.parseDouble(value));
        }
        catch (NumberFormatException e) {
            if ("inherit".equals(value)) {
                return NumberInherit.newInstance(NumberInherit.NumberInheritAsEnum.INHERIT);
            }
            throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownNumberInherit", value);
        }
    }

    private ColorWithEnum getColorWithEnum(FXGNode node, String value) {
        if ("transparent".equals(value)) {
            return ColorWithEnum.newInstance(ColorWithEnum.ColorEnum.TRANSPARENT);
        }
        if ("inherit".equals(value)) {
            return ColorWithEnum.newInstance(ColorWithEnum.ColorEnum.INHERIT);
        }
        return ColorWithEnum.newInstance(this.parseRGB(value));
    }

    public static FontStyle getFontStyle(FXGNode node, String value) {
        if ("normal".equals(value)) {
            return FontStyle.NORMAL;
        }
        if ("italic".equals(value)) {
            return FontStyle.ITALIC;
        }
        throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownFontStyle", value);
    }

    public static FontWeight getFontWeight(FXGNode node, String value) {
        if ("normal".equals(value)) {
            return FontWeight.NORMAL;
        }
        if ("bold".equals(value)) {
            return FontWeight.BOLD;
        }
        throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownFontWeight", value);
    }

    public static TextDecoration getTextDecoration(FXGNode node, String value) {
        if ("none".equals(value)) {
            return TextDecoration.NONE;
        }
        if ("underline".equals(value)) {
            return TextDecoration.UNDERLINE;
        }
        throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownTextDecoration", value);
    }

    public static Kerning getKerning(FXGNode node, String value) {
        if ("auto".equals(value)) {
            return Kerning.AUTO;
        }
        if ("on".equals(value)) {
            return Kerning.ON;
        }
        if ("off".equals(value)) {
            return Kerning.OFF;
        }
        throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownKerning", value);
    }

    public static WhiteSpaceCollapse getWhiteSpaceCollapse(FXGNode node, String value) {
        if ("preserve".equals(value)) {
            return WhiteSpaceCollapse.PRESERVE;
        }
        if ("collapse".equals(value)) {
            return WhiteSpaceCollapse.COLLAPSE;
        }
        throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownWhiteSpaceCollapse", value);
    }

    public static BreakOpportunity getBreakOpportunity(FXGNode node, String value) {
        if ("auto".equals(value)) {
            return BreakOpportunity.AUTO;
        }
        if ("any".equals(value)) {
            return BreakOpportunity.ANY;
        }
        if ("none".equals(value)) {
            return BreakOpportunity.NONE;
        }
        if ("all".equals(value)) {
            return BreakOpportunity.ALL;
        }
        throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownBreakOpportunity", value);
    }

    public static DigitCase getDigitCase(FXGNode node, String value) {
        if ("default".equals(value)) {
            return DigitCase.DEFAULT;
        }
        if ("lining".equals(value)) {
            return DigitCase.LINING;
        }
        if ("oldStyle".equals(value)) {
            return DigitCase.OLDSTYLE;
        }
        throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownDigitCase", value);
    }

    public static DigitWidth getDigitWidth(FXGNode node, String value) {
        if ("default".equals(value)) {
            return DigitWidth.DEFAULT;
        }
        if ("proportional".equals(value)) {
            return DigitWidth.PROPORTIONAL;
        }
        if ("tabular".equals(value)) {
            return DigitWidth.TABULAR;
        }
        throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownDigitWidth", value);
    }

    public static DominantBaseline getDominantBaseline(FXGNode node, String value) {
        if ("auto".equals(value)) {
            return DominantBaseline.AUTO;
        }
        if ("roman".equals(value)) {
            return DominantBaseline.ROMAN;
        }
        if ("ascent".equals(value)) {
            return DominantBaseline.ASCENT;
        }
        if ("descent".equals(value)) {
            return DominantBaseline.DESCENT;
        }
        if ("ideographicTop".equals(value)) {
            return DominantBaseline.IDEOGRAPHICTOP;
        }
        if ("ideographicCenter".equals(value)) {
            return DominantBaseline.IDEOGRAPHICCENTER;
        }
        if ("ideographicBottom".equals(value)) {
            return DominantBaseline.IDEOGRAPHICBOTTOM;
        }
        throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownDominantBaseline", value);
    }

    public static AlignmentBaseline getAlignmentBaseline(FXGNode node, String value) {
        if ("useDominantBaseline".equals(value)) {
            return AlignmentBaseline.USEDOMINANTBASELINE;
        }
        if ("roman".equals(value)) {
            return AlignmentBaseline.ROMAN;
        }
        if ("ascent".equals(value)) {
            return AlignmentBaseline.ASCENT;
        }
        if ("descent".equals(value)) {
            return AlignmentBaseline.DESCENT;
        }
        if ("ideographicTop".equals(value)) {
            return AlignmentBaseline.IDEOGRAPHICTOP;
        }
        if ("ideographicCenter".equals(value)) {
            return AlignmentBaseline.IDEOGRAPHICCENTER;
        }
        if ("ideographicBottom".equals(value)) {
            return AlignmentBaseline.IDEOGRAPHICBOTTOM;
        }
        throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownAlignmentBaseline", value);
    }

    public static LigatureLevel getLigatureLevel(FXGNode node, String value) {
        if ("minimum".equals(value)) {
            return LigatureLevel.MINIMUM;
        }
        if ("common".equals(value)) {
            return LigatureLevel.COMMON;
        }
        if ("uncommon".equals(value)) {
            return LigatureLevel.UNCOMMON;
        }
        if ("exotic".equals(value)) {
            return LigatureLevel.EXOTIC;
        }
        throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownLigatureLevel", value);
    }

    public static TypographicCase getTypographicCase(FXGNode node, String value) {
        if ("default".equals(value)) {
            return TypographicCase.DEFAULT;
        }
        if ("capsToSmallCaps".equals(value)) {
            return TypographicCase.CAPSTOSMALLCAPS;
        }
        if ("uppercase".equals(value)) {
            return TypographicCase.UPPERCASE;
        }
        if ("lowercase".equals(value)) {
            return TypographicCase.LOWERCASE;
        }
        if ("lowercaseToSmallCaps".equals(value)) {
            return TypographicCase.LOWERCASETOSMALLCAPS;
        }
        throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownTypographicCase", value);
    }

    private BaselineShift getBaselineShift(FXGNode node, String value) {
        try {
            return BaselineShift.newInstance(this.parsePercent(value));
        }
        catch (NumberFormatException e) {
            if ("superscript".equals(value)) {
                return BaselineShift.newInstance(BaselineShift.BaselineShiftAsEnum.SUPERSCRIPT);
            }
            if ("subscript".equals(value)) {
                return BaselineShift.newInstance(BaselineShift.BaselineShiftAsEnum.SUBSCRIPT);
            }
            throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownBaselineShift", value);
        }
    }

    private TextRotation getTextRotation(FXGNode node, String value) {
        if ("auto".equals(value)) {
            return TextRotation.AUTO;
        }
        if ("rotate0".equals(value)) {
            return TextRotation.ROTATE_0;
        }
        if ("rotate90".equals(value)) {
            return TextRotation.ROTATE_90;
        }
        if ("rotate180".equals(value)) {
            return TextRotation.ROTATE_180;
        }
        if ("rotate270".equals(value)) {
            return TextRotation.ROTATE_270;
        }
        throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownTextRotation", value);
    }

    private NumberInherit getAlphaInherit(FXGNode node, String value, double min, double max, double defaultValue) {
        try {
            return NumberInherit.newInstance(this.parseDouble(value, 0.0, 1.0, defaultValue));
        }
        catch (NumberFormatException e) {
            if ("inherit".equals(value)) {
                return NumberInherit.newInstance(NumberInherit.NumberInheritAsEnum.INHERIT);
            }
            throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownNumberInherit", value);
        }
    }
}

