/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.util;

import flex.messaging.log.Log;
import flex.messaging.log.Logger;
import flex.messaging.util.LocaleUtils;
import flex.messaging.util.ResourceLoader;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;

public class PropertyStringResourceLoader
implements ResourceLoader {
    public static final String PROPERTY_BUNDLE = "flex/messaging/errors";
    public static final String VENDORS_BUNDLE = "flex/messaging/vendors";
    public static final String LCDS_PROPERTY_BUNDLE = "flex/data/errors";
    private static final String LOG_CATEGORY = "Resource";
    private String[] propertyBundles;
    private Locale defaultLocale;
    private Set loadedLocales = new TreeSet();
    private Map strings = new HashMap();
    private Logger logger;

    public PropertyStringResourceLoader() {
        this(new String[]{PROPERTY_BUNDLE, LCDS_PROPERTY_BUNDLE});
    }

    public PropertyStringResourceLoader(String propertyBundle) {
        this(new String[]{propertyBundle});
    }

    public PropertyStringResourceLoader(String[] propertyBundles) {
        this.propertyBundles = propertyBundles;
        this.logger = Log.getLogger(LOG_CATEGORY);
    }

    public void init(Map properties) {
    }

    public String getString(String key) {
        return this.getString(key, null, null);
    }

    public String getString(String key, Object[] arguments) {
        return this.getString(key, null, arguments);
    }

    public String getString(String key, Locale locale) {
        return this.getString(key, locale, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(String key, Locale locale, Object[] arguments) {
        Map map;
        Map map2 = this.strings;
        synchronized (map2) {
            if (this.defaultLocale == null) {
                this.defaultLocale = this.getDefaultLocale();
            }
        }
        String value = null;
        String stringKey = null;
        String localeKey = locale != null ? this.generateLocaleKey(locale) : this.generateLocaleKey(this.defaultLocale);
        String originalStringKey = this.generateStringKey(key, localeKey);
        int trimIndex = 0;
        while (true) {
            this.loadStrings(localeKey);
            stringKey = this.generateStringKey(key, localeKey);
            map = this.strings;
            synchronized (map) {
                value = (String)this.strings.get(stringKey);
                if (value != null) {
                    if (!stringKey.equals(originalStringKey)) {
                        this.strings.put(originalStringKey, value);
                    }
                    return this.substituteArguments(value, arguments);
                }
            }
            trimIndex = localeKey.lastIndexOf("_");
            if (trimIndex == -1) break;
            localeKey = localeKey.substring(0, trimIndex);
        }
        if (locale != null && !locale.equals(this.defaultLocale)) {
            localeKey = this.generateLocaleKey(this.defaultLocale);
            stringKey = this.generateStringKey(key, localeKey);
            map = this.strings;
            synchronized (map) {
                value = (String)this.strings.get(stringKey);
                if (value != null) {
                    this.strings.put(originalStringKey, value);
                    return this.substituteArguments(value, arguments);
                }
            }
        }
        this.loadStrings("");
        stringKey = this.generateStringKey(key, "");
        map = this.strings;
        synchronized (map) {
            value = (String)this.strings.get(stringKey);
            if (value != null) {
                this.strings.put(originalStringKey, value);
                return this.substituteArguments(value, arguments);
            }
        }
        return "???" + key + "???";
    }

    public void setDefaultLocale(String locale) {
        this.defaultLocale = LocaleUtils.buildLocale(locale);
    }

    public void setDefaultLocale(Locale locale) {
        this.defaultLocale = locale;
    }

    public Locale getDefaultLocale() {
        if (this.defaultLocale == null) {
            this.defaultLocale = Locale.getDefault();
        }
        return this.defaultLocale;
    }

    private synchronized void loadStrings(String localeKey) {
        if (this.loadedLocales.contains(localeKey)) {
            return;
        }
        if (this.propertyBundles != null) {
            for (int i = 0; i < this.propertyBundles.length; ++i) {
                String propertyBundle = this.propertyBundles[i];
                this.loadProperties(localeKey, propertyBundle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProperties(String localeKey, String propertyBundle) {
        String filename = propertyBundle;
        if (localeKey.length() > 0) {
            filename = filename + "_" + localeKey;
        }
        filename = filename + ".properties";
        ClassLoader loader = this.getClass().getClassLoader();
        InputStream stream = loader.getResourceAsStream(filename);
        Properties props = new Properties();
        if (stream != null) {
            try {
                props.load(stream);
            }
            catch (IOException ioe) {
                this.logger.warn("There was a problem reading the string resource property file '" + filename + "' stream.", ioe);
            }
            catch (IllegalArgumentException iae) {
                this.logger.warn("The string resource property file '" + filename + "' contains a malformed Unicode escape sequence.", iae);
            }
            finally {
                try {
                    stream.close();
                }
                catch (IOException ioe) {
                    this.logger.warn("The string resource property file '" + filename + "' stream failed to close.", ioe);
                }
            }
        } else {
            this.logger.warn("The class loader could not locate the string resource property file '" + filename + "'. This may not be an issue if a property file is available for a less specific locale or the default locale.");
        }
        if (props.size() > 0) {
            Map map = this.strings;
            synchronized (map) {
                for (String string : props.keySet()) {
                    this.strings.put(this.generateStringKey(string, localeKey), props.getProperty(string));
                }
            }
        }
    }

    private String generateLocaleKey(Locale locale) {
        return locale == null ? "" : locale.toString();
    }

    private String generateStringKey(String key, String locale) {
        return key + "-" + locale;
    }

    private String substituteArguments(String parameterized, Object[] arguments) {
        return MessageFormat.format(parameterized, arguments).trim();
    }
}

