/*
 * Decompiled with CFR 0.152.
 */
package flash.fonts.flashtype;

public class ADFMathUtils {
    static final int ADF_N_EXP_BITS = 5;
    static final int ADF_N_MAN_BITS = 10;
    static final int ADF_MAX_EXP_VAL = 31;
    static final int ADF_EXP_BIAS = 16;
    static final int ADF_SGN_MASK = 32768;
    static final int ADF_EXP_MASK = 31744;
    static final int ADF_MAN_MASK = 1023;
    static final int ADF_MAN_SCALE = 1024;

    static float ADF_ABS(float f) {
        return f < 0.0f ? -f : f;
    }

    static float ADF_MIN(float f, float f2) {
        return f < f2 ? f : f2;
    }

    static float ADF_MAX(float f, float f2) {
        return f > f2 ? f : f2;
    }

    static void ADF_SERIALIZE_U16(long[] lArray, int n, int n2, int n3, int n4) {
        int n5 = n;
        lArray[n5] = lArray[n5] + (long)((n4 & 0xFF) << n2);
        int n6 = n;
        lArray[n6] = lArray[n6] + (long)(n4 >> 8 << n3);
    }

    static long ADF_DESERIALIZE_U16(long[] lArray, int n, int n2, int n3) {
        long l = lArray[n] >> n2 & 0xFFL;
        long l2 = lArray[n] >> n3 & 0xFFL;
        return l2 << 8 | l;
    }

    static int ADF_SERIALIZE_U32(int n) {
        int n2 = n & 0xFF;
        n2 += (n >> 8 & 0xFF) << 8;
        n2 += (n >> 16 & 0xFF) << 16;
        return n2 += (n >> 24 & 0xFF) << 24;
    }

    static int ADF_DESERIALIZE_U32(int n) {
        int n2 = n & 0xFF;
        int n3 = n >> 8 & 0xFF;
        int n4 = n >> 16 & 0xFF;
        int n5 = n >> 24 & 0xFF;
        return n5 << 24 | n4 << 16 | n3 << 8 | n2;
    }

    static ADFPackF32Result ADFPackF32(float f) {
        ADFPackF32Result aDFPackF32Result = new ADFPackF32Result();
        if (f == 0.0f) {
            aDFPackF32Result.packedValue = 0;
            return aDFPackF32Result;
        }
        FloatingPointValue floatingPointValue = new FloatingPointValue(f);
        ADFMathUtils.frexp(floatingPointValue);
        double d = floatingPointValue.mantissa;
        int n = floatingPointValue.exp;
        int n2 = n + 16;
        if (n2 < 0) {
            aDFPackF32Result.packedValue = 0;
            aDFPackF32Result.tooSmall = true;
            return aDFPackF32Result;
        }
        if (n2 > 31) {
            aDFPackF32Result.tooLarge = true;
            return aDFPackF32Result;
        }
        if (d >= 0.0) {
            aDFPackF32Result.packedValue = 0;
        } else {
            d *= -1.0;
            aDFPackF32Result.packedValue = 32768;
        }
        aDFPackF32Result.packedValue |= n2 << 10;
        aDFPackF32Result.packedValue |= (char)(d * 1024.0);
        return aDFPackF32Result;
    }

    static float ADFUnpackF32(long l) {
        double d = (l & 0x8000L) == 1L ? -1.0 : 1.0;
        int n = (int)((l & 0x7C00L) >> 10) - 16;
        double d2 = (double)(l & 0x3FFL) / 1024.0;
        FloatingPointValue floatingPointValue = new FloatingPointValue(d2, n);
        ADFMathUtils.ldexp(floatingPointValue);
        return (float)(d * floatingPointValue.value);
    }

    static RootValue ADFGetRealQuadraticRoots(double d) {
        return ADFMathUtils.ADFGetRealQuadraticRoots(new double[]{d, 0.0, 0.0});
    }

    static RootValue ADFGetRealQuadraticRoots(double[] dArray) {
        double d = dArray[2];
        double d2 = dArray[1];
        double d3 = dArray[0];
        if (d == 0.0) {
            if (d2 == 0.0) {
                return new RootValue(0);
            }
            RootValue rootValue = new RootValue(1);
            rootValue.roots = new double[]{-d3 / d2};
            return rootValue;
        }
        double d4 = d2 * d2 - 4.0 * d * d3;
        if (d4 == 0.0) {
            RootValue rootValue = new RootValue(1);
            rootValue.roots = new double[]{-0.5 * d2 / d};
            return rootValue;
        }
        if (d4 > 0.0) {
            d4 = Math.sqrt(d4);
            double d5 = (-d2 + (d2 < 0.0 ? -d4 : d4)) * 0.5;
            RootValue rootValue = new RootValue(2);
            rootValue.roots = new double[]{d5 / d, d3 / d5};
            return rootValue;
        }
        return new RootValue(0);
    }

    static RootValue ADFGetRealCubicRoots(double[] dArray) {
        if (dArray[3] == 0.0) {
            return ADFMathUtils.ADFGetRealQuadraticRoots(dArray);
        }
        if (dArray[0] == 0.0) {
            RootValue rootValue = ADFMathUtils.ADFGetRealQuadraticRoots(dArray[1]);
            double[] dArray2 = new double[rootValue.num + 1];
            if (rootValue.roots != null) {
                System.arraycopy(rootValue.roots, 0, dArray2, 0, rootValue.num);
            }
            dArray2[rootValue.num] = 0.0;
            rootValue.roots = dArray2;
            ++rootValue.num;
            return rootValue;
        }
        double d = 0.3333333333333333;
        double d2 = 1.0 / dArray[3];
        double d3 = dArray[2] * d2;
        double d4 = dArray[1] * d2;
        double d5 = dArray[0] * d2;
        double d6 = d3 * d;
        double d7 = d3 * d3;
        double d8 = (2.0 * d3 * d7 / 27.0 - d3 * d4 * d + d5) * 0.5;
        double d9 = (-d7 * d + d4) * d;
        double d10 = d9 * d9 * d9;
        double d11 = d8 * d8 + d10;
        if (d11 == 0.0) {
            if (d8 == 0.0) {
                RootValue rootValue = new RootValue(1);
                rootValue.roots = new double[]{0.0 - d6};
                return rootValue;
            }
            double d12 = d8 > 0.0 ? -Math.pow(d8, d) : Math.pow(-d8, d);
            RootValue rootValue = new RootValue(2);
            rootValue.roots = new double[]{2.0 * d12 - d6, -d12 - d6};
            return rootValue;
        }
        if (d11 < 0.0) {
            double d13 = 1.0471975511965979;
            double d14 = Math.acos(-d8 / Math.sqrt(-d10)) * d;
            double d15 = 2.0 * Math.sqrt(-d9);
            RootValue rootValue = new RootValue(3);
            rootValue.roots = new double[]{d15 * Math.cos(d14) - d6, -d15 * Math.cos(d14 + d13) - d6, -d15 * Math.cos(d14 - d13) - d6};
            return rootValue;
        }
        double d16 = Math.sqrt(d11);
        double d17 = d16 - d8 < 0.0 ? -Math.pow(-(d16 - d8), d) : Math.pow(d16 - d8, d);
        double d18 = d16 + d8 < 0.0 ? -Math.pow(-(d16 + d8), d) : Math.pow(d16 + d8, d);
        RootValue rootValue = new RootValue(1);
        rootValue.roots = new double[]{d17 - d18 - d6};
        return rootValue;
    }

    public static void frexp(FloatingPointValue floatingPointValue) {
        long l = Double.doubleToLongBits(floatingPointValue.value);
        if (floatingPointValue.value == 0.0) {
            floatingPointValue.exp = 0;
            floatingPointValue.mantissa = 0.0;
        } else {
            floatingPointValue.mantissa = Double.longBitsToDouble(0x800FFFFFFFFFFFFFL & l | 0x3FE0000000000000L);
            floatingPointValue.exp = (int)(((0x7FF0000000000000L & l) >> 52) - 1022L);
        }
    }

    public static void ldexp(FloatingPointValue floatingPointValue) {
        floatingPointValue.value = floatingPointValue.mantissa * Math.pow(2.0, floatingPointValue.exp);
    }

    public static class FloatingPointValue {
        public double value;
        public double mantissa;
        public int exp;

        public FloatingPointValue(double d) {
            this.value = d;
        }

        public FloatingPointValue(double d, int n) {
            this.mantissa = d;
            this.exp = n;
        }
    }

    static class RootValue {
        int num;
        double[] roots;

        RootValue(int n) {
            this.num = n;
        }
    }

    static class ADFPackF32Result {
        int packedValue;
        boolean tooSmall;
        boolean tooLarge;

        ADFPackF32Result() {
        }
    }
}

