/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fonts.transcoder;

import com.adobe.fonts.transcoder.FontTranscoder;
import com.adobe.fonts.transcoder.FontTranscoderException;
import flash.fonts.FontDescription;
import flash.swf.Frame;
import flash.swf.Header;
import flash.swf.Movie;
import flash.swf.MovieEncoder;
import flash.swf.SwfUtils;
import flash.swf.TagEncoder;
import flash.swf.TagHandler;
import flash.swf.tags.DefineFont;
import flash.swf.tags.DefineTag;
import flash.swf.tags.SetBackgroundColor;
import flash.swf.types.Rect;
import java.io.OutputStream;
import java.util.ArrayList;

public abstract class AbstractFontTranscoder
implements FontTranscoder {
    protected static final int TWIPS_PER_PIXEL = 20;
    protected int flashVersion = 10;
    protected int framerate = 24;
    protected int height = 400;
    protected int width = 550;
    protected int background_red = 255;
    protected int background_green = 255;
    protected int background_blue = 255;
    protected boolean compressed = true;

    protected AbstractFontTranscoder() {
    }

    public final void transcode(FontDescription fontDescription, OutputStream outputStream) throws FontTranscoderException {
        Movie movie = new Movie();
        movie.version = this.flashVersion;
        movie.framerate = this.framerate;
        movie.size = new Rect(this.width * 20, this.height * 20);
        movie.bgcolor = new SetBackgroundColor(SwfUtils.colorToInt((int)this.background_red, (int)this.background_green, (int)this.background_blue));
        ArrayList<Frame> arrayList = new ArrayList<Frame>(1);
        Frame frame = new Frame();
        arrayList.add(frame);
        movie.frames = arrayList;
        Header header = new Header();
        header.version = movie.version;
        header.size = movie.size;
        header.rate = movie.framerate;
        header.compressed = this.compressed;
        TagEncoder tagEncoder = new TagEncoder();
        tagEncoder.header(header);
        DefineFont defineFont = null;
        try {
            defineFont = this.createDefineFont(fontDescription);
            if (defineFont == null) {
                throw new FontTranscoderException("Failed to create font for " + fontDescription.source);
            }
            if (defineFont.name == null) {
                defineFont.name = defineFont.getFontName();
            }
            frame.addExport((DefineTag)defineFont);
            frame.addFont(defineFont);
            MovieEncoder movieEncoder = new MovieEncoder((TagHandler)tagEncoder);
            movieEncoder.export(movie);
            tagEncoder.writeTo(outputStream);
        }
        catch (Exception exception) {
            throw new FontTranscoderException(exception);
        }
    }

    protected abstract DefineFont createDefineFont(FontDescription var1);
}

