/*
 * Decompiled with CFR 0.152.
 */
package flex2.tools.oem.internal;

import flash.swf.Frame;
import flex2.compiler.AssetInfo;
import flex2.compiler.CompilationUnit;
import flex2.compiler.Source;
import flex2.compiler.SourceList;
import flex2.compiler.common.Configuration;
import flex2.compiler.io.FileUtil;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.swc.SwcScript;
import flex2.compiler.util.Name;
import flex2.compiler.util.QName;
import flex2.compiler.util.QNameList;
import flex2.linker.SimpleMovie;
import flex2.tools.VersionInfo;
import flex2.tools.oem.Message;
import flex2.tools.oem.Report;
import flex2.tools.oem.internal.GenericMessage;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OEMReport
implements Report {
    private String[] compiler_SourceNames;
    private String[] compiler_AssetNames;
    private String[] compiler_LibraryNames;
    private String[] linker_SourceNames;
    private String[] linker_AssetNames;
    private String[] linker_LibraryNames;
    private String[] resourceBundleNames;
    private Map<String, Data> data;
    private Map<String, String> locations;
    private Map<String, Long> timestamps;
    private int frameCount;
    private int bgColor;
    private int defaultWidth;
    private int defaultHeight;
    private int width;
    private int height;
    private String pageTitle;
    private double widthPercent;
    private double heightPercent;
    private String linkReport;
    private String sizeReport;
    private String configurationReport;
    private Message[] messages;
    private String[][] assetNames;
    private String[][] definitionNames;
    private List<File> sourceListPaths;

    public OEMReport(List<Source> sources, SimpleMovie movie, Configuration configuration, SourceList sourceList, String configurationReport, List<Message> messages) {
        this(sources, movie, configuration, sourceList, configurationReport, messages, null);
    }

    public OEMReport(List<Source> sources, SimpleMovie movie, Configuration configuration, SourceList sourceList, String configurationReport, List<Message> messages, Map<String, VirtualFile> archiveFiles) {
        if (sourceList != null) {
            this.sourceListPaths = sourceList.getPaths();
        }
        this.init(sources, movie == null ? null : movie.getExportedUnits(), configuration == null ? null : configuration.getResourceBundles(), archiveFiles, configuration);
        this.processFrames(movie);
        this.processMessages(messages);
        this.frameCount = movie == null ? 0 : movie.frames.size();
        this.configurationReport = configurationReport;
        this.defaultWidth = configuration != null ? configuration.defaultWidth() : 0;
        this.defaultHeight = configuration != null ? configuration.defaultHeight() : 0;
        this.width = 0;
        this.height = 0;
        this.widthPercent = 0.0;
        this.heightPercent = 0.0;
        if (movie != null) {
            String percent;
            this.linkReport = movie.getLinkReport();
            this.sizeReport = movie.getSizeReport();
            this.bgColor = movie.bgcolor.color;
            this.pageTitle = movie.pageTitle;
            if (movie.userSpecifiedWidth) {
                this.width = movie.width;
            } else if (configuration != null && (percent = configuration.widthPercent()) != null) {
                if ((percent = percent.trim()).length() >= 1 && percent.charAt(percent.length() - 1) == '%') {
                    percent = percent.substring(0, percent.length() - 1);
                }
                try {
                    this.widthPercent = Double.parseDouble(percent) / 100.0;
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
            }
            if (movie.userSpecifiedHeight) {
                this.height = movie.height;
            } else if (configuration != null && (percent = configuration.heightPercent()) != null) {
                if ((percent = percent.trim()).length() >= 1 && percent.charAt(percent.length() - 1) == '%') {
                    percent = percent.substring(0, percent.length() - 1);
                }
                try {
                    this.heightPercent = Double.parseDouble(percent) / 100.0;
                }
                catch (NumberFormatException ex) {}
            }
        } else {
            this.linkReport = null;
            this.sizeReport = null;
            this.bgColor = 0;
            this.pageTitle = null;
        }
    }

    private void init(List<Source> sources, List<CompilationUnit> exportedUnits, Set<String> resourceBundles, Map<String, VirtualFile> archiveFiles, Configuration configuration) {
        List rslPathInfoList;
        TreeSet<String> sourceNames = new TreeSet<String>();
        TreeSet<String> assetNames = new TreeSet<String>();
        TreeSet<String> libraryNames = new TreeSet<String>();
        this.data = new HashMap<String, Data>();
        this.locations = new HashMap<String, String>();
        if (sources != null) {
            this.processSources(sources, sourceNames, assetNames, libraryNames, this.data, this.locations);
        }
        this.timestamps = new HashMap<String, Long>();
        if (this.sourceListPaths != null) {
            for (File path : this.sourceListPaths) {
                this.storeTimestamps(path);
            }
        }
        this.compiler_SourceNames = this.toArray(sourceNames);
        this.storeTimestamps(this.compiler_SourceNames);
        this.compiler_AssetNames = this.toArray(assetNames);
        this.storeTimestamps(this.compiler_AssetNames);
        this.compiler_LibraryNames = this.toArray(libraryNames);
        this.storeTimestamps(this.compiler_LibraryNames);
        this.resourceBundleNames = this.toArray(resourceBundles);
        sourceNames.clear();
        assetNames.clear();
        libraryNames.clear();
        this.processCompilationUnits(exportedUnits, sourceNames, assetNames, libraryNames);
        if (archiveFiles != null) {
            for (String fileName : archiveFiles.keySet()) {
                assetNames.add(fileName);
            }
        }
        this.linker_SourceNames = this.toArray(sourceNames);
        this.storeTimestamps(this.linker_SourceNames);
        this.linker_AssetNames = this.toArray(assetNames);
        this.storeTimestamps(this.linker_AssetNames);
        this.linker_LibraryNames = this.toArray(libraryNames);
        this.storeTimestamps(this.linker_LibraryNames);
        if (configuration != null && (rslPathInfoList = configuration.getRslPathInfo()).size() > 0) {
            String[] rslPaths = new String[rslPathInfoList.size()];
            int i = 0;
            for (Configuration.RslPathInfo rslPathInfo : rslPathInfoList) {
                rslPaths[i++] = rslPathInfo.getSwcVirtualFile().getName();
            }
            this.storeTimestamps(rslPaths);
        }
    }

    private void storeTimestamps(File path) {
        this.timestamps.put(FileUtil.getCanonicalPath((File)path), path.lastModified());
        for (File file : path.listFiles()) {
            if (!file.isDirectory()) continue;
            this.storeTimestamps(file);
        }
    }

    private void storeTimestamps(String[] a) {
        if (a != null) {
            for (String fileName : a) {
                if (fileName == null || this.timestamps.containsKey(fileName)) continue;
                this.timestamps.put(fileName, new File(fileName).lastModified());
            }
        }
    }

    @Override
    public boolean contentUpdated() {
        for (String path : this.timestamps.keySet()) {
            Long ts = this.timestamps.get(path);
            File f = new File(path);
            if (f.exists() && f.lastModified() == ts.longValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String[] getSourceNames(Object report) {
        return COMPILER.equals(report) ? this.compiler_SourceNames : (LINKER.equals(report) ? this.linker_SourceNames : null);
    }

    @Override
    public String[] getAssetNames(int frame) {
        return this.assetNames[frame - 1];
    }

    @Override
    public String[] getAssetNames(Object report) {
        return COMPILER.equals(report) ? this.compiler_AssetNames : (LINKER.equals(report) ? this.linker_AssetNames : null);
    }

    @Override
    public String[] getLibraryNames(Object report) {
        return COMPILER.equals(report) ? this.compiler_LibraryNames : (LINKER.equals(report) ? this.linker_LibraryNames : null);
    }

    @Override
    public String[] getResourceBundleNames() {
        return this.resourceBundleNames;
    }

    @Override
    public String[] getDefinitionNames(int frame) {
        return this.definitionNames[frame - 1];
    }

    @Override
    public String[] getDefinitionNames(String sourceName) {
        Data d = this.data.get(sourceName);
        return d == null ? null : d.definitions;
    }

    @Override
    public String getLocation(String definition) {
        return this.locations.get(definition);
    }

    @Override
    public String[] getDependencies(String definition) {
        String location = this.getLocation(definition);
        if (location != null) {
            Data d = this.data.get(location);
            return d == null ? null : d.dependencies;
        }
        return null;
    }

    @Override
    public String[] getPrerequisites(String definition) {
        String location = this.getLocation(definition);
        if (location != null) {
            Data d = this.data.get(location);
            return d == null ? null : d.prerequisites;
        }
        return null;
    }

    @Override
    public long writeLinkReport(Writer out) throws IOException {
        long size = 0L;
        if (this.linkReport != null) {
            out.write(this.linkReport);
            out.flush();
            size = this.linkReport.length();
        }
        return size;
    }

    @Override
    public long writeSizeReport(Writer out) throws IOException {
        long size = 0L;
        if (this.sizeReport != null) {
            out.write(this.sizeReport);
            out.flush();
            size = this.sizeReport.length();
        }
        return size;
    }

    @Override
    public long writeConfigurationReport(Writer out) throws IOException {
        long size = 0L;
        if (this.configurationReport != null) {
            out.write(this.configurationReport);
            out.flush();
            size = this.configurationReport.length();
        }
        return size;
    }

    @Override
    public int getBackgroundColor() {
        return this.bgColor;
    }

    @Override
    public String getPageTitle() {
        return this.pageTitle;
    }

    @Override
    public int getDefaultWidth() {
        return this.defaultWidth;
    }

    @Override
    public int getDefaultHeight() {
        return this.defaultHeight;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public double getWidthPercent() {
        return this.widthPercent;
    }

    @Override
    public double getHeightPercent() {
        return this.heightPercent;
    }

    @Override
    public String getCompilerVersion() {
        return VersionInfo.buildMessage();
    }

    @Override
    public Message[] getMessages() {
        return this.messages;
    }

    @Override
    public int getFrameCount() {
        return this.frameCount;
    }

    private void processCompilationUnits(List<CompilationUnit> units, TreeSet<String> sourceNames, TreeSet<String> assetNames, TreeSet<String> libraryNames) {
        int length;
        int n = length = units == null ? 0 : units.size();
        for (int i = 0; i < length; ++i) {
            Source s;
            CompilationUnit u = units.get(i);
            Source source = s = u == null ? null : u.getSource();
            if (s == null) continue;
            if (s.isFileSpecOwner() || s.isSourceListOwner() || s.isSourcePathOwner() || s.isResourceBundlePathOwner()) {
                sourceNames.add(s.getName());
                Iterator j = s.getFileIncludes();
                while (j.hasNext()) {
                    VirtualFile f = (VirtualFile)j.next();
                    sourceNames.add(f.getName());
                }
                if (!u.hasAssets()) continue;
                for (Map.Entry e : u.getAssets()) {
                    AssetInfo assetInfo = (AssetInfo)e.getValue();
                    VirtualFile path = assetInfo.getPath();
                    if (path == null) continue;
                    assetNames.add(path.getName());
                }
                continue;
            }
            if (!s.isSwcScriptOwner()) continue;
            String location = ((SwcScript)s.getOwner()).getLibrary().getSwcLocation();
            libraryNames.add(location);
        }
    }

    private void processSources(List<Source> sources, TreeSet<String> sourceNames, TreeSet<String> assetNames, TreeSet<String> libraryNames, Map<String, Data> data, Map<String, String> locations) {
        CompilationUnit u;
        for (Source s : sources) {
            CompilationUnit compilationUnit = u = s == null ? null : s.getCompilationUnit();
            if (s == null) continue;
            if (s.isFileSpecOwner() || s.isSourceListOwner() || s.isSourcePathOwner() || s.isResourceBundlePathOwner()) {
                sourceNames.add(s.getName());
                Iterator j = s.getFileIncludes();
                while (j.hasNext()) {
                    VirtualFile f = (VirtualFile)j.next();
                    sourceNames.add(f.getName());
                }
                if (u.hasAssets()) {
                    for (Map.Entry e : u.getAssets()) {
                        AssetInfo assetInfo = (AssetInfo)e.getValue();
                        VirtualFile path = assetInfo.getPath();
                        if (path == null) continue;
                        assetNames.add(assetInfo.getPath().getName());
                    }
                }
                if (locations == null) continue;
                int size = u.topLevelDefinitions.size();
                for (int j2 = 0; j2 < size; ++j2) {
                    locations.put(((QName)u.topLevelDefinitions.get(j2)).toString(), s.getName());
                }
                continue;
            }
            if (!s.isSwcScriptOwner()) continue;
            String location = ((SwcScript)s.getOwner()).getLibrary().getSwcLocation();
            libraryNames.add(location);
            if (locations == null) continue;
            int size = u.topLevelDefinitions.size();
            for (int j = 0; j < size; ++j) {
                locations.put(((QName)u.topLevelDefinitions.get(j)).toString(), location);
            }
        }
        for (Source s : sources) {
            CompilationUnit compilationUnit = u = s == null ? null : s.getCompilationUnit();
            if (s == null || !s.isFileSpecOwner() && !s.isSourceListOwner() && !s.isSourcePathOwner() && !s.isResourceBundlePathOwner()) continue;
            Data d = new Data();
            d.definitions = this.toArray(u.topLevelDefinitions);
            d.prerequisites = this.toArray(u.inheritance, null, locations);
            HashSet<Name> nameSet = new HashSet<Name>();
            nameSet.addAll(u.namespaces);
            nameSet.addAll(u.types);
            nameSet.addAll(u.expressions);
            d.dependencies = this.toArray(nameSet, new Set[]{u.extraClasses, u.resourceBundleHistory}, locations);
            data.put(s.getName(), d);
        }
    }

    private void processFrames(SimpleMovie movie) {
        int count = movie == null ? 0 : movie.frames.size();
        this.assetNames = new String[count][];
        this.definitionNames = new String[count][];
        for (int i = 0; i < count; ++i) {
            int size;
            Frame f = (Frame)movie.frames.get(i);
            List units = movie.getExportedUnitsByFrame(f);
            ArrayList<String> aList = new ArrayList<String>();
            ArrayList<String> dList = new ArrayList<String>();
            int n = size = units == null ? 0 : units.size();
            for (int j = 0; j < size; ++j) {
                CompilationUnit u = (CompilationUnit)units.get(j);
                Source s = u.getSource();
                if (u.hasAssets()) {
                    for (Map.Entry e : u.getAssets()) {
                        String assetName;
                        AssetInfo assetInfo = (AssetInfo)e.getValue();
                        VirtualFile path = assetInfo.getPath();
                        if (path == null || aList.contains(assetName = path.getName())) continue;
                        aList.add(assetName);
                    }
                }
                if (!s.isFileSpecOwner() && !s.isResourceBundlePathOwner() && !s.isSourceListOwner() && !s.isSourcePathOwner() && !s.isSwcScriptOwner()) continue;
                Iterator k = u.topLevelDefinitions.iterator();
                while (k.hasNext()) {
                    String definitionName = k.next().toString();
                    dList.add(definitionName);
                }
            }
            if (aList.size() > 0) {
                this.assetNames[i] = new String[aList.size()];
                aList.toArray(this.assetNames[i]);
            }
            if (dList.size() <= 0) continue;
            this.definitionNames[i] = new String[dList.size()];
            dList.toArray(this.definitionNames[i]);
        }
    }

    private void processMessages(List<Message> messages) {
        if (messages != null && messages.size() > 0) {
            ArrayList<Message> filtered = new ArrayList<Message>();
            int length = messages.size();
            for (int i = 0; i < length; ++i) {
                Message m = messages.get(i);
                if (m == null || "info".equals(m.getLevel())) continue;
                filtered.add(m);
            }
            messages = filtered;
        }
        if (messages != null && messages.size() > 0) {
            this.messages = new Message[messages.size()];
            int length = this.messages.length;
            for (int i = 0; i < length; ++i) {
                this.messages[i] = new GenericMessage(messages.get(i));
            }
        } else {
            this.messages = null;
        }
    }

    private String[] toArray(Set<String> set) {
        String[] a = new String[set == null ? 0 : set.size()];
        int j = 0;
        if (set != null) {
            for (String source : set) {
                a[j++] = source;
            }
        }
        return a.length == 0 ? null : a;
    }

    private String[] toArray(QNameList definitions) {
        String[] a = new String[definitions == null ? 0 : definitions.size()];
        for (int i = 0; i < a.length; ++i) {
            a[i] = ((QName)definitions.get(i)).toString();
        }
        return a.length == 0 ? null : a;
    }

    private String[] toArray(Set<Name> nameSet, Set[] sets, Map locations) {
        int length;
        TreeSet<String> set = new TreeSet<String>();
        for (Name name : nameSet) {
            String qName = null;
            if (!(name instanceof QName) || locations != null && !locations.containsKey(qName = name.toString())) continue;
            set.add(qName);
        }
        int n = length = sets == null ? 0 : sets.length;
        for (int i = 0; i < length; ++i) {
            if (sets[i] == null) continue;
            for (Object obj : sets[i]) {
                if (!(obj instanceof String) || locations != null && !locations.containsKey(obj)) continue;
                set.add((String)obj);
            }
        }
        return this.toArray(set);
    }

    static class Data {
        String[] definitions;
        String[] prerequisites;
        String[] dependencies;

        Data() {
        }
    }
}

