/*
 * Decompiled with CFR 0.152.
 */
package flex2.tools.oem;

import flash.localization.LocalizationManager;
import flash.swf.Movie;
import flash.swf.MovieDecoder;
import flash.swf.MovieEncoder;
import flash.swf.TagDecoder;
import flash.swf.TagEncoder;
import flash.swf.TagHandler;
import flash.util.Trace;
import flex2.compiler.CompilerSwcContext;
import flex2.compiler.common.Configuration;
import flex2.compiler.io.LocalFile;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.swc.SwcCache;
import flex2.compiler.util.Benchmark;
import flex2.compiler.util.MimeMappings;
import flex2.compiler.util.NameMappings;
import flex2.compiler.util.OrderedProperties;
import flex2.compiler.util.SwcDependencyInfo;
import flex2.compiler.util.SwcDependencyUtil;
import flex2.compiler.util.ThreadLocalToolkit;
import flex2.tools.WebTierAPI;
import flex2.tools.oem.ApplicationInfo;
import flex2.tools.oem.ApplicationInfoImpl;
import flex2.tools.oem.Library;
import flex2.tools.oem.LibraryInfo;
import flex2.tools.oem.LibraryInfoImpl;
import flex2.tools.oem.Message;
import flex2.tools.oem.OEMException;
import flex2.tools.oem.internal.OEMUtil;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import macromedia.asc.util.ContextStatics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Toolkit {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static ApplicationInfo getApplicationInfo(File application) {
        ApplicationInfoImpl info;
        block12: {
            BufferedInputStream in = null;
            info = null;
            in = new BufferedInputStream(new FileInputStream(application));
            Movie movie = new Movie();
            new TagDecoder((InputStream)in).parse((TagHandler)new MovieDecoder(movie));
            info = new ApplicationInfoImpl(movie);
            Object var5_5 = null;
            try {
                if (in != null) {
                    ((InputStream)in).close();
                }
                break block12;
            }
            catch (IOException ex2) {}
            break block12;
            {
                catch (IOException ex) {
                    if (Trace.error) {
                        ex.printStackTrace();
                    }
                    Object var5_6 = null;
                    try {
                        if (in != null) {
                            ((InputStream)in).close();
                        }
                        break block12;
                    }
                    catch (IOException ex2) {}
                }
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                try {
                    if (in != null) {
                        ((InputStream)in).close();
                    }
                }
                catch (IOException ex2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return info;
    }

    public static LibraryInfo getLibraryInfo(File library) {
        return Toolkit.getLibraryInfo(new File[]{library});
    }

    public static LibraryInfo getLibraryInfo(File[] libraries) {
        return Toolkit.getLibraryInfo(libraries, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static LibraryInfo getLibraryInfo(File[] libraries, boolean includeBytecodes) {
        LibraryInfoImpl info = null;
        try {
            try {
                OEMUtil.init(OEMUtil.getLogger(null, new ArrayList<Message>()), new MimeMappings(), null, null, null);
                CompilerSwcContext swcContext = new CompilerSwcContext();
                SwcCache cache = new SwcCache();
                swcContext.load(Toolkit.toVirtualFiles(libraries), new NameMappings(), ".properties", cache);
                info = new LibraryInfoImpl(swcContext, includeBytecodes);
                swcContext.close();
            }
            catch (Throwable t) {
                if (Trace.error) {
                    t.printStackTrace();
                }
                Object var6_7 = null;
                OEMUtil.clean();
                return info;
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            OEMUtil.clean();
            throw throwable;
        }
        OEMUtil.clean();
        return info;
    }

    private static VirtualFile[] toVirtualFiles(File[] files) {
        if (files == null) {
            return null;
        }
        ArrayList<LocalFile> vFiles = new ArrayList<LocalFile>(files.length);
        for (int i = 0; i < files.length; ++i) {
            if (files[i] == null) continue;
            vFiles.add(new LocalFile(files[i]));
        }
        return vFiles.toArray(new VirtualFile[vFiles.size()]);
    }

    public static Properties loadProperties(InputStream in) {
        return Toolkit.loadProperties(in, "UTF-8");
    }

    public static Properties loadProperties(File f) {
        return Toolkit.loadProperties(f, "UTF-8");
    }

    public static Properties loadProperties(File f, String encoding) {
        if (f != null && f.isFile()) {
            try {
                return Toolkit.loadProperties(new FileInputStream(f), encoding);
            }
            catch (IOException ex) {
                return null;
            }
        }
        return null;
    }

    private static Properties loadProperties(InputStream in, String encoding) {
        if (in != null) {
            try {
                OrderedProperties p = new OrderedProperties();
                p.load((Reader)new BufferedReader(new InputStreamReader(in, encoding)));
                return p;
            }
            catch (IOException ex) {
                return null;
            }
        }
        return null;
    }

    public static long optimize(InputStream in, OutputStream out) {
        try {
            return WebTierAPI.optimize((InputStream)in, (OutputStream)out);
        }
        catch (IOException ex) {
            return 0L;
        }
    }

    public static long optimize(Library lib, OutputStream out) {
        if (lib == null || lib.data == null || lib.data.movie == null) {
            return 0L;
        }
        try {
            TagEncoder handler = new TagEncoder();
            MovieEncoder encoder = new MovieEncoder((TagHandler)handler);
            encoder.export((Movie)lib.data.movie);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            handler.writeTo((OutputStream)baos);
            return WebTierAPI.optimize((InputStream)new ByteArrayInputStream(baos.toByteArray()), (OutputStream)out, (Configuration)lib.data.configuration);
        }
        catch (IOException ex) {
            return 0L;
        }
    }

    public static void printMemoryUsage() {
        Benchmark.MemoryUsage mem = new Benchmark().getMemoryUsageInBytes();
        long mbHeapUsed = mem.heap / 0x100000L;
        long mbNonHeapUsed = mem.nonHeap / 0x100000L;
        System.out.println("Heap: " + mbHeapUsed + " Non-Heap: " + mbNonHeapUsed);
    }

    public static List<String> getRequiredUseNamespaces(int targetPlayerMajorVersion) {
        return ContextStatics.getRequiredUseNamespaces((int)targetPlayerMajorVersion);
    }

    public static List<String> getDependencyOrder(File[] libraries) throws OEMException.CircularLibraryDependencyException {
        if (libraries == null) {
            return Collections.emptyList();
        }
        SwcDependencyInfo info = SwcDependencyUtil.getSwcDependencyInfo((VirtualFile[])Toolkit.toVirtualFiles(libraries), null, (boolean)true);
        Set cycles = info.detectCycles();
        if (cycles.size() > 0) {
            LocalizationManager i10n = ThreadLocalToolkit.getLocalizationManager();
            if (i10n == null) {
                OEMUtil.setupLocalizationManager();
                i10n = ThreadLocalToolkit.getLocalizationManager();
            }
            String message = i10n.getLocalizedTextString((Object)new OEMException.CircularLibraryDependencyException(null, null));
            throw new OEMException.CircularLibraryDependencyException(message, SwcDependencyUtil.SetOfVertexToString((Set)cycles));
        }
        return info.getSwcDependencyOrder();
    }

    public static Set<String> getLibraryDependencies(File[] libraries, File targetLibrary, boolean minimizeDependencySet) throws OEMException.CircularLibraryDependencyException {
        if (libraries == null || targetLibrary == null) {
            return Collections.emptySet();
        }
        SwcDependencyInfo info = SwcDependencyUtil.getSwcDependencyInfo((VirtualFile[])Toolkit.toVirtualFiles(libraries), null, (boolean)minimizeDependencySet);
        Set cycles = info.detectCycles();
        if (cycles.size() > 0) {
            LocalizationManager i10n = ThreadLocalToolkit.getLocalizationManager();
            if (i10n == null) {
                OEMUtil.setupLocalizationManager();
                i10n = ThreadLocalToolkit.getLocalizationManager();
            }
            String message = i10n.getLocalizedTextString((Object)new OEMException.CircularLibraryDependencyException(null, null));
            throw new OEMException.CircularLibraryDependencyException(message, SwcDependencyUtil.SetOfVertexToString((Set)cycles));
        }
        LocalFile virtualLibrary = new LocalFile(targetLibrary);
        return info.getDependencies(virtualLibrary.getName());
    }
}

