/*
 * Decompiled with CFR 0.152.
 */
package flex2.tools.flexbuilder;

import flex2.compiler.config.ConfigurationBuffer;
import flex2.compiler.config.ConfigurationException;
import flex2.compiler.config.ConfigurationValue;
import flex2.compiler.io.FileUtil;
import flex2.tools.flexbuilder.BuilderConfiguration;
import flex2.tools.oem.Configuration;
import flex2.tools.oem.Library;
import flex2.tools.oem.internal.OEMConfiguration;
import flex2.tools.oem.internal.OEMUtil;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class BuilderLibrary
extends Library {
    private BuilderConfiguration c;
    private static final Set excludes = new HashSet();

    public Configuration getDefaultConfiguration() {
        return new BuilderConfiguration(super.getDefaultConfiguration());
    }

    public void setConfiguration(Configuration configuration) {
        if (configuration instanceof BuilderConfiguration) {
            this.c = (BuilderConfiguration)configuration;
            super.setConfiguration(this.c.configuration);
        } else {
            super.setConfiguration(configuration);
        }
    }

    public Configuration getConfiguration() {
        return this.c != null ? this.c : super.getConfiguration();
    }

    protected int compile(boolean incremental) {
        String[] args;
        File dumpConfigFile = null;
        OEMConfiguration config = null;
        if (this.c != null && (args = this.c.extra) != null && args.length > 0 && (config = (OEMConfiguration)this.c.configuration) != null) {
            ConfigurationBuffer cfgbuf = OEMUtil.getCompcConfigurationBuffer(OEMUtil.getLogger(this.getLogger(), null), this.resolver, args);
            if (cfgbuf == null) {
                return -1;
            }
            List positions = cfgbuf.getPositions();
            int length = positions.size();
            for (int i = 0; i < length; ++i) {
                int k;
                int size;
                List valArgs;
                ConfigurationValue val;
                int len;
                List l;
                String value;
                Object[] a = (Object[])positions.get(i);
                String var = (String)a[0];
                if ("dump-config".equals(var)) {
                    try {
                        dumpConfigFile = new File(cfgbuf.peekSimpleConfigurationVar(var));
                    }
                    catch (ConfigurationException ex) {}
                    continue;
                }
                if ("link-report".equals(var)) {
                    config.keepLinkReport(true);
                    continue;
                }
                if ("compiler.debug".equals(var)) {
                    try {
                        value = cfgbuf.peekSimpleConfigurationVar(var);
                        String debugPassword = cfgbuf.peekSimpleConfigurationVar("debug-password");
                        if ("true".equals(value)) {
                            config.enableDebugging(true, debugPassword);
                            continue;
                        }
                        if (!"false".equals(value)) continue;
                        config.enableDebugging(false, debugPassword);
                    }
                    catch (ConfigurationException ex) {}
                    continue;
                }
                if ("compiler.verbose-stacktraces".equals(var)) {
                    try {
                        value = cfgbuf.peekSimpleConfigurationVar(var);
                        if ("true".equals(value)) {
                            config.enableVerboseStacktraces(true);
                            continue;
                        }
                        if (!"false".equals(value)) continue;
                        config.enableVerboseStacktraces(false);
                    }
                    catch (ConfigurationException ex) {}
                    continue;
                }
                if ("compiler.accessible".equals(var)) {
                    try {
                        value = cfgbuf.peekSimpleConfigurationVar(var);
                        if ("true".equals(value)) {
                            config.enableAccessibility(true);
                            continue;
                        }
                        if (!"false".equals(value)) continue;
                        config.enableAccessibility(false);
                    }
                    catch (ConfigurationException ex) {}
                    continue;
                }
                if ("compiler.strict".equals(var)) {
                    try {
                        value = cfgbuf.peekSimpleConfigurationVar(var);
                        if ("true".equals(value)) {
                            config.enableStrictChecking(true);
                            continue;
                        }
                        if (!"false".equals(value)) continue;
                        config.enableStrictChecking(false);
                    }
                    catch (ConfigurationException ex) {}
                    continue;
                }
                if ("help".equals(var)) continue;
                if ("output".equals(var)) {
                    try {
                        String isDirectory = cfgbuf.peekSimpleConfigurationVar("directory");
                        String value2 = cfgbuf.peekSimpleConfigurationVar(var);
                        if ("true".equals(isDirectory)) {
                            this.setDirectory(new File(value2));
                            continue;
                        }
                        this.setOutput(new File(value2));
                    }
                    catch (ConfigurationException ex) {}
                    continue;
                }
                if ("directory".equals(var) || "version".equals(var)) continue;
                if ("include-classes".equals(var)) {
                    try {
                        l = cfgbuf.peekConfigurationVar(var);
                        int n = len = l == null ? 0 : l.size();
                        for (int j = 0; j < len; ++j) {
                            val = (ConfigurationValue)l.get(j);
                            valArgs = val.getArgs();
                            int n2 = size = valArgs == null ? 0 : valArgs.size();
                            for (k = 0; k < size; ++k) {
                                this.addComponent((String)valArgs.get(k));
                            }
                        }
                        continue;
                    }
                    catch (ConfigurationException ex) {
                        continue;
                    }
                }
                if ("include-file".equals(var)) {
                    try {
                        l = cfgbuf.peekConfigurationVar(var);
                        int n = len = l == null ? 0 : l.size();
                        for (int j = 0; j < len; ++j) {
                            val = (ConfigurationValue)l.get(j);
                            valArgs = val.getArgs();
                            this.addArchiveFile((String)valArgs.get(0), new File((String)valArgs.get(1)));
                        }
                        continue;
                    }
                    catch (ConfigurationException ex) {
                        continue;
                    }
                }
                if ("include-namespaces".equals(var)) {
                    try {
                        l = cfgbuf.peekConfigurationVar(var);
                        int n = len = l == null ? 0 : l.size();
                        for (int j = 0; j < len; ++j) {
                            val = (ConfigurationValue)l.get(j);
                            valArgs = val.getArgs();
                            int n3 = size = valArgs == null ? 0 : valArgs.size();
                            for (k = 0; k < size; ++k) {
                                try {
                                    this.addComponent(new URI((String)valArgs.get(k)));
                                    continue;
                                }
                                catch (URISyntaxException ex) {
                                    ex.printStackTrace();
                                }
                            }
                        }
                        continue;
                    }
                    catch (ConfigurationException ex) {
                        continue;
                    }
                }
                if ("include-resource-bundles".equals(var)) {
                    try {
                        l = cfgbuf.peekConfigurationVar(var);
                        int n = len = l == null ? 0 : l.size();
                        for (int j = 0; j < len; ++j) {
                            val = (ConfigurationValue)l.get(j);
                            valArgs = val.getArgs();
                            int n4 = size = valArgs == null ? 0 : valArgs.size();
                            for (k = 0; k < size; ++k) {
                                this.addResourceBundle((String)valArgs.get(k));
                            }
                        }
                        continue;
                    }
                    catch (ConfigurationException ex) {
                        continue;
                    }
                }
                if (!"include-sources".equals(var)) continue;
                try {
                    l = cfgbuf.peekConfigurationVar(var);
                    int n = len = l == null ? 0 : l.size();
                    for (int j = 0; j < len; ++j) {
                        val = (ConfigurationValue)l.get(j);
                        valArgs = val.getArgs();
                        int n5 = size = valArgs == null ? 0 : valArgs.size();
                        for (k = 0; k < size; ++k) {
                            this.addComponent(new File((String)valArgs.get(k)));
                        }
                    }
                    continue;
                }
                catch (ConfigurationException ex) {
                    // empty catch block
                }
            }
            config.setConfiguration(OEMUtil.trim(args, cfgbuf, excludes));
        }
        int result = super.compile(incremental);
        if (dumpConfigFile != null && config != null && config.cfgbuf != null) {
            try {
                String text = OEMUtil.formatConfigurationBuffer(config.cfgbuf);
                FileUtil.writeFile((String)dumpConfigFile.getAbsolutePath(), (String)text);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return result;
    }

    static {
        excludes.add("directory");
        excludes.add("dump-config");
        excludes.add("help");
        excludes.add("include-classes");
        excludes.add("include-file");
        excludes.add("include-namespaces");
        excludes.add("include-resource-bundles");
        excludes.add("include-sources");
        excludes.add("output");
        excludes.add("version");
        excludes.add("compiler.debug");
        excludes.add("compiler.profile");
        excludes.add("compiler.accessible");
        excludes.add("compiler.strict");
        excludes.add("compiler.verbose-stacktraces");
    }
}

