/*
 * Decompiled with CFR 0.152.
 */
package flex2.tools.oem;

import flex2.compiler.CompilerSwcContext;
import flex2.compiler.util.NameMappings;
import flex2.compiler.util.QName;
import flex2.tools.oem.Component;
import flex2.tools.oem.LibraryInfo;
import flex2.tools.oem.Script;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

class LibraryInfoImpl
implements LibraryInfo {
    private String[] definitionNames;
    private Map scripts;
    private Map components;
    private NameMappings mappings;
    private Set fileNames;

    LibraryInfoImpl(CompilerSwcContext swcContext, boolean includeBytecodes) {
        int i;
        ArrayList<QName> names = new ArrayList<QName>();
        Iterator i2 = swcContext.getDefinitionIterator();
        while (i2.hasNext()) {
            names.add((QName)i2.next());
        }
        this.definitionNames = new String[names.size()];
        for (i = 0; i < this.definitionNames.length; ++i) {
            this.definitionNames[i] = ((QName)names.get(i)).toString();
        }
        this.scripts = new TreeMap();
        for (i = 0; i < this.definitionNames.length; ++i) {
            QName def = (QName)names.get(i);
            Script s = swcContext.getScript(def, includeBytecodes);
            this.scripts.put(def.toString(), s);
        }
        this.components = new TreeMap();
        Iterator i3 = swcContext.getComponentIterator();
        while (i3.hasNext()) {
            Component c = (Component)i3.next();
            this.components.put(c.getClassName(), c);
        }
        this.mappings = swcContext.getNameMappings();
        this.fileNames = new TreeSet(swcContext.getFiles().keySet());
    }

    public Component getComponent(String namespaceURI, String name) {
        return this.getComponent(this.mappings.lookupClassName(namespaceURI, name));
    }

    public Component getComponent(String definition) {
        return definition != null ? (Component)this.components.get(definition) : null;
    }

    public Iterator getComponents() {
        return this.components.values().iterator();
    }

    public String[] getDefinitionNames() {
        return this.definitionNames;
    }

    public Script getScript(String definition) {
        return (Script)this.scripts.get(definition);
    }

    public Iterator getScripts() {
        return this.scripts.values().iterator();
    }

    public Iterator getFiles() {
        return this.fileNames.iterator();
    }
}

