/*
 * Decompiled with CFR 0.152.
 */
package flash.tools.debugger.expression;

import flash.localization.ILocalizer;
import flash.localization.LocalizationManager;
import flash.tools.debugger.DebuggerLocalizer;
import flash.tools.debugger.expression.DebuggerExpression;
import flash.tools.debugger.expression.IASTBuilder;
import flash.tools.debugger.expression.ValueExp;
import java.io.IOException;
import java.io.Reader;
import java.text.ParseException;
import java.util.ArrayList;
import macromedia.asc.embedding.CompilerHandler;
import macromedia.asc.parser.Parser;
import macromedia.asc.parser.ProgramNode;
import macromedia.asc.util.Context;
import macromedia.asc.util.ContextStatics;

public class ASTBuilder
implements IASTBuilder {
    private static LocalizationManager s_localizationManager = new LocalizationManager();
    private boolean m_isIndirectionOperatorAllowed = true;

    public ASTBuilder(boolean isIndirectionOperatorAllowed) {
        this.m_isIndirectionOperatorAllowed = isIndirectionOperatorAllowed;
    }

    public boolean isIndirectionOperatorAllowed() {
        return this.m_isIndirectionOperatorAllowed;
    }

    public ValueExp parse(Reader in) throws IOException, ParseException {
        int ch;
        DebuggerExpression retval = new DebuggerExpression();
        StringBuilder sb = new StringBuilder();
        while ((ch = in.read()) != -1) {
            sb.append((char)ch);
        }
        String s = sb.toString();
        s = s.replaceFirst("^#([0-9]+)", "\\$obj($1)");
        if (this.isIndirectionOperatorAllowed()) {
            if (s.endsWith(".")) {
                retval.setLookupMembers(true);
                s = s.substring(0, s.length() - 1);
            } else if (s.startsWith("*")) {
                retval.setLookupMembers(true);
                s = s.substring(1);
            }
        }
        s = "(" + s + ")";
        ContextStatics statics = new ContextStatics();
        Context cx = new Context(statics);
        final ArrayList errors = new ArrayList();
        CompilerHandler newHandler = new CompilerHandler(){

            public void error(String filename, int ln, int col, String msg, String source) {
                ErrorInfo ei = new ErrorInfo();
                ei.filename = filename;
                ei.ln = ln;
                ei.col = col;
                ei.msg = msg;
                ei.source = source;
                errors.add(ei);
            }
        };
        cx.setHandler(newHandler);
        cx.scriptAssistParsing = true;
        Parser parser = new Parser(cx, s, "Expression");
        ProgramNode programNode = parser.parseProgram();
        if (errors.size() > 0) {
            ErrorInfo firstError = (ErrorInfo)errors.get(0);
            throw new ParseException(firstError.msg, firstError.col);
        }
        retval.setProgramNode(programNode);
        retval.setContext(cx);
        return retval;
    }

    static LocalizationManager getLocalizationManager() {
        return s_localizationManager;
    }

    static {
        s_localizationManager.addLocalizer((ILocalizer)new DebuggerLocalizer("flash.tools.debugger.expression.expression."));
    }

    private static class ErrorInfo {
        public String filename;
        public int ln;
        public int col;
        public String msg;
        public String source;

        private ErrorInfo() {
        }
    }
}

