/*
 * Decompiled with CFR 0.152.
 */
package flash.tools.debugger.concrete;

import flash.localization.ILocalizer;
import flash.localization.LocalizationManager;
import flash.tools.debugger.AIRLaunchInfo;
import flash.tools.debugger.DebuggerLocalizer;
import flash.tools.debugger.DefaultDebuggerCallbacks;
import flash.tools.debugger.IDebuggerCallbacks;
import flash.tools.debugger.ILaunchNotification;
import flash.tools.debugger.IProgress;
import flash.tools.debugger.Player;
import flash.tools.debugger.Session;
import flash.tools.debugger.SessionManager;
import flash.tools.debugger.concrete.AIRPlayer;
import flash.tools.debugger.concrete.ActiveXPlayer;
import flash.tools.debugger.concrete.NetscapePluginPlayer;
import flash.tools.debugger.concrete.PlayerSession;
import flash.tools.debugger.concrete.ProcessListener;
import flash.tools.debugger.concrete.StandalonePlayer;
import flash.util.URLHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlayerSessionManager
implements SessionManager {
    private ServerSocket m_serverSocket = null;
    private HashMap<String, Object> m_prefs;
    private IDebuggerCallbacks m_debuggerCallbacks = new DefaultDebuggerCallbacks();
    private static LocalizationManager m_localizationManager = new LocalizationManager();

    public PlayerSessionManager() {
        this.m_prefs = new HashMap();
        this.setPreference("$accepttimeout", 120000);
        this.setPreference("$urimodification", 1);
        this.setPreference("$responsetimeout", 750);
        this.setPreference("$contextresponsetimeout", 1000);
        this.setPreference("$getvarresponsetimeout", 1500);
        this.setPreference("$setvarresponsetimeout", 5000);
        this.setPreference("$swfswdloadtimeout", 5000);
        this.setPreference("$suspendwait", 7000);
        this.setPreference("$invokegetters", 1);
        this.setPreference("$hiervars", 0);
    }

    @Override
    public void setPreference(String pref, int value) {
        this.m_prefs.put(pref, new Integer(value));
    }

    @Override
    public void setPreference(String pref, String value) {
        this.m_prefs.put(pref, value);
    }

    public Set<String> keySet() {
        return this.m_prefs.keySet();
    }

    public Object getPreferenceAsObject(String pref) {
        return this.m_prefs.get(pref);
    }

    @Override
    public int getPreference(String pref) {
        int val = 0;
        Integer i = (Integer)this.m_prefs.get(pref);
        if (i == null) {
            throw new NullPointerException();
        }
        val = i;
        return val;
    }

    @Override
    public void startListening() throws IOException {
        if (this.m_serverSocket == null) {
            this.m_serverSocket = new ServerSocket(7935);
        }
    }

    @Override
    public void stopListening() throws IOException {
        if (this.m_serverSocket != null) {
            this.m_serverSocket.close();
            this.m_serverSocket = null;
        }
    }

    @Override
    public boolean isListening() {
        return this.m_serverSocket != null;
    }

    private OS getOS() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.startsWith("mac os x")) {
            return OS.Mac;
        }
        if (osName.startsWith("windows")) {
            return OS.Windows;
        }
        return OS.Unix;
    }

    @Override
    public Session launch(String uri, AIRLaunchInfo airLaunchInfo, boolean forDebugging, IProgress waitReporter, ILaunchNotification launchNotification) throws IOException {
        String[] launchCommand;
        uri = uri.trim();
        if (airLaunchInfo == null) {
            LaunchInfo launchInfo = new LaunchInfo(uri);
            uri = this.tweakNativeLaunchUri(uri, forDebugging, launchInfo);
            launchCommand = this.getFlashLaunchArgs(uri, launchInfo);
        } else {
            launchCommand = this.getAIRLaunchArgs(uri, airLaunchInfo);
        }
        ProcessListener pl = null;
        PlayerSession session = null;
        Process proc = this.m_debuggerCallbacks.launchDebugTarget(launchCommand);
        pl = new ProcessListener(launchCommand, proc, launchNotification, forDebugging, airLaunchInfo != null);
        if (!forDebugging && airLaunchInfo != null && launchNotification != null) {
            pl.startLaunchNotifier();
        }
        if (forDebugging) {
            session = (PlayerSession)this.accept(pl, waitReporter);
            session.setProcess(proc);
            session.setLaunchUrl(uri);
            session.setAIRLaunchInfo(airLaunchInfo);
        }
        return session;
    }

    private String tweakNativeLaunchUri(String uri, boolean forDebugging, LaunchInfo launchInfo) throws IOException, FileNotFoundException {
        if (launchInfo.isHttpOrAbout()) {
            boolean modify;
            boolean bl = modify = this.getPreference("$urimodification") != 0;
            if (modify && forDebugging && !launchInfo.isAbout()) {
                uri = URLHelper.escapeSpace(uri);
                URLHelper urlHelper = new URLHelper(uri);
                LinkedHashMap<String, String> params = urlHelper.getParameterMap();
                params.put("debug", "true");
                urlHelper.setParameterMap(params);
                uri = urlHelper.getURL();
            }
        } else {
            File f = null;
            if (uri.startsWith("file:")) {
                try {
                    f = new File(new URI(uri));
                }
                catch (URISyntaxException e) {
                    IOException ioe = new IOException(e.getMessage());
                    ioe.initCause(e);
                    throw ioe;
                }
            } else {
                f = new File(uri);
            }
            if (f != null && f.exists()) {
                uri = f.getAbsolutePath();
            } else {
                throw new FileNotFoundException(uri);
            }
        }
        return uri;
    }

    private String[] getFlashLaunchArgs(String uri, LaunchInfo launchInfo) throws FileNotFoundException {
        String[] launchCommand;
        OS os = this.getOS();
        if (os == OS.Mac) {
            if (launchInfo.isWebBrowserNativeLaunch()) {
                File httpExe = this.m_debuggerCallbacks.getHttpExe();
                launchCommand = new String[]{"/usr/bin/open", "-a", httpExe.toString(), uri};
            } else if (launchInfo.isPlayerNativeLaunch()) {
                File playerExe = this.m_debuggerCallbacks.getPlayerExe();
                launchCommand = new String[]{"/usr/bin/open", "-a", playerExe.toString(), uri};
            } else {
                launchCommand = new String[]{"/usr/bin/open", uri};
            }
        } else if (launchInfo.isWebBrowserNativeLaunch()) {
            File httpExe = this.m_debuggerCallbacks.getHttpExe();
            launchCommand = os == OS.Windows ? this.getWindowsBrowserLaunchArgs(httpExe, uri) : new String[]{httpExe.toString(), uri};
        } else if (launchInfo.isPlayerNativeLaunch()) {
            File playerExe = this.m_debuggerCallbacks.getPlayerExe();
            launchCommand = new String[]{playerExe.toString(), uri};
        } else if (os == OS.Windows) {
            uri = uri.replaceAll("&", "\"&\"");
            launchCommand = new String[]{"cmd", "/c", "start", uri};
        } else {
            String exeName = launchInfo.isWebPage() ? this.m_debuggerCallbacks.getHttpExeName() : this.m_debuggerCallbacks.getPlayerExeName();
            throw new FileNotFoundException(exeName);
        }
        return launchCommand;
    }

    private String[] getWindowsBrowserLaunchArgs(File httpExe, String uri) {
        if (httpExe.getName().equalsIgnoreCase("chrome.exe")) {
            return new String[]{httpExe.toString(), "--disable-hang-monitor", uri};
        }
        if (httpExe.getName().equalsIgnoreCase("iexplore.exe")) {
            boolean isIE8 = false;
            try {
                int[] ieVersion = this.m_debuggerCallbacks.getAppVersion(httpExe);
                if (ieVersion != null) {
                    isIE8 = ieVersion[0] >= 8;
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            if (isIE8) {
                return new String[]{httpExe.toString(), "-noframemerging", uri};
            }
        }
        return new String[]{httpExe.toString(), uri};
    }

    private String[] getAIRLaunchArgs(String uri, AIRLaunchInfo airLaunchInfo) throws IOException {
        LinkedList<String> cmdList = new LinkedList<String>();
        cmdList.add(airLaunchInfo.airDebugLauncher.getPath());
        if (airLaunchInfo.airRuntimeDir != null) {
            cmdList.add("-runtime");
            cmdList.add(airLaunchInfo.airRuntimeDir.getPath());
        }
        if (airLaunchInfo.airSecurityPolicy != null) {
            cmdList.add("-security-policy");
            cmdList.add(airLaunchInfo.airSecurityPolicy.getPath());
        }
        if (airLaunchInfo.airPublisherID != null && airLaunchInfo.airPublisherID.length() > 0) {
            cmdList.add("-pubid");
            cmdList.add(airLaunchInfo.airPublisherID);
        }
        if (airLaunchInfo.profile != null && airLaunchInfo.profile.length() > 0) {
            cmdList.add("-profile");
            cmdList.add(airLaunchInfo.profile);
        }
        if (airLaunchInfo.screenSize != null && airLaunchInfo.screenSize.length() > 0) {
            cmdList.add("-screensize");
            cmdList.add(airLaunchInfo.screenSize);
        }
        if (airLaunchInfo.dpi > 0) {
            cmdList.add("-XscreenDPI");
            cmdList.add(String.valueOf(airLaunchInfo.dpi));
        }
        File f = null;
        if (uri.startsWith("file:")) {
            try {
                f = new File(new URI(uri));
                cmdList.add(f.getPath());
            }
            catch (URISyntaxException e) {
                IOException ioe = new IOException(e.getMessage());
                ioe.initCause(e);
                throw ioe;
            }
        } else {
            cmdList.add(uri);
        }
        if (airLaunchInfo.applicationContentRootDir != null) {
            cmdList.add(airLaunchInfo.applicationContentRootDir.getAbsolutePath());
        }
        List<String> args = null;
        if (airLaunchInfo.applicationArgumentsArray != null) {
            args = Arrays.asList(airLaunchInfo.applicationArgumentsArray);
        } else if (airLaunchInfo.applicationArguments != null) {
            args = this.splitArgs(airLaunchInfo.applicationArguments);
        }
        if (args != null && args.size() > 0) {
            cmdList.add("--");
            cmdList.addAll(args);
        }
        return cmdList.toArray(new String[cmdList.size()]);
    }

    private List<String> splitArgs(String arguments) {
        ArrayList<String> retval = new ArrayList<String>();
        arguments = arguments.trim();
        boolean isWindows = System.getProperty("os.name").toLowerCase().startsWith("win");
        boolean isMacOrUnix = !isWindows;
        int i = 0;
        while (i < arguments.length()) {
            char ch = arguments.charAt(i);
            if (ch == ' ' || ch == '\t') {
                ++i;
                continue;
            }
            if (ch == '\"' || isMacOrUnix && ch == '\'') {
                char quote = ch;
                int nextQuote = arguments.indexOf(quote, i + 1);
                if (nextQuote == -1) {
                    retval.add(arguments.substring(i + 1));
                    return retval;
                }
                retval.add(arguments.substring(i + 1, nextQuote));
                i = nextQuote + 1;
                continue;
            }
            int startPos = i;
            while (i < arguments.length() && (ch = arguments.charAt(i)) != ' ' && ch != '\t') {
                ++i;
            }
            retval.add(arguments.substring(startPos, i));
        }
        return retval;
    }

    @Override
    public Player playerForUri(String url, AIRLaunchInfo airLaunchInfo) {
        LaunchInfo launchInfo = new LaunchInfo(url);
        if (airLaunchInfo != null) {
            return new AIRPlayer(airLaunchInfo.airDebugLauncher);
        }
        if (launchInfo.isAIRLaunch()) {
            return new AIRPlayer(null);
        }
        if (this.getOS() == OS.Mac) {
            if (!launchInfo.isWebBrowserNativeLaunch()) {
                File playerExe = this.m_debuggerCallbacks.getPlayerExe();
                return new StandalonePlayer(playerExe);
            }
            File flashPlugin = new File("/Library/Internet Plug-Ins/Flash Player.plugin");
            return new NetscapePluginPlayer(this.m_debuggerCallbacks.getHttpExe(), flashPlugin);
        }
        if (launchInfo.isWebBrowserNativeLaunch()) {
            File pathFromRegistry;
            File pluginsDir;
            File flashPlugin;
            File httpExe = this.m_debuggerCallbacks.getHttpExe();
            if (httpExe.getName().equalsIgnoreCase("iexplore.exe")) {
                String activeXFile = null;
                try {
                    activeXFile = this.m_debuggerCallbacks.queryWindowsRegistry("HKEY_CLASSES_ROOT\\CLSID\\{D27CDB6E-AE6D-11cf-96B8-444553540000}\\InprocServer32", null);
                }
                catch (IOException e) {
                    // empty catch block
                }
                if (activeXFile == null) {
                    return null;
                }
                File file = new File(activeXFile);
                return new ActiveXPlayer(httpExe, file);
            }
            File browserDir = httpExe.getParentFile();
            if (httpExe.getName().equalsIgnoreCase("opera.exe")) {
                browserDir = new File(browserDir, "program");
            }
            if (!(flashPlugin = new File(pluginsDir = new File(browserDir, "plugins"), "NPSWF32.dll")).exists() && (pathFromRegistry = this.getWindowsMozillaPlayerPathFromRegistry()) != null) {
                flashPlugin = pathFromRegistry;
            }
            return new NetscapePluginPlayer(httpExe, flashPlugin);
        }
        if (launchInfo.isPlayerNativeLaunch()) {
            File playerExe = this.m_debuggerCallbacks.getPlayerExe();
            return new StandalonePlayer(playerExe);
        }
        return null;
    }

    private File getWindowsMozillaPlayerPathFromRegistry() {
        String KEY = "\\SOFTWARE\\MozillaPlugins\\@adobe.com/FlashPlayer";
        String PATH = "Path";
        String[] roots = new String[]{"HKEY_LOCAL_MACHINE", "HKEY_CURRENT_USER"};
        for (int i = 0; i < roots.length; ++i) {
            try {
                String path = this.m_debuggerCallbacks.queryWindowsRegistry(roots[i] + "\\SOFTWARE\\MozillaPlugins\\@adobe.com/FlashPlayer", "Path");
                if (path == null) continue;
                return new File(path);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public boolean supportsLaunch() {
        return true;
    }

    @Override
    public Session accept(IProgress waitReporter) throws IOException {
        return this.accept(null, waitReporter);
    }

    private Session accept(ProcessListener pl, IProgress waitReporter) throws IOException {
        int timeout;
        int totalTimeout = timeout = this.getPreference("$accepttimeout");
        int iterateOn = 100;
        PlayerSession session = null;
        try {
            this.m_serverSocket.setSoTimeout(iterateOn);
            Socket s = null;
            while (s == null && !this.airAppTerminated(pl)) {
                block6: {
                    try {
                        s = this.m_serverSocket.accept();
                    }
                    catch (IOException ste) {
                        if ((timeout -= iterateOn) >= 0 && this.m_serverSocket != null && !this.m_serverSocket.isClosed()) break block6;
                        throw ste;
                    }
                }
                if (waitReporter == null) continue;
                waitReporter.setProgress(totalTimeout - timeout, totalTimeout);
            }
            if (s == null && this.airAppTerminated(pl)) {
                throw pl.createLaunchFailureException();
            }
            session = PlayerSession.createFromSocket(s, this.m_debuggerCallbacks);
            session.setPreferences(this.m_prefs);
        }
        catch (NullPointerException npe) {
            throw new BindException(PlayerSessionManager.getLocalizationManager().getLocalizedTextString("serverSocketNotListening"));
        }
        return session;
    }

    private boolean airAppTerminated(ProcessListener pl) {
        return pl != null && pl.isAIRApp() && pl.isProcessDead();
    }

    public IDebuggerCallbacks getDebuggerCallbacks() {
        return this.m_debuggerCallbacks;
    }

    @Override
    public void setDebuggerCallbacks(IDebuggerCallbacks debuggerCallbacks) {
        this.m_debuggerCallbacks = debuggerCallbacks;
    }

    public static LocalizationManager getLocalizationManager() {
        return m_localizationManager;
    }

    static {
        m_localizationManager.addLocalizer((ILocalizer)new DebuggerLocalizer("flash.tools.debugger.concrete.djapi."));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum OS {
        Mac,
        Windows,
        Unix;

    }

    private class LaunchInfo {
        private String m_uri;

        public LaunchInfo(String uri) {
            this.m_uri = uri;
        }

        public boolean isAbout() {
            return this.m_uri.startsWith("about:");
        }

        public boolean isHttpOrAbout() {
            return this.m_uri.startsWith("http:") || this.m_uri.startsWith("https:") || this.isAbout();
        }

        public boolean isWebPage() {
            return this.isHttpOrAbout() || this.m_uri.endsWith(".htm") || this.m_uri.endsWith(".html");
        }

        public boolean isWebBrowserNativeLaunch() {
            return this.isWebPage() && PlayerSessionManager.this.m_debuggerCallbacks.getHttpExe() != null;
        }

        public boolean isPlayerNativeLaunch() {
            return this.m_uri.length() > 0 && !this.isWebPage() && PlayerSessionManager.this.m_debuggerCallbacks.getPlayerExe() != null;
        }

        public boolean isAIRLaunch() {
            return this.m_uri.startsWith("file:") && (this.m_uri.endsWith("-app.xml") || this.m_uri.endsWith("application.xml"));
        }
    }
}

