/*
 * Decompiled with CFR 0.152.
 */
package flash.tools.debugger.concrete;

import flash.swf.debug.DebugModule;
import flash.swf.debug.LineRecord;
import flash.tools.ActionLocation;
import flash.tools.debugger.InProgressException;
import flash.tools.debugger.NoResponseException;
import flash.tools.debugger.Session;
import flash.tools.debugger.SourceFile;
import flash.tools.debugger.SwfInfo;
import flash.tools.debugger.concrete.DManager;
import flash.tools.debugger.concrete.DModule;
import flash.tools.debugger.concrete.LineFunctionContainer;
import flash.tools.debugger.concrete.PlayerSession;
import flash.tools.debugger.concrete.PlayerSessionManager;
import flash.tools.debugger.events.FunctionMetaDataAvailableEvent;
import flash.util.IntMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DSwfInfo
implements SwfInfo {
    private int m_index;
    private long m_id = 0L;
    private IntMap m_source;
    private String m_path;
    private String m_url;
    private String m_host;
    private int m_port;
    private boolean m_swdLoading;
    private int m_swfSize;
    private int m_swdSize;
    private int m_bpCount;
    private int m_offsetCount;
    private int m_scriptsExpected;
    private int m_minId;
    private int m_maxId;
    private byte[] m_swf;
    private byte[] m_swd;
    private boolean m_unloaded;
    private Map<Long, Integer> m_local2Global;
    private int m_numRefreshes;
    private int m_vmVersion;
    private boolean m_populated;
    private LineFunctionContainer m_container;
    private static final String UNKNOWN = PlayerSessionManager.getLocalizationManager().getLocalizedTextString("unknown");
    DManager m_manager;

    public DSwfInfo(int index) {
        this.m_index = index;
        this.m_source = new IntMap();
        this.m_path = UNKNOWN;
        this.m_url = UNKNOWN;
        this.m_host = UNKNOWN;
        this.m_port = 0;
        this.m_swdLoading = true;
        this.m_scriptsExpected = -1;
    }

    @Override
    public String getPath() {
        return this.m_path;
    }

    @Override
    public String getUrl() {
        return this.m_url;
    }

    @Override
    public int getSwfSize() {
        return this.m_swfSize;
    }

    @Override
    public int getSwdSize(Session s) throws InProgressException {
        this.swdLoaded(s);
        return this.m_swdSize;
    }

    @Override
    public boolean isUnloaded() {
        return this.m_unloaded;
    }

    @Override
    public boolean isProcessingComplete() {
        return this.isPopulated();
    }

    @Override
    public boolean containsSource(SourceFile f) {
        return this.m_source.contains(f.getId());
    }

    public long getId() {
        return this.m_id;
    }

    public String getHost() {
        return this.m_host;
    }

    public int getPort() {
        return this.m_port;
    }

    public int getSwdSize() {
        return this.m_swdSize;
    }

    public int getRefreshCount() {
        return this.m_numRefreshes;
    }

    public boolean isSwdLoading() {
        return this.m_swdLoading;
    }

    public boolean isPopulated() {
        return this.m_populated;
    }

    public byte[] getSwf() {
        return this.m_swf;
    }

    public byte[] getSwd() {
        return this.m_swd;
    }

    public int getSourceExpectedCount() {
        return this.m_scriptsExpected;
    }

    public int getVmVersion() {
        return this.m_vmVersion;
    }

    public int getSourceCount() {
        return this.m_source.size();
    }

    public int getFirstSourceId() {
        return this.m_minId;
    }

    public int getLastSourceId() {
        return this.m_maxId;
    }

    public void setVmVersion(int vmVersion) {
        this.m_vmVersion = vmVersion;
    }

    public void setUnloaded() {
        this.m_unloaded = true;
    }

    public void setSwf(byte[] swf) {
        this.m_swf = swf;
    }

    public void setSwd(byte[] swd) {
        this.m_swd = swd;
    }

    public void setPopulated() {
        this.m_swdLoading = false;
        this.m_populated = true;
    }

    public void setSourceExpectedCount(int c) {
        this.m_scriptsExpected = c;
    }

    public void addSource(int i, DModule m) {
        this.m_source.put(i, (Object)m);
    }

    @Override
    public int getSourceCount(Session s) throws InProgressException {
        if (!this.hasAllSource()) {
            this.swdLoaded(s);
        }
        return this.getSourceCount();
    }

    @Override
    public SourceFile[] getSourceList(Session s) throws InProgressException {
        if (!this.hasAllSource()) {
            this.swdLoaded(s);
        }
        return (SourceFile[])this.m_source.valuesToArray((Object[])new SourceFile[this.m_source.size()]);
    }

    void swdLoaded(Session s) throws InProgressException {
        if (this.isSwdLoading() && !this.isUnloaded()) {
            try {
                ((PlayerSession)s).requestSwfInfo(this.m_index);
            }
            catch (NoResponseException noResponseException) {
                // empty catch block
            }
            if (this.m_swdLoading) {
                if (this.getSourceExpectedCount() > -1 && this.m_numRefreshes > 10) {
                    this.setPopulated();
                } else {
                    throw new InProgressException();
                }
            }
        }
    }

    public boolean hasAllSource() {
        boolean yes = false;
        int expect = this.getSourceExpectedCount();
        int have = this.getSourceCount();
        yes = expect == -1 && this.isSwdLoading() ? false : expect == have;
        return yes;
    }

    public void freshen(long id, String path, String url, String host, long port, boolean swdLoading, long swfSize, long swdSize, long bpCount, long offsetCount, long scriptCount, Map<Long, Integer> map, int minId, int maxId) {
        this.m_id = (int)id;
        this.m_path = path;
        this.m_url = url;
        this.m_host = host;
        this.m_port = (int)port;
        this.m_swfSize = (int)swfSize;
        this.m_swdSize = (int)swdSize;
        this.m_bpCount = (int)bpCount;
        this.m_offsetCount = (int)offsetCount;
        this.m_local2Global = map;
        this.m_minId = swdSize > 0L ? minId : 0;
        this.m_maxId = swdSize > 0L ? maxId : 0;
        this.m_swdLoading = swdLoading;
        ++this.m_numRefreshes;
        if (!swdLoading) {
            this.m_scriptsExpected = (int)scriptCount;
        }
    }

    public ActionLocation locate(int offset) {
        return this.m_container.locationLessOrEqualTo(offset);
    }

    public ActionLocation locateSourceLineEnd(ActionLocation l) {
        return this.locateSourceLineEnd(l, -1);
    }

    public ActionLocation locateSourceLineEnd(ActionLocation l, int stopAt) {
        ActionLocation end = this.m_container.endOfSourceLine(l);
        if (stopAt > -1 && end.at > stopAt) {
            end.at = stopAt;
        }
        return end;
    }

    int local2Global(long id) {
        Integer g = this.m_local2Global.get(id);
        if (g != null) {
            id = g.intValue();
        }
        return (int)id;
    }

    public void parseSwfSwd(DManager manager) {
        this.m_manager = manager;
        this.m_container = new LineFunctionContainer(this.m_swf, this.m_swd);
        this.m_container.combForLineRecords(this);
        this.setPopulated();
        manager.addEvent(new FunctionMetaDataAvailableEvent());
        this.m_manager = null;
    }

    public void processLineRecord(ActionLocation where, LineRecord r) {
        DModule module;
        int line = r.lineno;
        String func = where.function == null ? null : where.function.name;
        DebugModule dm = r.module;
        int id = -1;
        if (dm != null && where.at != -1 && (id = this.local2Global(dm.id)) >= 0 && (module = this.m_manager.getSource(id)) != null) {
            module.addLineFunctionInfo(where.actions.getOffset(where.at), line, func);
        }
    }

    public String toString() {
        return this.m_path;
    }
}

