/*
 * Decompiled with CFR 0.152.
 */
package flash.tools.debugger.concrete;

import flash.tools.debugger.SourceLocator;
import flash.tools.debugger.Value;
import flash.tools.debugger.concrete.DLocation;
import flash.tools.debugger.concrete.DMessage;
import flash.tools.debugger.concrete.DModule;
import flash.tools.debugger.concrete.DProtocol;
import flash.tools.debugger.concrete.DProtocolNotifierIF;
import flash.tools.debugger.concrete.DStackContext;
import flash.tools.debugger.concrete.DSuspendInfo;
import flash.tools.debugger.concrete.DSwfInfo;
import flash.tools.debugger.concrete.DValue;
import flash.tools.debugger.concrete.DVariable;
import flash.tools.debugger.concrete.DWatch;
import flash.tools.debugger.events.BreakEvent;
import flash.tools.debugger.events.ConsoleErrorFault;
import flash.tools.debugger.events.DebugEvent;
import flash.tools.debugger.events.DivideByZeroFault;
import flash.tools.debugger.events.ExceptionFault;
import flash.tools.debugger.events.FaultEvent;
import flash.tools.debugger.events.FileListModifiedEvent;
import flash.tools.debugger.events.InvalidTargetFault;
import flash.tools.debugger.events.InvalidURLFault;
import flash.tools.debugger.events.InvalidWithFault;
import flash.tools.debugger.events.ProtoLimitFault;
import flash.tools.debugger.events.RecursionLimitFault;
import flash.tools.debugger.events.ScriptTimeoutFault;
import flash.tools.debugger.events.StackUnderFlowFault;
import flash.tools.debugger.events.SwfLoadedEvent;
import flash.tools.debugger.events.SwfUnloadedEvent;
import flash.tools.debugger.events.TraceEvent;
import flash.util.Trace;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DManager
implements DProtocolNotifierIF,
SourceLocator {
    private final HashMap<String, String> m_parms;
    private final Map<Integer, DModule> m_source;
    private final ArrayList<DLocation> m_breakpoints;
    private final ArrayList<DSwfInfo> m_swfInfo;
    private final ArrayList<DWatch> m_watchpoints;
    private ArrayList<DStackContext> m_frames;
    private ArrayList<DStackContext> m_previousFrames;
    private Map<Long, DValue> m_values;
    private Map<Long, DValue> m_previousValues;
    private LinkedList<DebugEvent> m_event;
    private DSuspendInfo m_suspendInfo = null;
    private SourceLocator m_sourceLocator = null;
    private DSwfInfo m_lastSwfInfo;
    private DVariable m_lastInGetVariable = null;
    private boolean m_attachChildren = true;
    private DVariable m_lastInCallFunction = null;
    private DVariable m_lastInBinaryOp;
    private boolean m_squelchEnabled = false;
    private int m_playerVersion = -1;
    private boolean m_sourceListModified;
    private byte[] m_actions;
    private String[] m_lastConstantPool = null;
    private String m_uri;
    private byte[] m_swf;
    private byte[] m_swd;
    private boolean m_executingPlayerCode;
    private FaultEvent m_faultEventDuringPlayerCodeExecution;
    private Map<String, String> m_options = new HashMap<String, String>();
    public static final String ARGUMENTS_MARKER = "$arguments";
    public static final String SCOPE_CHAIN_MARKER = "$scopechain";

    public DManager() {
        this.m_parms = new HashMap();
        this.m_source = new HashMap<Integer, DModule>();
        this.m_breakpoints = new ArrayList();
        this.m_values = new HashMap<Long, DValue>();
        this.m_previousValues = new HashMap<Long, DValue>();
        this.m_frames = new ArrayList();
        this.m_previousFrames = new ArrayList();
        this.m_swfInfo = new ArrayList();
        this.m_watchpoints = new ArrayList();
        this.m_event = new LinkedList();
    }

    public String getURI() {
        return this.m_uri;
    }

    public byte[] getSWF() {
        return this.m_swf;
    }

    public byte[] getSWD() {
        return this.m_swd;
    }

    public byte[] getActions() {
        return this.m_actions;
    }

    public int getVersion() {
        return this.m_playerVersion;
    }

    public SourceLocator getSourceLocator() {
        return this.m_sourceLocator;
    }

    public void setSourceLocator(SourceLocator sl) {
        this.m_sourceLocator = sl;
    }

    public void enableChildAttach(boolean enable) {
        this.m_attachChildren = enable;
    }

    public DVariable lastVariable() {
        return this.m_lastInGetVariable;
    }

    public void clearLastVariable() {
        this.m_lastInGetVariable = null;
    }

    public DVariable lastFunctionCall() {
        return this.m_lastInCallFunction;
    }

    public void clearLastFunctionCall() {
        this.m_lastInCallFunction = null;
    }

    public DVariable lastBinaryOp() {
        return this.m_lastInBinaryOp;
    }

    public void clearLastBinaryOp() {
        this.m_lastInBinaryOp = null;
    }

    void freeCaches() {
        this.clearFrames();
        this.freeValueCache();
    }

    void freeValueCache() {
        this.m_previousValues = this.m_values;
        this.m_values = new HashMap<Long, DValue>();
        int size = this.getFrameCount();
        for (int i = 0; i < size; ++i) {
            this.getFrame(i).markStale();
        }
    }

    void continuing() {
        this.freeCaches();
        this.m_suspendInfo = null;
    }

    DValue getOrCreateValue(long id) {
        DValue v = this.getValue(id);
        if (v == null) {
            v = new DValue(id);
            this.putValue(id, v);
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DSwfInfo[] getSwfInfos() {
        ArrayList<DSwfInfo> arrayList = this.m_swfInfo;
        synchronized (arrayList) {
            return this.m_swfInfo.toArray(new DSwfInfo[this.m_swfInfo.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DSwfInfo getSwfInfo(int at) {
        ArrayList<DSwfInfo> arrayList = this.m_swfInfo;
        synchronized (arrayList) {
            return this.m_swfInfo.get(at);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSwfInfoCount() {
        ArrayList<DSwfInfo> arrayList = this.m_swfInfo;
        synchronized (arrayList) {
            return this.m_swfInfo.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DSwfInfo getOrCreateSwfInfo(int at) {
        ArrayList<DSwfInfo> arrayList = this.m_swfInfo;
        synchronized (arrayList) {
            DSwfInfo i;
            DSwfInfo dSwfInfo = i = at > -1 && at < this.getSwfInfoCount() ? this.getSwfInfo(at) : null;
            if (i == null) {
                int n = at = at < 0 ? 0 : at;
                while (at > this.m_swfInfo.size()) {
                    this.m_swfInfo.add(null);
                }
                i = new DSwfInfo(at);
                this.m_swfInfo.add(at, i);
            }
            return i;
        }
    }

    DSwfInfo getActiveSwfInfo() {
        int count = this.getSwfInfoCount();
        DSwfInfo swf = this.m_lastSwfInfo;
        if (swf == null) {
            swf = this.getOrCreateSwfInfo(count - 1);
        }
        if (swf.hasAllSource()) {
            swf = this.getOrCreateSwfInfo(count);
        }
        return swf;
    }

    void tieScriptsToSwf(DSwfInfo info) {
        if (!info.hasAllSource()) {
            int min = info.getFirstSourceId();
            int max = info.getLastSourceId();
            for (int i = min; i <= max; ++i) {
                DModule m = this.getSource(i);
                if (m == null) continue;
                info.addSource(i, m);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean putSource(int swfIndex, int moduleId, int bitmap, String name, String text) {
        Map<Integer, DModule> map = this.m_source;
        synchronized (map) {
            if (!this.m_source.containsKey(moduleId)) {
                DModule s = new DModule(this, moduleId, bitmap, name, text);
                this.m_source.put(moduleId, s);
                DSwfInfo swf = swfIndex == -1 ? this.getActiveSwfInfo() : this.getOrCreateSwfInfo(swfIndex);
                swf.addSource(moduleId, s);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeSource(int id) {
        Map<Integer, DModule> map = this.m_source;
        synchronized (map) {
            try {
                this.m_source.remove(id);
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DModule getSource(int id) {
        Map<Integer, DModule> map = this.m_source;
        synchronized (map) {
            return this.m_source.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DModule[] getSources() {
        Map<Integer, DModule> map = this.m_source;
        synchronized (map) {
            this.m_sourceListModified = false;
            int count = this.m_source.size();
            DModule[] ar = new DModule[count];
            count = 0;
            for (DModule sf : this.m_source.values()) {
                ar[count++] = sf;
            }
            return ar;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean sourceListModified() {
        Map<Integer, DModule> map = this.m_source;
        synchronized (map) {
            return this.m_sourceListModified;
        }
    }

    public DValue getValue(long id) {
        DValue v = this.m_values.get(id);
        return v;
    }

    public DValue getPreviousValue(long id) {
        return this.m_previousValues.get(id);
    }

    void putValue(long id, DValue v) {
        if (id != -1L) {
            this.m_values.put(id, v);
        }
    }

    DValue removeValue(long id) {
        return this.m_values.remove((int)id);
    }

    void addVariableMember(long parentId, DVariable child) {
        DValue parent = this.getValue(parentId);
        this.addVariableMember(parent, child);
    }

    void addVariableMember(DValue parent, DVariable child) {
        if (this.m_attachChildren) {
            DVariable existingChildWithSameName = parent.findMember(child.getName());
            if (existingChildWithSameName != null) {
                int existingScope = existingChildWithSameName.getScope();
                int newScope = child.getScope();
                if (existingScope == 0x2000000 && newScope == 0) {
                    parent.addMember(child);
                } else if (existingScope == 0 && newScope == 0x2000000) {
                    child.makePublic();
                    parent.addMember(child);
                } else if (existingScope != 0x800000 && existingScope == newScope) {
                    parent.addMember(child);
                }
            } else {
                parent.addMember(child);
            }
            DValue childValue = (DValue)child.getValue();
            long childId = childValue.getId();
            if (childId != -1L) {
                DValue existingValue = this.getValue(childId);
                if (existingValue != null) {
                    assert (existingValue == childValue);
                } else {
                    this.putValue(childId, childValue);
                }
            }
        }
    }

    void addVariableMember(long parentId, DVariable child, long doubleAsId) {
        this.addVariableMember(parentId, child);
        if (this.m_attachChildren) {
            this.putValue(doubleAsId, (DValue)child.getValue());
        }
    }

    public String[] getConstantPool() {
        return this.m_lastConstantPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DLocation getBreakpoint(int id) {
        ArrayList<DLocation> arrayList = this.m_breakpoints;
        synchronized (arrayList) {
            DLocation loc = null;
            int which = this.findBreakpoint(id);
            if (which > -1) {
                loc = this.m_breakpoints.get(which);
            }
            return loc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int findBreakpoint(int id) {
        ArrayList<DLocation> arrayList = this.m_breakpoints;
        synchronized (arrayList) {
            int which = -1;
            int size = this.m_breakpoints.size();
            for (int i = 0; which < 0 && i < size; ++i) {
                DLocation l = this.m_breakpoints.get(i);
                if (l.getId() != id) continue;
                which = i;
            }
            return which;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DLocation removeBreakpoint(int id) {
        ArrayList<DLocation> arrayList = this.m_breakpoints;
        synchronized (arrayList) {
            DLocation loc = null;
            int which = this.findBreakpoint(id);
            if (which > -1) {
                loc = this.m_breakpoints.get(which);
                this.m_breakpoints.remove(which);
            }
            return loc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addBreakpoint(int id, DLocation l) {
        ArrayList<DLocation> arrayList = this.m_breakpoints;
        synchronized (arrayList) {
            this.m_breakpoints.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DLocation[] getBreakpoints() {
        ArrayList<DLocation> arrayList = this.m_breakpoints;
        synchronized (arrayList) {
            return this.m_breakpoints.toArray(new DLocation[this.m_breakpoints.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DWatch getWatchpoint(int at) {
        ArrayList<DWatch> arrayList = this.m_watchpoints;
        synchronized (arrayList) {
            return this.m_watchpoints.get(at);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getWatchpointCount() {
        ArrayList<DWatch> arrayList = this.m_watchpoints;
        synchronized (arrayList) {
            return this.m_watchpoints.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DWatch[] getWatchpoints() {
        ArrayList<DWatch> arrayList = this.m_watchpoints;
        synchronized (arrayList) {
            return this.m_watchpoints.toArray(new DWatch[this.m_watchpoints.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean addWatchpoint(DWatch w) {
        ArrayList<DWatch> arrayList = this.m_watchpoints;
        synchronized (arrayList) {
            return this.m_watchpoints.add(w);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DWatch removeWatchpoint(int tag) {
        ArrayList<DWatch> arrayList = this.m_watchpoints;
        synchronized (arrayList) {
            DWatch w = null;
            int at = this.findWatchpoint(tag);
            if (at > -1) {
                w = this.m_watchpoints.remove(at);
            }
            return w;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int findWatchpoint(int tag) {
        ArrayList<DWatch> arrayList = this.m_watchpoints;
        synchronized (arrayList) {
            int at = -1;
            int size = this.getWatchpointCount();
            for (int i = 0; i < size && at < 0; ++i) {
                DWatch w = this.getWatchpoint(i);
                if (w.getTag() != tag) continue;
                at = i;
            }
            return at;
        }
    }

    boolean addFrame(DStackContext ds) {
        this.m_frames.add(ds);
        return true;
    }

    void clearFrames() {
        if (this.m_frames.size() > 0) {
            this.m_previousFrames = this.m_frames;
        }
        this.m_frames = new ArrayList();
    }

    public DStackContext getFrame(int at) {
        return this.m_frames.get(at);
    }

    public int getFrameCount() {
        return this.m_frames.size();
    }

    public DStackContext[] getFrames() {
        return this.m_frames.toArray(new DStackContext[this.m_frames.size()]);
    }

    private boolean stringsEqual(String s1, String s2) {
        if (s1 == null) {
            return s2 == null;
        }
        return s1.equals(s2);
    }

    private void mapOldFramesToNew() {
        int oldSize = this.m_previousFrames.size();
        int newSize = this.m_frames.size();
        DValue[] oldFrames = new DValue[oldSize];
        for (int depth = 0; depth < oldSize; ++depth) {
            oldFrames[depth] = this.m_previousValues.remove(-100L - (long)depth);
        }
        int oldDepth = oldSize - 1;
        for (int newDepth = newSize - 1; oldDepth >= 0 && newDepth >= 0; --oldDepth, --newDepth) {
            DValue frame;
            DStackContext oldFrame = this.m_previousFrames.get(oldDepth);
            DStackContext newFrame = this.m_frames.get(newDepth);
            if (oldFrame == null || newFrame == null || !this.stringsEqual(oldFrame.getCallSignature(), newFrame.getCallSignature()) || (frame = oldFrames[oldDepth]) == null) continue;
            this.m_previousValues.put(-100L - (long)newDepth, frame);
        }
    }

    public boolean isGetSupported() {
        return this.m_squelchEnabled;
    }

    public DSuspendInfo getSuspendInfo() {
        return this.m_suspendInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getEventCount() {
        LinkedList<DebugEvent> linkedList = this.m_event;
        synchronized (linkedList) {
            return this.m_event.size();
        }
    }

    public Object getEventNotifier() {
        return this.m_event;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DebugEvent nextEvent() {
        DebugEvent s = null;
        LinkedList<DebugEvent> linkedList = this.m_event;
        synchronized (linkedList) {
            if (this.m_event.size() > 0) {
                s = this.m_event.removeFirst();
            }
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addEvent(DebugEvent e) {
        LinkedList<DebugEvent> linkedList = this.m_event;
        synchronized (linkedList) {
            this.m_event.add(e);
            this.m_event.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnected() {
        LinkedList<DebugEvent> linkedList = this.m_event;
        synchronized (linkedList) {
            this.m_event.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void messageArrived(DMessage msg, DProtocol which) {
        int type = msg.getType();
        switch (type) {
            case 26: {
                long ver = msg.getDWord();
                this.m_playerVersion = (int)ver;
                int pointerSize = msg.getRemaining() >= 1 ? msg.getByte() : 4;
                DMessage.setSizeofPtr(pointerSize);
                break;
            }
            case 7: {
                this.handleFaultEvent(new RecursionLimitFault());
                break;
            }
            case 8: {
                this.handleFaultEvent(new InvalidWithFault());
                break;
            }
            case 9: {
                this.handleFaultEvent(new ProtoLimitFault());
                break;
            }
            case 24: {
                String url = msg.getString();
                this.handleFaultEvent(new InvalidURLFault(url));
                break;
            }
            case 6: {
                String name = msg.getString();
                this.handleFaultEvent(new InvalidTargetFault(name));
                break;
            }
            case 36: {
                String exceptionMessage;
                long offset = msg.getDWord();
                boolean willExceptionBeCaught = false;
                Value thrown = null;
                if (msg.getRemaining() > 0) {
                    exceptionMessage = msg.getString();
                    if (msg.getRemaining() > 0 && msg.getByte() != 0) {
                        willExceptionBeCaught = msg.getByte() != 0;
                        msg.getPtr();
                        DVariable thrownVar = this.extractVariable(msg);
                        thrown = thrownVar.getValue();
                    }
                } else {
                    exceptionMessage = "";
                }
                this.handleFaultEvent(new ExceptionFault(exceptionMessage, willExceptionBeCaught, thrown));
                break;
            }
            case 37: {
                long offset = msg.getDWord();
                this.handleFaultEvent(new StackUnderFlowFault());
                break;
            }
            case 38: {
                long offset = msg.getDWord();
                this.handleFaultEvent(new DivideByZeroFault());
                break;
            }
            case 39: {
                this.handleFaultEvent(new ScriptTimeoutFault());
                break;
            }
            case 44: {
                String s = msg.getString();
                this.handleFaultEvent(new ConsoleErrorFault(s));
                break;
            }
            case 5: {
                String text = msg.getString();
                this.addEvent(new TraceEvent(text));
                break;
            }
            case 29: {
                long state = msg.getDWord();
                this.m_squelchEnabled = state != 0L;
                break;
            }
            case 12: {
                String name = msg.getString();
                String value = msg.getString();
                this.m_parms.put(name, value);
                if (!name.startsWith("movie")) break;
                this.m_uri = DManager.convertToURI(value);
                break;
            }
            case 13: {
                long objId = msg.getPtr();
                String path = msg.getString();
                break;
            }
            case 1: {
                long objId = msg.getPtr();
                int item = msg.getWord();
                String value = msg.getString();
                break;
            }
            case 3: {
                long objId = msg.getPtr();
                break;
            }
            case 4: {
                long objId = msg.getPtr();
                break;
            }
            case 10: {
                long objId = msg.getPtr();
                String name = msg.getString();
                int dType = msg.getWord();
                int flags = (int)msg.getDWord();
                String value = msg.getString();
                break;
            }
            case 11: {
                long objId = msg.getPtr();
                String name = msg.getString();
                break;
            }
            case 14: {
                int module = (int)msg.getDWord();
                int bitmap = (int)msg.getDWord();
                String name = msg.getString();
                String text = msg.getString();
                int swfIndex = -1;
                if (msg.getRemaining() >= 4) {
                    swfIndex = (int)msg.getDWord();
                }
                Map<Integer, DModule> value = this.m_source;
                synchronized (value) {
                    if (this.putSource(swfIndex, module, bitmap, name, text)) {
                        if (!this.m_sourceListModified) {
                            this.addEvent(new FileListModifiedEvent());
                        }
                        this.m_sourceListModified = true;
                    }
                    break;
                }
            }
            case 21: {
                long module = msg.getDWord();
                Map<Integer, DModule> name = this.m_source;
                synchronized (name) {
                    if (this.removeSource((int)module)) {
                        if (!this.m_sourceListModified) {
                            this.addEvent(new FileListModifiedEvent());
                        }
                        this.m_sourceListModified = true;
                    }
                    break;
                }
            }
            case 15: {
                if (this.m_suspendInfo != null) break;
                this.m_suspendInfo = new DSuspendInfo(7, 0, 0, 0, 0);
                break;
            }
            case 16: {
                long bp = msg.getDWord();
                long id = msg.getPtr();
                String stack = msg.getString();
                int module = DLocation.decodeFile(bp);
                int line = DLocation.decodeLine(bp);
                this.addEvent(new BreakEvent(module, line));
                break;
            }
            case 17: {
                this.continuing();
                break;
            }
            case 18: {
                long objId = msg.getPtr();
                break;
            }
            case 19: {
                long count = msg.getDWord();
                while (count-- > 0L) {
                    long bp = msg.getDWord();
                    int fileId = DLocation.decodeFile(bp);
                    int line = DLocation.decodeLine(bp);
                    DModule file = this.getSource(fileId);
                    DLocation l = new DLocation(file, line);
                    if (file == null) continue;
                    this.addBreakpoint((int)bp, l);
                }
                break;
            }
            case 20: {
                DSwfInfo swf;
                int num = (int)msg.getDWord();
                if (msg.getRemaining() >= 4) {
                    int swfIndex = (int)msg.getDWord();
                    this.m_lastSwfInfo = swf = this.getOrCreateSwfInfo(swfIndex);
                } else {
                    swf = this.getActiveSwfInfo();
                }
                swf.setSourceExpectedCount(num);
                break;
            }
            case 22: {
                long count = msg.getDWord();
                while (count-- > 0L) {
                    long bp = msg.getDWord();
                    this.removeBreakpoint((int)bp);
                }
                break;
            }
            case 27: {
                long bp = msg.getDWord();
                long num = msg.getDWord();
                this.clearFrames();
                int depth = 0;
                while (num-- > 0L) {
                    DModule m;
                    int line;
                    long bpi = msg.getDWord();
                    long id = msg.getPtr();
                    String stack = msg.getString();
                    int module = DLocation.decodeFile(bpi);
                    DStackContext c = new DStackContext(module, line = DLocation.decodeLine(bpi), m = this.getSource(module), id, stack, depth);
                    if (!this.addFrame(c)) continue;
                    ++depth;
                }
                this.mapOldFramesToNew();
                break;
            }
            case 31: {
                DValue frame = null;
                DVariable child = null;
                ArrayList<DVariable> v = new ArrayList<DVariable>();
                ArrayList<DVariable> registers = new ArrayList<DVariable>();
                int depth = (int)msg.getDWord();
                if (depth > -1) {
                    int num = (int)msg.getDWord();
                    for (int i = 0; i < num; ++i) {
                        registers.add(this.extractRegister(msg, i + 1));
                    }
                }
                int currentArg = -1;
                boolean gettingScopeChain = false;
                while (msg.getRemaining() > 0) {
                    long frameId = msg.getPtr();
                    if (frame == null) {
                        frame = this.getOrCreateValue(frameId);
                        this.extractVariable(msg);
                        continue;
                    }
                    child = this.extractVariable(msg);
                    if (currentArg == -1 && child.getName().equals(ARGUMENTS_MARKER)) {
                        currentArg = 0;
                        gettingScopeChain = false;
                    } else if (child.getName().equals(SCOPE_CHAIN_MARKER)) {
                        currentArg = -1;
                        gettingScopeChain = true;
                    } else if (currentArg >= 0) {
                        ++currentArg;
                        if (child.getName().equals("undefined")) {
                            child.setName("_arg" + currentArg);
                        }
                    }
                    if (!gettingScopeChain) {
                        this.addVariableMember(frameId, child);
                    }
                    v.add(child);
                }
                if (depth == 0) {
                    this.populateRootNode(frame, v);
                    break;
                }
                this.populateFrame(depth, v);
                break;
            }
            case 32: {
                String s = msg.getString();
                String v = msg.getString();
                this.m_options.put(s, v);
                break;
            }
            case 30: {
                DValue parent = null;
                DVariable child = null;
                String definingClass = null;
                int level = 0;
                int highestLevelWithMembers = -1;
                ArrayList<String> classes = new ArrayList<String>();
                while (msg.getRemaining() > 0) {
                    String classWithoutDollar;
                    int indexOfClass;
                    long parentId = msg.getPtr();
                    if (parent == null) {
                        String name = msg.getString();
                        this.m_lastInGetVariable = this.extractVariable(msg, name);
                        parent = this.getOrCreateValue(parentId);
                        continue;
                    }
                    child = this.extractVariable(msg);
                    if (this.showMember(child)) {
                        if (child.isAttributeSet(131072)) {
                            if (classes.size() > 0) {
                                child.setDefiningClass(0, (String)classes.get(0));
                                highestLevelWithMembers = Math.max(highestLevelWithMembers, 0);
                            }
                        } else {
                            child.setDefiningClass(level, definingClass);
                            if (definingClass != null) {
                                highestLevelWithMembers = Math.max(highestLevelWithMembers, level);
                            }
                        }
                        this.addVariableMember(parent.getId(), child);
                        continue;
                    }
                    if (!this.isTraits(child)) continue;
                    definingClass = child.getQualifiedName();
                    level = classes.size();
                    if (definingClass.endsWith("$") && (indexOfClass = classes.indexOf(classWithoutDollar = definingClass.substring(0, definingClass.length() - 1))) != -1) {
                        level = indexOfClass;
                        definingClass = classWithoutDollar;
                    }
                    if (level != classes.size()) continue;
                    classes.add(definingClass);
                }
                if (parent == null || parent.getClassHierarchy(true) != null) break;
                parent.setClassHierarchy(classes.toArray(new String[classes.size()]), highestLevelWithMembers + 1);
                break;
            }
            case 33: 
            case 55: {
                int success = msg.getWord();
                int oldFlags = msg.getWord();
                int oldTag = msg.getWord();
                int flags = msg.getWord();
                int tag = msg.getWord();
                long id = type == 55 ? msg.getPtr() : (long)msg.getWord();
                String name = msg.getString();
                if (success == 0) break;
                if (flags == 0) {
                    this.removeWatchpoint(oldTag);
                    break;
                }
                this.removeWatchpoint(oldTag);
                DWatch w = new DWatch(id, name, flags, tag);
                this.addWatchpoint(w);
                break;
            }
            case 34: {
                this.m_swf = msg.getData();
                break;
            }
            case 35: {
                this.m_swd = msg.getData();
                break;
            }
            case 40: {
                int suspendReason = msg.getWord();
                int suspendPlayer = msg.getWord();
                int breakOffset = (int)msg.getDWord();
                int prevBreakOffset = (int)msg.getDWord();
                int nextBreakOffset = (int)msg.getDWord();
                this.m_suspendInfo = new DSuspendInfo(suspendReason, suspendPlayer, breakOffset, prevBreakOffset, nextBreakOffset);
                try {
                    DStackContext c = this.getFrame(0);
                    c.setOffset(breakOffset);
                    c.setSwfIndex(suspendPlayer);
                }
                catch (Exception e) {
                    if (!Trace.error) break;
                    Trace.trace((String)"Oh my god, gag me with a spoon...getFrame(0) call failed");
                    e.printStackTrace();
                }
                break;
            }
            case 41: {
                int item = msg.getWord();
                int rsvd = msg.getWord();
                int at = (int)msg.getDWord();
                int len = (int)msg.getDWord();
                int i = 0;
                byte[] byArray = this.m_actions = len <= 0 ? null : new byte[len];
                while (len-- > 0) {
                    this.m_actions[i++] = (byte)msg.getByte();
                }
                break;
            }
            case 42: {
                int count = msg.getWord();
                for (int i = 0; i < count; ++i) {
                    DSwfInfo info;
                    long index = msg.getDWord();
                    long id = msg.getPtr();
                    this.m_lastSwfInfo = info = this.getOrCreateSwfInfo((int)index);
                    if (id != 0L) {
                        boolean justCreated;
                        boolean debugComing = msg.getByte() != 0;
                        byte vmVersion = (byte)msg.getByte();
                        int rsvd1 = msg.getWord();
                        long swfSize = msg.getDWord();
                        long swdSize = msg.getDWord();
                        long scriptCount = msg.getDWord();
                        long offsetCount = msg.getDWord();
                        long breakpointCount = msg.getDWord();
                        long port = msg.getDWord();
                        String path = msg.getString();
                        String url = msg.getString();
                        String host = msg.getString();
                        long num = msg.getDWord();
                        HashMap<Long, Integer> local2global = new HashMap<Long, Integer>();
                        int minId = Integer.MAX_VALUE;
                        int maxId = Integer.MIN_VALUE;
                        int j = 0;
                        while ((long)j < num) {
                            long local = msg.getPtr();
                            int global = (int)msg.getDWord();
                            local2global.put(local, global);
                            minId = global < minId ? global : minId;
                            maxId = global > maxId ? global : maxId;
                            ++j;
                        }
                        boolean bl = justCreated = info.getSwfSize() == 0;
                        if (vmVersion > 0) {
                            debugComing = false;
                            info.setVmVersion(vmVersion);
                            info.setPopulated();
                        }
                        info.freshen(id, path, url, host, port, debugComing, swfSize, swdSize, breakpointCount, offsetCount, scriptCount, local2global, minId, maxId);
                        this.tieScriptsToSwf(info);
                        if (!justCreated) continue;
                        this.addEvent(new SwfLoadedEvent(id, (int)index, path, url, host, port, swfSize));
                        continue;
                    }
                    boolean alreadyUnloaded = info.isUnloaded();
                    info.setUnloaded();
                    if (alreadyUnloaded) continue;
                    this.addEvent(new SwfUnloadedEvent(info.getId(), info.getPath(), (int)index));
                }
                break;
            }
            case 43: {
                int item = msg.getWord();
                int count = (int)msg.getDWord();
                String[] pool = new String[count];
                for (int i = 0; i < count; ++i) {
                    long id = msg.getPtr();
                    DVariable var = this.extractVariable(msg);
                    pool[i] = var.getValue().getValueAsString();
                }
                this.m_lastConstantPool = pool;
                break;
            }
            case 45: {
                long id = msg.getDWord();
                long count = msg.getDWord();
                DModule m = this.getSource((int)id);
                if (m == null) break;
                int i = 0;
                while ((long)i < count) {
                    int offset = (int)msg.getDWord();
                    int firstLine = (int)msg.getDWord();
                    int lastLine = (int)msg.getDWord();
                    String name = msg.getString();
                    m.addLineFunctionInfo(offset, firstLine, lastLine, name);
                    ++i;
                }
                break;
            }
            case 54: 
            case 57: {
                DValue parent = null;
                DVariable child = null;
                String definingClass = null;
                int level = 0;
                int highestLevelWithMembers = -1;
                ArrayList<String> classes = new ArrayList<String>();
                if (type == 57) {
                    msg.getDWord();
                }
                while (msg.getRemaining() > 0) {
                    String classWithoutDollar;
                    int indexOfClass;
                    long parentId = msg.getPtr();
                    if (parent == null) {
                        String name = msg.getString();
                        DVariable var = this.extractVariable(msg, name);
                        if (type == 54) {
                            this.m_lastInCallFunction = var;
                        } else {
                            this.m_lastInBinaryOp = var;
                        }
                        parent = this.getOrCreateValue(parentId);
                        continue;
                    }
                    child = this.extractVariable(msg);
                    if (this.showMember(child)) {
                        if (child.isAttributeSet(131072)) {
                            if (classes.size() > 0) {
                                child.setDefiningClass(0, (String)classes.get(0));
                                highestLevelWithMembers = Math.max(highestLevelWithMembers, 0);
                            }
                        } else {
                            child.setDefiningClass(level, definingClass);
                            if (definingClass != null) {
                                highestLevelWithMembers = Math.max(highestLevelWithMembers, level);
                            }
                        }
                        this.addVariableMember(parent.getId(), child);
                        continue;
                    }
                    if (!this.isTraits(child)) continue;
                    definingClass = child.getQualifiedName();
                    level = classes.size();
                    if (definingClass.endsWith("$") && (indexOfClass = classes.indexOf(classWithoutDollar = definingClass.substring(0, definingClass.length() - 1))) != -1) {
                        level = indexOfClass;
                        definingClass = classWithoutDollar;
                    }
                    if (level != classes.size()) continue;
                    classes.add(definingClass);
                }
                if (parent == null || parent.getClassHierarchy(true) != null) break;
                parent.setClassHierarchy(classes.toArray(new String[classes.size()]), highestLevelWithMembers + 1);
                break;
            }
        }
    }

    private boolean showMember(DVariable child) {
        return !this.isTraits(child);
    }

    private boolean isTraits(DVariable variable) {
        Value value = variable.getValue();
        return value.getType() == 8 && "traits".equals(value.getTypeName());
    }

    void populateRootNode(DValue frame, ArrayList<DVariable> orderedChildList) {
        this.populateFrame(0, orderedChildList);
        DValue base = this.getOrCreateValue(-100L);
        base.setMembersObtained(true);
    }

    void populateFrame(int depth, ArrayList<DVariable> frameVars) {
        DStackContext context = null;
        boolean inArgs = false;
        int nArgs = -1;
        boolean inScopeChain = false;
        DValue root = this.getOrCreateValue(-100L - (long)depth);
        if (depth < this.getFrameCount()) {
            context = this.getFrame(depth);
        }
        if (context != null) {
            context.removeAllVariables();
        }
        for (DVariable v : frameVars) {
            String name = v.getName();
            v.clearAttribute(32);
            v.clearAttribute(65536);
            if (name.equals("this")) {
                if (context != null) {
                    context.setThis(v);
                }
                v.setAttribute(65536);
                this.addVariableMember(root, v);
                if (depth != 0) continue;
                this.putValue(-3L, (DValue)v.getValue());
                continue;
            }
            if (name.equals("super")) {
                inArgs = false;
                continue;
            }
            if (name.equals(ARGUMENTS_MARKER)) {
                inArgs = true;
                try {
                    nArgs = ((Number)v.getValue().getValueAsObject()).intValue();
                }
                catch (NumberFormatException nfe) {}
                continue;
            }
            if (name.equals(SCOPE_CHAIN_MARKER)) {
                inArgs = false;
                inScopeChain = true;
                continue;
            }
            if (inArgs) {
                v.setAttribute(65536);
                if (context != null) {
                    context.addArgument(v);
                }
                if (nArgs > -1 && --nArgs <= 0) {
                    inArgs = false;
                }
            } else if (inScopeChain) {
                if (context != null) {
                    context.addScopeChainEntry(v);
                }
            } else {
                v.setAttribute(32);
                if (context != null) {
                    context.addLocal(v);
                }
            }
            if (inScopeChain) continue;
            this.addVariableMember(root, v);
        }
    }

    int toAttributes(int pAttr) {
        int attr = pAttr;
        return attr;
    }

    DVariable extractVariable(DMessage msg) {
        DVariable v = this.extractVariable(msg, msg.getString());
        return v;
    }

    DVariable extractVariable(DMessage msg, String name) {
        int oType = msg.getWord();
        int flags = (int)msg.getDWord();
        return this.extractAtom(msg, name, oType, flags);
    }

    DVariable extractRegister(DMessage msg, int number) {
        int oType = msg.getWord();
        return this.extractAtom(msg, "$" + number, oType, 0);
    }

    DVariable extractAtom(DMessage msg, String name, int oType, int flags) {
        int vType = 8;
        Object value = null;
        String typeName = "";
        String className = "";
        boolean isPrimitive = false;
        switch (oType) {
            case 0: {
                String s = msg.getString();
                double dval = Double.NaN;
                try {
                    dval = Double.parseDouble(s);
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
                value = new Double(dval);
                isPrimitive = true;
                break;
            }
            case 1: {
                int bval = msg.getByte();
                value = new Boolean(bval != 0);
                isPrimitive = true;
                break;
            }
            case 2: {
                String s = msg.getString();
                value = s;
                isPrimitive = true;
                break;
            }
            case 3: 
            case 18: {
                long oid = msg.getPtr();
                long cType = oid == -1L ? 0L : msg.getDWord();
                int isFnc = oid == -1L ? 0 : msg.getWord();
                int rsvd = oid == -1L ? 0 : msg.getWord();
                typeName = oid == -1L ? "" : msg.getString();
                className = DVariable.classNameFor(cType, false);
                value = new Long(oid);
                vType = isFnc == 0 ? 3 : 4;
                break;
            }
            case 4: {
                long oid = msg.getPtr();
                long cType = oid == -1L ? 0L : msg.getDWord();
                long rsvd = oid == -1L ? 0L : msg.getDWord();
                typeName = oid == -1L ? "" : msg.getString();
                className = DVariable.classNameFor(cType, true);
                value = new Long(oid);
                vType = 5;
                break;
            }
            case 5: {
                value = null;
                isPrimitive = true;
                break;
            }
            case 6: {
                value = Value.UNDEFINED;
                isPrimitive = true;
                break;
            }
            case 19: {
                vType = 8;
                typeName = "traits";
                break;
            }
        }
        DValue valueObject = null;
        if (value instanceof Long) {
            valueObject = this.getValue((Long)value);
        }
        if (valueObject == null) {
            if (isPrimitive) {
                valueObject = DValue.forPrimitive(value);
                valueObject.setAttributes(this.toAttributes(flags));
            } else {
                valueObject = new DValue(vType, typeName, className, this.toAttributes(flags), value);
            }
            if (value instanceof Long && (this.toAttributes(flags) & 0x80000) == 0) {
                this.putValue((Long)value, valueObject);
            }
        } else {
            if (isPrimitive) {
                DValue temp = DValue.forPrimitive(value);
                vType = temp.getType();
                typeName = temp.getTypeName();
                className = temp.getClassName();
            }
            valueObject.setType(vType);
            valueObject.setTypeName(typeName);
            valueObject.setClassName(className);
            valueObject.setAttributes(this.toAttributes(flags));
            valueObject.setValue(value);
        }
        DVariable var = new DVariable(name, valueObject);
        return var;
    }

    public static String convertToURI(String playerURL) {
        int index = playerURL.indexOf(124);
        StringBuilder sb = new StringBuilder(playerURL);
        while (index > 0) {
            sb.setCharAt(index, ':');
            index = playerURL.indexOf(124, index + 1);
        }
        return sb.toString();
    }

    public void beginPlayerCodeExecution() {
        this.m_executingPlayerCode = true;
        this.m_faultEventDuringPlayerCodeExecution = null;
    }

    public FaultEvent endPlayerCodeExecution() {
        this.m_executingPlayerCode = false;
        FaultEvent e = this.m_faultEventDuringPlayerCodeExecution;
        this.m_faultEventDuringPlayerCodeExecution = null;
        return e;
    }

    private void handleFaultEvent(FaultEvent faultEvent) {
        if (this.m_executingPlayerCode) {
            if (this.m_faultEventDuringPlayerCodeExecution == null) {
                this.m_faultEventDuringPlayerCodeExecution = faultEvent;
            }
        } else {
            this.addEvent(faultEvent);
        }
    }

    @Override
    public InputStream locateSource(String path, String pkg, String name) {
        if (this.m_sourceLocator != null) {
            return this.m_sourceLocator.locateSource(path, pkg, name);
        }
        return null;
    }

    @Override
    public int getChangeCount() {
        if (this.m_sourceLocator != null) {
            return this.m_sourceLocator.getChangeCount();
        }
        return 0;
    }

    public String getOption(String optionName) {
        return this.m_options.get(optionName);
    }
}

