/*
 * Decompiled with CFR 0.152.
 */
package flash.tools.debugger;

import flash.tools.debugger.Bootstrap;
import flash.tools.debugger.IDebuggerCallbacks;
import flash.util.Trace;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DefaultDebuggerCallbacks
implements IDebuggerCallbacks {
    private boolean m_computedExeLocations;
    private File m_httpExe;
    private File m_playerExe;
    private static final String UNIX_DEFAULT_BROWSER = "firefox";
    private static final String UNIX_FLASH_PLAYER = "flashplayer";
    private static final int WINDOWS = 0;
    private static final int MAC = 1;
    private static final int UNIX = 2;
    private static final Pattern registryValuePattern = Pattern.compile("\\sREG_[^ \t]+\\s+(.*)$");

    private static int getOS() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.startsWith("windows")) {
            return 0;
        }
        if (osName.startsWith("mac os x")) {
            return 1;
        }
        return 2;
    }

    public synchronized File getHttpExe() {
        if (!this.m_computedExeLocations) {
            this.recomputeExeLocations();
        }
        return this.m_httpExe;
    }

    public synchronized File getPlayerExe() {
        if (!this.m_computedExeLocations) {
            this.recomputeExeLocations();
        }
        return this.m_playerExe;
    }

    public synchronized void recomputeExeLocations() {
        int os = DefaultDebuggerCallbacks.getOS();
        if (os == 0) {
            this.m_httpExe = this.getDefaultWindowsBrowser();
            this.m_playerExe = this.determineExeForType("ShockwaveFlash.ShockwaveFlash");
        } else if (os == 1) {
            this.m_httpExe = null;
            this.m_playerExe = null;
        } else {
            this.m_httpExe = this.findUnixProgram(UNIX_DEFAULT_BROWSER);
            this.m_playerExe = this.findUnixProgram(UNIX_FLASH_PLAYER);
        }
        this.m_computedExeLocations = true;
    }

    public String getHttpExeName() {
        if (DefaultDebuggerCallbacks.getOS() == 2) {
            return UNIX_DEFAULT_BROWSER;
        }
        return Bootstrap.getLocalizationManager().getLocalizedTextString("webBrowserGenericName");
    }

    public String getPlayerExeName() {
        if (DefaultDebuggerCallbacks.getOS() == 2) {
            return UNIX_FLASH_PLAYER;
        }
        return Bootstrap.getLocalizationManager().getLocalizedTextString("flashPlayerGenericName");
    }

    private File findUnixProgram(String program) {
        String[] cmd = new String[]{"/bin/sh", "-c", "which " + program};
        try {
            File f;
            File f2;
            Process process = Runtime.getRuntime().exec(cmd);
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = reader.readLine();
            if (line != null && (f2 = new File(line)).exists()) {
                return f2;
            }
            String flexHome = System.getProperty("application.home");
            if (flexHome != null && (f = new File(flexHome, "bin/" + program)).exists()) {
                return f;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private File getDefaultWindowsBrowser() {
        try {
            String progid;
            double osVersion;
            String browser = null;
            try {
                osVersion = Double.parseDouble(System.getProperty("os.version"));
            }
            catch (NumberFormatException e) {
                osVersion = 0.0;
            }
            if (osVersion >= 6.0 && (progid = this.queryWindowsRegistry("HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\Shell\\Associations\\UrlAssociations\\http\\UserChoice", "Progid")) != null) {
                browser = this.getClassShellOpenCommand(progid);
            }
            if (browser == null) {
                browser = this.getClassShellOpenCommand("http");
            }
            if (browser != null) {
                browser = this.extractExenameFromCommandString(browser);
                return new File(browser);
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    private String getClassShellOpenCommand(String clazz) throws IOException {
        return this.queryWindowsRegistry("HKEY_CLASSES_ROOT\\" + clazz + "\\shell\\open\\command", null);
    }

    private File determineExeForType(String type) {
        String it = null;
        try {
            String[] cmd = new String[]{"cmd", "/d", "/c", "ftype", type};
            Process p = Runtime.getRuntime().exec(cmd);
            LineNumberReader lnr = new LineNumberReader(new InputStreamReader(p.getInputStream()));
            String line = null;
            type = type + "=";
            while (it == null && (line = lnr.readLine()) != null) {
                if (line.length() >= type.length() && line.substring(0, type.length()).compareToIgnoreCase(type) != 0) continue;
                it = line;
                break;
            }
            p.destroy();
            if (it != null) {
                int equalSign = it.indexOf(61);
                if (equalSign != -1) {
                    it = it.substring(equalSign + 1);
                }
                it = this.extractExenameFromCommandString(it);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (it != null) {
            return new File(it);
        }
        return null;
    }

    protected String extractExenameFromCommandString(String cmd) {
        if (cmd.startsWith("\"")) {
            int closingQuote = cmd.indexOf(34, 1);
            if (closingQuote == -1) {
                closingQuote = cmd.length();
            }
            cmd = cmd.substring(1, closingQuote);
        } else {
            int endOfFilename = -1;
            while (true) {
                int nextSpace;
                if ((nextSpace = cmd.indexOf(32, endOfFilename + 1)) == -1) {
                    endOfFilename = -1;
                    break;
                }
                String filename = cmd.substring(0, nextSpace);
                if (!filename.toLowerCase().endsWith(".exe")) {
                    filename = filename + ".exe";
                }
                if (new File(filename).exists()) {
                    endOfFilename = nextSpace;
                    break;
                }
                endOfFilename = nextSpace;
            }
            if (endOfFilename != -1 && endOfFilename < cmd.length()) {
                cmd = cmd.substring(0, endOfFilename);
            }
        }
        return cmd;
    }

    public Process launchDebugTarget(String[] cmd) throws IOException {
        return Runtime.getRuntime().exec(cmd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String queryWindowsRegistry(String key, String value) throws IOException {
        Process p = null;
        String result = null;
        ArrayList<String> arguments = new ArrayList<String>(6);
        arguments.add("reg.exe");
        arguments.add("query");
        arguments.add(key);
        if (value == null || value.length() == 0) {
            arguments.add("/ve");
        } else {
            arguments.add("/v");
            arguments.add(value);
        }
        p = Runtime.getRuntime().exec(arguments.toArray(new String[arguments.size()]));
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = reader.readLine()) != null) {
                Matcher matcher;
                if (!line.equalsIgnoreCase(key)) continue;
                line = reader.readLine();
                if (line != null && (matcher = registryValuePattern.matcher(line)).find()) {
                    result = matcher.group(1);
                }
                break;
            }
        }
        catch (IOException e) {
            if (Trace.error) {
                e.printStackTrace();
            }
        }
        finally {
            if (p != null) {
                p.destroy();
                p = null;
            }
        }
        return result;
    }

    public int[] getAppVersion(File application) throws IOException {
        return null;
    }
}

