/*
 * Decompiled with CFR 0.152.
 */
package flash.tools.debugger.concrete;

import flash.tools.debugger.concrete.DMessage;
import flash.tools.debugger.concrete.DMessageCache;
import flash.tools.debugger.concrete.DMessageCounter;
import flash.tools.debugger.concrete.DProtocolNotifierIF;
import flash.util.Trace;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.net.SocketException;
import java.util.Vector;

public class DProtocol
implements Runnable {
    public static final int DEBUG_PORT = 7935;
    private final BufferedInputStream m_in;
    private final BufferedOutputStream m_out;
    private final Vector m_listeners;
    private long m_msgRx;
    private long m_msgTx;
    private volatile boolean m_stopRx;
    private volatile Thread m_rxThread;

    public DProtocol(BufferedInputStream in, BufferedOutputStream out) {
        this.m_in = in;
        this.m_out = out;
        this.m_listeners = new Vector();
        this.m_msgRx = 0L;
        this.m_msgTx = 0L;
        this.m_stopRx = false;
        this.m_rxThread = null;
        this.addListener(new DMessageCounter());
    }

    static DProtocol createFromSocket(Socket s) throws IOException {
        s.setTcpNoDelay(true);
        BufferedInputStream in = new BufferedInputStream(s.getInputStream());
        BufferedOutputStream out = new BufferedOutputStream(s.getOutputStream());
        DProtocol dp = new DProtocol(in, out);
        return dp;
    }

    public boolean addListener(DProtocolNotifierIF n) {
        if (this.m_listeners.size() == 0) {
            this.m_listeners.addElement(n);
        } else {
            this.m_listeners.insertElementAt(n, this.m_listeners.size() - 1);
        }
        return true;
    }

    public boolean removeListener(DProtocolNotifierIF n) {
        this.m_listeners.removeElement(n);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long messagesReceived() {
        DProtocol dProtocol = this;
        synchronized (dProtocol) {
            return this.m_msgRx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long messagesSent() {
        DProtocol dProtocol = this;
        synchronized (dProtocol) {
            return this.m_msgTx;
        }
    }

    public void run() {
        block5: {
            try {
                this.m_stopRx = false;
                this.listenForMessages();
            }
            catch (Exception ex) {
                if (!Trace.error || ex instanceof SocketException && ex.getMessage().equalsIgnoreCase("socket closed")) break block5;
                ex.printStackTrace();
            }
        }
        Object[] listeners = this.m_listeners.toArray();
        for (int i = 0; i < listeners.length; ++i) {
            DProtocolNotifierIF elem = (DProtocolNotifierIF)listeners[i];
            try {
                elem.disconnected();
                continue;
            }
            catch (Exception exc) {
                if (!Trace.error) continue;
                exc.printStackTrace();
            }
        }
        this.m_rxThread = null;
    }

    public boolean bind() {
        boolean worked = true;
        if (this.m_rxThread == null) {
            this.getMessageCounter().clearInCounts();
            this.getMessageCounter().clearOutCounts();
            this.m_rxThread = new Thread((Runnable)this, "DJAPI message listener");
            this.m_rxThread.setDaemon(true);
            this.m_rxThread.start();
        } else {
            worked = false;
        }
        return worked;
    }

    public boolean unbind() {
        boolean worked = true;
        if (this.m_rxThread == null) {
            worked = false;
        } else {
            this.m_stopRx = true;
        }
        return worked;
    }

    void listenForMessages() throws IOException {
        DProtocolNotifierIF[] listeners = new DProtocolNotifierIF[]{};
        while (!this.m_stopRx) {
            try {
                DMessage msg = this.rxMessage();
                listeners = this.m_listeners.toArray(listeners);
                for (int i = 0; i < listeners.length; ++i) {
                    block6: {
                        DProtocolNotifierIF elem = listeners[i];
                        try {
                            elem.messageArrived(msg, this);
                        }
                        catch (Exception exc) {
                            if (!Trace.error) break block6;
                            System.err.println("Error in listener parsing incoming message :");
                            System.err.println(msg.inToString(16));
                            exc.printStackTrace();
                        }
                    }
                    msg.reset();
                }
                DMessageCache.free(msg);
            }
            catch (InterruptedIOException interruptedIOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void txMessage(DMessage message) throws IOException {
        int size = message.getSize();
        int command = message.getType();
        this.writeDWord(size);
        this.writeDWord(command);
        this.writeData(message.getData(), size);
        this.m_out.flush();
        DProtocol dProtocol = this;
        synchronized (dProtocol) {
            ++this.m_msgTx;
        }
        this.getMessageCounter().messageSent(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DMessage rxMessage() throws IOException {
        int size = (int)this.readDWord();
        int command = (int)this.readDWord();
        if (size < 0) {
            throw new IOException("socket closed");
        }
        DMessage message = DMessageCache.alloc(size);
        byte[] messageContent = message.getData();
        for (int offset = 0; offset < size; offset += this.m_in.read(messageContent, offset, size - offset)) {
        }
        message.setType(command);
        DProtocol dProtocol = this;
        synchronized (dProtocol) {
            ++this.m_msgRx;
        }
        return message;
    }

    void writeDWord(long dw) throws IOException {
        byte b0 = (byte)(dw & 0xFFL);
        byte b1 = (byte)(dw >> 8 & 0xFFL);
        byte b2 = (byte)(dw >> 16 & 0xFFL);
        byte b3 = (byte)(dw >> 24 & 0xFFL);
        this.m_out.write(b0);
        this.m_out.write(b1);
        this.m_out.write(b2);
        this.m_out.write(b3);
    }

    void writeData(byte[] data, long size) throws IOException {
        if (size > 0L) {
            this.m_out.write(data, 0, (int)size);
        }
    }

    long readDWord() throws IOException {
        int b0 = this.m_in.read();
        int b1 = this.m_in.read();
        int b2 = this.m_in.read();
        int b3 = this.m_in.read();
        long value = b3 << 24 & 0xFF000000 | b2 << 16 & 0xFF0000 | b1 << 8 & 0xFF00 | b0 & 0xFF;
        return value;
    }

    public DMessageCounter getMessageCounter() {
        return (DMessageCounter)this.m_listeners.get(this.m_listeners.size() - 1);
    }
}

