/*
 * Decompiled with CFR 0.152.
 */
package flex.tools.debugger.cli;

import flash.tools.debugger.PlayerDebugException;
import flash.tools.debugger.Session;
import flash.tools.debugger.Value;
import flash.tools.debugger.Variable;
import flash.tools.debugger.events.ExceptionFault;
import flash.tools.debugger.events.FaultEvent;
import flash.tools.debugger.expression.ArithmeticExp;
import flash.tools.debugger.expression.Context;
import flash.tools.debugger.expression.NoSuchVariableException;
import flash.tools.debugger.expression.PlayerFaultException;
import flex.tools.debugger.cli.ExpressionCache;
import flex.tools.debugger.cli.InternalProperty;
import flex.tools.debugger.cli.VariableFacade;
import java.util.StringTokenizer;
import java.util.Vector;

public class ExpressionContext
implements Context {
    ExpressionCache m_cache;
    Object m_current;
    boolean m_createIfMissing;
    Vector m_namedPath;
    boolean m_nameLocked;
    String m_newline = System.getProperty("line.separator");

    public ExpressionContext(ExpressionCache cache) {
        this.m_cache = cache;
        this.m_current = null;
        this.m_createIfMissing = false;
        this.m_namedPath = new Vector();
        this.m_nameLocked = false;
    }

    void setContext(Object o) {
        this.m_current = o;
    }

    Session getSession() {
        return this.m_cache.getSession();
    }

    void pushName(String name) {
        if (this.m_nameLocked || name.length() < 1) {
            return;
        }
        this.m_namedPath.add(name);
    }

    boolean setName(String name) {
        if (this.m_nameLocked) {
            return true;
        }
        this.m_namedPath.clear();
        this.pushName(name);
        return true;
    }

    void lockName() {
        this.m_nameLocked = true;
    }

    public String getName() {
        int size = this.m_namedPath.size();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < size; ++i) {
            String s = (String)this.m_namedPath.get(i);
            if (i > 0) {
                sb.append('.');
            }
            sb.append(s);
        }
        return sb.toString();
    }

    String getCurrentPackageName() {
        String s = null;
        try {
            Integer o = (Integer)this.m_cache.get("$listmodule");
            s = this.m_cache.getPackageName(o);
        }
        catch (NullPointerException npe) {
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return s;
    }

    public void createPseudoVariables(boolean oui) {
        this.m_createIfMissing = oui;
    }

    public Context createContext(Object o) {
        ExpressionContext c = new ExpressionContext(this.m_cache);
        c.setContext(o);
        c.createPseudoVariables(this.m_createIfMissing);
        c.m_namedPath.addAll(this.m_namedPath);
        return c;
    }

    public Object assign(Object o, Object v) throws NoSuchVariableException, PlayerFaultException {
        boolean worked = false;
        try {
            if (o instanceof InternalProperty) {
                worked = this.assignInternal((InternalProperty)o, v);
            } else {
                Variable var = this.resolveToVariable(o);
                if (var == null) {
                    throw new NoSuchVariableException(var == null ? this.m_current : var.getName());
                }
                int type = this.determineType(var, v);
                FaultEvent faultEvent = var.setValue(this.getSession(), type, v.toString());
                if (faultEvent != null) {
                    throw new PlayerFaultException(faultEvent);
                }
                worked = true;
            }
        }
        catch (PlayerDebugException pde) {
            worked = false;
        }
        return new Boolean(worked);
    }

    public Object lookup(Object o) throws NoSuchVariableException, PlayerFaultException {
        Object result = null;
        try {
            Object value;
            if (o instanceof String && ((String)o).charAt(0) == '$') {
                String key = (String)o;
                value = null;
                try {
                    value = this.m_cache.get(key);
                }
                catch (Exception e) {
                    // empty catch block
                }
                result = new InternalProperty(key, value);
            } else {
                result = this.resolveToVariable(o);
                if (result == null && (result = this.resolveToValue(o)) == null) {
                    throw new NoSuchVariableException(o);
                }
            }
            if (result != null && result instanceof VariableFacade) {
                ((VariableFacade)result).setPath(this.getName());
            }
            Value resultValue = null;
            if (result instanceof Variable) {
                resultValue = ((Variable)result).getValue();
            } else if (result instanceof Value) {
                resultValue = (Value)result;
            }
            if (resultValue != null && resultValue.isAttributeSet(262144)) {
                value = resultValue.getValueAsString();
                throw new PlayerFaultException(new ExceptionFault((String)value));
            }
        }
        catch (PlayerDebugException pde) {
            result = null;
        }
        return result;
    }

    public Object lookupMembers(Object o) throws NoSuchVariableException {
        String[] classHierarchy;
        Variable var = null;
        Value val = null;
        Variable[] mems = null;
        try {
            var = this.resolveToVariable(o);
            val = var != null ? var.getValue() : this.resolveToValue(o);
            mems = val.getMembers(this.getSession());
        }
        catch (NullPointerException npe) {
            throw new NoSuchVariableException(o);
        }
        catch (PlayerDebugException pde) {
            throw new NoSuchVariableException(o);
        }
        StringBuffer sb = new StringBuffer();
        if (var != null) {
            ExpressionCache.appendVariable(sb, var);
        } else {
            ExpressionCache.appendVariableValue(sb, val);
        }
        boolean attrs = this.m_cache.propertyEnabled("$displayattributes");
        if (attrs && var != null) {
            ExpressionCache.appendVariableAttributes(sb, var);
        }
        if ((classHierarchy = val.getClassHierarchy(false)) != null && this.getSession().getPreference("$hiervars") != 0) {
            for (int c = 0; c < classHierarchy.length; ++c) {
                String classname = classHierarchy[c];
                sb.append(this.m_newline + "(Members of " + classname + ")");
                for (int i = 0; i < mems.length; ++i) {
                    if (!classname.equals(mems[i].getDefiningClass())) continue;
                    sb.append(this.m_newline + " ");
                    ExpressionCache.appendVariable(sb, mems[i]);
                    if (!attrs) continue;
                    ExpressionCache.appendVariableAttributes(sb, mems[i]);
                }
            }
        } else {
            for (int i = 0; i < mems.length; ++i) {
                sb.append(this.m_newline + " ");
                ExpressionCache.appendVariable(sb, mems[i]);
                if (!attrs) continue;
                ExpressionCache.appendVariableAttributes(sb, mems[i]);
            }
        }
        return sb.toString();
    }

    int determineType(Variable var, Object value) {
        int type = 8;
        type = var instanceof VariableFacade && ((VariableFacade)var).getVariable() == null ? (value instanceof Number ? 0 : (value instanceof Boolean ? 1 : 2)) : var.getValue().getType();
        return type;
    }

    boolean assignInternal(InternalProperty var, Object v) throws NoSuchVariableException, NumberFormatException {
        long l = ArithmeticExp.toLong(v);
        this.m_cache.put(var.getName(), (int)l);
        return true;
    }

    Variable resolveToVariable(Object o) throws PlayerDebugException {
        Variable v = null;
        if (o instanceof Variable) {
            return (Variable)o;
        }
        String name = o.toString();
        long id = this.nameAsId(name);
        if (id == -1L) {
            id = this.determineContext(name);
            v = this.locateForNamed((int)id, name, true);
            if (v != null) {
                v = new VariableFacade(v, id);
            } else if (v == null && this.m_createIfMissing && name.charAt(0) != '$') {
                v = new VariableFacade(id, name);
            }
        }
        return v;
    }

    Value resolveToValue(Object o) throws PlayerDebugException {
        Value v = null;
        if (o instanceof Value) {
            return (Value)o;
        }
        if (o instanceof Variable) {
            return ((Variable)o).getValue();
        }
        String name = o.toString();
        long id = this.nameAsId(name);
        if (id != -1L) {
            v = this.getSession().getValue((int)id);
        }
        return v;
    }

    long nameAsId(String name) {
        long id = -1L;
        try {
            if (name.charAt(0) == '#') {
                id = Long.parseLong(name.substring(1));
            }
        }
        catch (Exception e) {
            id = -1L;
        }
        return id;
    }

    Variable memberNamed(int id, String name) throws NoSuchVariableException, PlayerDebugException {
        Variable v = null;
        Value parent = this.getSession().getValue(id);
        if (parent == null) {
            throw new NoSuchVariableException(name);
        }
        v = parent.getMemberNamed(this.getSession(), name);
        return v;
    }

    int determineContext(String name) throws PlayerDebugException {
        long id = -1L;
        if (this.m_current != null) {
            Object value = this.m_current instanceof Variable ? ((Variable)this.m_current).getValue().getValueAsObject() : (this.m_current instanceof Value ? ((Value)this.m_current).getValueAsObject() : this.m_current);
            id = ArithmeticExp.toLong(value);
        } else if (name != null) {
            int baseId = -100;
            int depth = (Integer)this.m_cache.get("$displayframenumber");
            Variable contextVar = null;
            Value contextVal = null;
            Value val = null;
            val = this.locateParentForNamed(baseId -= depth, name, false);
            if (val != null || (contextVar = this.locateForNamed(baseId, "this", false)) != null && this.setName("this") && (val = this.locateParentForNamed(contextVar.getValue().getId(), name, true)) != null || this.setName("_root") && (val = this.locateParentForNamed(-4, name, true)) != null || this.setName("_global") && (val = this.locateParentForNamed(-2, name, true)) != null || (contextVal = this.locate(-2, this.getCurrentPackageName(), false)) == null || !this.setName("_global." + this.getCurrentPackageName()) || (val = this.locateParentForNamed(contextVal.getId(), name, true)) != null) {
                // empty if block
            }
            if (val != null) {
                id = val.getId();
                this.pushName(name);
                this.lockName();
            }
        }
        return (int)id;
    }

    Value locateParentForNamed(int id, String name, boolean traverseProto) throws PlayerDebugException {
        StringBuffer sb = new StringBuffer();
        Variable var = null;
        Value val = null;
        try {
            var = this.memberNamed(id, name);
            while (var == null && traverseProto) {
                Variable proto = this.memberNamed(id, "__proto__");
                sb.append("__proto__");
                if (proto == null) {
                    traverseProto = false;
                    continue;
                }
                id = proto.getValue().getId();
                var = this.memberNamed(id, name);
                if (var != null) continue;
                sb.append('.');
            }
        }
        catch (NoSuchVariableException nsv) {
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        if (var != null) {
            this.pushName(sb.toString());
            val = this.getSession().getValue(id);
        }
        return val;
    }

    Variable locateForNamed(int id, String name, boolean traverseProto) throws PlayerDebugException {
        Variable var = null;
        Value v = this.locateParentForNamed(id, name, traverseProto);
        if (v != null) {
            try {
                var = this.memberNamed(v.getId(), name);
            }
            catch (NoSuchVariableException nse) {
                v = null;
            }
        }
        return var;
    }

    Value locate(int startingId, String dottedName, boolean traverseProto) throws PlayerDebugException {
        if (dottedName == null) {
            return null;
        }
        StringTokenizer names = new StringTokenizer(dottedName, ".");
        Value val = this.getSession().getValue(startingId);
        while (names.hasMoreTokens() && val != null) {
            val = this.locateForNamed(val.getId(), names.nextToken(), traverseProto).getValue();
        }
        return val;
    }
}

