/*
 * Decompiled with CFR 0.152.
 */
package flash.tools.debugger;

import flash.localization.ILocalizedText;
import flash.localization.ILocalizer;
import flash.localization.ResourceBundleLocalizer;
import java.util.Locale;
import java.util.Map;

public class DebuggerLocalizer
implements ILocalizer {
    private ResourceBundleLocalizer m_resourceBundleLocalizer = new ResourceBundleLocalizer();
    private String m_prefix;
    public static final String m_newline = System.getProperty("line.separator");

    public DebuggerLocalizer(String prefix) {
        this.m_prefix = prefix;
    }

    public ILocalizedText getLocalizedText(Locale locale, final String id) {
        ILocalizedText localizedText = this.m_resourceBundleLocalizer.getLocalizedText(locale, this.m_prefix + id);
        if (localizedText == null && !Locale.getDefault().getLanguage().equals("en")) {
            localizedText = this.m_resourceBundleLocalizer.getLocalizedText(Locale.ENGLISH, this.m_prefix + id);
        }
        if (localizedText == null) {
            localizedText = new ILocalizedText(){

                public String format(Map parameters) {
                    StringBuffer sb = new StringBuffer();
                    sb.append('!');
                    sb.append(id);
                    sb.append('!');
                    if (parameters != null && !parameters.isEmpty()) {
                        sb.append(' ');
                        sb.append(parameters.toString());
                    }
                    return sb.toString();
                }
            };
        }
        if (m_newline.equals("\n")) {
            return localizedText;
        }
        final ILocalizedText finalLocalizedText = localizedText;
        return new ILocalizedText(){

            public String format(Map parameters) {
                String result = finalLocalizedText.format(parameters);
                return result.replaceAll("\n", m_newline);
            }
        };
    }
}

