/*
 * Decompiled with CFR 0.152.
 */
package flex2.tools;

import flash.localization.ILocalizer;
import flash.localization.LocalizationManager;
import flash.localization.ResourceBundleLocalizer;
import flash.swf.Movie;
import flex2.compiler.CompilerAPI;
import flex2.compiler.CompilerException;
import flex2.compiler.CompilerSwcContext;
import flex2.compiler.FileSpec;
import flex2.compiler.ILocalizableMessage;
import flex2.compiler.LicenseException;
import flex2.compiler.ResourceBundlePath;
import flex2.compiler.ResourceContainer;
import flex2.compiler.SourceList;
import flex2.compiler.SourcePath;
import flex2.compiler.SubCompiler;
import flex2.compiler.SymbolTable;
import flex2.compiler.Transcoder;
import flex2.compiler.common.CompilerConfiguration;
import flex2.compiler.common.Configuration;
import flex2.compiler.common.DefaultsConfigurator;
import flex2.compiler.config.ConfigurationBuffer;
import flex2.compiler.config.ConfigurationException;
import flex2.compiler.i18n.I18nUtils;
import flex2.compiler.io.FileUtil;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.swc.SwcAPI;
import flex2.compiler.swc.SwcCache;
import flex2.compiler.swc.SwcException;
import flex2.compiler.util.Benchmark;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.NameMappings;
import flex2.compiler.util.ThreadLocalToolkit;
import flex2.linker.ConsoleApplication;
import flex2.linker.LinkerAPI;
import flex2.linker.LinkerConfiguration;
import flex2.linker.LinkerException;
import flex2.tools.CommandLineConfiguration;
import flex2.tools.Compc;
import flex2.tools.CompcConfiguration;
import flex2.tools.CompcPreLink;
import flex2.tools.Mxmlc;
import flex2.tools.PostLink;
import flex2.tools.PreLink;
import flex2.tools.SwcTarget;
import flex2.tools.Target;
import flex2.tools.Tool;
import flex2.tools.VersionInfo;
import flex2.tools.WebTierAPI;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import macromedia.asc.util.ContextStatics;

public class Fcsh
extends Tool {
    private static int counter;
    private static boolean exit;
    private static Map<String, Target> targets;
    private static Map<String, Process> processes;

    public static void main(String[] args) throws IOException {
        String s;
        exit = false;
        counter = 1;
        targets = new HashMap<String, Target>();
        processes = new HashMap<String, Process>();
        BufferedReader r = new BufferedReader(new InputStreamReader(System.in));
        CompilerAPI.useAS3();
        LocalizationManager localizationManager = new LocalizationManager();
        localizationManager.addLocalizer((ILocalizer)new ResourceBundleLocalizer());
        ThreadLocalToolkit.setLocalizationManager((LocalizationManager)localizationManager);
        Fcsh.intro();
        Fcsh.prompt();
        while ((s = r.readLine()) != null) {
            CompilerAPI.useConsoleLogger();
            if (s.trim().length() == 0) {
                Fcsh.prompt();
                continue;
            }
            try {
                Fcsh.process(s);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            if (exit) break;
            Fcsh.prompt();
        }
    }

    private static void process(String s) {
        block56: {
            LocalizationManager l10n = ThreadLocalToolkit.getLocalizationManager();
            if (s.startsWith("mxmlc")) {
                StringTokenizer t = new StringTokenizer(s.substring("mxmlc".length()).trim(), " ");
                String[] args = new String[t.countTokens()];
                int i = 0;
                while (t.hasMoreTokens()) {
                    args[i] = t.nextToken();
                    ++i;
                }
                if (args.length == 1) {
                    try {
                        int id = Integer.parseInt(args[0]);
                        Target target = targets.get("" + id);
                        if (target == null) {
                            ThreadLocalToolkit.logInfo((String)l10n.getLocalizedTextString((Object)new TargetNotFound("" + id)));
                            break block56;
                        }
                        Fcsh.mxmlc(target.args, id);
                    }
                    catch (NumberFormatException ex) {
                        ThreadLocalToolkit.logInfo((String)l10n.getLocalizedTextString((Object)new AssignTargetID(counter)));
                        Fcsh.mxmlc(args, counter++);
                    }
                } else {
                    ThreadLocalToolkit.logInfo((String)l10n.getLocalizedTextString((Object)new AssignTargetID(counter)));
                    Fcsh.mxmlc(args, counter++);
                }
            } else if (s.startsWith("compc")) {
                StringTokenizer t = new StringTokenizer(s.substring("compc".length()).trim(), " ");
                String[] args = new String[t.countTokens()];
                int i = 0;
                while (t.hasMoreTokens()) {
                    args[i] = t.nextToken();
                    ++i;
                }
                if (args.length == 1) {
                    try {
                        int id = Integer.parseInt(args[0]);
                        Target target = targets.get("" + id);
                        if (target == null) {
                            ThreadLocalToolkit.logInfo((String)l10n.getLocalizedTextString((Object)new TargetNotFound("" + id)));
                            break block56;
                        }
                        Fcsh.compc(target.args, id);
                    }
                    catch (NumberFormatException ex) {
                        ThreadLocalToolkit.logInfo((String)l10n.getLocalizedTextString((Object)new AssignTargetID(counter)));
                        Fcsh.compc(args, counter++);
                    }
                } else {
                    ThreadLocalToolkit.logInfo((String)l10n.getLocalizedTextString((Object)new AssignTargetID(counter)));
                    Fcsh.compc(args, counter++);
                }
            } else if (s.startsWith("compile")) {
                String id = s.substring("compile".length()).trim();
                if (targets.containsKey(id)) {
                    Fcsh.compile(id);
                    if (ThreadLocalToolkit.errorCount() == 0) {
                        Fcsh.link(id);
                    }
                } else {
                    ThreadLocalToolkit.logInfo((String)l10n.getLocalizedTextString((Object)new TargetNotFound(id)));
                }
            } else if (s.startsWith("clear")) {
                String id = s.substring("clear".length()).trim();
                if (id.length() == 0) {
                    HashSet<String> keys = new HashSet<String>(targets.keySet());
                    Iterator<String> i = keys.iterator();
                    while (i.hasNext()) {
                        Fcsh.clear(i.next());
                    }
                } else if (targets.containsKey(id)) {
                    Fcsh.clear(id);
                } else {
                    ThreadLocalToolkit.logInfo((String)l10n.getLocalizedTextString((Object)new TargetNotFound(id)));
                }
            } else if (s.startsWith("info")) {
                String id = s.substring("info".length()).trim();
                if (id.length() == 0) {
                    HashSet<String> keys = new HashSet<String>(targets.keySet());
                    Iterator<String> i = keys.iterator();
                    while (i.hasNext()) {
                        Fcsh.info(i.next());
                    }
                } else if (targets.containsKey(id)) {
                    Fcsh.info(id);
                } else {
                    ThreadLocalToolkit.logInfo((String)l10n.getLocalizedTextString((Object)new TargetNotFound(id)));
                }
            } else if (s.startsWith("touch")) {
                String args = s.substring("touch".length()).trim();
                StringTokenizer stok = new StringTokenizer(args);
                while (stok.hasMoreTokens()) {
                    String f = stok.nextToken();
                    if (!new File(f).canWrite()) {
                        ThreadLocalToolkit.logInfo((String)("touch: cannot write " + f));
                        continue;
                    }
                    new File(f).setLastModified(System.currentTimeMillis());
                }
            } else if (s.startsWith("cp")) {
                String args = s.substring("cp".length()).trim();
                StringTokenizer stok = new StringTokenizer(args);
                if (stok.countTokens() != 2) {
                    ThreadLocalToolkit.logInfo((String)"cp fileFrom fileTo");
                } else {
                    String copyFrom = stok.nextToken();
                    String copyTo = stok.nextToken();
                    try {
                        FileUtil.writeBinaryFile((File)new File(copyTo), (InputStream)FileUtil.openStream((String)copyFrom));
                    }
                    catch (IOException e) {
                        ThreadLocalToolkit.logInfo((String)e.getMessage());
                    }
                }
            } else if (s.startsWith("mv")) {
                String args = s.substring("mv".length()).trim();
                StringTokenizer stok = new StringTokenizer(args);
                if (stok.countTokens() != 2) {
                    ThreadLocalToolkit.logInfo((String)"mv fileFrom fileTo");
                } else {
                    String moveFrom = stok.nextToken();
                    String moveTo = stok.nextToken();
                    new File(moveFrom).renameTo(new File(moveTo));
                }
            } else if (s.startsWith("rm")) {
                String args = s.substring("rm".length()).trim();
                StringTokenizer stok = new StringTokenizer(args);
                if (stok.countTokens() != 1) {
                    ThreadLocalToolkit.logInfo((String)"rm file");
                } else {
                    String rmFile = stok.nextToken();
                    new File(rmFile).delete();
                }
            } else if (s.equals("quit")) {
                HashSet<String> names = new HashSet<String>(targets.keySet());
                Iterator i = names.iterator();
                while (i.hasNext()) {
                    Fcsh.process("clear " + (String)i.next());
                }
                exit = true;
            } else {
                Fcsh.cmdList();
            }
        }
    }

    private static void clear(String target) {
        Process p = processes.remove(target);
        if (p != null) {
            p.destroy();
        }
        targets.remove(target);
    }

    private static void info(String target) {
        Target s = targets.get(target);
        ThreadLocalToolkit.logInfo((String)("id: " + s.id));
        StringBuilder b = new StringBuilder();
        int size = s.args.length;
        for (int i = 0; i < size; ++i) {
            b.append(s.args[i]);
            b.append(' ');
        }
        ThreadLocalToolkit.logInfo((String)((s instanceof SwcTarget ? "compc: " : "mxmlc: ") + b));
    }

    private static void compile(String id) {
        Target s = targets.get(id);
        if (s instanceof SwcTarget) {
            Fcsh.compile_compc((SwcTarget)s);
        } else {
            Fcsh.compile_mxmlc(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void compile_compc(SwcTarget s) {
        block33: {
            LocalizationManager l10n = ThreadLocalToolkit.getLocalizationManager();
            Benchmark benchmark = null;
            try {
                try {
                    CompilerAPI.usePathResolver();
                    ConfigurationBuffer cfgbuf = new ConfigurationBuffer(CompcConfiguration.class, CompcConfiguration.getAliases());
                    cfgbuf.setDefaultVar("include-classes");
                    DefaultsConfigurator.loadCompcDefaults((ConfigurationBuffer)cfgbuf);
                    CompcConfiguration configuration = (CompcConfiguration)Mxmlc.processConfiguration((LocalizationManager)ThreadLocalToolkit.getLocalizationManager(), (String)"compc", (String[])s.args, (ConfigurationBuffer)cfgbuf, CompcConfiguration.class, (String)"include-classes");
                    CompilerAPI.setupHeadless((Configuration)configuration);
                    if (configuration.benchmark()) {
                        benchmark = CompilerAPI.runBenchmark();
                        benchmark.startTime("precompile");
                    } else {
                        CompilerAPI.disableBenchmark();
                    }
                    s.sourcePath.clearCache();
                    s.bundlePath.clearCache();
                    s.resources.refresh();
                    CompilerConfiguration compilerConfig = configuration.getCompilerConfiguration();
                    compilerConfig.setMetadataExport(true);
                    NameMappings mappings = CompilerAPI.getNameMappings((Configuration)configuration);
                    Transcoder[] transcoders = WebTierAPI.getTranscoders((Configuration)configuration);
                    SubCompiler[] compilers = WebTierAPI.getCompilers((CompilerConfiguration)compilerConfig, (NameMappings)mappings, (Transcoder[])transcoders);
                    if (benchmark != null) {
                        benchmark.benchmark(l10n.getLocalizedTextString((Object)new Mxmlc.InitialSetup()));
                    }
                    CompilerSwcContext swcContext = new CompilerSwcContext(true);
                    swcContext.load(compilerConfig.getLibraryPath(), compilerConfig.getExternalLibraryPath(), null, null, mappings, I18nUtils.getTranslationFormat((CompilerConfiguration)compilerConfig), s.swcCache);
                    configuration.addExterns((Collection)swcContext.getExterns());
                    boolean recompile = false;
                    int newChecksum = cfgbuf.checksum_ts() + swcContext.checksum();
                    if (newChecksum != s.checksum) {
                        ThreadLocalToolkit.logInfo((String)l10n.getLocalizedTextString((Object)new DetectConfigurationChange()));
                        s.checksum = newChecksum;
                        s.resources = new ResourceContainer();
                        recompile = true;
                    }
                    if (CompilerAPI.validateCompilationUnits((FileSpec)s.fileSpec, (SourceList)s.sourceList, (SourcePath)s.sourcePath, (ResourceBundlePath)s.bundlePath, (ResourceContainer)s.resources, (CompilerSwcContext)swcContext, (Map)s.classes, (ContextStatics)s.perCompileData, (boolean)recompile, (Configuration)configuration) > 0) {
                        Map licenseMap = configuration.getLicensesConfiguration().getLicenseMap();
                        SymbolTable symbolTable = new SymbolTable(s.perCompileData);
                        s.configuration = configuration;
                        HashMap classes = new HashMap();
                        s.nsComponents = SwcAPI.setupNamespaceComponents((CompcConfiguration)configuration, (NameMappings)mappings, (SourcePath)s.sourcePath, classes);
                        SwcAPI.setupClasses((CompcConfiguration)configuration, (SourcePath)s.sourcePath, classes);
                        s.classes = classes;
                        HashMap rbFiles = new HashMap();
                        if (benchmark != null) {
                            benchmark.stopTime("precompile", false);
                        }
                        List units = CompilerAPI.compile((FileSpec)s.fileSpec, (SourceList)s.sourceList, s.classes.values(), (SourcePath)s.sourcePath, (ResourceContainer)s.resources, (ResourceBundlePath)s.bundlePath, (CompilerSwcContext)swcContext, (SymbolTable)symbolTable, (NameMappings)mappings, (Configuration)configuration, (SubCompiler[])compilers, (flex2.compiler.PreLink)new CompcPreLink(rbFiles, configuration.getIncludeResourceBundles()), (Map)licenseMap, new ArrayList());
                        if (benchmark != null) {
                            benchmark.startTime("postcompile");
                        }
                        s.units = units;
                        s.rbFiles = rbFiles;
                        s.sourcePath.clearCache();
                        s.bundlePath.clearCache();
                        s.resources.refresh();
                    } else {
                        ThreadLocalToolkit.logInfo((String)l10n.getLocalizedTextString((Object)new NoChange()));
                    }
                }
                catch (ConfigurationException ex) {
                    Compc.displayStartMessage();
                    Mxmlc.processConfigurationException((ConfigurationException)ex, (String)"compc");
                    Object var18_23 = null;
                    if (benchmark != null) {
                        if (ThreadLocalToolkit.errorCount() == 0 && benchmark.hasStarted("postcompile")) {
                            benchmark.stopTime("postcompile", false);
                        }
                        benchmark.totalTime();
                        benchmark.peakMemoryUsage(true);
                    }
                    CompilerAPI.removePathResolver();
                    return;
                }
                catch (LicenseException ex) {
                    ThreadLocalToolkit.logError((String)ex.getMessage());
                    Object var18_24 = null;
                    if (benchmark != null) {
                        if (ThreadLocalToolkit.errorCount() == 0 && benchmark.hasStarted("postcompile")) {
                            benchmark.stopTime("postcompile", false);
                        }
                        benchmark.totalTime();
                        benchmark.peakMemoryUsage(true);
                    }
                    CompilerAPI.removePathResolver();
                    return;
                }
                catch (CompilerException ex) {
                    assert (ThreadLocalToolkit.errorCount() > 0);
                    Object var18_25 = null;
                    if (benchmark != null) {
                        if (ThreadLocalToolkit.errorCount() == 0 && benchmark.hasStarted("postcompile")) {
                            benchmark.stopTime("postcompile", false);
                        }
                        benchmark.totalTime();
                        benchmark.peakMemoryUsage(true);
                    }
                    CompilerAPI.removePathResolver();
                    return;
                }
                catch (SwcException ex) {
                    assert (ThreadLocalToolkit.errorCount() > 0);
                    Object var18_26 = null;
                    if (benchmark != null) {
                        if (ThreadLocalToolkit.errorCount() == 0 && benchmark.hasStarted("postcompile")) {
                            benchmark.stopTime("postcompile", false);
                        }
                        benchmark.totalTime();
                        benchmark.peakMemoryUsage(true);
                    }
                    CompilerAPI.removePathResolver();
                    return;
                }
                catch (Throwable t) {
                    ThreadLocalToolkit.logError((String)t.getMessage());
                    t.printStackTrace();
                    Object var18_27 = null;
                    if (benchmark != null) {
                        if (ThreadLocalToolkit.errorCount() == 0 && benchmark.hasStarted("postcompile")) {
                            benchmark.stopTime("postcompile", false);
                        }
                        benchmark.totalTime();
                        benchmark.peakMemoryUsage(true);
                    }
                    CompilerAPI.removePathResolver();
                    return;
                }
                Object var18_22 = null;
                if (benchmark == null) break block33;
            }
            catch (Throwable throwable) {
                Object var18_28 = null;
                if (benchmark != null) {
                    if (ThreadLocalToolkit.errorCount() == 0 && benchmark.hasStarted("postcompile")) {
                        benchmark.stopTime("postcompile", false);
                    }
                    benchmark.totalTime();
                    benchmark.peakMemoryUsage(true);
                }
                CompilerAPI.removePathResolver();
                throw throwable;
            }
            if (ThreadLocalToolkit.errorCount() == 0 && benchmark.hasStarted("postcompile")) {
                benchmark.stopTime("postcompile", false);
            }
            benchmark.totalTime();
            benchmark.peakMemoryUsage(true);
        }
        CompilerAPI.removePathResolver();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void compile_mxmlc(Target s) {
        block33: {
            LocalizationManager l10n = ThreadLocalToolkit.getLocalizationManager();
            Benchmark benchmark = null;
            try {
                try {
                    CompilerAPI.usePathResolver();
                    ConfigurationBuffer cfgbuf = new ConfigurationBuffer(CommandLineConfiguration.class, Configuration.getAliases());
                    cfgbuf.setDefaultVar("file-specs");
                    DefaultsConfigurator.loadDefaults((ConfigurationBuffer)cfgbuf);
                    CommandLineConfiguration configuration = (CommandLineConfiguration)Mxmlc.processConfiguration((LocalizationManager)ThreadLocalToolkit.getLocalizationManager(), (String)"mxmlc", (String[])s.args, (ConfigurationBuffer)cfgbuf, CommandLineConfiguration.class, (String)"file-specs");
                    CompilerAPI.setupHeadless((Configuration)configuration);
                    if (configuration.benchmark()) {
                        benchmark = CompilerAPI.runBenchmark();
                        benchmark.startTime("precompile");
                    } else {
                        CompilerAPI.disableBenchmark();
                    }
                    s.sourcePath.clearCache();
                    s.bundlePath.clearCache();
                    s.resources.refresh();
                    CompilerConfiguration compilerConfig = configuration.getCompilerConfiguration();
                    NameMappings mappings = CompilerAPI.getNameMappings((Configuration)configuration);
                    Transcoder[] transcoders = WebTierAPI.getTranscoders((Configuration)configuration);
                    SubCompiler[] compilers = WebTierAPI.getCompilers((CompilerConfiguration)compilerConfig, (NameMappings)mappings, (Transcoder[])transcoders);
                    if (benchmark != null) {
                        benchmark.benchmark(l10n.getLocalizedTextString((Object)new Mxmlc.InitialSetup()));
                    }
                    CompilerSwcContext swcContext = new CompilerSwcContext(true);
                    swcContext.load(compilerConfig.getLibraryPath(), Configuration.getAllExcludedLibraries((CompilerConfiguration)compilerConfig, (Configuration)configuration), compilerConfig.getThemeFiles(), compilerConfig.getIncludeLibraries(), mappings, I18nUtils.getTranslationFormat((CompilerConfiguration)compilerConfig), s.swcCache);
                    configuration.addExterns((Collection)swcContext.getExterns());
                    configuration.addIncludes((Collection)swcContext.getIncludes());
                    configuration.getCompilerConfiguration().addThemeCssFiles(swcContext.getThemeStyleSheets());
                    boolean recompile = false;
                    int newChecksum = cfgbuf.checksum_ts() + swcContext.checksum();
                    if (newChecksum != s.checksum) {
                        ThreadLocalToolkit.logInfo((String)l10n.getLocalizedTextString((Object)new DetectConfigurationChange()));
                        s.checksum = newChecksum;
                        s.resources = new ResourceContainer();
                        recompile = true;
                    }
                    if (CompilerAPI.validateCompilationUnits((FileSpec)s.fileSpec, (SourceList)s.sourceList, (SourcePath)s.sourcePath, (ResourceBundlePath)s.bundlePath, (ResourceContainer)s.resources, (CompilerSwcContext)swcContext, (ContextStatics)s.perCompileData, (boolean)recompile, (Configuration)configuration) > 0) {
                        Map licenseMap = configuration.getLicensesConfiguration().getLicenseMap();
                        SymbolTable symbolTable = new SymbolTable(s.perCompileData);
                        s.configuration = configuration;
                        VirtualFile projector = configuration.getProjector();
                        if (benchmark != null) {
                            benchmark.stopTime("precompile", false);
                        }
                        s.units = projector != null && projector.getName().endsWith("avmplus.exe") ? CompilerAPI.compile((FileSpec)s.fileSpec, (SourceList)s.sourceList, null, (SourcePath)s.sourcePath, (ResourceContainer)s.resources, (ResourceBundlePath)s.bundlePath, (CompilerSwcContext)swcContext, (SymbolTable)symbolTable, (NameMappings)mappings, (Configuration)configuration, (SubCompiler[])compilers, null, (Map)licenseMap, new ArrayList()) : CompilerAPI.compile((FileSpec)s.fileSpec, (SourceList)s.sourceList, null, (SourcePath)s.sourcePath, (ResourceContainer)s.resources, (ResourceBundlePath)s.bundlePath, (CompilerSwcContext)swcContext, (SymbolTable)symbolTable, (NameMappings)mappings, (Configuration)configuration, (SubCompiler[])compilers, (flex2.compiler.PreLink)new PreLink(), (Map)licenseMap, new ArrayList());
                        if (benchmark != null) {
                            benchmark.startTime("postcompile");
                        }
                        s.sourcePath.clearCache();
                        s.bundlePath.clearCache();
                        s.resources.refresh();
                    } else {
                        ThreadLocalToolkit.logInfo((String)l10n.getLocalizedTextString((Object)new NoChange()));
                    }
                }
                catch (ConfigurationException ex) {
                    Mxmlc.processConfigurationException((ConfigurationException)ex, (String)"mxmlc");
                    Object var16_21 = null;
                    if (benchmark != null) {
                        if (ThreadLocalToolkit.errorCount() == 0 && benchmark.hasStarted("postcompile")) {
                            benchmark.stopTime("postcompile", false);
                        }
                        benchmark.totalTime();
                        benchmark.peakMemoryUsage(true);
                    }
                    CompilerAPI.removePathResolver();
                    return;
                }
                catch (LicenseException ex) {
                    ThreadLocalToolkit.logError((String)ex.getMessage());
                    Object var16_22 = null;
                    if (benchmark != null) {
                        if (ThreadLocalToolkit.errorCount() == 0 && benchmark.hasStarted("postcompile")) {
                            benchmark.stopTime("postcompile", false);
                        }
                        benchmark.totalTime();
                        benchmark.peakMemoryUsage(true);
                    }
                    CompilerAPI.removePathResolver();
                    return;
                }
                catch (CompilerException ex) {
                    assert (ThreadLocalToolkit.errorCount() > 0);
                    Object var16_23 = null;
                    if (benchmark != null) {
                        if (ThreadLocalToolkit.errorCount() == 0 && benchmark.hasStarted("postcompile")) {
                            benchmark.stopTime("postcompile", false);
                        }
                        benchmark.totalTime();
                        benchmark.peakMemoryUsage(true);
                    }
                    CompilerAPI.removePathResolver();
                    return;
                }
                catch (SwcException ex) {
                    assert (ThreadLocalToolkit.errorCount() > 0);
                    Object var16_24 = null;
                    if (benchmark != null) {
                        if (ThreadLocalToolkit.errorCount() == 0 && benchmark.hasStarted("postcompile")) {
                            benchmark.stopTime("postcompile", false);
                        }
                        benchmark.totalTime();
                        benchmark.peakMemoryUsage(true);
                    }
                    CompilerAPI.removePathResolver();
                    return;
                }
                catch (Throwable t) {
                    ThreadLocalToolkit.logError((String)t.getMessage());
                    t.printStackTrace();
                    Object var16_25 = null;
                    if (benchmark != null) {
                        if (ThreadLocalToolkit.errorCount() == 0 && benchmark.hasStarted("postcompile")) {
                            benchmark.stopTime("postcompile", false);
                        }
                        benchmark.totalTime();
                        benchmark.peakMemoryUsage(true);
                    }
                    CompilerAPI.removePathResolver();
                    return;
                }
                Object var16_20 = null;
                if (benchmark == null) break block33;
            }
            catch (Throwable throwable) {
                Object var16_26 = null;
                if (benchmark != null) {
                    if (ThreadLocalToolkit.errorCount() == 0 && benchmark.hasStarted("postcompile")) {
                        benchmark.stopTime("postcompile", false);
                    }
                    benchmark.totalTime();
                    benchmark.peakMemoryUsage(true);
                }
                CompilerAPI.removePathResolver();
                throw throwable;
            }
            if (ThreadLocalToolkit.errorCount() == 0 && benchmark.hasStarted("postcompile")) {
                benchmark.stopTime("postcompile", false);
            }
            benchmark.totalTime();
            benchmark.peakMemoryUsage(true);
        }
        CompilerAPI.removePathResolver();
    }

    private static void link(String target) {
        Target s = targets.get(target);
        if (s instanceof SwcTarget) {
            Fcsh.link_compc((SwcTarget)s);
        } else {
            Fcsh.link_mxmlc(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void link_compc(SwcTarget s) {
        try {
            block10: {
                try {
                    ThreadLocalToolkit.resetBenchmark();
                    CompilerAPI.usePathResolver();
                    if (s.units == null) break block10;
                    SwcAPI.exportSwc((CompcConfiguration)((CompcConfiguration)s.configuration), (List)s.units, (List)s.nsComponents, (SwcCache)s.swcCache, (Map)s.rbFiles);
                    if (s.outputName == null || ThreadLocalToolkit.errorCount() != 0) break block10;
                    File file = new File(s.outputName);
                    s.outputName = FileUtil.getCanonicalPath((File)file);
                    ThreadLocalToolkit.log((ILocalizableMessage)new Mxmlc.OutputMessage(s.outputName, Long.toString(file.length())));
                }
                catch (LinkerException ex) {
                    assert (ThreadLocalToolkit.errorCount() > 0);
                    Object var3_5 = null;
                    Benchmark benchmark = ThreadLocalToolkit.getBenchmark();
                    if (benchmark != null) {
                        benchmark.totalTime();
                        benchmark.peakMemoryUsage(true);
                    }
                    CompilerAPI.removePathResolver();
                    return;
                }
                catch (Throwable t) {
                    ThreadLocalToolkit.logError((String)t.getMessage());
                    t.printStackTrace();
                    Object var3_6 = null;
                    Benchmark benchmark = ThreadLocalToolkit.getBenchmark();
                    if (benchmark != null) {
                        benchmark.totalTime();
                        benchmark.peakMemoryUsage(true);
                    }
                    CompilerAPI.removePathResolver();
                    return;
                }
            }
            Object var3_4 = null;
            Benchmark benchmark = ThreadLocalToolkit.getBenchmark();
            if (benchmark != null) {
                benchmark.totalTime();
                benchmark.peakMemoryUsage(true);
            }
            CompilerAPI.removePathResolver();
            return;
        }
        catch (Throwable throwable) {
            Object var3_7 = null;
            Benchmark benchmark = ThreadLocalToolkit.getBenchmark();
            if (benchmark != null) {
                benchmark.totalTime();
                benchmark.peakMemoryUsage(true);
            }
            CompilerAPI.removePathResolver();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void link_mxmlc(Target s) {
        block24: {
            OutputStream swfOut = null;
            try {
                block23: {
                    ThreadLocalToolkit.resetBenchmark();
                    if (s.units == null) break block23;
                    VirtualFile projector = ((CommandLineConfiguration)s.configuration).getProjector();
                    PostLink postLink = null;
                    if (s.configuration.optimize() && !s.configuration.generateDebugTags()) {
                        postLink = new PostLink((LinkerConfiguration)s.configuration);
                    }
                    if (projector != null && projector.getName().endsWith("avmplus.exe")) {
                        s.app = LinkerAPI.linkConsole((List)s.units, (flex2.linker.PostLink)postLink, (Configuration)s.configuration);
                        File file = FileUtil.openFile((String)s.outputName, (boolean)true);
                        swfOut = new BufferedOutputStream(new FileOutputStream(file));
                        Mxmlc.createProjector((VirtualFile)projector, (ConsoleApplication)s.app, (OutputStream)swfOut);
                        swfOut.flush();
                        swfOut.close();
                        ThreadLocalToolkit.log((ILocalizableMessage)new Mxmlc.OutputMessage(s.outputName, Long.toString(file.length())));
                        break block23;
                    }
                    s.movie = LinkerAPI.link((List)s.units, postLink, (Configuration)s.configuration);
                    File file = FileUtil.openFile((String)s.outputName, (boolean)true);
                    swfOut = new BufferedOutputStream(new FileOutputStream(file));
                    if (projector != null) {
                        Mxmlc.createProjector((VirtualFile)projector, (Movie)s.movie, (OutputStream)swfOut);
                    } else {
                        CompilerAPI.encode((Movie)s.movie, (OutputStream)swfOut);
                    }
                    swfOut.flush();
                    swfOut.close();
                    ThreadLocalToolkit.log((ILocalizableMessage)new Mxmlc.OutputMessage(s.outputName, Long.toString(file.length())));
                }
                Object var6_8 = null;
            }
            catch (Throwable throwable) {
                Object var6_11 = null;
                Benchmark benchmark = ThreadLocalToolkit.getBenchmark();
                if (benchmark != null) {
                    benchmark.totalTime();
                    benchmark.peakMemoryUsage(true);
                }
                if (swfOut != null) {
                    try {
                        swfOut.close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            Benchmark benchmark = ThreadLocalToolkit.getBenchmark();
            if (benchmark != null) {
                benchmark.totalTime();
                benchmark.peakMemoryUsage(true);
            }
            if (swfOut != null) {
                try {
                    swfOut.close();
                }
                catch (IOException ioe) {}
            }
            break block24;
            {
                catch (LinkerException ex) {
                    assert (ThreadLocalToolkit.errorCount() > 0);
                    Object var6_9 = null;
                    benchmark = ThreadLocalToolkit.getBenchmark();
                    if (benchmark != null) {
                        benchmark.totalTime();
                        benchmark.peakMemoryUsage(true);
                    }
                    if (swfOut != null) {
                        try {
                            swfOut.close();
                        }
                        catch (IOException ioe) {}
                    }
                    break block24;
                }
                catch (Throwable t) {
                    ThreadLocalToolkit.logError((String)t.getMessage());
                    t.printStackTrace();
                    Object var6_10 = null;
                    benchmark = ThreadLocalToolkit.getBenchmark();
                    if (benchmark != null) {
                        benchmark.totalTime();
                        benchmark.peakMemoryUsage(true);
                    }
                    if (swfOut != null) {
                        try {
                            swfOut.close();
                        }
                        catch (IOException ioe) {}
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void mxmlc(String[] args, int id) {
        block61: {
            OutputStream swfOut;
            Benchmark benchmark;
            block60: {
                LocalizationManager l10n = ThreadLocalToolkit.getLocalizationManager();
                benchmark = null;
                swfOut = null;
                Target s = new Target();
                s.id = id;
                try {
                    block59: {
                        CompilerAPI.usePathResolver();
                        ConfigurationBuffer cfgbuf = new ConfigurationBuffer(CommandLineConfiguration.class, Configuration.getAliases());
                        cfgbuf.setDefaultVar("file-specs");
                        DefaultsConfigurator.loadDefaults((ConfigurationBuffer)cfgbuf);
                        CommandLineConfiguration configuration = (CommandLineConfiguration)Mxmlc.processConfiguration((LocalizationManager)ThreadLocalToolkit.getLocalizationManager(), (String)"mxmlc", (String[])args, (ConfigurationBuffer)cfgbuf, CommandLineConfiguration.class, (String)"file-specs");
                        s.configuration = configuration;
                        CompilerAPI.setupHeadless((Configuration)configuration);
                        if (configuration.benchmark()) {
                            benchmark = CompilerAPI.runBenchmark();
                            benchmark.startTime("precompile");
                        } else {
                            CompilerAPI.disableBenchmark();
                        }
                        String target = configuration.getTargetFile();
                        targets.put("" + id, s);
                        s.args = args;
                        VirtualFile targetFile = CompilerAPI.getVirtualFile((String)target);
                        WebTierAPI.checkSupportedTargetMimeType((VirtualFile)targetFile);
                        List virtualFileList = CompilerAPI.getVirtualFileList((List)configuration.getFileList());
                        CompilerConfiguration compilerConfig = configuration.getCompilerConfiguration();
                        NameMappings mappings = CompilerAPI.getNameMappings((Configuration)configuration);
                        Transcoder[] transcoders = WebTierAPI.getTranscoders((Configuration)configuration);
                        SubCompiler[] compilers = WebTierAPI.getCompilers((CompilerConfiguration)compilerConfig, (NameMappings)mappings, (Transcoder[])transcoders);
                        VirtualFile projector = configuration.getProjector();
                        if (projector != null && projector.getName().endsWith("avmplus.exe")) {
                            s.outputName = configuration.getOutput();
                            if (s.outputName == null) {
                                s.outputName = targetFile.getName();
                                s.outputName = s.outputName.substring(0, s.outputName.lastIndexOf(46)) + ".exe";
                            }
                        } else {
                            s.outputName = configuration.getOutput();
                            if (s.outputName == null) {
                                s.outputName = targetFile.getName();
                                s.outputName = projector != null ? s.outputName.substring(0, s.outputName.lastIndexOf(46)) + ".exe" : s.outputName.substring(0, s.outputName.lastIndexOf(46)) + ".swf";
                            }
                        }
                        VirtualFile[] asClasspath = compilerConfig.getSourcePath();
                        s.fileSpec = new FileSpec(Collections.emptyList(), WebTierAPI.getFileSpecMimeTypes());
                        s.sourceList = new SourceList(virtualFileList, asClasspath, targetFile, WebTierAPI.getSourcePathMimeTypes());
                        s.sourcePath = new SourcePath(asClasspath, targetFile, WebTierAPI.getSourcePathMimeTypes(), compilerConfig.allowSourcePathOverlap());
                        s.resources = new ResourceContainer();
                        s.bundlePath = new ResourceBundlePath(configuration.getCompilerConfiguration(), targetFile);
                        if (benchmark != null) {
                            benchmark.benchmark(l10n.getLocalizedTextString((Object)new Mxmlc.InitialSetup()));
                        }
                        s.swcCache = new SwcCache();
                        CompilerSwcContext swcContext = new CompilerSwcContext(true);
                        swcContext.load(compilerConfig.getLibraryPath(), Configuration.getAllExcludedLibraries((CompilerConfiguration)compilerConfig, (Configuration)configuration), compilerConfig.getThemeFiles(), compilerConfig.getIncludeLibraries(), mappings, I18nUtils.getTranslationFormat((CompilerConfiguration)compilerConfig), s.swcCache);
                        configuration.addExterns((Collection)swcContext.getExterns());
                        configuration.addIncludes((Collection)swcContext.getIncludes());
                        configuration.getCompilerConfiguration().addThemeCssFiles(swcContext.getThemeStyleSheets());
                        s.checksum = cfgbuf.checksum_ts() + swcContext.checksum();
                        SymbolTable symbolTable = SymbolTable.newSymbolTable((Configuration)configuration);
                        s.perCompileData = symbolTable.perCompileData;
                        Map licenseMap = configuration.getLicensesConfiguration().getLicenseMap();
                        PostLink postLink = null;
                        if (configuration.optimize() && !configuration.generateDebugTags()) {
                            postLink = new PostLink((LinkerConfiguration)configuration);
                        }
                        if (projector != null && projector.getName().endsWith("avmplus.exe")) {
                            if (benchmark != null) {
                                benchmark.stopTime("precompile", false);
                            }
                            List units = CompilerAPI.compile((FileSpec)s.fileSpec, (SourceList)s.sourceList, null, (SourcePath)s.sourcePath, (ResourceContainer)s.resources, (ResourceBundlePath)s.bundlePath, (CompilerSwcContext)swcContext, (SymbolTable)symbolTable, (NameMappings)mappings, (Configuration)configuration, (SubCompiler[])compilers, null, (Map)licenseMap, new ArrayList());
                            if (benchmark != null) {
                                benchmark.startTime("postcompile");
                            }
                            s.units = units;
                            s.sourcePath.clearCache();
                            s.bundlePath.clearCache();
                            s.resources.refresh();
                            s.app = LinkerAPI.linkConsole((List)units, (flex2.linker.PostLink)postLink, (Configuration)configuration);
                            File file = FileUtil.openFile((String)s.outputName, (boolean)true);
                            swfOut = new BufferedOutputStream(new FileOutputStream(file));
                            Mxmlc.createProjector((VirtualFile)projector, (ConsoleApplication)s.app, (OutputStream)swfOut);
                            swfOut.flush();
                            swfOut.close();
                            ThreadLocalToolkit.log((ILocalizableMessage)new Mxmlc.OutputMessage(s.outputName, Long.toString(file.length())));
                            break block59;
                        }
                        if (benchmark != null) {
                            benchmark.stopTime("precompile", false);
                        }
                        List units = CompilerAPI.compile((FileSpec)s.fileSpec, (SourceList)s.sourceList, null, (SourcePath)s.sourcePath, (ResourceContainer)s.resources, (ResourceBundlePath)s.bundlePath, (CompilerSwcContext)swcContext, (SymbolTable)symbolTable, (NameMappings)mappings, (Configuration)configuration, (SubCompiler[])compilers, (flex2.compiler.PreLink)new PreLink(), (Map)licenseMap, new ArrayList());
                        if (benchmark != null) {
                            benchmark.startTime("postcompile");
                        }
                        s.units = units;
                        s.sourcePath.clearCache();
                        s.bundlePath.clearCache();
                        s.resources.refresh();
                        s.movie = LinkerAPI.link((List)units, (flex2.linker.PostLink)postLink, (Configuration)configuration);
                        File file = FileUtil.openFile((String)s.outputName, (boolean)true);
                        swfOut = new BufferedOutputStream(new FileOutputStream(file));
                        if (projector != null) {
                            Mxmlc.createProjector((VirtualFile)projector, (Movie)s.movie, (OutputStream)swfOut);
                        } else {
                            CompilerAPI.encode((Movie)s.movie, (OutputStream)swfOut);
                        }
                        swfOut.flush();
                        swfOut.close();
                        ThreadLocalToolkit.log((ILocalizableMessage)new Mxmlc.OutputMessage(s.outputName, Long.toString(file.length())));
                    }
                    Object var24_31 = null;
                    if (benchmark == null) break block60;
                }
                catch (Throwable throwable) {
                    Object var24_38 = null;
                    if (benchmark != null) {
                        if (ThreadLocalToolkit.errorCount() == 0 && benchmark.hasStarted("postcompile")) {
                            benchmark.stopTime("postcompile", false);
                        }
                        benchmark.totalTime();
                        benchmark.peakMemoryUsage(true);
                    }
                    CompilerAPI.removePathResolver();
                    if (swfOut != null) {
                        try {
                            swfOut.close();
                        }
                        catch (IOException ioe) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                if (ThreadLocalToolkit.errorCount() == 0 && benchmark.hasStarted("postcompile")) {
                    benchmark.stopTime("postcompile", false);
                }
                benchmark.totalTime();
                benchmark.peakMemoryUsage(true);
            }
            CompilerAPI.removePathResolver();
            if (swfOut != null) {
                try {
                    swfOut.close();
                }
                catch (IOException ioe) {}
            }
            break block61;
            {
                catch (ConfigurationException ex) {
                    Mxmlc.processConfigurationException((ConfigurationException)ex, (String)"mxmlc");
                    Object var24_32 = null;
                    if (benchmark != null) {
                        if (ThreadLocalToolkit.errorCount() == 0 && benchmark.hasStarted("postcompile")) {
                            benchmark.stopTime("postcompile", false);
                        }
                        benchmark.totalTime();
                        benchmark.peakMemoryUsage(true);
                    }
                    CompilerAPI.removePathResolver();
                    if (swfOut != null) {
                        try {
                            swfOut.close();
                        }
                        catch (IOException ioe) {}
                    }
                    break block61;
                }
                catch (LicenseException ex) {
                    ThreadLocalToolkit.logError((String)ex.getMessage());
                    Object var24_33 = null;
                    if (benchmark != null) {
                        if (ThreadLocalToolkit.errorCount() == 0 && benchmark.hasStarted("postcompile")) {
                            benchmark.stopTime("postcompile", false);
                        }
                        benchmark.totalTime();
                        benchmark.peakMemoryUsage(true);
                    }
                    CompilerAPI.removePathResolver();
                    if (swfOut != null) {
                        try {
                            swfOut.close();
                        }
                        catch (IOException ioe) {}
                    }
                    break block61;
                }
                catch (CompilerException ex) {
                    assert (ThreadLocalToolkit.errorCount() > 0);
                    Object var24_34 = null;
                    if (benchmark != null) {
                        if (ThreadLocalToolkit.errorCount() == 0 && benchmark.hasStarted("postcompile")) {
                            benchmark.stopTime("postcompile", false);
                        }
                        benchmark.totalTime();
                        benchmark.peakMemoryUsage(true);
                    }
                    CompilerAPI.removePathResolver();
                    if (swfOut != null) {
                        try {
                            swfOut.close();
                        }
                        catch (IOException ioe) {}
                    }
                    break block61;
                }
                catch (LinkerException ex) {
                    assert (ThreadLocalToolkit.errorCount() > 0);
                    Object var24_35 = null;
                    if (benchmark != null) {
                        if (ThreadLocalToolkit.errorCount() == 0 && benchmark.hasStarted("postcompile")) {
                            benchmark.stopTime("postcompile", false);
                        }
                        benchmark.totalTime();
                        benchmark.peakMemoryUsage(true);
                    }
                    CompilerAPI.removePathResolver();
                    if (swfOut != null) {
                        try {
                            swfOut.close();
                        }
                        catch (IOException ioe) {}
                    }
                    break block61;
                }
                catch (SwcException ex) {
                    assert (ThreadLocalToolkit.errorCount() > 0);
                    Object var24_36 = null;
                    if (benchmark != null) {
                        if (ThreadLocalToolkit.errorCount() == 0 && benchmark.hasStarted("postcompile")) {
                            benchmark.stopTime("postcompile", false);
                        }
                        benchmark.totalTime();
                        benchmark.peakMemoryUsage(true);
                    }
                    CompilerAPI.removePathResolver();
                    if (swfOut != null) {
                        try {
                            swfOut.close();
                        }
                        catch (IOException ioe) {}
                    }
                    break block61;
                }
                catch (Throwable thr) {
                    ThreadLocalToolkit.logError((String)thr.getMessage());
                    thr.printStackTrace();
                    Object var24_37 = null;
                    if (benchmark != null) {
                        if (ThreadLocalToolkit.errorCount() == 0 && benchmark.hasStarted("postcompile")) {
                            benchmark.stopTime("postcompile", false);
                        }
                        benchmark.totalTime();
                        benchmark.peakMemoryUsage(true);
                    }
                    CompilerAPI.removePathResolver();
                    if (swfOut != null) {
                        try {
                            swfOut.close();
                        }
                        catch (IOException ioe) {}
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void compc(String[] args, int id) {
        block34: {
            LocalizationManager l10n = ThreadLocalToolkit.getLocalizationManager();
            Benchmark benchmark = null;
            SwcTarget s = new SwcTarget();
            s.id = id;
            try {
                try {
                    File file;
                    CompilerAPI.usePathResolver();
                    ConfigurationBuffer cfgbuf = new ConfigurationBuffer(CompcConfiguration.class, CompcConfiguration.getAliases());
                    cfgbuf.setDefaultVar("include-classes");
                    DefaultsConfigurator.loadCompcDefaults((ConfigurationBuffer)cfgbuf);
                    CompcConfiguration configuration = (CompcConfiguration)Mxmlc.processConfiguration((LocalizationManager)ThreadLocalToolkit.getLocalizationManager(), (String)"compc", (String[])args, (ConfigurationBuffer)cfgbuf, CompcConfiguration.class, (String)"include-classes");
                    s.configuration = configuration;
                    CompilerAPI.setupHeadless((Configuration)configuration);
                    if (configuration.benchmark()) {
                        benchmark = CompilerAPI.runBenchmark();
                        benchmark.startTime("precompile");
                    } else {
                        CompilerAPI.disableBenchmark();
                    }
                    targets.put("" + id, (Target)s);
                    s.args = args;
                    String[] sourceMimeTypes = WebTierAPI.getSourcePathMimeTypes();
                    CompilerConfiguration compilerConfig = configuration.getCompilerConfiguration();
                    s.sourcePath = new SourcePath(sourceMimeTypes, compilerConfig.allowSourcePathOverlap());
                    s.sourcePath.addPathElements(compilerConfig.getSourcePath());
                    List[] array = CompilerAPI.getVirtualFileList((Collection)configuration.getIncludeSources(), configuration.getStylesheets().values(), new HashSet<String>(Arrays.asList(sourceMimeTypes)), (List)s.sourcePath.getPaths());
                    NameMappings mappings = CompilerAPI.getNameMappings((Configuration)configuration);
                    compilerConfig.setMetadataExport(true);
                    Transcoder[] transcoders = WebTierAPI.getTranscoders((Configuration)configuration);
                    SubCompiler[] compilers = WebTierAPI.getCompilers((CompilerConfiguration)compilerConfig, (NameMappings)mappings, (Transcoder[])transcoders);
                    s.outputName = FileUtil.getCanonicalPath((File)FileUtil.openFile((String)configuration.getOutput()));
                    s.fileSpec = new FileSpec(array[0], WebTierAPI.getFileSpecMimeTypes(), false);
                    s.sourceList = new SourceList(array[1], compilerConfig.getSourcePath(), null, WebTierAPI.getSourceListMimeTypes(), false);
                    s.resources = new ResourceContainer();
                    s.bundlePath = new ResourceBundlePath(configuration.getCompilerConfiguration(), null);
                    if (benchmark != null) {
                        benchmark.benchmark(l10n.getLocalizedTextString((Object)new Mxmlc.InitialSetup()));
                    }
                    s.swcCache = new SwcCache();
                    CompilerSwcContext swcContext = new CompilerSwcContext(true);
                    swcContext.load(compilerConfig.getLibraryPath(), compilerConfig.getExternalLibraryPath(), null, null, mappings, I18nUtils.getTranslationFormat((CompilerConfiguration)compilerConfig), s.swcCache);
                    configuration.addExterns((Collection)swcContext.getExterns());
                    s.checksum = cfgbuf.checksum_ts() + swcContext.checksum();
                    SymbolTable symbolTable = SymbolTable.newSymbolTable((Configuration)configuration);
                    s.perCompileData = symbolTable.perCompileData;
                    Map licenseMap = configuration.getLicensesConfiguration().getLicenseMap();
                    s.classes = new HashMap();
                    s.nsComponents = SwcAPI.setupNamespaceComponents((CompcConfiguration)configuration, (NameMappings)mappings, (SourcePath)s.sourcePath, (Map)s.classes);
                    SwcAPI.setupClasses((CompcConfiguration)configuration, (SourcePath)s.sourcePath, (Map)s.classes);
                    HashMap rbFiles = new HashMap();
                    if (benchmark != null) {
                        benchmark.stopTime("precompile", false);
                    }
                    List units = CompilerAPI.compile((FileSpec)s.fileSpec, (SourceList)s.sourceList, s.classes.values(), (SourcePath)s.sourcePath, (ResourceContainer)s.resources, (ResourceBundlePath)s.bundlePath, (CompilerSwcContext)swcContext, (SymbolTable)symbolTable, (NameMappings)mappings, (Configuration)configuration, (SubCompiler[])compilers, (flex2.compiler.PreLink)new CompcPreLink(rbFiles, configuration.getIncludeResourceBundles()), (Map)licenseMap, new ArrayList());
                    if (benchmark != null) {
                        benchmark.startTime("postcompile");
                    }
                    s.units = units;
                    s.rbFiles = rbFiles;
                    s.sourcePath.clearCache();
                    s.bundlePath.clearCache();
                    s.resources.refresh();
                    SwcAPI.exportSwc((CompcConfiguration)configuration, (List)units, (List)s.nsComponents, (SwcCache)s.swcCache, (Map)s.rbFiles);
                    if (s.outputName != null && ThreadLocalToolkit.errorCount() == 0 && (file = FileUtil.openFile((String)s.outputName)) != null && file.exists() && file.isFile()) {
                        s.outputName = FileUtil.getCanonicalPath((File)file);
                        ThreadLocalToolkit.log((ILocalizableMessage)new Mxmlc.OutputMessage(s.outputName, Long.toString(file.length())));
                    }
                }
                catch (ConfigurationException ex) {
                    Compc.displayStartMessage();
                    Mxmlc.processConfigurationException((ConfigurationException)ex, (String)"compc");
                    Object var20_26 = null;
                    if (benchmark != null) {
                        if (ThreadLocalToolkit.errorCount() == 0 && benchmark.hasStarted("postcompile")) {
                            benchmark.stopTime("postcompile", false);
                        }
                        benchmark.totalTime();
                        benchmark.peakMemoryUsage(true);
                    }
                    CompilerAPI.removePathResolver();
                    return;
                }
                catch (LicenseException ex) {
                    ThreadLocalToolkit.logError((String)ex.getMessage());
                    Object var20_27 = null;
                    if (benchmark != null) {
                        if (ThreadLocalToolkit.errorCount() == 0 && benchmark.hasStarted("postcompile")) {
                            benchmark.stopTime("postcompile", false);
                        }
                        benchmark.totalTime();
                        benchmark.peakMemoryUsage(true);
                    }
                    CompilerAPI.removePathResolver();
                    return;
                }
                catch (CompilerException ex) {
                    assert (ThreadLocalToolkit.errorCount() > 0);
                    Object var20_28 = null;
                    if (benchmark != null) {
                        if (ThreadLocalToolkit.errorCount() == 0 && benchmark.hasStarted("postcompile")) {
                            benchmark.stopTime("postcompile", false);
                        }
                        benchmark.totalTime();
                        benchmark.peakMemoryUsage(true);
                    }
                    CompilerAPI.removePathResolver();
                    return;
                }
                catch (LinkerException ex) {
                    assert (ThreadLocalToolkit.errorCount() > 0);
                    Object var20_29 = null;
                    if (benchmark != null) {
                        if (ThreadLocalToolkit.errorCount() == 0 && benchmark.hasStarted("postcompile")) {
                            benchmark.stopTime("postcompile", false);
                        }
                        benchmark.totalTime();
                        benchmark.peakMemoryUsage(true);
                    }
                    CompilerAPI.removePathResolver();
                    return;
                }
                catch (SwcException ex) {
                    assert (ThreadLocalToolkit.errorCount() > 0);
                    Object var20_30 = null;
                    if (benchmark != null) {
                        if (ThreadLocalToolkit.errorCount() == 0 && benchmark.hasStarted("postcompile")) {
                            benchmark.stopTime("postcompile", false);
                        }
                        benchmark.totalTime();
                        benchmark.peakMemoryUsage(true);
                    }
                    CompilerAPI.removePathResolver();
                    return;
                }
                catch (Throwable t) {
                    ThreadLocalToolkit.logError((String)t.getMessage());
                    t.printStackTrace();
                    Object var20_31 = null;
                    if (benchmark != null) {
                        if (ThreadLocalToolkit.errorCount() == 0 && benchmark.hasStarted("postcompile")) {
                            benchmark.stopTime("postcompile", false);
                        }
                        benchmark.totalTime();
                        benchmark.peakMemoryUsage(true);
                    }
                    CompilerAPI.removePathResolver();
                    return;
                }
                Object var20_25 = null;
                if (benchmark == null) break block34;
            }
            catch (Throwable throwable) {
                Object var20_32 = null;
                if (benchmark != null) {
                    if (ThreadLocalToolkit.errorCount() == 0 && benchmark.hasStarted("postcompile")) {
                        benchmark.stopTime("postcompile", false);
                    }
                    benchmark.totalTime();
                    benchmark.peakMemoryUsage(true);
                }
                CompilerAPI.removePathResolver();
                throw throwable;
            }
            if (ThreadLocalToolkit.errorCount() == 0 && benchmark.hasStarted("postcompile")) {
                benchmark.stopTime("postcompile", false);
            }
            benchmark.totalTime();
            benchmark.peakMemoryUsage(true);
        }
        CompilerAPI.removePathResolver();
    }

    private static String getPlayer() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.startsWith("windows")) {
            return "SAFlashPlayer";
        }
        if (osName.startsWith("mac os x")) {
            return "SAFlashPlayer";
        }
        return "flashplayer";
    }

    private static void intro() {
        LocalizationManager l10n = ThreadLocalToolkit.getLocalizationManager();
        System.out.println(l10n.getLocalizedTextString((Object)new ShellMessage("fcsh", VersionInfo.buildMessage())));
    }

    private static void prompt() {
        System.out.print("(fcsh) ");
    }

    private static void cmdList() {
        LocalizationManager l10n = ThreadLocalToolkit.getLocalizationManager();
        System.out.println(l10n.getLocalizedTextString((Object)new CommandList()));
    }

    public static class CommandList
    extends CompilerMessage.CompilerInfo {
        private static final long serialVersionUID = -84561512138741212L;
    }

    public static class ShellMessage
    extends CompilerMessage.CompilerInfo {
        private static final long serialVersionUID = 6261274935205405965L;
        public final String program;
        public final String buildMessage;

        public ShellMessage(String program, String buildMessage) {
            this.program = program;
            this.buildMessage = buildMessage;
        }
    }

    public static class NoChange
    extends CompilerMessage.CompilerInfo {
        private static final long serialVersionUID = -8351736794365308893L;
    }

    public static class DetectConfigurationChange
    extends CompilerMessage.CompilerInfo {
        private static final long serialVersionUID = 1170261585837917433L;
    }

    public static class AssignTargetID
    extends CompilerMessage.CompilerInfo {
        private static final long serialVersionUID = 1870591829772910578L;
        public final int counter;

        public AssignTargetID(int counter) {
            this.counter = counter;
        }
    }

    public static class TargetNotFound
    extends CompilerMessage.CompilerInfo {
        private static final long serialVersionUID = 6927065187698595699L;
        public final String id;

        public TargetNotFound(String id) {
            this.id = id;
        }
    }
}

