/*
 * Decompiled with CFR 0.152.
 */
package flex2.tools;

import flash.localization.ILocalizer;
import flash.localization.LocalizationManager;
import flash.localization.ResourceBundleLocalizer;
import flash.localization.XLRLocalizer;
import flex2.compiler.CompilerAPI;
import flex2.compiler.ILocalizableMessage;
import flex2.compiler.config.CommandLineConfigurator;
import flex2.compiler.config.ConfigurationBuffer;
import flex2.compiler.config.ConfigurationException;
import flex2.compiler.swc.Digest;
import flex2.compiler.swc.Swc;
import flex2.compiler.swc.SwcCache;
import flex2.compiler.swc.SwcException;
import flex2.compiler.swc.SwcGroup;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.ThreadLocalToolkit;
import flex2.tools.DigestConfiguration;
import flex2.tools.DigestRootConfiguration;
import flex2.tools.Mxmlc;
import flex2.tools.Tool;
import flex2.tools.VersionInfo;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;

public class DigestTool
extends Tool {
    private static final String PROGRAM_NAME = "digest";

    public static void main(String[] args) {
        DigestTool.digestTool(args);
        System.exit(ThreadLocalToolkit.errorCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void digestTool(String[] args) {
        ConfigurationBuffer cfgbuf = new ConfigurationBuffer(DigestRootConfiguration.class, DigestConfiguration.getAliases());
        try {
            try {
                block18: {
                    CompilerAPI.usePathResolver();
                    LocalizationManager l10n = new LocalizationManager();
                    l10n.addLocalizer((ILocalizer)new XLRLocalizer());
                    l10n.addLocalizer((ILocalizer)new ResourceBundleLocalizer());
                    ThreadLocalToolkit.setLocalizationManager((LocalizationManager)l10n);
                    CompilerAPI.useConsoleLogger();
                    DigestTool.loadDefaults(cfgbuf);
                    DigestRootConfiguration rootConfiguration = DigestTool.processConfiguration(cfgbuf, args, l10n);
                    DigestConfiguration configuration = rootConfiguration.getDigestConfiguration();
                    SwcCache cache = null;
                    File libraryFile = null;
                    BufferedInputStream libraryInput = null;
                    try {
                        cache = new SwcCache();
                        libraryFile = configuration.getRslFile();
                        libraryInput = new BufferedInputStream(new FileInputStream(libraryFile));
                        String[] paths = new String[]{configuration.getSwcPath()};
                        SwcGroup group = cache.getSwcGroup(paths);
                        long fileLength = libraryFile.length();
                        if (fileLength > Integer.MAX_VALUE) {
                            throw new ConfigurationException.FileTooBig(libraryFile.getAbsolutePath(), "rsl-file", null, 0);
                        }
                        byte[] fileBytes = new byte[(int)fileLength];
                        libraryInput.read(fileBytes);
                        Digest digest = new Digest();
                        digest.computeDigest(fileBytes);
                        digest.setSigned(configuration.getSigned());
                        Swc[] swcs = group.getSwcs().values().toArray(new Swc[1]);
                        if (swcs.length != 1) {
                            throw new IllegalStateException("expecting one swc file, found " + swcs.length);
                        }
                        Swc swc = swcs[0];
                        swc.setDigest(Swc.LIBRARY_SWF, digest);
                        cache.export(swc);
                        if (ThreadLocalToolkit.errorCount() == 0) {
                            ThreadLocalToolkit.log((ILocalizableMessage)new OutputMessage(swc.getLocation()));
                        }
                        Object var17_18 = null;
                        if (libraryInput == null) break block18;
                    }
                    catch (Throwable throwable) {
                        Object var17_19 = null;
                        if (libraryInput == null) throw throwable;
                        libraryInput.close();
                        throw throwable;
                    }
                    libraryInput.close();
                }
                Object var19_21 = null;
            }
            catch (ConfigurationException ex) {
                DigestTool.displayStartMessage();
                Mxmlc.processConfigurationException((ConfigurationException)ex, (String)PROGRAM_NAME);
                Object var19_22 = null;
                if (ThreadLocalToolkit.getBenchmark() != null) {
                    ThreadLocalToolkit.getBenchmark().totalTime();
                    ThreadLocalToolkit.getBenchmark().peakMemoryUsage(true);
                }
                CompilerAPI.removePathResolver();
                return;
            }
            catch (SwcException ex) {
                assert (ThreadLocalToolkit.errorCount() > 0);
                Object var19_23 = null;
                if (ThreadLocalToolkit.getBenchmark() != null) {
                    ThreadLocalToolkit.getBenchmark().totalTime();
                    ThreadLocalToolkit.getBenchmark().peakMemoryUsage(true);
                }
                CompilerAPI.removePathResolver();
                return;
            }
            catch (Throwable t) {
                ThreadLocalToolkit.logError((String)t.getMessage());
                t.printStackTrace();
                Object var19_24 = null;
                if (ThreadLocalToolkit.getBenchmark() != null) {
                    ThreadLocalToolkit.getBenchmark().totalTime();
                    ThreadLocalToolkit.getBenchmark().peakMemoryUsage(true);
                }
                CompilerAPI.removePathResolver();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var19_25 = null;
            if (ThreadLocalToolkit.getBenchmark() != null) {
                ThreadLocalToolkit.getBenchmark().totalTime();
                ThreadLocalToolkit.getBenchmark().peakMemoryUsage(true);
            }
            CompilerAPI.removePathResolver();
            throw throwable;
        }
        if (ThreadLocalToolkit.getBenchmark() != null) {
            ThreadLocalToolkit.getBenchmark().totalTime();
            ThreadLocalToolkit.getBenchmark().peakMemoryUsage(true);
        }
        CompilerAPI.removePathResolver();
    }

    private static void loadDefaults(ConfigurationBuffer cfgbuf) throws ConfigurationException {
        cfgbuf.setVar("digest.rsl-file", "", "defaults", -1);
        cfgbuf.setVar("digest.swc-path", "", "defaults", -1);
        cfgbuf.setVar("digest.signed", "false", "defaults", -1);
    }

    public static void displayStartMessage() {
        LocalizationManager l10n = ThreadLocalToolkit.getLocalizationManager();
        System.out.println(l10n.getLocalizedTextString((Object)new StartMessage(VersionInfo.buildMessage())));
    }

    private static DigestRootConfiguration processConfiguration(ConfigurationBuffer cfgbuf, String[] args, LocalizationManager l10n) throws ConfigurationException {
        String defaultVar = "digest.rsl-file";
        CommandLineConfigurator.parse((ConfigurationBuffer)cfgbuf, (String)defaultVar, (String[])args);
        if (cfgbuf.getVar("version") != null) {
            System.out.println(VersionInfo.buildMessage());
            System.exit(0);
        }
        Mxmlc.processHelp((ConfigurationBuffer)cfgbuf, (String)PROGRAM_NAME, (String)defaultVar, (LocalizationManager)l10n, (String[])args);
        DigestRootConfiguration configuration = new DigestRootConfiguration();
        cfgbuf.commit((Object)configuration);
        return configuration;
    }

    public static class OutputMessage
    extends CompilerMessage.CompilerInfo {
        private static final long serialVersionUID = -5542944826672307954L;
        public String location;

        public OutputMessage(String location) {
            this.location = location;
        }
    }

    public static class StartMessage
    extends CompilerMessage.CompilerInfo {
        private static final long serialVersionUID = -2440824621618753347L;
        public final String buildMessage;

        public StartMessage(String buildMessage) {
            this.buildMessage = buildMessage;
        }
    }
}

