/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Factory;
import org.apache.commons.collections.Predicate;

public class ListUtils {
    public static final List EMPTY_LIST = Collections.EMPTY_LIST;

    public static List intersection(List list1, List list2) {
        ArrayList result = new ArrayList();
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            if (!list1.contains(o)) continue;
            result.add(o);
        }
        return result;
    }

    public static List subtract(List list1, List list2) {
        ArrayList result = new ArrayList(list1);
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            result.remove(iterator.next());
        }
        return result;
    }

    public static List sum(List list1, List list2) {
        return ListUtils.subtract(ListUtils.union(list1, list2), ListUtils.intersection(list1, list2));
    }

    public static List union(List list1, List list2) {
        ArrayList result = new ArrayList(list1);
        result.addAll(list2);
        return result;
    }

    public static List synchronizedList(List list) {
        return Collections.synchronizedList(list);
    }

    public static List unmodifiableList(List list) {
        return Collections.unmodifiableList(list);
    }

    public static List predicatedList(List list, Predicate predicate) {
        return new PredicatedList(list, predicate);
    }

    public static List lazyList(List list, Factory factory) {
        return new LazyList(list, factory);
    }

    public static List fixedSizeList(List list) {
        return new FixedSizeList(list);
    }

    static class LazyList
    extends CollectionUtils.CollectionWrapper
    implements List {
        protected final Factory factory;

        public LazyList(List list, Factory factory) {
            super(list);
            if (factory == null) {
                throw new IllegalArgumentException("Factory must not be null");
            }
            this.factory = factory;
        }

        public Object get(int index) {
            if (index < this.getList().size()) {
                Object obj = this.getList().get(index);
                if (obj == null) {
                    obj = this.factory.create();
                    this.getList().set(index, obj);
                    return obj;
                }
                return obj;
            }
            int i = this.getList().size();
            while (i < index) {
                this.getList().add(null);
                ++i;
            }
            Object obj = this.factory.create();
            this.getList().add(obj);
            return obj;
        }

        public List subList(int fromIndex, int toIndex) {
            return new LazyList(this.getList().subList(fromIndex, toIndex), this.factory);
        }

        public boolean addAll(int i, Collection c) {
            return this.getList().addAll(i, c);
        }

        public Object set(int i, Object o) {
            return this.getList().set(i, o);
        }

        public void add(int i, Object o) {
            this.getList().add(i, o);
        }

        public Object remove(int i) {
            return this.getList().remove(i);
        }

        public int indexOf(Object o) {
            return this.getList().indexOf(o);
        }

        public int lastIndexOf(Object o) {
            return this.getList().lastIndexOf(o);
        }

        public ListIterator listIterator() {
            return this.getList().listIterator();
        }

        public ListIterator listIterator(int i) {
            return this.getList().listIterator(i);
        }

        private List getList() {
            return (List)this.collection;
        }
    }

    static class FixedSizeList
    extends CollectionUtils.UnmodifiableCollection
    implements List {
        public FixedSizeList(List list) {
            super(list);
        }

        public boolean addAll(int i, Collection c) {
            throw new UnsupportedOperationException();
        }

        public Object get(int i) {
            return this.getList().get(i);
        }

        public Object set(int i, Object o) {
            return this.getList().set(i, o);
        }

        public void add(int i, Object o) {
            throw new UnsupportedOperationException();
        }

        public Object remove(int i) {
            throw new UnsupportedOperationException();
        }

        public int indexOf(Object o) {
            return this.getList().indexOf(o);
        }

        public int lastIndexOf(Object o) {
            return this.getList().lastIndexOf(o);
        }

        public ListIterator listIterator() {
            return this.listIterator(0);
        }

        public ListIterator listIterator(int i) {
            return new ListIteratorWrapper(this, this.getList().listIterator(i)){
                private final /* synthetic */ FixedSizeList this$0;
                {
                    this.this$0 = this$0;
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }

                public void add(Object o) {
                    throw new UnsupportedOperationException();
                }

                public void remove(Object o) {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public List subList(int i1, int i2) {
            List sub = this.getList().subList(i1, i2);
            return new FixedSizeList(sub);
        }

        private List getList() {
            return (List)this.collection;
        }
    }

    static class PredicatedList
    extends CollectionUtils.PredicatedCollection
    implements List {
        public PredicatedList(List list, Predicate p) {
            super(list, p);
        }

        public boolean addAll(int i, Collection c) {
            Iterator iter = c.iterator();
            while (iter.hasNext()) {
                this.validate(iter.next());
            }
            return this.getList().addAll(i, c);
        }

        public Object get(int i) {
            return this.getList().get(i);
        }

        public Object set(int i, Object o) {
            this.validate(o);
            return this.getList().set(i, o);
        }

        public void add(int i, Object o) {
            this.validate(o);
            this.getList().add(i, o);
        }

        public Object remove(int i) {
            return this.getList().remove(i);
        }

        public int indexOf(Object o) {
            return this.getList().indexOf(o);
        }

        public int lastIndexOf(Object o) {
            return this.getList().lastIndexOf(o);
        }

        public ListIterator listIterator() {
            return this.listIterator(0);
        }

        public ListIterator listIterator(int i) {
            return new ListIteratorWrapper(this, this.getList().listIterator(i)){
                private final /* synthetic */ PredicatedList this$0;
                {
                    this.this$0 = this$0;
                }

                public void add(Object o) {
                    this.this$0.validate(o);
                    this.iterator.add(o);
                }

                public void set(Object o) {
                    this.this$0.validate(o);
                    this.iterator.set(o);
                }
            };
        }

        public List subList(int i1, int i2) {
            List sub = this.getList().subList(i1, i2);
            return new PredicatedList(sub, this.predicate);
        }

        private List getList() {
            return (List)this.collection;
        }
    }

    static class ListIteratorWrapper
    implements ListIterator {
        protected final ListIterator iterator;

        public ListIteratorWrapper(ListIterator iterator) {
            this.iterator = iterator;
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Object next() {
            return this.iterator.next();
        }

        public boolean hasPrevious() {
            return this.iterator.hasPrevious();
        }

        public Object previous() {
            return this.iterator.previous();
        }

        public int nextIndex() {
            return this.iterator.nextIndex();
        }

        public int previousIndex() {
            return this.iterator.previousIndex();
        }

        public void remove() {
            this.iterator.remove();
        }

        public void set(Object o) {
            this.iterator.set(o);
        }

        public void add(Object o) {
            this.iterator.add(o);
        }
    }
}

