/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.commons.collections.primitives.AbstractLongArrayList;

public class UnsignedIntArrayList
extends AbstractLongArrayList
implements Serializable {
    private transient int[] _data = null;
    private int _size = 0;
    public static final long MAX_VALUE = 0xFFFFFFFFL;
    public static final long MIN_VALUE = 0L;

    public UnsignedIntArrayList() {
        this(8);
    }

    public UnsignedIntArrayList(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("capacity=" + capacity);
        }
        this._data = new int[capacity];
    }

    public int capacity() {
        return this._data.length;
    }

    public int size() {
        return this._size;
    }

    public long getLong(int index) {
        this.checkRange(index);
        return this.toLong(this._data[index]);
    }

    public boolean containsLong(long value) {
        this.assertValidUnsignedInt(value);
        return -1 != this.indexOfLong(value);
    }

    public int indexOfLong(long value) {
        this.assertValidUnsignedInt(value);
        int ivalue = this.fromLong(value);
        int i = 0;
        while (i < this._size) {
            if (ivalue == this._data[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int lastIndexOfLong(long value) {
        this.assertValidUnsignedInt(value);
        int ivalue = this.fromLong(value);
        int i = this._size - 1;
        while (i >= 0) {
            if (ivalue == this._data[i]) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public long setLong(int index, long value) {
        this.assertValidUnsignedInt(value);
        this.checkRange(index);
        long old = this.toLong(this._data[index]);
        this._data[index] = this.fromLong(value);
        return old;
    }

    public boolean addLong(long value) {
        this.assertValidUnsignedInt(value);
        this.ensureCapacity(this._size + 1);
        this._data[this._size++] = this.fromLong(value);
        return true;
    }

    public void addLong(int index, long value) {
        this.assertValidUnsignedInt(value);
        this.checkRangeIncludingEndpoint(index);
        this.ensureCapacity(this._size + 1);
        int numtomove = this._size - index;
        System.arraycopy(this._data, index, this._data, index + 1, numtomove);
        this._data[index] = this.fromLong(value);
        ++this._size;
    }

    public void clear() {
        ++this.modCount;
        this._size = 0;
    }

    public long removeLongAt(int index) {
        this.checkRange(index);
        ++this.modCount;
        long oldval = this.toLong(this._data[index]);
        int numtomove = this._size - index - 1;
        if (numtomove > 0) {
            System.arraycopy(this._data, index + 1, this._data, index, numtomove);
        }
        --this._size;
        return oldval;
    }

    public boolean removeLong(long value) {
        this.assertValidUnsignedInt(value);
        int index = this.indexOfLong(value);
        if (-1 == index) {
            return false;
        }
        this.removeLongAt(index);
        return true;
    }

    public void ensureCapacity(int mincap) {
        ++this.modCount;
        if (mincap > this._data.length) {
            int newcap = this._data.length * 3 / 2 + 1;
            int[] olddata = this._data;
            this._data = new int[newcap < mincap ? mincap : newcap];
            System.arraycopy(olddata, 0, this._data, 0, this._size);
        }
    }

    public void trimToSize() {
        ++this.modCount;
        if (this._size < this._data.length) {
            int[] olddata = this._data;
            this._data = new int[this._size];
            System.arraycopy(olddata, 0, this._data, 0, this._size);
        }
    }

    private final long toLong(int value) {
        return (long)value & 0xFFFFFFFFL;
    }

    private final int fromLong(long value) {
        return (int)(value & 0xFFFFFFFFL);
    }

    private final void assertValidUnsignedInt(long value) throws IllegalArgumentException {
        if (value > 0xFFFFFFFFL) {
            throw new IllegalArgumentException(value + " > " + 0xFFFFFFFFL);
        }
        if (value < 0L) {
            throw new IllegalArgumentException(value + " < " + 0L);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this._data.length);
        int i = 0;
        while (i < this._size) {
            out.writeInt(this._data[i]);
            ++i;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this._data = new int[in.readInt()];
        int i = 0;
        while (i < this._size) {
            this._data[i] = in.readInt();
            ++i;
        }
    }

    private final void checkRange(int index) {
        if (index < 0 || index >= this._size) {
            throw new IndexOutOfBoundsException("Should be at least 0 and less than " + this._size + ", found " + index);
        }
    }

    private final void checkRangeIncludingEndpoint(int index) {
        if (index < 0 || index > this._size) {
            throw new IndexOutOfBoundsException("Should be at least 0 and at most " + this._size + ", found " + index);
        }
    }
}

