/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.iterators;

import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.iterators.ProxyListIterator;

public class FilterListIterator
extends ProxyListIterator {
    private Predicate predicate;
    private Object nextObject;
    private boolean nextObjectSet = false;
    private Object previousObject;
    private boolean previousObjectSet = false;
    private int nextIndex = 0;

    public FilterListIterator() {
    }

    public FilterListIterator(ListIterator iterator) {
        super(iterator);
    }

    public FilterListIterator(ListIterator iterator, Predicate predicate) {
        super(iterator);
        this.predicate = predicate;
    }

    public FilterListIterator(Predicate predicate) {
        this.predicate = predicate;
    }

    public void add(Object o) {
        throw new UnsupportedOperationException("FilterListIterator.add(Object) is not supported.");
    }

    public boolean hasNext() {
        if (this.nextObjectSet) {
            return true;
        }
        return this.setNextObject();
    }

    public boolean hasPrevious() {
        if (this.previousObjectSet) {
            return true;
        }
        return this.setPreviousObject();
    }

    public Object next() {
        if (!this.nextObjectSet && !this.setNextObject()) {
            throw new NoSuchElementException();
        }
        ++this.nextIndex;
        Object temp = this.nextObject;
        this.clearNextObject();
        return temp;
    }

    public int nextIndex() {
        return this.nextIndex;
    }

    public Object previous() {
        if (!this.previousObjectSet && !this.setPreviousObject()) {
            throw new NoSuchElementException();
        }
        --this.nextIndex;
        Object temp = this.previousObject;
        this.clearPreviousObject();
        return temp;
    }

    public int previousIndex() {
        return this.nextIndex - 1;
    }

    public void remove() {
        throw new UnsupportedOperationException("FilterListIterator.remove() is not supported.");
    }

    public void set(Object o) {
        throw new UnsupportedOperationException("FilterListIterator.set(Object) is not supported.");
    }

    public Predicate getPredicate() {
        return this.predicate;
    }

    public void setPredicate(Predicate predicate) {
        this.predicate = predicate;
    }

    private void clearNextObject() {
        this.nextObject = null;
        this.nextObjectSet = false;
    }

    private boolean setNextObject() {
        ListIterator iterator = this.getListIterator();
        Predicate predicate = this.getPredicate();
        if (this.previousObjectSet) {
            this.clearPreviousObject();
            if (!this.setNextObject()) {
                return false;
            }
            this.clearNextObject();
        }
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!predicate.evaluate(object)) continue;
            this.nextObject = object;
            this.nextObjectSet = true;
            return true;
        }
        return false;
    }

    private void clearPreviousObject() {
        this.previousObject = null;
        this.previousObjectSet = false;
    }

    private boolean setPreviousObject() {
        ListIterator iterator = this.getListIterator();
        Predicate predicate = this.getPredicate();
        if (this.nextObjectSet) {
            this.clearNextObject();
            if (!this.setPreviousObject()) {
                return false;
            }
            this.clearPreviousObject();
        }
        while (iterator.hasPrevious()) {
            Object object = iterator.previous();
            if (!predicate.evaluate(object)) continue;
            this.previousObject = object;
            this.previousObjectSet = true;
            return true;
        }
        return false;
    }
}

