/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.transcoder.wmf.tosvg;

import java.io.DataInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Vector;
import org.apache.batik.transcoder.wmf.WMFConstants;
import org.apache.batik.transcoder.wmf.tosvg.GdiObject;
import org.apache.batik.transcoder.wmf.tosvg.MetaRecord;
import org.apache.batik.transcoder.wmf.tosvg.StringRecord;

public class WMFRecordStore
implements WMFConstants {
    private transient URL url;
    protected transient int numRecords;
    protected transient int numObjects;
    public transient int lastObjectIdx;
    protected transient int vpX;
    protected transient int vpY;
    protected transient int vpW;
    protected transient int vpH;
    protected transient Vector records;
    protected transient Vector objectVector;
    protected transient boolean bReading = false;

    public WMFRecordStore() {
        this.reset();
    }

    public void reset() {
        this.numRecords = 0;
        this.vpX = 0;
        this.vpY = 0;
        this.vpW = 1000;
        this.vpH = 1000;
        this.numObjects = 0;
        this.records = new Vector(20, 20);
        this.objectVector = new Vector();
    }

    private short readShort(DataInputStream is) throws IOException {
        byte[] js = new byte[2];
        is.read(js);
        int iTemp = (0xFF & js[1]) << 8;
        short i = (short)(0xFFFF & iTemp);
        i = (short)(i | 0xFF & js[0]);
        return i;
    }

    private int readInt(DataInputStream is) throws IOException {
        byte[] js = new byte[4];
        is.read(js);
        int i = (0xFF & js[3]) << 24;
        i |= (0xFF & js[2]) << 16;
        i |= (0xFF & js[1]) << 8;
        return i |= 0xFF & js[0];
    }

    public boolean read(DataInputStream is) throws IOException {
        this.reset();
        this.setReading(true);
        int dwIsAldus = this.readInt(is);
        if (dwIsAldus != -1698247209) {
            System.out.println("Unable to read file, it is not a Aldus Placable Metafile");
            this.setReading(false);
            return false;
        }
        this.readShort(is);
        this.readShort(is);
        this.readShort(is);
        this.readShort(is);
        this.readShort(is);
        this.readShort(is);
        this.readInt(is);
        this.readShort(is);
        this.readShort(is);
        this.readShort(is);
        this.readShort(is);
        this.readInt(is);
        short mtNoObjects = this.readShort(is);
        this.readInt(is);
        this.readShort(is);
        int functionId = 1;
        int recSize = 0;
        this.numRecords = 0;
        this.numObjects = mtNoObjects;
        this.objectVector.ensureCapacity(this.numObjects);
        for (int i = 0; i < this.numObjects; ++i) {
            this.objectVector.addElement(new GdiObject(i, false));
        }
        while (functionId > 0) {
            recSize = this.readInt(is);
            recSize -= 3;
            functionId = this.readShort(is);
            if (functionId <= 0) break;
            MetaRecord mr = new MetaRecord();
            switch (functionId) {
                case 1583: {
                    for (int i = 0; i < recSize; ++i) {
                        this.readShort(is);
                    }
                    --this.numRecords;
                    break;
                }
                case 2610: {
                    int i;
                    short yVal = this.readShort(is);
                    short xVal = this.readShort(is);
                    int lenText = this.readInt(is);
                    int len = 2 * (recSize - 4);
                    byte[] bstr = new byte[lenText];
                    for (i = 0; i < lenText; ++i) {
                        bstr[i] = is.readByte();
                    }
                    while (i < len) {
                        is.readByte();
                        ++i;
                    }
                    String str = new String(bstr);
                    mr = new StringRecord(str);
                    mr.numPoints = recSize;
                    mr.functionId = functionId;
                    mr.AddElement(new Integer(xVal));
                    mr.AddElement(new Integer(yVal));
                    this.records.addElement(mr);
                    break;
                }
                case 1313: {
                    int len = this.readShort(is);
                    byte[] bstr = new byte[len];
                    for (int i = 0; i < len; ++i) {
                        bstr[i] = is.readByte();
                    }
                    short yVal = this.readShort(is);
                    short xVal = this.readShort(is);
                    String str = new String(bstr);
                    mr = new StringRecord(str);
                    mr.numPoints = recSize;
                    mr.functionId = functionId;
                    mr.AddElement(new Integer(xVal));
                    mr.AddElement(new Integer(yVal));
                    this.records.addElement(mr);
                    break;
                }
                case 763: {
                    int i;
                    short lfHeight = this.readShort(is);
                    this.readShort(is);
                    this.readShort(is);
                    this.readShort(is);
                    short lfWeight = this.readShort(is);
                    byte lfItalic = is.readByte();
                    is.readByte();
                    is.readByte();
                    is.readByte();
                    is.readByte();
                    is.readByte();
                    is.readByte();
                    is.readByte();
                    int len = 2 * (recSize - 9);
                    byte[] lfFaceName = new byte[len];
                    for (i = 0; i < len; ++i) {
                        lfFaceName[i] = is.readByte();
                    }
                    String str = new String(lfFaceName);
                    mr = new StringRecord(str);
                    mr.numPoints = recSize;
                    mr.functionId = functionId;
                    mr.AddElement(new Integer(lfHeight));
                    mr.AddElement(new Integer(lfItalic));
                    mr.AddElement(new Integer(lfWeight));
                    this.records.addElement(mr);
                    break;
                }
                case 523: 
                case 524: {
                    mr.numPoints = recSize;
                    mr.functionId = functionId;
                    short i0 = this.readShort(is);
                    short i1 = this.readShort(is);
                    mr.AddElement(new Integer(i1));
                    mr.AddElement(new Integer(i0));
                    this.records.addElement(mr);
                    if (functionId != 524) break;
                    this.vpW = i0;
                    this.vpH = i1;
                    break;
                }
                case 764: {
                    mr.numPoints = recSize;
                    mr.functionId = functionId;
                    mr.AddElement(new Integer(this.readShort(is)));
                    int colorref = this.readInt(is);
                    int red = colorref & 0xFF;
                    int green = (colorref & 0xFF00) >> 8;
                    int blue = (colorref & 0xFF0000) >> 16;
                    mr.AddElement(new Integer(red));
                    mr.AddElement(new Integer(green));
                    mr.AddElement(new Integer(blue));
                    mr.AddElement(new Integer(this.readShort(is)));
                    this.records.addElement(mr);
                    break;
                }
                case 762: {
                    mr.numPoints = recSize;
                    mr.functionId = functionId;
                    Integer style = new Integer(this.readShort(is));
                    mr.AddElement(style);
                    short width = this.readShort(is);
                    int colorref = this.readInt(is);
                    this.readShort(is);
                    int red = colorref & 0xFF;
                    int green = (colorref & 0xFF00) >> 8;
                    int blue = (colorref & 0xFF0000) >> 16;
                    mr.AddElement(new Integer(red));
                    mr.AddElement(new Integer(green));
                    mr.AddElement(new Integer(blue));
                    mr.AddElement(new Integer(width));
                    this.records.addElement(mr);
                    break;
                }
                case 513: 
                case 521: {
                    mr.numPoints = recSize;
                    mr.functionId = functionId;
                    int colorref = this.readInt(is);
                    int red = colorref & 0xFF;
                    int green = (colorref & 0xFF00) >> 8;
                    int blue = (colorref & 0xFF0000) >> 16;
                    mr.AddElement(new Integer(red));
                    mr.AddElement(new Integer(green));
                    mr.AddElement(new Integer(blue));
                    this.records.addElement(mr);
                    break;
                }
                case 531: 
                case 532: {
                    mr.numPoints = recSize;
                    mr.functionId = functionId;
                    short i0 = this.readShort(is);
                    short i1 = this.readShort(is);
                    mr.AddElement(new Integer(i1));
                    mr.AddElement(new Integer(i0));
                    this.records.addElement(mr);
                    break;
                }
                case 1336: {
                    int i;
                    mr.numPoints = recSize;
                    mr.functionId = functionId;
                    int count = this.readShort(is);
                    int[] pts = new int[count];
                    int ptCount = 0;
                    for (i = 0; i < count; ++i) {
                        pts[i] = this.readShort(is);
                        ptCount += pts[i];
                    }
                    mr.AddElement(new Integer(count));
                    for (i = 0; i < count; ++i) {
                        mr.AddElement(new Integer(pts[i]));
                    }
                    for (i = 0; i < count; ++i) {
                        for (int j = 0; j < pts[i]; ++j) {
                            mr.AddElement(new Integer(this.readShort(is)));
                            mr.AddElement(new Integer(this.readShort(is)));
                        }
                    }
                    this.records.addElement(mr);
                    break;
                }
                case 804: {
                    mr.numPoints = recSize;
                    mr.functionId = functionId;
                    int count = this.readShort(is);
                    mr.AddElement(new Integer(count));
                    for (int i = 0; i < count; ++i) {
                        mr.AddElement(new Integer(this.readShort(is)));
                        mr.AddElement(new Integer(this.readShort(is)));
                    }
                    this.records.addElement(mr);
                    break;
                }
                case 1046: 
                case 1048: 
                case 1051: {
                    mr.numPoints = recSize;
                    mr.functionId = functionId;
                    short i0 = this.readShort(is);
                    short i1 = this.readShort(is);
                    short i2 = this.readShort(is);
                    short i3 = this.readShort(is);
                    mr.AddElement(new Integer(i3));
                    mr.AddElement(new Integer(i2));
                    mr.AddElement(new Integer(i1));
                    mr.AddElement(new Integer(i0));
                    this.records.addElement(mr);
                    break;
                }
                case 1564: {
                    mr.numPoints = recSize;
                    mr.functionId = functionId;
                    short i0 = this.readShort(is);
                    short i1 = this.readShort(is);
                    short i2 = this.readShort(is);
                    short i3 = this.readShort(is);
                    short i4 = this.readShort(is);
                    short i5 = this.readShort(is);
                    mr.AddElement(new Integer(i5));
                    mr.AddElement(new Integer(i4));
                    mr.AddElement(new Integer(i3));
                    mr.AddElement(new Integer(i2));
                    mr.AddElement(new Integer(i1));
                    mr.AddElement(new Integer(i0));
                    this.records.addElement(mr);
                    break;
                }
                case 2071: 
                case 2074: {
                    mr.numPoints = recSize;
                    mr.functionId = functionId;
                    short i0 = this.readShort(is);
                    short i1 = this.readShort(is);
                    short i2 = this.readShort(is);
                    short i3 = this.readShort(is);
                    short i4 = this.readShort(is);
                    short i5 = this.readShort(is);
                    short i6 = this.readShort(is);
                    short i7 = this.readShort(is);
                    mr.AddElement(new Integer(i7));
                    mr.AddElement(new Integer(i6));
                    mr.AddElement(new Integer(i5));
                    mr.AddElement(new Integer(i4));
                    mr.AddElement(new Integer(i3));
                    mr.AddElement(new Integer(i2));
                    mr.AddElement(new Integer(i1));
                    mr.AddElement(new Integer(i0));
                    this.records.addElement(mr);
                    break;
                }
                default: {
                    mr.numPoints = recSize;
                    mr.functionId = functionId;
                    for (int j = 0; j < recSize; ++j) {
                        mr.AddElement(new Integer(this.readShort(is)));
                    }
                    this.records.addElement(mr);
                }
            }
            ++this.numRecords;
        }
        this.setReading(false);
        return true;
    }

    public void addObject(int type, Object obj) {
        int startIdx;
        for (int i = startIdx = 0; i < this.numObjects; ++i) {
            GdiObject gdi = (GdiObject)this.objectVector.elementAt(i);
            if (gdi.used) continue;
            gdi.Setup(type, obj);
            this.lastObjectIdx = i;
            break;
        }
    }

    synchronized void setReading(boolean state) {
        this.bReading = state;
    }

    synchronized boolean isReading() {
        return this.bReading;
    }

    public void addObjectAt(int type, Object obj, int idx) {
        if (idx == 0 || idx > this.numObjects) {
            this.addObject(type, obj);
            return;
        }
        this.lastObjectIdx = idx;
        for (int i = 0; i < this.numObjects; ++i) {
            GdiObject gdi = (GdiObject)this.objectVector.elementAt(i);
            if (i != idx) continue;
            gdi.Setup(type, obj);
            break;
        }
    }

    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL newUrl) {
        this.url = newUrl;
    }

    public GdiObject getObject(int idx) {
        return (GdiObject)this.objectVector.elementAt(idx);
    }

    public MetaRecord getRecord(int idx) {
        return (MetaRecord)this.records.elementAt(idx);
    }

    public int getNumRecords() {
        return this.numRecords;
    }

    public int getNumObjects() {
        return this.numObjects;
    }

    public int getVpX() {
        return this.vpX;
    }

    public int getVpY() {
        return this.vpY;
    }

    public int getVpW() {
        return this.vpW;
    }

    public int getVpH() {
        return this.vpH;
    }

    public void setVpX(int newValue) {
        this.vpX = newValue;
    }

    public void setVpY(int newValue) {
        this.vpY = newValue;
    }

    public void setVpW(int newValue) {
        this.vpW = newValue;
    }

    public void setVpH(int newValue) {
        this.vpH = newValue;
    }
}

