/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.dom;

import java.util.HashMap;
import java.util.Map;
import org.apache.batik.css.dom.CSSOMValue;
import org.apache.batik.css.engine.value.Value;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSValue;

public class CSSOMStyleDeclaration
implements CSSStyleDeclaration {
    protected ValueProvider valueProvider;
    protected ModificationHandler handler;
    protected CSSRule parentRule;
    protected Map values;

    public CSSOMStyleDeclaration(ValueProvider valueProvider, CSSRule cSSRule) {
        this.valueProvider = valueProvider;
        this.parentRule = cSSRule;
    }

    public void setModificationHandler(ModificationHandler modificationHandler) {
        this.handler = modificationHandler;
    }

    public String getCssText() {
        return this.valueProvider.getText();
    }

    public void setCssText(String string) throws DOMException {
        if (this.handler == null) {
            throw new DOMException(7, "");
        }
        this.values = null;
        this.handler.textChanged(string);
    }

    public String getPropertyValue(String string) {
        Value value = this.valueProvider.getValue(string);
        if (value == null) {
            return "";
        }
        return value.getCssText();
    }

    public CSSValue getPropertyCSSValue(String string) {
        Value value = this.valueProvider.getValue(string);
        if (value == null) {
            return null;
        }
        return this.getCSSValue(string);
    }

    public String removeProperty(String string) throws DOMException {
        String string2 = this.getPropertyValue(string);
        if (string2.length() > 0) {
            if (this.handler == null) {
                throw new DOMException(7, "");
            }
            if (this.values != null) {
                this.values.remove(string);
            }
            this.handler.propertyRemoved(string);
        }
        return string2;
    }

    public String getPropertyPriority(String string) {
        return this.valueProvider.isImportant(string) ? "important" : "";
    }

    public void setProperty(String string, String string2, String string3) throws DOMException {
        if (this.handler == null) {
            throw new DOMException(7, "");
        }
        this.handler.propertyChanged(string, string2, string3);
    }

    public int getLength() {
        return this.valueProvider.getLength();
    }

    public String item(int n) {
        return this.valueProvider.item(n);
    }

    public CSSRule getParentRule() {
        return this.parentRule;
    }

    protected CSSValue getCSSValue(String string) {
        CSSValue cSSValue = null;
        if (this.values != null) {
            cSSValue = (CSSValue)this.values.get(string);
        }
        if (cSSValue == null) {
            cSSValue = this.createCSSValue(string);
            if (this.values == null) {
                this.values = new HashMap(11);
            }
            this.values.put(string, cSSValue);
        }
        return cSSValue;
    }

    protected CSSValue createCSSValue(String string) {
        return new StyleDeclarationValue(string);
    }

    public class StyleDeclarationValue
    extends CSSOMValue
    implements CSSOMValue.ValueProvider {
        protected String property;

        public StyleDeclarationValue(String string) {
            super(null);
            this.valueProvider = this;
            this.setModificationHandler(new CSSOMValue.AbstractModificationHandler(this, CSSOMStyleDeclaration.this){
                private final /* synthetic */ CSSOMStyleDeclaration val$this$0;
                private final /* synthetic */ StyleDeclarationValue this$1;
                {
                    this.this$1 = styleDeclarationValue;
                    this.val$this$0 = cSSOMStyleDeclaration;
                    super(styleDeclarationValue);
                }

                protected Value getValue() {
                    return this.this$1.getValue();
                }

                public void textChanged(String string) throws DOMException {
                    if (StyleDeclarationValue.access$000((StyleDeclarationValue)this.this$1).values == null || StyleDeclarationValue.access$000((StyleDeclarationValue)this.this$1).values.get(this) == null || this.this$1.handler == null) {
                        throw new DOMException(7, "");
                    }
                    String string2 = StyleDeclarationValue.access$000(this.this$1).getPropertyPriority(this.this$1.property);
                    StyleDeclarationValue.access$000((StyleDeclarationValue)this.this$1).handler.propertyChanged(this.this$1.property, string, string2);
                }
            });
            this.property = string;
        }

        public Value getValue() {
            return CSSOMStyleDeclaration.this.valueProvider.getValue(this.property);
        }

        static /* synthetic */ CSSOMStyleDeclaration access$000(StyleDeclarationValue styleDeclarationValue) {
            return styleDeclarationValue.CSSOMStyleDeclaration.this;
        }
    }

    public static interface ModificationHandler {
        public void textChanged(String var1) throws DOMException;

        public void propertyRemoved(String var1) throws DOMException;

        public void propertyChanged(String var1, String var2, String var3) throws DOMException;
    }

    public static interface ValueProvider {
        public Value getValue(String var1);

        public boolean isImportant(String var1);

        public String getText();

        public int getLength();

        public String item(int var1);
    }
}

