/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import org.apache.batik.svggen.CachedImageHandler;
import org.apache.batik.svggen.DOMTreeManager;
import org.apache.batik.svggen.ErrorConstants;
import org.apache.batik.svggen.ImageCacher;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphics2DIOException;
import org.apache.batik.svggen.SVGGraphics2DRuntimeException;
import org.apache.batik.svggen.SVGSyntax;
import org.w3c.dom.Element;

public abstract class DefaultCachedImageHandler
implements CachedImageHandler,
SVGSyntax,
ErrorConstants {
    static final String XLINK_NAMESPACE_URI = "http://www.w3.org/1999/xlink";
    static final AffineTransform IDENTITY = new AffineTransform();
    private static Method createGraphics = null;
    private static boolean initDone = false;
    private static final Class[] paramc = new Class[]{BufferedImage.class};
    private static Object[] paramo = null;
    protected ImageCacher imageCacher;

    public ImageCacher getImageCacher() {
        return this.imageCacher;
    }

    void setImageCacher(ImageCacher imageCacher) {
        if (imageCacher == null) {
            throw new IllegalArgumentException();
        }
        DOMTreeManager dOMTreeManager = null;
        if (this.imageCacher != null) {
            dOMTreeManager = this.imageCacher.getDOMTreeManager();
        }
        this.imageCacher = imageCacher;
        if (dOMTreeManager != null) {
            this.imageCacher.setDOMTreeManager(dOMTreeManager);
        }
    }

    public void setDOMTreeManager(DOMTreeManager dOMTreeManager) {
        this.imageCacher.setDOMTreeManager(dOMTreeManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Graphics2D createGraphics(BufferedImage bufferedImage) {
        Object object;
        if (!initDone) {
            try {
                object = Class.forName("org.apache.batik.ext.awt.image.GraphicsUtil");
                createGraphics = ((Class)object).getMethod("createGraphics", paramc);
                paramo = new Object[1];
            }
            catch (Throwable throwable) {
            }
            finally {
                initDone = true;
            }
        }
        if (createGraphics == null) {
            return bufferedImage.createGraphics();
        }
        DefaultCachedImageHandler.paramo[0] = bufferedImage;
        object = null;
        try {
            object = (Graphics2D)createGraphics.invoke(null, paramo);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return object;
    }

    public Element createElement(SVGGeneratorContext sVGGeneratorContext) {
        Element element = sVGGeneratorContext.getDOMFactory().createElementNS("http://www.w3.org/2000/svg", "image");
        return element;
    }

    public AffineTransform handleImage(Image image, Element element, int n, int n2, int n3, int n4, SVGGeneratorContext sVGGeneratorContext) {
        int n5 = image.getWidth(null);
        int n6 = image.getHeight(null);
        AffineTransform affineTransform = null;
        if (n5 == 0 || n6 == 0 || n3 == 0 || n4 == 0) {
            this.handleEmptyImage(element);
        } else {
            try {
                this.handleHREF(image, element, sVGGeneratorContext);
            }
            catch (SVGGraphics2DIOException sVGGraphics2DIOException) {
                try {
                    sVGGeneratorContext.errorHandler.handleError(sVGGraphics2DIOException);
                }
                catch (SVGGraphics2DIOException sVGGraphics2DIOException2) {
                    throw new SVGGraphics2DRuntimeException(sVGGraphics2DIOException2);
                }
            }
            affineTransform = this.handleTransform(element, n, n2, n5, n6, n3, n4, sVGGeneratorContext);
        }
        return affineTransform;
    }

    public AffineTransform handleImage(RenderedImage renderedImage, Element element, int n, int n2, int n3, int n4, SVGGeneratorContext sVGGeneratorContext) {
        int n5 = renderedImage.getWidth();
        int n6 = renderedImage.getHeight();
        AffineTransform affineTransform = null;
        if (n5 == 0 || n6 == 0 || n3 == 0 || n4 == 0) {
            this.handleEmptyImage(element);
        } else {
            try {
                this.handleHREF(renderedImage, element, sVGGeneratorContext);
            }
            catch (SVGGraphics2DIOException sVGGraphics2DIOException) {
                try {
                    sVGGeneratorContext.errorHandler.handleError(sVGGraphics2DIOException);
                }
                catch (SVGGraphics2DIOException sVGGraphics2DIOException2) {
                    throw new SVGGraphics2DRuntimeException(sVGGraphics2DIOException2);
                }
            }
            affineTransform = this.handleTransform(element, n, n2, n5, n6, n3, n4, sVGGeneratorContext);
        }
        return affineTransform;
    }

    public AffineTransform handleImage(RenderableImage renderableImage, Element element, double d, double d2, double d3, double d4, SVGGeneratorContext sVGGeneratorContext) {
        double d5 = renderableImage.getWidth();
        double d6 = renderableImage.getHeight();
        AffineTransform affineTransform = null;
        if (d5 == 0.0 || d6 == 0.0 || d3 == 0.0 || d4 == 0.0) {
            this.handleEmptyImage(element);
        } else {
            try {
                this.handleHREF(renderableImage, element, sVGGeneratorContext);
            }
            catch (SVGGraphics2DIOException sVGGraphics2DIOException) {
                try {
                    sVGGeneratorContext.errorHandler.handleError(sVGGraphics2DIOException);
                }
                catch (SVGGraphics2DIOException sVGGraphics2DIOException2) {
                    throw new SVGGraphics2DRuntimeException(sVGGraphics2DIOException2);
                }
            }
            affineTransform = this.handleTransform(element, d, d2, d5, d6, d3, d4, sVGGeneratorContext);
        }
        return affineTransform;
    }

    protected AffineTransform handleTransform(Element element, double d, double d2, double d3, double d4, double d5, double d6, SVGGeneratorContext sVGGeneratorContext) {
        element.setAttributeNS(null, "x", sVGGeneratorContext.doubleString(d));
        element.setAttributeNS(null, "y", sVGGeneratorContext.doubleString(d2));
        element.setAttributeNS(null, "width", sVGGeneratorContext.doubleString(d5));
        element.setAttributeNS(null, "height", sVGGeneratorContext.doubleString(d6));
        return null;
    }

    protected void handleEmptyImage(Element element) {
        element.setAttributeNS(XLINK_NAMESPACE_URI, "xlink:href", "");
        element.setAttributeNS(null, "width", "0");
        element.setAttributeNS(null, "height", "0");
    }

    public void handleHREF(Image image, Element element, SVGGeneratorContext sVGGeneratorContext) throws SVGGraphics2DIOException {
        if (image == null) {
            throw new SVGGraphics2DRuntimeException("image should not be null");
        }
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        if (n == 0 || n2 == 0) {
            this.handleEmptyImage(element);
        } else if (image instanceof RenderedImage) {
            this.handleHREF((RenderedImage)((Object)image), element, sVGGeneratorContext);
        } else {
            BufferedImage bufferedImage = this.buildBufferedImage(new Dimension(n, n2));
            Graphics2D graphics2D = DefaultCachedImageHandler.createGraphics(bufferedImage);
            graphics2D.drawImage(image, 0, 0, null);
            graphics2D.dispose();
            this.handleHREF(bufferedImage, element, sVGGeneratorContext);
        }
    }

    public BufferedImage buildBufferedImage(Dimension dimension) {
        return new BufferedImage(dimension.width, dimension.height, this.getBufferedImageType());
    }

    protected void handleHREF(RenderedImage renderedImage, Element element, SVGGeneratorContext sVGGeneratorContext) throws SVGGraphics2DIOException {
        BufferedImage bufferedImage = null;
        if (renderedImage instanceof BufferedImage && ((BufferedImage)renderedImage).getType() == this.getBufferedImageType()) {
            bufferedImage = (BufferedImage)renderedImage;
        } else {
            Dimension dimension = new Dimension(renderedImage.getWidth(), renderedImage.getHeight());
            bufferedImage = this.buildBufferedImage(dimension);
            Graphics2D graphics2D = DefaultCachedImageHandler.createGraphics(bufferedImage);
            graphics2D.drawRenderedImage(renderedImage, IDENTITY);
            graphics2D.dispose();
        }
        this.cacheBufferedImage(element, bufferedImage, sVGGeneratorContext);
    }

    protected void handleHREF(RenderableImage renderableImage, Element element, SVGGeneratorContext sVGGeneratorContext) throws SVGGraphics2DIOException {
        Dimension dimension = new Dimension((int)Math.ceil(renderableImage.getWidth()), (int)Math.ceil(renderableImage.getHeight()));
        BufferedImage bufferedImage = this.buildBufferedImage(dimension);
        Graphics2D graphics2D = DefaultCachedImageHandler.createGraphics(bufferedImage);
        graphics2D.drawRenderableImage(renderableImage, IDENTITY);
        graphics2D.dispose();
        this.handleHREF(bufferedImage, element, sVGGeneratorContext);
    }

    protected void cacheBufferedImage(Element element, BufferedImage bufferedImage, SVGGeneratorContext sVGGeneratorContext) throws SVGGraphics2DIOException {
        ByteArrayOutputStream byteArrayOutputStream;
        if (sVGGeneratorContext == null) {
            throw new SVGGraphics2DRuntimeException("generatorContext should not be null");
        }
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            this.encodeImage(bufferedImage, byteArrayOutputStream);
            byteArrayOutputStream.flush();
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            throw new SVGGraphics2DIOException("unexpected exception", iOException);
        }
        String string = this.imageCacher.lookup(byteArrayOutputStream, bufferedImage.getWidth(), bufferedImage.getHeight(), sVGGeneratorContext);
        element.setAttributeNS(XLINK_NAMESPACE_URI, "xlink:href", this.getRefPrefix() + string);
    }

    public abstract String getRefPrefix();

    public abstract void encodeImage(BufferedImage var1, OutputStream var2) throws IOException;

    public abstract int getBufferedImageType();
}

