/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.WeakHashMap;
import org.apache.batik.dom.AbstractAttr;
import org.apache.batik.dom.AbstractDOMImplementation;
import org.apache.batik.dom.AbstractParentNode;
import org.apache.batik.dom.ExtendedNode;
import org.apache.batik.dom.GenericDocumentType;
import org.apache.batik.dom.events.DocumentEventSupport;
import org.apache.batik.dom.traversal.TraversalSupport;
import org.apache.batik.i18n.Localizable;
import org.apache.batik.i18n.LocalizableSupport;
import org.apache.batik.util.CleanerThread;
import org.apache.batik.util.SoftDoublyIndexedTable;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.events.DocumentEvent;
import org.w3c.dom.events.Event;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;
import org.w3c.dom.traversal.TreeWalker;

public abstract class AbstractDocument
extends AbstractParentNode
implements Document,
DocumentEvent,
DocumentTraversal,
Localizable {
    protected static final String RESOURCES = "org.apache.batik.dom.resources.Messages";
    protected transient LocalizableSupport localizableSupport = new LocalizableSupport("org.apache.batik.dom.resources.Messages", this.getClass().getClassLoader());
    protected transient DOMImplementation implementation;
    protected transient TraversalSupport traversalSupport;
    protected transient DocumentEventSupport documentEventSupport;
    protected transient boolean eventsEnabled;
    protected transient WeakHashMap elementsByTagNames;
    protected transient WeakHashMap elementsByTagNamesNS;
    protected transient Map elementsById;

    protected AbstractDocument() {
    }

    public AbstractDocument(DocumentType dt, DOMImplementation impl) {
        this.implementation = impl;
        if (dt != null) {
            GenericDocumentType gdt;
            if (dt instanceof GenericDocumentType && (gdt = (GenericDocumentType)dt).getOwnerDocument() == null) {
                gdt.setOwnerDocument(this);
            }
            this.appendChild(dt);
        }
    }

    public void setLocale(Locale l) {
        this.localizableSupport.setLocale(l);
    }

    public Locale getLocale() {
        return this.localizableSupport.getLocale();
    }

    public String formatMessage(String key, Object[] args) throws MissingResourceException {
        return this.localizableSupport.formatMessage(key, args);
    }

    public boolean getEventsEnabled() {
        return this.eventsEnabled;
    }

    public void setEventsEnabled(boolean b) {
        this.eventsEnabled = b;
    }

    public String getNodeName() {
        return "#document";
    }

    public short getNodeType() {
        return 9;
    }

    public DocumentType getDoctype() {
        for (Node n = this.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 10) continue;
            return (DocumentType)n;
        }
        return null;
    }

    public void setDoctype(DocumentType dt) {
        if (dt != null) {
            this.appendChild(dt);
            ((ExtendedNode)((Object)dt)).setReadonly(true);
        }
    }

    public DOMImplementation getImplementation() {
        return this.implementation;
    }

    public Element getDocumentElement() {
        for (Node n = this.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 1) continue;
            return (Element)n;
        }
        return null;
    }

    public Node importNode(Node importedNode, boolean deep) throws DOMException {
        return this.importNode(importedNode, deep, false);
    }

    /*
     * WARNING - void declaration
     */
    public Node importNode(Node importedNode, boolean deep, boolean trimId) {
        void var4_5;
        switch (importedNode.getNodeType()) {
            case 1: {
                Element e = this.createElementNS(importedNode.getNamespaceURI(), importedNode.getNodeName());
                Node result = e;
                if (!importedNode.hasAttributes()) break;
                NamedNodeMap attr = importedNode.getAttributes();
                int len = attr.getLength();
                for (int i = 0; i < len; ++i) {
                    Attr a = (Attr)attr.item(i);
                    if (!a.getSpecified()) continue;
                    AbstractAttr aa = (AbstractAttr)this.importNode(a, true);
                    if (trimId && aa.isId()) {
                        aa.setIsId(false);
                    }
                    e.setAttributeNodeNS(aa);
                }
                break;
            }
            case 2: {
                Node result = this.createAttributeNS(importedNode.getNamespaceURI(), importedNode.getNodeName());
                break;
            }
            case 3: {
                Node result = this.createTextNode(importedNode.getNodeValue());
                deep = false;
                break;
            }
            case 4: {
                Node result = this.createCDATASection(importedNode.getNodeValue());
                deep = false;
                break;
            }
            case 5: {
                Node result = this.createEntityReference(importedNode.getNodeName());
                break;
            }
            case 7: {
                Node result = this.createProcessingInstruction(importedNode.getNodeName(), importedNode.getNodeValue());
                deep = false;
                break;
            }
            case 8: {
                Node result = this.createComment(importedNode.getNodeValue());
                deep = false;
                break;
            }
            case 11: {
                Node result = this.createDocumentFragment();
                break;
            }
            default: {
                throw this.createDOMException((short)9, "import.node", new Object[0]);
            }
        }
        if (deep) {
            for (Node n = importedNode.getFirstChild(); n != null; n = n.getNextSibling()) {
                var4_5.appendChild(this.importNode(n, true));
            }
        }
        return var4_5;
    }

    public Node cloneNode(boolean deep) {
        Document n = (Document)this.newNode();
        this.copyInto(n);
        if (deep) {
            for (Node c = this.getFirstChild(); c != null; c = c.getNextSibling()) {
                n.appendChild(n.importNode(c, deep));
            }
        }
        return n;
    }

    public abstract boolean isId(Attr var1);

    public Element getElementById(String id) {
        return this.getChildElementById(this.getDocumentElement(), id);
    }

    public Element getChildElementById(Node requestor, String id) {
        if (id == null || id.length() == 0) {
            return null;
        }
        if (this.elementsById == null) {
            return null;
        }
        Node root = this.getRoot(requestor);
        Object o = this.elementsById.get(id);
        if (o == null) {
            return null;
        }
        if (o instanceof IdSoftRef) {
            if ((o = ((IdSoftRef)o).get()) == null) {
                this.elementsById.remove(id);
                return null;
            }
            Element e = (Element)o;
            if (this.getRoot(e) == root) {
                return e;
            }
            return null;
        }
        List l = (List)o;
        Iterator li = l.iterator();
        while (li.hasNext()) {
            IdSoftRef sr = (IdSoftRef)li.next();
            o = sr.get();
            if (o == null) {
                li.remove();
                continue;
            }
            Element e = (Element)o;
            if (this.getRoot(e) != root) continue;
            return e;
        }
        return null;
    }

    protected Node getRoot(Node n) {
        Node r = n;
        while (n != null) {
            r = n;
            n = n.getParentNode();
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIdEntry(Element e, String id) {
        if (id == null) {
            return;
        }
        if (this.elementsById == null) {
            return;
        }
        Map map = this.elementsById;
        synchronized (map) {
            Object o = this.elementsById.get(id);
            if (o == null) {
                return;
            }
            if (o instanceof IdSoftRef) {
                this.elementsById.remove(id);
                return;
            }
            List l = (List)o;
            Iterator li = l.iterator();
            while (li.hasNext()) {
                IdSoftRef ip = (IdSoftRef)li.next();
                o = ip.get();
                if (o == null) {
                    li.remove();
                    continue;
                }
                if (e != o) continue;
                li.remove();
                break;
            }
            if (l.size() == 0) {
                this.elementsById.remove(id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIdEntry(Element e, String id) {
        if (id == null) {
            return;
        }
        if (this.elementsById == null) {
            HashMap tmp;
            HashMap hashMap = tmp = new HashMap();
            synchronized (hashMap) {
                this.elementsById = tmp;
                this.elementsById.put(id, new IdSoftRef(e, id));
            }
            return;
        }
        Map map = this.elementsById;
        synchronized (map) {
            Object o = this.elementsById.get(id);
            if (o == null) {
                this.elementsById.put(id, new IdSoftRef(e, id));
                return;
            }
            if (o instanceof IdSoftRef) {
                IdSoftRef ip = (IdSoftRef)o;
                Object r = ip.get();
                if (r == null) {
                    this.elementsById.put(id, new IdSoftRef(e, id));
                    return;
                }
                ArrayList<IdSoftRef> l = new ArrayList<IdSoftRef>(4);
                ip.setList(l);
                l.add(ip);
                l.add(new IdSoftRef(e, id, l));
                this.elementsById.put(id, l);
                return;
            }
            List l = (List)o;
            l.add(new IdSoftRef(e, id, l));
        }
    }

    public void updateIdEntry(Element e, String oldId, String newId) {
        if (oldId == newId || oldId != null && oldId.equals(newId)) {
            return;
        }
        this.removeIdEntry(e, oldId);
        this.addIdEntry(e, newId);
    }

    public AbstractParentNode.ElementsByTagName getElementsByTagName(Node n, String ln) {
        if (this.elementsByTagNames == null) {
            return null;
        }
        SoftDoublyIndexedTable t = (SoftDoublyIndexedTable)this.elementsByTagNames.get(n);
        if (t == null) {
            return null;
        }
        return (AbstractParentNode.ElementsByTagName)t.get(null, ln);
    }

    public void putElementsByTagName(Node n, String ln, AbstractParentNode.ElementsByTagName l) {
        SoftDoublyIndexedTable t;
        if (this.elementsByTagNames == null) {
            this.elementsByTagNames = new WeakHashMap(11);
        }
        if ((t = (SoftDoublyIndexedTable)this.elementsByTagNames.get(n)) == null) {
            t = new SoftDoublyIndexedTable();
            this.elementsByTagNames.put(n, t);
        }
        t.put(null, ln, l);
    }

    public AbstractParentNode.ElementsByTagNameNS getElementsByTagNameNS(Node n, String ns, String ln) {
        if (this.elementsByTagNamesNS == null) {
            return null;
        }
        SoftDoublyIndexedTable t = (SoftDoublyIndexedTable)this.elementsByTagNamesNS.get(n);
        if (t == null) {
            return null;
        }
        return (AbstractParentNode.ElementsByTagNameNS)t.get(ns, ln);
    }

    public void putElementsByTagNameNS(Node n, String ns, String ln, AbstractParentNode.ElementsByTagNameNS l) {
        SoftDoublyIndexedTable t;
        if (this.elementsByTagNamesNS == null) {
            this.elementsByTagNamesNS = new WeakHashMap(11);
        }
        if ((t = (SoftDoublyIndexedTable)this.elementsByTagNamesNS.get(n)) == null) {
            t = new SoftDoublyIndexedTable();
            this.elementsByTagNamesNS.put(n, t);
        }
        t.put(ns, ln, l);
    }

    public Event createEvent(String eventType) throws DOMException {
        if (this.documentEventSupport == null) {
            this.documentEventSupport = ((AbstractDOMImplementation)this.implementation).createDocumentEventSupport();
        }
        return this.documentEventSupport.createEvent(eventType);
    }

    public NodeIterator createNodeIterator(Node root, int whatToShow, NodeFilter filter, boolean entityReferenceExpansion) throws DOMException {
        if (this.traversalSupport == null) {
            this.traversalSupport = new TraversalSupport();
        }
        return this.traversalSupport.createNodeIterator(this, root, whatToShow, filter, entityReferenceExpansion);
    }

    public TreeWalker createTreeWalker(Node root, int whatToShow, NodeFilter filter, boolean entityReferenceExpansion) throws DOMException {
        return TraversalSupport.createTreeWalker(this, root, whatToShow, filter, entityReferenceExpansion);
    }

    public void detachNodeIterator(NodeIterator it) {
        this.traversalSupport.detachNodeIterator(it);
    }

    public void nodeToBeRemoved(Node node) {
        if (this.traversalSupport != null) {
            this.traversalSupport.nodeToBeRemoved(node);
        }
    }

    protected AbstractDocument getCurrentDocument() {
        return this;
    }

    protected Node export(Node n, Document d) {
        throw this.createDOMException((short)9, "import.document", new Object[0]);
    }

    protected Node deepExport(Node n, Document d) {
        throw this.createDOMException((short)9, "import.document", new Object[0]);
    }

    protected Node copyInto(Node n) {
        super.copyInto(n);
        AbstractDocument ad = (AbstractDocument)n;
        ad.implementation = this.implementation;
        ad.localizableSupport = new LocalizableSupport(RESOURCES, this.getClass().getClassLoader());
        return n;
    }

    protected Node deepCopyInto(Node n) {
        super.deepCopyInto(n);
        AbstractDocument ad = (AbstractDocument)n;
        ad.implementation = this.implementation;
        ad.localizableSupport = new LocalizableSupport(RESOURCES, this.getClass().getClassLoader());
        return n;
    }

    protected void checkChildType(Node n, boolean replace) {
        short t = n.getNodeType();
        switch (t) {
            case 1: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                break;
            }
            default: {
                throw this.createDOMException((short)3, "child.type", new Object[]{new Integer(this.getNodeType()), this.getNodeName(), new Integer(t), n.getNodeName()});
            }
        }
        if (!replace && t == 1 && this.getDocumentElement() != null || t == 10 && this.getDoctype() != null) {
            throw this.createDOMException((short)3, "child.type", new Object[]{new Integer(this.getNodeType()), this.getNodeName(), new Integer(t), n.getNodeName()});
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeObject(this.implementation.getClass().getName());
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.localizableSupport = new LocalizableSupport(RESOURCES, this.getClass().getClassLoader());
        Class<?> c = Class.forName((String)s.readObject());
        try {
            Method m = c.getMethod("getDOMImplementation", null);
            this.implementation = (DOMImplementation)m.invoke(null, null);
        }
        catch (Exception e) {
            try {
                this.implementation = (DOMImplementation)c.newInstance();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    protected class IdSoftRef
    extends CleanerThread.SoftReferenceCleared {
        String id;
        List list;

        IdSoftRef(Object o, String id) {
            super(o);
            this.id = id;
        }

        IdSoftRef(Object o, String id, List list) {
            super(o);
            this.id = id;
            this.list = list;
        }

        public void setList(List list) {
            this.list = list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cleared() {
            if (AbstractDocument.this.elementsById == null) {
                return;
            }
            Map map = AbstractDocument.this.elementsById;
            synchronized (map) {
                if (this.list != null) {
                    this.list.remove(this);
                } else {
                    Object o = AbstractDocument.this.elementsById.remove(this.id);
                    if (o != this) {
                        AbstractDocument.this.elementsById.put(this.id, o);
                    }
                }
            }
        }
    }
}

