/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.parser;

import org.w3c.css.sac.LexicalUnit;

public abstract class CSSLexicalUnit
implements LexicalUnit {
    public static final String UNIT_TEXT_CENTIMETER = "cm";
    public static final String UNIT_TEXT_DEGREE = "deg";
    public static final String UNIT_TEXT_EM = "em";
    public static final String UNIT_TEXT_EX = "ex";
    public static final String UNIT_TEXT_GRADIAN = "grad";
    public static final String UNIT_TEXT_HERTZ = "Hz";
    public static final String UNIT_TEXT_INCH = "in";
    public static final String UNIT_TEXT_KILOHERTZ = "kHz";
    public static final String UNIT_TEXT_MILLIMETER = "mm";
    public static final String UNIT_TEXT_MILLISECOND = "ms";
    public static final String UNIT_TEXT_PERCENTAGE = "%";
    public static final String UNIT_TEXT_PICA = "pc";
    public static final String UNIT_TEXT_PIXEL = "px";
    public static final String UNIT_TEXT_POINT = "pt";
    public static final String UNIT_TEXT_RADIAN = "rad";
    public static final String UNIT_TEXT_REAL = "";
    public static final String UNIT_TEXT_SECOND = "s";
    protected short lexicalUnitType;
    protected LexicalUnit nextLexicalUnit;
    protected LexicalUnit previousLexicalUnit;
    protected int lineNumber;

    protected CSSLexicalUnit(short t, LexicalUnit prev, int lineNumber) {
        this.lexicalUnitType = t;
        this.previousLexicalUnit = prev;
        if (prev != null) {
            ((CSSLexicalUnit)prev).nextLexicalUnit = this;
        }
        this.lineNumber = lineNumber;
    }

    public short getLexicalUnitType() {
        return this.lexicalUnitType;
    }

    public LexicalUnit getNextLexicalUnit() {
        return this.nextLexicalUnit;
    }

    public void setNextLexicalUnit(LexicalUnit lu) {
        this.nextLexicalUnit = lu;
    }

    public LexicalUnit getPreviousLexicalUnit() {
        return this.previousLexicalUnit;
    }

    public void setPreviousLexicalUnit(LexicalUnit lu) {
        this.previousLexicalUnit = lu;
    }

    public int getIntegerValue() {
        throw new IllegalStateException();
    }

    public float getFloatValue() {
        throw new IllegalStateException();
    }

    public String getDimensionUnitText() {
        switch (this.lexicalUnitType) {
            case 19: {
                return UNIT_TEXT_CENTIMETER;
            }
            case 28: {
                return UNIT_TEXT_DEGREE;
            }
            case 15: {
                return UNIT_TEXT_EM;
            }
            case 16: {
                return UNIT_TEXT_EX;
            }
            case 29: {
                return UNIT_TEXT_GRADIAN;
            }
            case 33: {
                return UNIT_TEXT_HERTZ;
            }
            case 18: {
                return UNIT_TEXT_INCH;
            }
            case 34: {
                return UNIT_TEXT_KILOHERTZ;
            }
            case 20: {
                return UNIT_TEXT_MILLIMETER;
            }
            case 31: {
                return UNIT_TEXT_MILLISECOND;
            }
            case 23: {
                return UNIT_TEXT_PERCENTAGE;
            }
            case 22: {
                return UNIT_TEXT_PICA;
            }
            case 17: {
                return UNIT_TEXT_PIXEL;
            }
            case 21: {
                return UNIT_TEXT_POINT;
            }
            case 30: {
                return UNIT_TEXT_RADIAN;
            }
            case 14: {
                return UNIT_TEXT_REAL;
            }
            case 32: {
                return UNIT_TEXT_SECOND;
            }
        }
        throw new IllegalStateException("No Unit Text for type: " + this.lexicalUnitType);
    }

    public String getFunctionName() {
        throw new IllegalStateException();
    }

    public LexicalUnit getParameters() {
        throw new IllegalStateException();
    }

    public String getStringValue() {
        throw new IllegalStateException();
    }

    public LexicalUnit getSubValues() {
        throw new IllegalStateException();
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public static CSSLexicalUnit createSimple(short t, LexicalUnit prev) {
        return new SimpleLexicalUnit(t, prev, -1);
    }

    public static CSSLexicalUnit createSimple(short t, LexicalUnit prev, int lineNumber) {
        return new SimpleLexicalUnit(t, prev, lineNumber);
    }

    public static CSSLexicalUnit createInteger(int val, LexicalUnit prev) {
        return new IntegerLexicalUnit(val, prev, -1);
    }

    public static CSSLexicalUnit createInteger(int val, LexicalUnit prev, int lineNumber) {
        return new IntegerLexicalUnit(val, prev, lineNumber);
    }

    public static CSSLexicalUnit createFloat(short t, float val, LexicalUnit prev) {
        return new FloatLexicalUnit(t, val, prev, -1);
    }

    public static CSSLexicalUnit createFloat(short t, float val, LexicalUnit prev, int lineNumber) {
        return new FloatLexicalUnit(t, val, prev, lineNumber);
    }

    public static CSSLexicalUnit createDimension(float val, String dim, LexicalUnit prev) {
        return new DimensionLexicalUnit(val, dim, prev, -1);
    }

    public static CSSLexicalUnit createDimension(float val, String dim, LexicalUnit prev, int lineNumber) {
        return new DimensionLexicalUnit(val, dim, prev, lineNumber);
    }

    public static CSSLexicalUnit createFunction(String f, LexicalUnit params, LexicalUnit prev) {
        return new FunctionLexicalUnit(f, params, prev, -1);
    }

    public static CSSLexicalUnit createFunction(String f, LexicalUnit params, LexicalUnit prev, int lineNumber) {
        return new FunctionLexicalUnit(f, params, prev, lineNumber);
    }

    public static CSSLexicalUnit createPredefinedFunction(short t, LexicalUnit params, LexicalUnit prev) {
        return new PredefinedFunctionLexicalUnit(t, params, prev, -1);
    }

    public static CSSLexicalUnit createPredefinedFunction(short t, LexicalUnit params, LexicalUnit prev, int lineNumber) {
        return new PredefinedFunctionLexicalUnit(t, params, prev, lineNumber);
    }

    public static CSSLexicalUnit createString(short t, String val, LexicalUnit prev) {
        return new StringLexicalUnit(t, val, prev, -1);
    }

    public static CSSLexicalUnit createString(short t, String val, LexicalUnit prev, int lineNumber) {
        return new StringLexicalUnit(t, val, prev, lineNumber);
    }

    protected static class StringLexicalUnit
    extends CSSLexicalUnit {
        protected String value;

        public StringLexicalUnit(short t, String val, LexicalUnit prev, int lineNumber) {
            super(t, prev, lineNumber);
            this.value = val;
        }

        public String getStringValue() {
            return this.value;
        }
    }

    protected static class PredefinedFunctionLexicalUnit
    extends CSSLexicalUnit {
        protected LexicalUnit parameters;

        public PredefinedFunctionLexicalUnit(short t, LexicalUnit params, LexicalUnit prev, int lineNumber) {
            super(t, prev, lineNumber);
            this.parameters = params;
        }

        public LexicalUnit getParameters() {
            return this.parameters;
        }
    }

    protected static class FunctionLexicalUnit
    extends CSSLexicalUnit {
        protected String name;
        protected LexicalUnit parameters;

        public FunctionLexicalUnit(String f, LexicalUnit params, LexicalUnit prev, int lineNumber) {
            super((short)41, prev, lineNumber);
            this.name = f;
            this.parameters = params;
        }

        public String getFunctionName() {
            return this.name;
        }

        public LexicalUnit getParameters() {
            return this.parameters;
        }
    }

    protected static class DimensionLexicalUnit
    extends CSSLexicalUnit {
        protected float value;
        protected String dimension;

        public DimensionLexicalUnit(float val, String dim, LexicalUnit prev, int lineNumber) {
            super((short)42, prev, lineNumber);
            this.value = val;
            this.dimension = dim;
        }

        public float getFloatValue() {
            return this.value;
        }

        public String getDimensionUnitText() {
            return this.dimension;
        }
    }

    protected static class FloatLexicalUnit
    extends CSSLexicalUnit {
        protected float value;

        public FloatLexicalUnit(short t, float val, LexicalUnit prev, int lineNumber) {
            super(t, prev, lineNumber);
            this.value = val;
        }

        public float getFloatValue() {
            return this.value;
        }
    }

    protected static class IntegerLexicalUnit
    extends CSSLexicalUnit {
        protected int value;

        public IntegerLexicalUnit(int val, LexicalUnit prev, int lineNumber) {
            super((short)13, prev, lineNumber);
            this.value = val;
        }

        public int getIntegerValue() {
            return this.value;
        }
    }

    protected static class SimpleLexicalUnit
    extends CSSLexicalUnit {
        public SimpleLexicalUnit(short t, LexicalUnit prev, int lineNumber) {
            super(t, prev, lineNumber);
        }
    }
}

