/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.apps.svgbrowser;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.batik.apps.svgbrowser.ConfigurationPanelSelector;
import org.apache.batik.apps.svgbrowser.IconCellRenderer;
import org.apache.batik.apps.svgbrowser.Resources;
import org.apache.batik.apps.svgbrowser.XMLPreferenceManager;
import org.apache.batik.ext.swing.GridBagConstants;
import org.apache.batik.ext.swing.JGridBagPanel;
import org.apache.batik.util.PreferenceManager;
import org.apache.batik.util.gui.CSSMediaPanel;
import org.apache.batik.util.gui.LanguageDialog;
import org.apache.batik.util.gui.UserStyleDialog;

public class PreferenceDialog
extends JDialog
implements GridBagConstants {
    public static final int OK_OPTION = 0;
    public static final int CANCEL_OPTION = 1;
    public static final String ICON_USER_LANGUAGE = "PreferenceDialog.icon.userLanguagePref";
    public static final String ICON_USER_STYLESHEET = "PreferenceDialog.icon.userStylesheetPref";
    public static final String ICON_BEHAVIOR = "PreferenceDialog.icon.behaviorsPref";
    public static final String ICON_NETWORK = "PreferenceDialog.icon.networkPref";
    public static final String LABEL_USER_OPTIONS = "PreferenceDialog.label.user.options";
    public static final String LABEL_BEHAVIOR = "PreferenceDialog.label.behavior";
    public static final String LABEL_NETWORK = "PreferenceDialog.label.network";
    public static final String LABEL_USER_LANGUAGE = "PreferenceDialog.label.user.language";
    public static final String LABEL_USER_STYLESHEET = "PreferenceDialog.label.user.stylesheet";
    public static final String LABEL_USER_FONT = "PreferenceDialog.label.user.font";
    public static final String LABEL_APPLICATIONS = "PreferenceDialog.label.applications";
    public static final String LABEL_SHOW_RENDERING = "PreferenceDialog.label.show.rendering";
    public static final String LABEL_AUTO_ADJUST_WINDOW = "PreferenceDialog.label.auto.adjust.window";
    public static final String LABEL_ENABLE_DOUBLE_BUFFERING = "PreferenceDialog.label.enable.double.buffering";
    public static final String LABEL_SHOW_DEBUG_TRACE = "PreferenceDialog.label.show.debug.trace";
    public static final String LABEL_SELECTION_XOR_MODE = "PreferenceDialog.label.selection.xor.mode";
    public static final String LABEL_IS_XML_PARSER_VALIDATING = "PreferenceDialog.label.is.xml.parser.validating";
    public static final String LABEL_ENFORCE_SECURE_SCRIPTING = "PreferenceDialog.label.enforce.secure.scripting";
    public static final String LABEL_SECURE_SCRIPTING_TOGGLE = "PreferenceDialog.label.secure.scripting.toggle";
    public static final String LABEL_GRANT_SCRIPT_FILE_ACCESS = "PreferenceDialog.label.grant.script.file.access";
    public static final String LABEL_GRANT_SCRIPT_NETWORK_ACCESS = "PreferenceDialog.label.grant.script.network.access";
    public static final String LABEL_LOAD_JAVA = "PreferenceDialog.label.load.java";
    public static final String LABEL_LOAD_ECMASCRIPT = "PreferenceDialog.label.load.ecmascript";
    public static final String LABEL_HOST = "PreferenceDialog.label.host";
    public static final String LABEL_PORT = "PreferenceDialog.label.port";
    public static final String LABEL_OK = "PreferenceDialog.label.ok";
    public static final String LABEL_LOAD_SCRIPTS = "PreferenceDialog.label.load.scripts";
    public static final String LABEL_ORIGIN_ANY = "PreferenceDialog.label.origin.any";
    public static final String LABEL_ORIGIN_DOCUMENT = "PreferenceDialog.label.origin.document";
    public static final String LABEL_ORIGIN_EMBED = "PreferenceDialog.label.origin.embed";
    public static final String LABEL_ORIGIN_NONE = "PreferenceDialog.label.origin.none";
    public static final String LABEL_SCRIPT_ORIGIN = "PreferenceDialog.label.script.origin";
    public static final String LABEL_RESOURCE_ORIGIN = "PreferenceDialog.label.resource.origin";
    public static final String LABEL_CANCEL = "PreferenceDialog.label.cancel";
    public static final String TITLE_BROWSER_OPTIONS = "PreferenceDialog.title.browser.options";
    public static final String TITLE_BEHAVIOR = "PreferenceDialog.title.behavior";
    public static final String TITLE_SECURITY = "PreferenceDialog.title.security";
    public static final String TITLE_NETWORK = "PreferenceDialog.title.network";
    public static final String TITLE_DIALOG = "PreferenceDialog.title.dialog";
    public static final String CONFIG_HOST_TEXT_FIELD_LENGTH = "PreferenceDialog.config.host.text.field.length";
    public static final String CONFIG_PORT_TEXT_FIELD_LENGTH = "PreferenceDialog.config.port.text.field.length";
    public static final String CONFIG_OK_MNEMONIC = "PreferenceDialog.config.ok.mnemonic";
    public static final String CONFIG_CANCEL_MNEMONIC = "PreferenceDialog.config.cancel.mnemonic";
    public static final String PREFERENCE_KEY_LANGUAGES = "preference.key.languages";
    public static final String PREFERENCE_KEY_IS_XML_PARSER_VALIDATING = "preference.key.is.xml.parser.validating";
    public static final String PREFERENCE_KEY_USER_STYLESHEET = "preference.key.user.stylesheet";
    public static final String PREFERENCE_KEY_SHOW_RENDERING = "preference.key.show.rendering";
    public static final String PREFERENCE_KEY_AUTO_ADJUST_WINDOW = "preference.key.auto.adjust.window";
    public static final String PREFERENCE_KEY_ENABLE_DOUBLE_BUFFERING = "preference.key.enable.double.buffering";
    public static final String PREFERENCE_KEY_SHOW_DEBUG_TRACE = "preference.key.show.debug.trace";
    public static final String PREFERENCE_KEY_SELECTION_XOR_MODE = "preference.key.selection.xor.mode";
    public static final String PREFERENCE_KEY_PROXY_HOST = "preference.key.proxy.host";
    public static final String PREFERENCE_KEY_CSS_MEDIA = "preference.key.cssmedia";
    public static final String PREFERENCE_KEY_DEFAULT_FONT_FAMILY = "preference.key.default.font.family";
    public static final String PREFERENCE_KEY_PROXY_PORT = "preference.key.proxy.port";
    public static final String PREFERENCE_KEY_ENFORCE_SECURE_SCRIPTING = "preference.key.enforce.secure.scripting";
    public static final String PREFERENCE_KEY_GRANT_SCRIPT_FILE_ACCESS = "preference.key.grant.script.file.access";
    public static final String PREFERENCE_KEY_GRANT_SCRIPT_NETWORK_ACCESS = "preferenced.key.grant.script.network.access";
    public static final String PREFERENCE_KEY_LOAD_ECMASCRIPT = "preference.key.load.ecmascript";
    public static final String PREFERENCE_KEY_LOAD_JAVA = "preference.key.load.java.script";
    public static final String PREFERENCE_KEY_ALLOWED_SCRIPT_ORIGIN = "preference.key.allowed.script.origin";
    public static final String PREFERENCE_KEY_ALLOWED_EXTERNAL_RESOURCE_ORIGIN = "preference.key.allowed.external.resource.origin";
    protected PreferenceManager model;
    protected ConfigurationPanelSelector configPanelSelector;
    protected LanguageDialog.Panel languagePanel;
    protected UserStyleDialog.Panel userStylesheetPanel;
    protected JCheckBox showRendering;
    protected JCheckBox autoAdjustWindow;
    protected JCheckBox showDebugTrace;
    protected JCheckBox enableDoubleBuffering;
    protected JCheckBox selectionXorMode;
    protected JCheckBox isXMLParserValidating;
    protected JCheckBox enforceSecureScripting;
    protected JCheckBox grantScriptFileAccess;
    protected JCheckBox grantScriptNetworkAccess;
    protected JCheckBox loadJava;
    protected JCheckBox loadEcmascript;
    protected ButtonGroup scriptOriginGroup;
    protected ButtonGroup resourceOriginGroup;
    protected JTextField host;
    protected JTextField port;
    protected CSSMediaPanel cssMediaPanel;
    protected int returnCode;

    public PreferenceDialog(PreferenceManager model) {
        super((Frame)null, true);
        if (model == null) {
            throw new IllegalArgumentException();
        }
        this.model = model;
        this.buildGUI();
        this.initializeGUI();
        this.pack();
    }

    public PreferenceManager getPreferenceManager() {
        return this.model;
    }

    protected void initializeGUI() {
        String languages = this.model.getString(PREFERENCE_KEY_LANGUAGES);
        this.languagePanel.setLanguages(languages);
        String userStylesheetPath = this.model.getString(PREFERENCE_KEY_USER_STYLESHEET);
        this.userStylesheetPanel.setPath(userStylesheetPath);
        this.showRendering.setSelected(this.model.getBoolean(PREFERENCE_KEY_SHOW_RENDERING));
        this.autoAdjustWindow.setSelected(this.model.getBoolean(PREFERENCE_KEY_AUTO_ADJUST_WINDOW));
        this.enableDoubleBuffering.setSelected(this.model.getBoolean(PREFERENCE_KEY_ENABLE_DOUBLE_BUFFERING));
        this.showDebugTrace.setSelected(this.model.getBoolean(PREFERENCE_KEY_SHOW_DEBUG_TRACE));
        this.selectionXorMode.setSelected(this.model.getBoolean(PREFERENCE_KEY_SELECTION_XOR_MODE));
        this.isXMLParserValidating.setSelected(this.model.getBoolean(PREFERENCE_KEY_IS_XML_PARSER_VALIDATING));
        this.enforceSecureScripting.setSelected(this.model.getBoolean(PREFERENCE_KEY_ENFORCE_SECURE_SCRIPTING));
        this.grantScriptFileAccess.setSelected(this.model.getBoolean(PREFERENCE_KEY_GRANT_SCRIPT_FILE_ACCESS));
        this.grantScriptNetworkAccess.setSelected(this.model.getBoolean(PREFERENCE_KEY_GRANT_SCRIPT_NETWORK_ACCESS));
        this.loadJava.setSelected(this.model.getBoolean(PREFERENCE_KEY_LOAD_JAVA));
        this.loadEcmascript.setSelected(this.model.getBoolean(PREFERENCE_KEY_LOAD_ECMASCRIPT));
        String allowedScriptOrigin = "" + this.model.getInteger(PREFERENCE_KEY_ALLOWED_SCRIPT_ORIGIN);
        if (allowedScriptOrigin == null || "".equals(allowedScriptOrigin)) {
            allowedScriptOrigin = "8";
        }
        Enumeration<AbstractButton> e = this.scriptOriginGroup.getElements();
        while (e.hasMoreElements()) {
            AbstractButton ab = e.nextElement();
            String ac = ab.getActionCommand();
            if (!allowedScriptOrigin.equals(ac)) continue;
            ab.setSelected(true);
        }
        String allowedResourceOrigin = "" + this.model.getInteger(PREFERENCE_KEY_ALLOWED_EXTERNAL_RESOURCE_ORIGIN);
        if (allowedResourceOrigin == null || "".equals(allowedResourceOrigin)) {
            allowedResourceOrigin = "8";
        }
        e = this.resourceOriginGroup.getElements();
        while (e.hasMoreElements()) {
            AbstractButton ab = e.nextElement();
            String ac = ab.getActionCommand();
            if (!allowedResourceOrigin.equals(ac)) continue;
            ab.setSelected(true);
        }
        this.showRendering.setEnabled(!this.model.getBoolean(PREFERENCE_KEY_ENABLE_DOUBLE_BUFFERING));
        this.grantScriptFileAccess.setEnabled(this.model.getBoolean(PREFERENCE_KEY_ENFORCE_SECURE_SCRIPTING));
        this.grantScriptNetworkAccess.setEnabled(this.model.getBoolean(PREFERENCE_KEY_ENFORCE_SECURE_SCRIPTING));
        this.host.setText(this.model.getString(PREFERENCE_KEY_PROXY_HOST));
        this.port.setText(this.model.getString(PREFERENCE_KEY_PROXY_PORT));
        this.cssMediaPanel.setMedia(this.model.getString(PREFERENCE_KEY_CSS_MEDIA));
        this.setTitle(Resources.getString(TITLE_DIALOG));
    }

    protected void savePreferences() {
        this.model.setString(PREFERENCE_KEY_LANGUAGES, this.languagePanel.getLanguages());
        this.model.setString(PREFERENCE_KEY_USER_STYLESHEET, this.userStylesheetPanel.getPath());
        this.model.setBoolean(PREFERENCE_KEY_SHOW_RENDERING, this.showRendering.isSelected());
        this.model.setBoolean(PREFERENCE_KEY_AUTO_ADJUST_WINDOW, this.autoAdjustWindow.isSelected());
        this.model.setBoolean(PREFERENCE_KEY_ENABLE_DOUBLE_BUFFERING, this.enableDoubleBuffering.isSelected());
        this.model.setBoolean(PREFERENCE_KEY_SHOW_DEBUG_TRACE, this.showDebugTrace.isSelected());
        this.model.setBoolean(PREFERENCE_KEY_SELECTION_XOR_MODE, this.selectionXorMode.isSelected());
        this.model.setBoolean(PREFERENCE_KEY_IS_XML_PARSER_VALIDATING, this.isXMLParserValidating.isSelected());
        this.model.setBoolean(PREFERENCE_KEY_ENFORCE_SECURE_SCRIPTING, this.enforceSecureScripting.isSelected());
        this.model.setBoolean(PREFERENCE_KEY_GRANT_SCRIPT_FILE_ACCESS, this.grantScriptFileAccess.isSelected());
        this.model.setBoolean(PREFERENCE_KEY_GRANT_SCRIPT_NETWORK_ACCESS, this.grantScriptNetworkAccess.isSelected());
        this.model.setBoolean(PREFERENCE_KEY_LOAD_JAVA, this.loadJava.isSelected());
        this.model.setBoolean(PREFERENCE_KEY_LOAD_ECMASCRIPT, this.loadEcmascript.isSelected());
        this.model.setInteger(PREFERENCE_KEY_ALLOWED_SCRIPT_ORIGIN, new Integer(this.scriptOriginGroup.getSelection().getActionCommand()));
        this.model.setInteger(PREFERENCE_KEY_ALLOWED_EXTERNAL_RESOURCE_ORIGIN, new Integer(this.resourceOriginGroup.getSelection().getActionCommand()));
        this.model.setString(PREFERENCE_KEY_PROXY_HOST, this.host.getText());
        this.model.setString(PREFERENCE_KEY_PROXY_PORT, this.port.getText());
        this.model.setString(PREFERENCE_KEY_CSS_MEDIA, this.cssMediaPanel.getMediaAsString());
    }

    protected void buildGUI() {
        JPanel panel = new JPanel(new BorderLayout());
        Component config = this.buildConfigPanel();
        Component list = this.buildConfigPanelList();
        panel.add(list, "West");
        panel.add(config, "Center");
        panel.add((Component)this.buildButtonsPanel(), "South");
        panel.setBorder(BorderFactory.createEmptyBorder(2, 2, 0, 0));
        this.getContentPane().add(panel);
    }

    protected JPanel buildButtonsPanel() {
        JPanel p = new JPanel(new FlowLayout(2));
        JButton okButton = new JButton(Resources.getString(LABEL_OK));
        okButton.setMnemonic(Resources.getCharacter(CONFIG_OK_MNEMONIC));
        JButton cancelButton = new JButton(Resources.getString(LABEL_CANCEL));
        cancelButton.setMnemonic(Resources.getCharacter(CONFIG_CANCEL_MNEMONIC));
        p.add(okButton);
        p.add(cancelButton);
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PreferenceDialog.this.setVisible(false);
                PreferenceDialog.this.returnCode = 0;
                PreferenceDialog.this.savePreferences();
                PreferenceDialog.this.dispose();
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PreferenceDialog.this.setVisible(false);
                PreferenceDialog.this.returnCode = 1;
                PreferenceDialog.this.dispose();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    PreferenceDialog.this.setVisible(false);
                    PreferenceDialog.this.returnCode = 1;
                    PreferenceDialog.this.dispose();
                }
            }
        });
        return p;
    }

    protected Component buildConfigPanelList() {
        String[] configList = new String[]{Resources.getString(LABEL_NETWORK), Resources.getString(LABEL_USER_LANGUAGE), Resources.getString(LABEL_BEHAVIOR), Resources.getString(LABEL_USER_STYLESHEET)};
        final JList<String> list = new JList<String>(configList);
        list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                if (!evt.getValueIsAdjusting()) {
                    PreferenceDialog.this.configPanelSelector.select(list.getSelectedValue().toString());
                }
            }
        });
        list.setVisibleRowCount(4);
        ClassLoader cl = this.getClass().getClassLoader();
        Hashtable<String, ImageIcon> map = new Hashtable<String, ImageIcon>();
        map.put(Resources.getString(LABEL_USER_LANGUAGE), new ImageIcon(cl.getResource(Resources.getString(ICON_USER_LANGUAGE))));
        map.put(Resources.getString(LABEL_USER_STYLESHEET), new ImageIcon(cl.getResource(Resources.getString(ICON_USER_STYLESHEET))));
        map.put(Resources.getString(LABEL_BEHAVIOR), new ImageIcon(cl.getResource(Resources.getString(ICON_BEHAVIOR))));
        map.put(Resources.getString(LABEL_NETWORK), new ImageIcon(cl.getResource(Resources.getString(ICON_NETWORK))));
        list.setCellRenderer(new IconCellRenderer(map));
        list.setSelectedIndex(0);
        return new JScrollPane(list);
    }

    protected Component buildConfigPanel() {
        JPanel configPanel = new JPanel();
        CardLayout cardLayout = new CardLayout();
        configPanel.setLayout(cardLayout);
        configPanel.add(this.buildUserLanguage(), Resources.getString(LABEL_USER_LANGUAGE));
        configPanel.add(this.buildUserStyleSheet(), Resources.getString(LABEL_USER_STYLESHEET));
        configPanel.add(this.buildBehavior(), Resources.getString(LABEL_BEHAVIOR));
        configPanel.add(this.buildNetwork(), Resources.getString(LABEL_NETWORK));
        configPanel.add(this.buildApplications(), Resources.getString(LABEL_APPLICATIONS));
        this.configPanelSelector = new ConfigurationPanelSelector(configPanel, cardLayout);
        return configPanel;
    }

    protected Component buildUserOptions() {
        JTabbedPane p = new JTabbedPane();
        p.add(this.buildUserLanguage(), Resources.getString(LABEL_USER_LANGUAGE));
        p.add(this.buildUserStyleSheet(), Resources.getString(LABEL_USER_STYLESHEET));
        p.add(this.buildUserFont(), Resources.getString(LABEL_USER_FONT));
        return p;
    }

    protected Component buildUserLanguage() {
        this.languagePanel = new LanguageDialog.Panel();
        return this.languagePanel;
    }

    protected Component buildUserStyleSheet() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.userStylesheetPanel = new UserStyleDialog.Panel();
        panel.add((Component)this.userStylesheetPanel, "North");
        this.cssMediaPanel = new CSSMediaPanel();
        panel.add((Component)this.cssMediaPanel, "South");
        return panel;
    }

    protected Component buildUserFont() {
        return new JButton("User Font");
    }

    protected Component buildBehavior() {
        JGridBagPanel p = new JGridBagPanel();
        this.showRendering = new JCheckBox(Resources.getString(LABEL_SHOW_RENDERING));
        this.autoAdjustWindow = new JCheckBox(Resources.getString(LABEL_AUTO_ADJUST_WINDOW));
        this.enableDoubleBuffering = new JCheckBox(Resources.getString(LABEL_ENABLE_DOUBLE_BUFFERING));
        this.enableDoubleBuffering.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PreferenceDialog.this.showRendering.setEnabled(!PreferenceDialog.this.enableDoubleBuffering.isSelected());
            }
        });
        this.showDebugTrace = new JCheckBox(Resources.getString(LABEL_SHOW_DEBUG_TRACE));
        this.selectionXorMode = new JCheckBox(Resources.getString(LABEL_SELECTION_XOR_MODE));
        this.isXMLParserValidating = new JCheckBox(Resources.getString(LABEL_IS_XML_PARSER_VALIDATING));
        this.enforceSecureScripting = new JCheckBox(Resources.getString(LABEL_SECURE_SCRIPTING_TOGGLE));
        this.grantScriptFileAccess = new JCheckBox(Resources.getString(LABEL_GRANT_SCRIPT_FILE_ACCESS));
        this.grantScriptNetworkAccess = new JCheckBox(Resources.getString(LABEL_GRANT_SCRIPT_NETWORK_ACCESS));
        JGridBagPanel scriptSecurityPanel = new JGridBagPanel();
        scriptSecurityPanel.add(this.enforceSecureScripting, 0, 0, 1, 1, 17, 2, 1.0, 0.0);
        scriptSecurityPanel.add(this.grantScriptFileAccess, 1, 0, 1, 1, 17, 2, 1.0, 0.0);
        scriptSecurityPanel.add(this.grantScriptNetworkAccess, 1, 1, 1, 1, 17, 2, 1.0, 0.0);
        this.enforceSecureScripting.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PreferenceDialog.this.grantScriptFileAccess.setEnabled(PreferenceDialog.this.enforceSecureScripting.isSelected());
                PreferenceDialog.this.grantScriptNetworkAccess.setEnabled(PreferenceDialog.this.enforceSecureScripting.isSelected());
            }
        });
        this.loadJava = new JCheckBox(Resources.getString(LABEL_LOAD_JAVA));
        this.loadEcmascript = new JCheckBox(Resources.getString(LABEL_LOAD_ECMASCRIPT));
        JGridBagPanel loadScriptPanel = new JGridBagPanel();
        loadScriptPanel.add(this.loadJava, 0, 0, 1, 1, 17, 0, 1.0, 0.0);
        loadScriptPanel.add(this.loadEcmascript, 1, 0, 1, 1, 17, 0, 1.0, 0.0);
        JPanel scriptOriginPanel = new JPanel();
        this.scriptOriginGroup = new ButtonGroup();
        JRadioButton rb = null;
        rb = new JRadioButton(Resources.getString(LABEL_ORIGIN_ANY));
        rb.setActionCommand("1");
        this.scriptOriginGroup.add(rb);
        scriptOriginPanel.add(rb);
        rb = new JRadioButton(Resources.getString(LABEL_ORIGIN_DOCUMENT));
        rb.setActionCommand("2");
        this.scriptOriginGroup.add(rb);
        scriptOriginPanel.add(rb);
        rb = new JRadioButton(Resources.getString(LABEL_ORIGIN_EMBED));
        rb.setActionCommand("4");
        this.scriptOriginGroup.add(rb);
        scriptOriginPanel.add(rb);
        rb = new JRadioButton(Resources.getString(LABEL_ORIGIN_NONE));
        rb.setActionCommand("8");
        this.scriptOriginGroup.add(rb);
        scriptOriginPanel.add(rb);
        JPanel resourceOriginPanel = new JPanel();
        this.resourceOriginGroup = new ButtonGroup();
        rb = new JRadioButton(Resources.getString(LABEL_ORIGIN_ANY));
        rb.setActionCommand("1");
        this.resourceOriginGroup.add(rb);
        resourceOriginPanel.add(rb);
        rb = new JRadioButton(Resources.getString(LABEL_ORIGIN_DOCUMENT));
        rb.setActionCommand("2");
        this.resourceOriginGroup.add(rb);
        resourceOriginPanel.add(rb);
        rb = new JRadioButton(Resources.getString(LABEL_ORIGIN_EMBED));
        rb.setActionCommand("4");
        this.resourceOriginGroup.add(rb);
        resourceOriginPanel.add(rb);
        rb = new JRadioButton(Resources.getString(LABEL_ORIGIN_NONE));
        rb.setActionCommand("8");
        this.resourceOriginGroup.add(rb);
        resourceOriginPanel.add(rb);
        JTabbedPane browserOptions = new JTabbedPane();
        p.add(this.showRendering, 0, 0, 2, 1, 17, 2, 1.0, 0.0);
        p.add(this.autoAdjustWindow, 0, 1, 2, 1, 17, 2, 1.0, 0.0);
        p.add(this.enableDoubleBuffering, 0, 2, 2, 1, 17, 2, 1.0, 0.0);
        p.add(this.showDebugTrace, 0, 3, 2, 1, 17, 2, 1.0, 0.0);
        p.add(this.selectionXorMode, 0, 4, 2, 1, 17, 2, 1.0, 0.0);
        p.add(this.isXMLParserValidating, 0, 5, 2, 1, 17, 2, 1.0, 0.0);
        p.add(new JLabel(), 0, 11, 2, 1, 17, 1, 1.0, 1.0);
        browserOptions.addTab(Resources.getString(TITLE_BEHAVIOR), p);
        p.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        p = new JGridBagPanel();
        p.add(new JLabel(Resources.getString(LABEL_ENFORCE_SECURE_SCRIPTING)), 0, 6, 1, 1, 18, 0, 0.0, 0.0);
        p.add(scriptSecurityPanel, 1, 6, 1, 1, 17, 0, 0.0, 0.0);
        p.add(new JLabel(Resources.getString(LABEL_LOAD_SCRIPTS)), 0, 8, 1, 1, 17, 0, 0.0, 0.0);
        p.add(loadScriptPanel, 1, 8, 1, 1, 17, 0, 1.0, 0.0);
        p.add(new JLabel(Resources.getString(LABEL_SCRIPT_ORIGIN)), 0, 9, 1, 1, 17, 0, 0.0, 0.0);
        p.add(scriptOriginPanel, 1, 9, 1, 1, 17, 0, 1.0, 0.0);
        p.add(new JLabel(Resources.getString(LABEL_RESOURCE_ORIGIN)), 0, 10, 1, 1, 17, 0, 0.0, 0.0);
        p.add(resourceOriginPanel, 1, 10, 1, 1, 17, 0, 1.0, 0.0);
        p.add(new JLabel(), 0, 11, 2, 1, 17, 1, 1.0, 1.0);
        browserOptions.addTab(Resources.getString(TITLE_SECURITY), p);
        p.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JGridBagPanel borderedPanel = new JGridBagPanel();
        borderedPanel.add(browserOptions, 0, 0, 1, 1, 17, 1, 1.0, 1.0);
        borderedPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Resources.getString(TITLE_BROWSER_OPTIONS)), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        return borderedPanel;
    }

    protected Component buildNetwork() {
        JGridBagPanel p = new JGridBagPanel();
        this.host = new JTextField(Resources.getInteger(CONFIG_HOST_TEXT_FIELD_LENGTH));
        JLabel hostLabel = new JLabel(Resources.getString(LABEL_HOST));
        this.port = new JTextField(Resources.getInteger(CONFIG_PORT_TEXT_FIELD_LENGTH));
        JLabel portLabel = new JLabel(Resources.getString(LABEL_PORT));
        p.add(hostLabel, 0, 0, 1, 1, 17, 2, 0.0, 0.0);
        p.add(this.host, 0, 1, 1, 1, 10, 2, 1.0, 0.0);
        p.add(portLabel, 1, 0, 1, 1, 17, 2, 0.0, 0.0);
        p.add(this.port, 1, 1, 1, 1, 10, 2, 0.0, 0.0);
        p.add(new JLabel(""), 2, 1, 1, 1, 10, 2, 0.0, 0.0);
        p.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Resources.getString(TITLE_NETWORK)), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        return p;
    }

    protected Component buildApplications() {
        return new JButton("Applications");
    }

    public int showDialog() {
        this.pack();
        this.show();
        return this.returnCode;
    }

    public static void main(String[] args) {
        Hashtable<String, Object> defaults = new Hashtable<String, Object>();
        defaults.put(PREFERENCE_KEY_LANGUAGES, "fr");
        defaults.put(PREFERENCE_KEY_SHOW_RENDERING, Boolean.TRUE);
        defaults.put(PREFERENCE_KEY_SELECTION_XOR_MODE, Boolean.FALSE);
        defaults.put(PREFERENCE_KEY_IS_XML_PARSER_VALIDATING, Boolean.FALSE);
        defaults.put(PREFERENCE_KEY_AUTO_ADJUST_WINDOW, Boolean.TRUE);
        defaults.put(PREFERENCE_KEY_ENABLE_DOUBLE_BUFFERING, Boolean.TRUE);
        defaults.put(PREFERENCE_KEY_SHOW_DEBUG_TRACE, Boolean.TRUE);
        defaults.put(PREFERENCE_KEY_PROXY_HOST, "webcache.eng.sun.com");
        defaults.put(PREFERENCE_KEY_PROXY_PORT, "8080");
        XMLPreferenceManager manager = new XMLPreferenceManager(args[0], defaults);
        PreferenceDialog dlg = new PreferenceDialog(manager);
        int c = dlg.showDialog();
        if (c == 0) {
            try {
                manager.save();
                System.out.println("Done Saving options");
                System.exit(0);
            }
            catch (Exception e) {
                System.err.println("Could not save options");
                e.printStackTrace();
            }
        }
    }
}

