/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.apps.rasterizer;

import java.io.IOException;
import java.io.InputStream;
import org.apache.batik.apps.rasterizer.SVGConverterException;
import org.apache.batik.apps.rasterizer.SVGConverterSource;
import org.apache.batik.util.ParsedURL;

public class SVGConverterURLSource
implements SVGConverterSource {
    protected static final String SVG_EXTENSION = ".svg";
    protected static final String SVGZ_EXTENSION = ".svgz";
    public static final String ERROR_INVALID_URL = "SVGConverterURLSource.error.invalid.url";
    ParsedURL purl;
    String name;

    public SVGConverterURLSource(String url) throws SVGConverterException {
        this.purl = new ParsedURL(url);
        String path = this.purl.getPath();
        if (path == null || !path.toLowerCase().endsWith(SVG_EXTENSION) && !path.toLowerCase().endsWith(SVGZ_EXTENSION)) {
            throw new SVGConverterException(ERROR_INVALID_URL, new Object[]{url});
        }
        int n = path.lastIndexOf("/");
        if (n != -1) {
            path = path.substring(n + 1);
        }
        this.name = path;
        String ref = this.purl.getRef();
        if (ref != null && ref.length() != 0) {
            this.name = this.name + "" + ref.hashCode();
        }
    }

    public String toString() {
        return this.purl.toString();
    }

    public String getURI() {
        return this.toString();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof SVGConverterURLSource)) {
            return false;
        }
        return this.purl.equals(((SVGConverterURLSource)o).purl);
    }

    public InputStream openStream() throws IOException {
        return this.purl.openStream();
    }

    public boolean isSameAs(String srcStr) {
        return this.toString().equals(srcStr);
    }

    public boolean isReadable() {
        return true;
    }

    public String getName() {
        return this.name;
    }
}

