/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import java.awt.geom.AffineTransform;
import org.w3c.dom.svg.SVGMatrix;
import org.w3c.dom.svg.SVGTransform;

public abstract class AbstractSVGTransform
implements SVGTransform {
    protected short type = 0;
    protected AffineTransform affineTransform;
    protected float angle;
    protected float x;
    protected float y;

    protected abstract SVGMatrix createMatrix();

    protected AbstractSVGTransform() {
    }

    protected void setType(short type) {
        this.type = type;
    }

    protected float getX() {
        return this.x;
    }

    protected float getY() {
        return this.y;
    }

    public short getType() {
        return this.type;
    }

    public SVGMatrix getMatrix() {
        return this.createMatrix();
    }

    public float getAngle() {
        return this.angle;
    }

    public void setMatrix(SVGMatrix matrix) {
        this.type = 1;
        this.affineTransform = new AffineTransform(matrix.getA(), matrix.getB(), matrix.getC(), matrix.getD(), matrix.getE(), matrix.getF());
    }

    public void setTranslate(float tx, float ty) {
        this.type = (short)2;
        this.affineTransform = AffineTransform.getTranslateInstance(tx, ty);
    }

    public void setScale(float sx, float sy) {
        this.type = (short)3;
        this.affineTransform = AffineTransform.getScaleInstance(sx, sy);
    }

    public void setRotate(float angle, float cx, float cy) {
        this.type = (short)4;
        this.affineTransform = AffineTransform.getRotateInstance(Math.toRadians(angle), cx, cy);
        this.angle = angle;
        this.x = cx;
        this.y = cy;
    }

    public void setSkewX(float angle) {
        this.type = (short)5;
        this.affineTransform = new AffineTransform(1.0, Math.tan(Math.toRadians(angle)), 0.0, 1.0, 0.0, 0.0);
        this.angle = angle;
    }

    public void setSkewY(float angle) {
        this.type = (short)6;
        this.angle = angle;
        this.affineTransform = new AffineTransform(1.0, 0.0, Math.tan(Math.toRadians(angle)), 1.0, 0.0, 0.0);
    }
}

