/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.spi;

import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import org.apache.batik.ext.awt.image.spi.AbstractRegistryEntry;
import org.apache.batik.ext.awt.image.spi.StreamRegistryEntry;

public abstract class MagicNumberRegistryEntry
extends AbstractRegistryEntry
implements StreamRegistryEntry {
    public static final float PRIORITY = 1000.0f;
    MagicNumber[] magicNumbers;

    public MagicNumberRegistryEntry(String name, String ext, String mimeType, int offset, byte[] magicNumber) {
        super(name, 1000.0f, ext, mimeType);
        this.magicNumbers = new MagicNumber[1];
        this.magicNumbers[0] = new MagicNumber(offset, magicNumber);
    }

    public MagicNumberRegistryEntry(String name, String ext, String mimeType, MagicNumber[] magicNumbers) {
        super(name, 1000.0f, ext, mimeType);
        this.magicNumbers = magicNumbers;
    }

    public MagicNumberRegistryEntry(String name, String[] exts, String[] mimeTypes, int offset, byte[] magicNumber) {
        super(name, 1000.0f, exts, mimeTypes);
        this.magicNumbers = new MagicNumber[1];
        this.magicNumbers[0] = new MagicNumber(offset, magicNumber);
    }

    public MagicNumberRegistryEntry(String name, String[] exts, String[] mimeTypes, MagicNumber[] magicNumbers) {
        super(name, 1000.0f, exts, mimeTypes);
        this.magicNumbers = magicNumbers;
    }

    public MagicNumberRegistryEntry(String name, String[] exts, String[] mimeTypes, MagicNumber[] magicNumbers, float priority) {
        super(name, priority, exts, mimeTypes);
        this.magicNumbers = magicNumbers;
    }

    public int getReadlimit() {
        int maxbuf = 0;
        for (int i = 0; i < this.magicNumbers.length; ++i) {
            int req = this.magicNumbers[i].getReadlimit();
            if (req <= maxbuf) continue;
            maxbuf = req;
        }
        return maxbuf;
    }

    public boolean isCompatibleStream(InputStream is) throws StreamCorruptedException {
        for (int i = 0; i < this.magicNumbers.length; ++i) {
            if (!this.magicNumbers[i].isMatch(is)) continue;
            return true;
        }
        return false;
    }

    public static class MagicNumber {
        int offset;
        byte[] magicNumber;
        byte[] buffer;

        public MagicNumber(int offset, byte[] magicNumber) {
            this.offset = offset;
            this.magicNumber = (byte[])magicNumber.clone();
            this.buffer = new byte[magicNumber.length];
        }

        int getReadlimit() {
            return this.offset + this.magicNumber.length;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        boolean isMatch(InputStream is) throws StreamCorruptedException {
            int idx;
            int rn;
            is.mark(this.getReadlimit());
            try {
                try {}
                catch (IOException ioe) {
                    boolean bl = false;
                    Object var6_13 = null;
                    try {
                        is.reset();
                        return bl;
                    }
                    catch (IOException ioe2) {
                        throw new StreamCorruptedException(ioe2.getMessage());
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_14 = null;
                try {}
                catch (IOException ioe2) {
                    throw new StreamCorruptedException(ioe2.getMessage());
                }
                is.reset();
                throw throwable;
            }
            for (idx = 0; idx < this.offset; idx += rn) {
                rn = (int)is.skip(this.offset - idx);
                if (rn != -1) continue;
                boolean bl = false;
                Object var6_9 = null;
                try {}
                catch (IOException ioe2) {
                    throw new StreamCorruptedException(ioe2.getMessage());
                }
                is.reset();
                return bl;
            }
            for (idx = 0; idx < this.buffer.length; idx += rn) {
                rn = is.read(this.buffer, idx, this.buffer.length - idx);
                if (rn != -1) continue;
                boolean bl = false;
                Object var6_10 = null;
                try {}
                catch (IOException ioe2) {
                    throw new StreamCorruptedException(ioe2.getMessage());
                }
                is.reset();
                return bl;
            }
            for (int i = 0; i < this.magicNumber.length; ++i) {
                if (this.magicNumber[i] == this.buffer[i]) continue;
                boolean bl = false;
                Object var6_11 = null;
                try {}
                catch (IOException ioe2) {
                    throw new StreamCorruptedException(ioe2.getMessage());
                }
                is.reset();
                return bl;
            }
            Object var6_12 = null;
            try {}
            catch (IOException ioe2) {
                throw new StreamCorruptedException(ioe2.getMessage());
            }
            is.reset();
            return true;
        }
    }
}

