/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.util.gui.resource;

import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import org.apache.batik.util.gui.resource.ActionMap;
import org.apache.batik.util.gui.resource.JComponentModifier;
import org.apache.batik.util.gui.resource.MissingListenerException;
import org.apache.batik.util.gui.resource.ResourceFormatException;
import org.apache.batik.util.gui.resource.ResourceManager;

public class MenuFactory
extends ResourceManager {
    private static final String TYPE_MENU = "MENU";
    private static final String TYPE_ITEM = "ITEM";
    private static final String TYPE_RADIO = "RADIO";
    private static final String TYPE_CHECK = "CHECK";
    private static final String SEPARATOR = "-";
    private static final String TYPE_SUFFIX = ".type";
    private static final String TEXT_SUFFIX = ".text";
    private static final String MNEMONIC_SUFFIX = ".mnemonic";
    private static final String ACCELERATOR_SUFFIX = ".accelerator";
    private static final String ACTION_SUFFIX = ".action";
    private static final String SELECTED_SUFFIX = ".selected";
    private static final String ENABLED_SUFFIX = ".enabled";
    private static final String ICON_SUFFIX = ".icon";
    private ActionMap actions;
    private ButtonGroup buttonGroup;

    public MenuFactory(ResourceBundle rb, ActionMap am) {
        super(rb);
        this.actions = am;
        this.buttonGroup = null;
    }

    public JMenuBar createJMenuBar(String name) throws MissingResourceException, ResourceFormatException, MissingListenerException {
        JMenuBar result = new JMenuBar();
        List menus = this.getStringList(name);
        Iterator it = menus.iterator();
        while (it.hasNext()) {
            result.add(this.createJMenuComponent((String)it.next()));
        }
        return result;
    }

    protected JComponent createJMenuComponent(String name) throws MissingResourceException, ResourceFormatException, MissingListenerException {
        if (name.equals(SEPARATOR)) {
            this.buttonGroup = null;
            return new JSeparator();
        }
        String type = this.getString(name + TYPE_SUFFIX);
        JMenuItem item = null;
        if (type.equals(TYPE_RADIO)) {
            if (this.buttonGroup == null) {
                this.buttonGroup = new ButtonGroup();
            }
        } else {
            this.buttonGroup = null;
        }
        if (type.equals(TYPE_MENU)) {
            item = this.createJMenu(name);
        } else if (type.equals(TYPE_ITEM)) {
            item = this.createJMenuItem(name);
        } else if (type.equals(TYPE_RADIO)) {
            item = this.createJRadioButtonMenuItem(name);
            this.buttonGroup.add(item);
        } else if (type.equals(TYPE_CHECK)) {
            item = this.createJCheckBoxMenuItem(name);
        } else {
            throw new ResourceFormatException("Malformed resource", this.bundle.getClass().getName(), name + TYPE_SUFFIX);
        }
        return item;
    }

    public JMenu createJMenu(String name) throws MissingResourceException, ResourceFormatException, MissingListenerException {
        JMenu result = new JMenu(this.getString(name + TEXT_SUFFIX));
        this.initializeJMenuItem(result, name);
        List items = this.getStringList(name);
        Iterator it = items.iterator();
        while (it.hasNext()) {
            result.add(this.createJMenuComponent((String)it.next()));
        }
        return result;
    }

    public JMenuItem createJMenuItem(String name) throws MissingResourceException, ResourceFormatException, MissingListenerException {
        JMenuItem result = new JMenuItem(this.getString(name + TEXT_SUFFIX));
        this.initializeJMenuItem(result, name);
        return result;
    }

    public JRadioButtonMenuItem createJRadioButtonMenuItem(String name) throws MissingResourceException, ResourceFormatException, MissingListenerException {
        JRadioButtonMenuItem result = new JRadioButtonMenuItem(this.getString(name + TEXT_SUFFIX));
        this.initializeJMenuItem(result, name);
        try {
            result.setSelected(this.getBoolean(name + SELECTED_SUFFIX));
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return result;
    }

    public JCheckBoxMenuItem createJCheckBoxMenuItem(String name) throws MissingResourceException, ResourceFormatException, MissingListenerException {
        JCheckBoxMenuItem result = new JCheckBoxMenuItem(this.getString(name + TEXT_SUFFIX));
        this.initializeJMenuItem(result, name);
        try {
            result.setSelected(this.getBoolean(name + SELECTED_SUFFIX));
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return result;
    }

    protected void initializeJMenuItem(JMenuItem item, String name) throws ResourceFormatException, MissingListenerException {
        block15: {
            String str;
            try {
                Action a = this.actions.getAction(this.getString(name + ACTION_SUFFIX));
                if (a == null) {
                    throw new MissingListenerException("", "Action", name + ACTION_SUFFIX);
                }
                item.setAction(a);
                item.setText(this.getString(name + TEXT_SUFFIX));
                if (a instanceof JComponentModifier) {
                    ((JComponentModifier)((Object)a)).addJComponent(item);
                }
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
            try {
                String s = this.getString(name + ICON_SUFFIX);
                URL url = this.actions.getClass().getResource(s);
                if (url != null) {
                    item.setIcon(new ImageIcon(url));
                }
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
            try {
                str = this.getString(name + MNEMONIC_SUFFIX);
                if (str.length() != 1) {
                    throw new ResourceFormatException("Malformed mnemonic", this.bundle.getClass().getName(), name + MNEMONIC_SUFFIX);
                }
                item.setMnemonic(str.charAt(0));
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
            try {
                if (item instanceof JMenu) break block15;
                str = this.getString(name + ACCELERATOR_SUFFIX);
                KeyStroke ks = this.toKeyStroke(str);
                if (ks != null) {
                    item.setAccelerator(ks);
                    break block15;
                }
                throw new ResourceFormatException("Malformed accelerator", this.bundle.getClass().getName(), name + ACCELERATOR_SUFFIX);
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
        }
        try {
            item.setEnabled(this.getBoolean(name + ENABLED_SUFFIX));
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }

    protected KeyStroke toKeyStroke(String str) {
        char curr;
        int i;
        int state = 0;
        int code = 0;
        int modif = 0;
        block31: for (i = 0; state != 100 && i < str.length(); ++i) {
            curr = Character.toUpperCase(str.charAt(i));
            switch (state) {
                case 0: {
                    code = curr;
                    switch (curr) {
                        case 'C': {
                            state = 1;
                            continue block31;
                        }
                        case 'A': {
                            state = 5;
                            continue block31;
                        }
                        case 'M': {
                            state = 8;
                            continue block31;
                        }
                        case 'S': {
                            state = 12;
                            continue block31;
                        }
                    }
                    state = 100;
                    continue block31;
                }
                case 1: {
                    state = curr == 'T' ? 2 : 100;
                    continue block31;
                }
                case 2: {
                    state = curr == 'R' ? 3 : 100;
                    continue block31;
                }
                case 3: {
                    state = curr == 'L' ? 4 : 100;
                    continue block31;
                }
                case 4: {
                    int n = state = curr == '+' ? 0 : 100;
                    if (state != 0) continue block31;
                    modif |= 2;
                    continue block31;
                }
                case 5: {
                    state = curr == 'L' ? 6 : 100;
                    continue block31;
                }
                case 6: {
                    state = curr == 'T' ? 7 : 100;
                    continue block31;
                }
                case 7: {
                    int n = state = curr == '+' ? 0 : 100;
                    if (state != 0) continue block31;
                    modif |= 8;
                    continue block31;
                }
                case 8: {
                    state = curr == 'E' ? 9 : 100;
                    continue block31;
                }
                case 9: {
                    state = curr == 'T' ? 10 : 100;
                    continue block31;
                }
                case 10: {
                    state = curr == 'A' ? 11 : 100;
                    continue block31;
                }
                case 11: {
                    int n = state = curr == '+' ? 0 : 100;
                    if (state != 0) continue block31;
                    modif |= 4;
                    continue block31;
                }
                case 12: {
                    state = curr == 'H' ? 13 : 100;
                    continue block31;
                }
                case 13: {
                    state = curr == 'I' ? 14 : 100;
                    continue block31;
                }
                case 14: {
                    state = curr == 'F' ? 15 : 100;
                    continue block31;
                }
                case 15: {
                    state = curr == 'T' ? 16 : 100;
                    continue block31;
                }
                case 16: {
                    int n = state = curr == '+' ? 0 : 100;
                    if (state != 0) continue block31;
                    modif |= 1;
                }
            }
        }
        if (code > 0 && modif > 0) {
            if (i < str.length()) {
                curr = Character.toUpperCase(str.charAt(i));
                switch (code) {
                    case 85: {
                        if (str.length() - i != 1 || curr != 'P') break;
                        code = 38;
                        break;
                    }
                    case 76: {
                        if (str.length() - i != 3 || curr != 'E' || Character.toUpperCase(str.charAt(i + 1)) != 'F' || Character.toUpperCase(str.charAt(i + 2)) != 'T') break;
                        code = 37;
                        break;
                    }
                    case 68: {
                        if (str.length() - i != 3 || curr != 'O' || Character.toUpperCase(str.charAt(i + 1)) != 'W' || Character.toUpperCase(str.charAt(i + 2)) != 'N') break;
                        code = 40;
                        break;
                    }
                    case 82: {
                        if (str.length() - i != 4 || curr != 'I' || Character.toUpperCase(str.charAt(i + 1)) != 'G' || Character.toUpperCase(str.charAt(i + 2)) != 'H' || Character.toUpperCase(str.charAt(i + 3)) != 'T') break;
                        code = 39;
                    }
                }
            }
            return KeyStroke.getKeyStroke(code, modif);
        }
        return null;
    }
}

