/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.MissingResourceException;
import org.apache.batik.css.engine.CSSContext;
import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.value.ShorthandManager;
import org.apache.batik.css.engine.value.ValueManager;
import org.apache.batik.css.parser.ExtendedParser;
import org.apache.batik.css.parser.ExtendedParserWrapper;
import org.apache.batik.dom.AbstractDOMImplementation;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.AbstractStylableDocument;
import org.apache.batik.dom.DomExtension;
import org.apache.batik.dom.GenericElement;
import org.apache.batik.dom.GenericElementNS;
import org.apache.batik.dom.StyleSheetFactory;
import org.apache.batik.dom.util.DOMUtilities;
import org.apache.batik.dom.util.DoublyIndexedTable;
import org.apache.batik.i18n.Localizable;
import org.apache.batik.i18n.LocalizableSupport;
import org.apache.batik.util.Service;
import org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.css.sac.Parser;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.css.DOMImplementationCSS;
import org.w3c.dom.css.ViewCSS;

public abstract class ExtensibleDOMImplementation
extends AbstractDOMImplementation
implements DOMImplementationCSS,
StyleSheetFactory,
Localizable {
    protected DoublyIndexedTable customFactories;
    protected List customValueManagers;
    protected List customShorthandManagers;
    protected static final String RESOURCES = "org.apache.batik.dom.resources.Messages";
    protected LocalizableSupport localizableSupport;
    protected static List extensions = null;
    static /* synthetic */ Class class$org$apache$batik$dom$DomExtension;

    public ExtensibleDOMImplementation() {
        this.initLocalizable();
        Iterator iter = ExtensibleDOMImplementation.getDomExtensions().iterator();
        while (iter.hasNext()) {
            DomExtension de = (DomExtension)iter.next();
            de.registerTags(this);
        }
    }

    public void setLocale(Locale l) {
        this.localizableSupport.setLocale(l);
    }

    public Locale getLocale() {
        return this.localizableSupport.getLocale();
    }

    protected void initLocalizable() {
        this.localizableSupport = new LocalizableSupport(RESOURCES, this.getClass().getClassLoader());
    }

    public String formatMessage(String key, Object[] args) throws MissingResourceException {
        return this.localizableSupport.formatMessage(key, args);
    }

    public void registerCustomElementFactory(String namespaceURI, String localName, ElementFactory factory) {
        if (this.customFactories == null) {
            this.customFactories = new DoublyIndexedTable();
        }
        this.customFactories.put(namespaceURI, localName, factory);
    }

    public void registerCustomCSSValueManager(ValueManager vm) {
        if (this.customValueManagers == null) {
            this.customValueManagers = new LinkedList();
        }
        this.customValueManagers.add(vm);
    }

    public void registerCustomCSSShorthandManager(ShorthandManager sm) {
        if (this.customShorthandManagers == null) {
            this.customShorthandManagers = new LinkedList();
        }
        this.customShorthandManagers.add(sm);
    }

    public CSSEngine createCSSEngine(AbstractStylableDocument doc, CSSContext ctx) {
        ShorthandManager[] sms;
        ValueManager[] vms;
        Parser p;
        String pn = XMLResourceDescriptor.getCSSParserClassName();
        try {
            p = (Parser)Class.forName(pn).newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new DOMException(15, this.formatMessage("css.parser.class", new Object[]{pn}));
        }
        catch (InstantiationException e) {
            throw new DOMException(15, this.formatMessage("css.parser.creation", new Object[]{pn}));
        }
        catch (IllegalAccessException e) {
            throw new DOMException(15, this.formatMessage("css.parser.access", new Object[]{pn}));
        }
        ExtendedParser ep = ExtendedParserWrapper.wrap(p);
        if (this.customValueManagers == null) {
            vms = new ValueManager[]{};
        } else {
            vms = new ValueManager[this.customValueManagers.size()];
            Iterator it = this.customValueManagers.iterator();
            int i = 0;
            while (it.hasNext()) {
                vms[i++] = (ValueManager)it.next();
            }
        }
        if (this.customShorthandManagers == null) {
            sms = new ShorthandManager[]{};
        } else {
            sms = new ShorthandManager[this.customShorthandManagers.size()];
            Iterator it = this.customShorthandManagers.iterator();
            int i = 0;
            while (it.hasNext()) {
                sms[i++] = (ShorthandManager)it.next();
            }
        }
        CSSEngine result = this.createCSSEngine(doc, ctx, ep, vms, sms);
        doc.setCSSEngine(result);
        return result;
    }

    public abstract CSSEngine createCSSEngine(AbstractStylableDocument var1, CSSContext var2, ExtendedParser var3, ValueManager[] var4, ShorthandManager[] var5);

    public abstract ViewCSS createViewCSS(AbstractStylableDocument var1);

    public Element createElementNS(AbstractDocument document, String namespaceURI, String qualifiedName) {
        String name;
        ElementFactory cef;
        if (namespaceURI == null) {
            return new GenericElement(qualifiedName.intern(), document);
        }
        if (this.customFactories != null && (cef = (ElementFactory)this.customFactories.get(namespaceURI, name = DOMUtilities.getLocalName(qualifiedName))) != null) {
            return cef.create(DOMUtilities.getPrefix(qualifiedName), document);
        }
        return new GenericElementNS(namespaceURI.intern(), qualifiedName.intern(), document);
    }

    protected static synchronized List getDomExtensions() {
        if (extensions != null) {
            return extensions;
        }
        extensions = new LinkedList();
        Iterator iter = Service.providers(class$org$apache$batik$dom$DomExtension == null ? (class$org$apache$batik$dom$DomExtension = ExtensibleDOMImplementation.class$("org.apache.batik.dom.DomExtension")) : class$org$apache$batik$dom$DomExtension);
        block0: while (iter.hasNext()) {
            DomExtension lde;
            DomExtension de = (DomExtension)iter.next();
            float priority = de.getPriority();
            ListIterator<DomExtension> li = extensions.listIterator();
            do {
                if (li.hasNext()) continue;
                li.add(de);
                continue block0;
            } while (!((lde = (DomExtension)li.next()).getPriority() > priority));
            li.previous();
            li.add(de);
        }
        return extensions;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static interface ElementFactory {
        public Element create(String var1, Document var2);
    }
}

