/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali.Adaptors.Format;

import java.io.IOException;
import org.jf.baksmali.Adaptors.MethodItem;
import org.jf.baksmali.Adaptors.ReferenceFormatter;
import org.jf.baksmali.Adaptors.RegisterFormatter;
import org.jf.baksmali.Renderers.LongRenderer;
import org.jf.dexlib.Code.FiveRegisterInstruction;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.InstructionWithReference;
import org.jf.dexlib.Code.LiteralInstruction;
import org.jf.dexlib.Code.OdexedFieldAccess;
import org.jf.dexlib.Code.OdexedInvokeVirtual;
import org.jf.dexlib.Code.RegisterRangeInstruction;
import org.jf.dexlib.Code.SingleRegisterInstruction;
import org.jf.dexlib.Code.ThreeRegisterInstruction;
import org.jf.dexlib.Code.TwoRegisterInstruction;
import org.jf.dexlib.CodeItem;
import org.jf.dexlib.Item;
import org.jf.util.IndentingWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstructionMethodItem<T extends Instruction>
extends MethodItem {
    protected final CodeItem codeItem;
    protected final T instruction;

    public InstructionMethodItem(CodeItem codeItem, int codeAddress, T instruction) {
        super(codeAddress);
        this.codeItem = codeItem;
        this.instruction = instruction;
    }

    @Override
    public double getSortOrder() {
        return 100.0;
    }

    @Override
    public boolean writeTo(IndentingWriter writer) throws IOException {
        switch (((Instruction)this.instruction).getFormat()) {
            case Format10t: {
                this.writeOpcode(writer);
                writer.write(32);
                this.writeTargetLabel(writer);
                return true;
            }
            case Format10x: {
                this.writeOpcode(writer);
                return true;
            }
            case Format11n: {
                this.writeOpcode(writer);
                writer.write(32);
                this.writeFirstRegister(writer);
                writer.write(", ");
                this.writeLiteral(writer);
                return true;
            }
            case Format11x: {
                this.writeOpcode(writer);
                writer.write(32);
                this.writeFirstRegister(writer);
                return true;
            }
            case Format12x: {
                this.writeOpcode(writer);
                writer.write(32);
                this.writeFirstRegister(writer);
                writer.write(", ");
                this.writeSecondRegister(writer);
                return true;
            }
            case Format20t: 
            case Format30t: {
                this.writeOpcode(writer);
                writer.write(32);
                this.writeTargetLabel(writer);
                return true;
            }
            case Format21c: 
            case Format31c: {
                this.writeOpcode(writer);
                writer.write(32);
                this.writeFirstRegister(writer);
                writer.write(", ");
                this.writeReference(writer);
                return true;
            }
            case Format21h: 
            case Format21s: 
            case Format31i: 
            case Format51l: {
                this.writeOpcode(writer);
                writer.write(32);
                this.writeFirstRegister(writer);
                writer.write(", ");
                this.writeLiteral(writer);
                return true;
            }
            case Format21t: 
            case Format31t: {
                this.writeOpcode(writer);
                writer.write(32);
                this.writeFirstRegister(writer);
                writer.write(", ");
                this.writeTargetLabel(writer);
                return true;
            }
            case Format22b: 
            case Format22s: {
                this.writeOpcode(writer);
                writer.write(32);
                this.writeFirstRegister(writer);
                writer.write(", ");
                this.writeSecondRegister(writer);
                writer.write(", ");
                this.writeLiteral(writer);
                return true;
            }
            case Format22c: {
                this.writeOpcode(writer);
                writer.write(32);
                this.writeFirstRegister(writer);
                writer.write(", ");
                this.writeSecondRegister(writer);
                writer.write(", ");
                this.writeReference(writer);
                return true;
            }
            case Format22cs: {
                this.writeOpcode(writer);
                writer.write(32);
                this.writeFirstRegister(writer);
                writer.write(", ");
                this.writeSecondRegister(writer);
                writer.write(", ");
                this.writeFieldOffset(writer);
                return true;
            }
            case Format22t: {
                this.writeOpcode(writer);
                writer.write(32);
                this.writeFirstRegister(writer);
                writer.write(", ");
                this.writeSecondRegister(writer);
                writer.write(", ");
                this.writeTargetLabel(writer);
                return true;
            }
            case Format22x: 
            case Format32x: {
                this.writeOpcode(writer);
                writer.write(32);
                this.writeFirstRegister(writer);
                writer.write(", ");
                this.writeSecondRegister(writer);
                return true;
            }
            case Format23x: {
                this.writeOpcode(writer);
                writer.write(32);
                this.writeFirstRegister(writer);
                writer.write(", ");
                this.writeSecondRegister(writer);
                writer.write(", ");
                this.writeThirdRegister(writer);
                return true;
            }
            case Format35c: 
            case Format35s: {
                this.writeOpcode(writer);
                writer.write(32);
                this.writeInvokeRegisters(writer);
                writer.write(", ");
                this.writeReference(writer);
                return true;
            }
            case Format35ms: {
                this.writeOpcode(writer);
                writer.write(32);
                this.writeInvokeRegisters(writer);
                writer.write(", ");
                this.writeVtableIndex(writer);
                return true;
            }
            case Format3rc: {
                this.writeOpcode(writer);
                writer.write(32);
                this.writeInvokeRangeRegisters(writer);
                writer.write(", ");
                this.writeReference(writer);
                return true;
            }
            case Format3rms: {
                this.writeOpcode(writer);
                writer.write(32);
                this.writeInvokeRangeRegisters(writer);
                writer.write(", ");
                this.writeVtableIndex(writer);
                return true;
            }
        }
        assert (false);
        return false;
    }

    protected void writeOpcode(IndentingWriter writer) throws IOException {
        writer.write(((Instruction)this.instruction).opcode.name);
    }

    protected void writeTargetLabel(IndentingWriter writer) throws IOException {
        throw new RuntimeException();
    }

    protected void writeRegister(IndentingWriter writer, int registerNumber) throws IOException {
        RegisterFormatter.writeTo(writer, this.codeItem, registerNumber);
    }

    protected void writeFirstRegister(IndentingWriter writer) throws IOException {
        this.writeRegister(writer, ((SingleRegisterInstruction)this.instruction).getRegisterA());
    }

    protected void writeSecondRegister(IndentingWriter writer) throws IOException {
        this.writeRegister(writer, ((TwoRegisterInstruction)this.instruction).getRegisterB());
    }

    protected void writeThirdRegister(IndentingWriter writer) throws IOException {
        this.writeRegister(writer, ((ThreeRegisterInstruction)this.instruction).getRegisterC());
    }

    protected void writeInvokeRegisters(IndentingWriter writer) throws IOException {
        FiveRegisterInstruction instruction = (FiveRegisterInstruction)this.instruction;
        byte regCount = instruction.getRegCount();
        writer.write(123);
        switch (regCount) {
            case 1: {
                this.writeRegister(writer, instruction.getRegisterD());
                break;
            }
            case 2: {
                this.writeRegister(writer, instruction.getRegisterD());
                writer.write(", ");
                this.writeRegister(writer, instruction.getRegisterE());
                break;
            }
            case 3: {
                this.writeRegister(writer, instruction.getRegisterD());
                writer.write(", ");
                this.writeRegister(writer, instruction.getRegisterE());
                writer.write(", ");
                this.writeRegister(writer, instruction.getRegisterF());
                break;
            }
            case 4: {
                this.writeRegister(writer, instruction.getRegisterD());
                writer.write(", ");
                this.writeRegister(writer, instruction.getRegisterE());
                writer.write(", ");
                this.writeRegister(writer, instruction.getRegisterF());
                writer.write(", ");
                this.writeRegister(writer, instruction.getRegisterG());
                break;
            }
            case 5: {
                this.writeRegister(writer, instruction.getRegisterD());
                writer.write(", ");
                this.writeRegister(writer, instruction.getRegisterE());
                writer.write(", ");
                this.writeRegister(writer, instruction.getRegisterF());
                writer.write(", ");
                this.writeRegister(writer, instruction.getRegisterG());
                writer.write(", ");
                this.writeRegister(writer, instruction.getRegisterA());
            }
        }
        writer.write(125);
    }

    protected void writeInvokeRangeRegisters(IndentingWriter writer) throws IOException {
        RegisterRangeInstruction instruction = (RegisterRangeInstruction)this.instruction;
        short regCount = instruction.getRegCount();
        if (regCount == 0) {
            writer.write("{}");
        } else {
            int startRegister = instruction.getStartRegister();
            RegisterFormatter.writeRegisterRange(writer, this.codeItem, startRegister, startRegister + regCount - 1);
        }
    }

    protected void writeLiteral(IndentingWriter writer) throws IOException {
        LongRenderer.writeSignedIntOrLongTo(writer, ((LiteralInstruction)this.instruction).getLiteral());
    }

    protected void writeFieldOffset(IndentingWriter writer) throws IOException {
        writer.write("field@0x");
        writer.printLongAsHex(((OdexedFieldAccess)this.instruction).getFieldOffset());
    }

    protected void writeVtableIndex(IndentingWriter writer) throws IOException {
        writer.write("vtable@0x");
        writer.printLongAsHex(((OdexedInvokeVirtual)this.instruction).getMethodIndex());
    }

    protected void writeReference(IndentingWriter writer) throws IOException {
        Item item = ((InstructionWithReference)this.instruction).getReferencedItem();
        ReferenceFormatter.writeReference(writer, item);
    }
}

