/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.semantics;

import java.util.HashMap;
import java.util.Map;
import macromedia.asc.embedding.avmplus.ClassBuilder;
import macromedia.asc.embedding.avmplus.InstanceBuilder;
import macromedia.asc.semantics.Builder;
import macromedia.asc.semantics.FlowAnalyzer;
import macromedia.asc.semantics.InterfaceWalker;
import macromedia.asc.semantics.ObjectValue;
import macromedia.asc.semantics.ObjectValueWrapper;
import macromedia.asc.semantics.ParameterizedName;
import macromedia.asc.semantics.QName;
import macromedia.asc.semantics.TypeInfo;
import macromedia.asc.util.Context;
import macromedia.asc.util.Namespaces;

public final class TypeValue
extends ObjectValue {
    public ObjectValue prototype;
    public TypeValue baseclass;
    public boolean is_parameterized;
    public TypeValue indexed_type;
    public QName name;
    public int type_id;
    public boolean resolved;
    private TypeInfo default_typeinfo = null;
    private TypeInfo explicit_nullable_typeinfo = null;
    private TypeInfo explicit_nonnullable_typeinfo = null;
    public boolean is_nullable = true;
    private Map<String, TypeValue> parameterizedTypes;

    public static void init() {
    }

    public static void clear() {
    }

    public static TypeValue defineTypeValue(Context cx, Builder builder, QName name, int type_id) {
        String fullname = name.toString();
        TypeValue type = cx.userDefined(fullname);
        if (type == null) {
            type = new TypeValue(cx, builder, name, type_id);
            cx.setUserDefined(fullname, type);
            type.resolved = true;
        } else {
            type.resolved = true;
            type.clearInstance(cx, builder, null, fullname.intern(), false);
            type.type_id = type_id;
            type.name = name;
            type.type = null;
            type.baseclass = null;
            if (type.default_typeinfo != null) {
                type.default_typeinfo.clearInstance();
            }
            if (type.explicit_nonnullable_typeinfo != null) {
                type.explicit_nonnullable_typeinfo.clearInstance();
            }
            if (type.explicit_nullable_typeinfo != null) {
                type.explicit_nullable_typeinfo.clearInstance();
            }
        }
        return type;
    }

    public static TypeValue getTypeValue(Context cx, QName name) {
        String fullname = name.toString();
        TypeValue type = cx.userDefined(fullname);
        if (type == null) {
            if ("Vector" == name.name && name instanceof ParameterizedName && (type = cx.vectorType().getParameterizedType(fullname)) == null) {
                type = new TypeValue(cx, name);
                ParameterizedName pname = (ParameterizedName)name;
                QName indexed_name = pname.type_params.at(0);
                type.indexed_type = cx.isBuiltin(indexed_name.toString()) ? cx.builtin(indexed_name.toString()) : TypeValue.getTypeValue(cx, pname.type_params.at(0));
                cx.vectorType().addParameterizedType(fullname, type);
            }
            if (type == null) {
                type = new TypeValue(cx, name);
            }
            cx.setUserDefined(fullname, type);
        }
        return type;
    }

    public TypeValue(Context cx, Builder builder, QName name, int type_id) {
        super(cx, builder, null);
        this.type_id = type_id;
        this.prototype = null;
        this.name = name;
        this.type = null;
        this.baseclass = null;
        ((ObjectValue)this).name = this.name.toString();
        this.resolved = false;
    }

    private TypeValue(Context cx, QName name) {
        super((TypeValue)null);
        this.name = name;
        this.resolved = false;
    }

    public TypeInfo getType(Context cx) {
        return cx.typeType().getDefaultTypeInfo();
    }

    public int getTypeId() {
        return this.type_id;
    }

    public String toString() {
        return this.name != null ? this.name.toString() : "";
    }

    public boolean includes(Context cx, TypeValue type) {
        block6: {
            block5: {
                if (this == cx.noType()) {
                    return true;
                }
                if (!this.resolved) {
                    this.resolve(cx);
                }
                if (this.isInterface()) break block5;
                while (type != null) {
                    if (this == type) {
                        return true;
                    }
                    type = type.baseclass;
                }
                break block6;
            }
            if (type == null) break block6;
            InterfaceWalker interfaceWalker = new InterfaceWalker(type);
            while (interfaceWalker.hasNext()) {
                if (interfaceWalker.next().type.getTypeValue() != this) continue;
                return true;
            }
        }
        return false;
    }

    public void build(Context cx, ObjectValue ob) {
    }

    public ObjectValue proto() {
        return null;
    }

    public String getPrintableName() {
        return this.name.name;
    }

    public boolean isNumeric(Context cx) {
        return this == cx.intType() || this == cx.uintType() || this == cx.doubleType() || this == cx.numberType() || cx.statics.es4_numerics && this == cx.decimalType();
    }

    public boolean isDynamic() {
        return false;
    }

    public TypeInfo getDefaultTypeInfo() {
        if (this.default_typeinfo == null) {
            this.default_typeinfo = new TypeInfo(this, this.is_nullable, true);
        }
        return this.default_typeinfo;
    }

    public TypeInfo getTypeInfo(boolean nullable) {
        TypeInfo ti;
        TypeInfo typeInfo = ti = nullable ? this.explicit_nullable_typeinfo : this.explicit_nonnullable_typeinfo;
        if (ti == null) {
            ti = nullable ? (this.explicit_nullable_typeinfo = new TypeInfo(this, nullable, false)) : (this.explicit_nonnullable_typeinfo = new TypeInfo(this, nullable, false));
        }
        if (ti.getPrototype() == this.prototype) {
            ObjectValueWrapper nullable_proto = new ObjectValueWrapper(this.prototype);
            nullable_proto.builder = this.prototype.builder;
            nullable_proto.type = ti;
            ti.setPrototype(nullable_proto);
        }
        return ti;
    }

    public void addParameterizedType(String name, TypeValue typeValue) {
        if (this.parameterizedTypes == null) {
            this.parameterizedTypes = new HashMap<String, TypeValue>();
        }
        this.parameterizedTypes.put(name, typeValue);
    }

    public TypeValue getParameterizedType(String name) {
        TypeValue result = null;
        if (this.parameterizedTypes != null) {
            result = this.parameterizedTypes.get(name);
        }
        return result;
    }

    public void copyInstantiationData(TypeValue uninstantiated_type) {
        this.builder.is_final = uninstantiated_type.builder.is_final;
    }

    protected TypeValue(TypeValue type) {
        super((ObjectValue)type);
        this.type_id = type.type_id;
        this.prototype = new ObjectValue(type.prototype);
        this.name = type.name;
        this.type = type.type;
        this.baseclass = type.baseclass;
    }

    public TypeValue copyType() {
        return new TypeValue(this);
    }

    private boolean resolve(Context cx) {
        if (this.resolved) {
            return true;
        }
        if (this.indexed_type != null) {
            ParameterizedName pname;
            ParameterizedName parameterizedName = pname = this.name instanceof ParameterizedName ? (ParameterizedName)this.name : null;
            if (pname != null) {
                TypeValue.instantiateParameterizedType(cx, pname);
                assert (this.resolved);
            }
        }
        return this.resolved;
    }

    static TypeValue instantiateParameterizedType(Context cx, ParameterizedName pname) {
        ObjectValue iframe;
        TypeValue cframe = TypeValue.getTypeValue(cx, pname);
        if (cframe.resolved) {
            return cframe;
        }
        ObjectValue prot_ns = cx.getNamespace(pname.toString(), (byte)3);
        ObjectValue static_prot_ns = cx.getNamespace(pname.toString(), (byte)5);
        cframe = TypeValue.defineTypeValue(cx, new ClassBuilder(pname, prot_ns, static_prot_ns), pname, 8192);
        cframe.type = cx.typeType().getDefaultTypeInfo();
        cframe.prototype = iframe = new ObjectValue(cx, new InstanceBuilder(pname), cframe);
        TypeValue uninstantiated_generic = cx.vectorObjType();
        FlowAnalyzer.inheritClassSlotsStatic(cframe, iframe, uninstantiated_generic, cx);
        cframe.copyInstantiationData(uninstantiated_generic);
        return cframe;
    }

    public boolean hasName(Context cx, int kind, String name, ObjectValue qualifier) {
        if (!this.resolved) {
            this.resolve(cx);
        }
        return super.hasName(cx, kind, name, qualifier);
    }

    public boolean hasNameUnqualified(Context cx, String name, int kind) {
        if (!this.resolved) {
            this.resolve(cx);
        }
        return super.hasNameUnqualified(cx, name, kind);
    }

    public Namespaces hasNames(Context cx, int kind, String name, Namespaces namespaces, boolean search_base_objs) {
        if (!this.resolved) {
            this.resolve(cx);
        }
        return super.hasNames(cx, kind, name, namespaces, search_base_objs);
    }
}

