/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.embedding.avmplus;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import macromedia.abc.BytecodeBuffer;
import macromedia.asc.embedding.avmplus.ByteCodeFactory;
import macromedia.asc.embedding.avmplus.ClassBuilder;
import macromedia.asc.embedding.avmplus.DebugInfo;
import macromedia.asc.embedding.avmplus.InstanceBuilder;
import macromedia.asc.embedding.avmplus.RuntimeConstants;
import macromedia.asc.parser.LiteralNumberNode;
import macromedia.asc.parser.MetaDataEvaluator;
import macromedia.asc.semantics.Builder;
import macromedia.asc.semantics.Emitter;
import macromedia.asc.semantics.MetaData;
import macromedia.asc.semantics.MethodSlot;
import macromedia.asc.semantics.NamespaceValue;
import macromedia.asc.semantics.ObjectValue;
import macromedia.asc.semantics.ParameterizedName;
import macromedia.asc.semantics.QName;
import macromedia.asc.semantics.ReferenceValue;
import macromedia.asc.semantics.Slot;
import macromedia.asc.semantics.TypeInfo;
import macromedia.asc.semantics.TypeValue;
import macromedia.asc.semantics.Value;
import macromedia.asc.semantics.VariableSlot;
import macromedia.asc.util.APIVersions;
import macromedia.asc.util.ByteList;
import macromedia.asc.util.Context;
import macromedia.asc.util.Decimal128;
import macromedia.asc.util.DecimalNumberConstant;
import macromedia.asc.util.DoubleNumberConstant;
import macromedia.asc.util.IntList;
import macromedia.asc.util.IntNumberConstant;
import macromedia.asc.util.IntegerPool;
import macromedia.asc.util.Names;
import macromedia.asc.util.Namespaces;
import macromedia.asc.util.NumberConstant;
import macromedia.asc.util.NumberUsage;
import macromedia.asc.util.ObjectList;
import macromedia.asc.util.Qualifiers;
import macromedia.asc.util.Slots;
import macromedia.asc.util.UintNumberConstant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionBlockEmitter
extends Emitter {
    public static final int MAJOR = 46;
    public static final int MINOR = 16;
    private ActionBlock ab;
    private Context cx;
    private ByteCodeFactory bytecodeFactory;
    protected int max_locals;
    protected int cur_locals;
    protected int max_stack;
    protected int cur_stack;
    protected int max_scope;
    protected int cur_scope;
    protected int max_params;
    protected String scriptname;
    protected String modulename;
    protected ObjectList<ExceptionBlock> exceptionBlocks = new ObjectList();
    protected IntList if_addrs = new IntList();
    protected IntList try_addrs = new IntList();
    protected IntList else_addrs = new IntList();
    protected IntList loopbegin_addrs = new IntList();
    protected ObjectList<IntList> break_addrs = new ObjectList();
    protected IntList break_scope_depth = new IntList();
    protected IntList break_temp_count = new IntList();
    protected ObjectList<IntList> continue_addrs = new ObjectList();
    protected IntList continue_scope_depth = new IntList();
    protected IntList switchbegin_addrs = new IntList();
    protected ObjectList<IntList> case_addrs = new ObjectList();
    protected IntList default_addrs = new IntList();
    protected IntList seen_default_case = new IntList();
    private boolean sets_dxns;
    private Map<ObjectValue, Integer> nsConstants = new HashMap<ObjectValue, Integer>();
    protected ObjectList<String> method_infos = new ObjectList();
    protected Map<String, Integer> method_infos_map = new HashMap<String, Integer>();
    protected ObjectList<String> metadata_infos = new ObjectList();
    protected Map<String, Integer> metadata_infos_map = new HashMap<String, Integer>();
    protected ObjectList<QName> class_infos = new ObjectList();
    protected ObjectList<String> package_infos = new ObjectList();
    protected ObjectList<String> global_method_names = new ObjectList();
    private static final long MAXUINT = 0xFFFFFFFFL;
    private static Decimal128 D128_SIXTEEN = null;
    private static Decimal128[] D128_HEXDIGIT = null;
    IntList stackDepthStack = new IntList();
    IntList scopeDepthStack = new IntList();
    static final int IKIND_push = 1;
    static final int IKIND_other = 2;
    static final int IKIND_coerce = 3;
    protected int last_in;
    protected int last_ip;
    static final int DI_BAD = 0;
    static final int DI_LOCAL = 1;
    private boolean doingAPIVersioning = false;
    public boolean show_instructions;
    public boolean show_linenums;
    public boolean show_stacknames;
    public boolean emit_debug_info;
    private DebugInfo debug_info = new DebugInfo();
    private PrintWriter code_out;
    private PrintWriter header_out;
    public int native_method_count = 0;
    public int native_class_count = 0;
    public int native_package_count = 1;

    int addClassName(QName name) {
        if (name == null || name.toString().equals("*")) {
            return 0;
        }
        String classname_string = name.name;
        int namespace_index = this.addNamespace(name.ns);
        int name_index = this.ab.addUtf8Constant(this.bytecodeFactory.ConstantUtf8Info(classname_string));
        int qname_index = this.ab.addMultiNameConstant(this.bytecodeFactory.ConstantQualifiedName(name_index, namespace_index, false));
        if (name instanceof ParameterizedName) {
            ParameterizedName pname = (ParameterizedName)name;
            IntList params = new IntList(pname.type_params.size());
            int n = pname.type_params.size();
            for (int i = 0; i < n; ++i) {
                params.add(this.addClassName(pname.type_params.at(i)));
            }
            qname_index = this.ab.addMultiNameConstant(this.bytecodeFactory.ConstantTypeName(qname_index, params));
        }
        return qname_index;
    }

    int addNamespace(ObjectValue ns) {
        return this.addNamespace(ns, -1);
    }

    String markURI(ObjectValue ns, int v) {
        if (v < 0 || !this.isVersionedNamespace(ns)) {
            return ns.name;
        }
        String uri = ns.name + (char)(57344 + v);
        return uri;
    }

    private String formatNSKind(ObjectValue ns) {
        switch (ns.getNamespaceKind()) {
            case 2: {
                return "private";
            }
            case 3: 
            case 5: {
                return "protected";
            }
            case 1: {
                return "internal";
            }
        }
        return "public";
    }

    boolean isVersionedNamespace(ObjectValue ns) {
        switch (ns.getNamespaceKind()) {
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            default: {
                if (!this.cx.isVersionedURI(ns.name)) break;
                return true;
            }
        }
        return false;
    }

    int addNamespace(ObjectValue ns, int v) {
        int namespace_index;
        if (ns == this.cx.anyNamespace()) {
            return 0;
        }
        String uri = this.markURI(ns, v);
        int namespace_name_index = this.ab.addUtf8Constant(this.bytecodeFactory.ConstantUtf8Info(uri));
        if (ns.isPackage()) {
            namespace_index = this.ab.addNsConstant(this.bytecodeFactory.ConstantPackageNamespace(namespace_name_index));
        } else {
            switch (ns.getNamespaceKind()) {
                case 1: {
                    namespace_index = this.ab.addNsConstant(this.bytecodeFactory.ConstantInternalNamespace(namespace_name_index));
                    break;
                }
                case 2: {
                    namespace_index = this.ab.addNsConstant(this.bytecodeFactory.ConstantPrivateNamespace(namespace_name_index));
                    break;
                }
                case 3: {
                    namespace_index = this.ab.addNsConstant(this.bytecodeFactory.ConstantProtectedNamespace(namespace_name_index));
                    break;
                }
                case 5: {
                    namespace_index = this.ab.addNsConstant(this.bytecodeFactory.ConstantStaticProtectedNamespace(namespace_name_index));
                    break;
                }
                default: {
                    namespace_index = this.ab.addNsConstant(this.bytecodeFactory.ConstantNamespace(namespace_name_index));
                }
            }
        }
        this.nsConstants.put(ns, namespace_index);
        return namespace_index;
    }

    int makeNamespaceSet(ObjectList<ObjectValue> namespaces) {
        TreeSet<Integer> namespace_set = new TreeSet<Integer>();
        for (ObjectValue ns : namespaces) {
            if (ns != null) {
                int ns_index = this.addNamespace(ns);
                namespace_set.add(IntegerPool.getNumber(ns_index));
                continue;
            }
            this.cx.internalError("internal error: non object value for namespace");
        }
        int ns_set_index = this.ab.addNsSetConstant(this.bytecodeFactory.ConstantNamespaceSet(namespace_set));
        return ns_set_index;
    }

    int makeVersionedNamespaceSet(ObjectValue ns, TreeSet<Integer> versions) {
        TreeSet<Integer> namespace_set = new TreeSet<Integer>();
        if (versions.size() == 0) {
            this.cx.internalError("internal error: empty versions set");
        } else {
            for (Integer v : versions) {
                if (ns != null) {
                    int ns_index = this.addNamespace(ns, v);
                    namespace_set.add(IntegerPool.getNumber(ns_index));
                    continue;
                }
                this.cx.internalError("internal error: non object value for namespace");
            }
        }
        int ns_set_index = this.ab.addNsSetConstant(this.bytecodeFactory.ConstantNamespaceSet(namespace_set));
        return ns_set_index;
    }

    int makeMultiname(String name, ObjectList<ObjectValue> namespaces) {
        int name_index = this.ab.addUtf8Constant(this.bytecodeFactory.ConstantUtf8Info(name));
        int namespaces_set = this.makeNamespaceSet(namespaces);
        int mname_index = this.ab.addMultiNameConstant(this.bytecodeFactory.ConstantMultiname(name_index, namespaces_set, false));
        return mname_index;
    }

    @Override
    protected void StartClass(String filename) {
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("// ++StartClass " + filename);
        }
        this.showLineNumber();
    }

    @Override
    protected void FinishClass(Context cx, QName name, QName basename, boolean is_dynamic, boolean is_final, boolean is_interface, boolean is_nullable) {
        int protected_index;
        Builder bui;
        ObjectValue obj;
        ObjectList<ByteList> static_traits = new ObjectList<ByteList>();
        ObjectList<ByteList> instance_traits = new ObjectList<ByteList>();
        IntList interfaces = new IntList();
        int scope_depth = cx.getScopes().size();
        ObjectValue protected_namespace = null;
        if (!is_interface) {
            obj = cx.scope(scope_depth - 2);
            bui = obj.builder;
            protected_namespace = ((ClassBuilder)bui).protected_namespace;
            this.FinishTraits(obj, static_traits);
        }
        obj = cx.scope(scope_depth - 1);
        bui = obj.builder instanceof InstanceBuilder ? (InstanceBuilder)obj.builder : null;
        for (ReferenceValue ref : ((InstanceBuilder)bui).interface_refs) {
            interfaces.add(this.makeMultiname(ref.name, ref.getImmutableNamespaces()));
        }
        this.FinishTraits(obj, instance_traits);
        int qname_index = this.addClassName(name);
        int base_index = basename == null ? 0 : this.addClassName(basename);
        int iinit_info = 0;
        ObjectValue obj2 = cx.scope();
        int slot_id = obj2.getSlotIndex(cx, -79, "$construct", cx.publicNamespace());
        slot_id = obj2.getImplicitIndex(cx, slot_id, -133);
        Slot slot = obj2.getSlot(cx, slot_id);
        iinit_info = this.GetMethodInfo(slot.getMethodName());
        int class_info = this.GetClassInfo(name);
        int flags = 0;
        if (!is_dynamic) {
            flags |= 1;
        }
        if (is_final) {
            flags |= 2;
        }
        if (is_interface) {
            flags |= 4;
        }
        if (!is_nullable) {
            flags |= 0x10;
        }
        int n = protected_index = protected_namespace != null ? this.addNamespace(protected_namespace) : 0;
        if (protected_index != 0) {
            flags |= 8;
        }
        this.ab.addBytesToTable(this.ab.instances, this.bytecodeFactory.InstanceInfo(this.ab.instances.at(class_info), qname_index, base_index, flags, protected_index, interfaces.size(), interfaces, iinit_info, instance_traits, class_info));
        int cinit_info = this.GetMethodInfo(name + "$cinit");
        this.ab.addBytesToTable(this.ab.classes, this.bytecodeFactory.ClassInfo(this.ab.classes.at(class_info), cinit_info, static_traits, class_info));
        String constName = name.toString().replace('.', '_');
        constName = constName.replace('/', '_');
        constName = constName.replace(':', '_');
        constName = constName.replace('|', '_');
        constName = constName.replace('$', '_');
        this.header_out.println("const int abcclass_" + constName + " = " + class_info + ";");
        if (class_info >= this.native_class_count) {
            this.native_class_count = class_info + 1;
        }
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("// --FinishClass " + name + " " + (basename != null ? basename.toString() : ""));
        }
        this.showLineNumber();
    }

    @Override
    protected void StartProgram(String name) {
        this.modulename = name;
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("// ++StartProgram " + this.modulename);
        }
    }

    @Override
    public ByteList emit(ByteList bytes) {
        return this.bytecodeFactory.ActionBlock(bytes, this.ab.minor_version, this.ab.major_version, this.ab.constant_int_pool.size() == 0 ? 0 : this.ab.constant_int_pool.size() + 1, this.ab.constant_int_pool, this.ab.constant_uint_pool.size() == 0 ? 0 : this.ab.constant_uint_pool.size() + 1, this.ab.constant_uint_pool, this.ab.constant_double_pool.size() == 0 ? 0 : this.ab.constant_double_pool.size() + 1, this.ab.constant_double_pool, this.ab.constant_decimal_pool.size() == 0 ? 0 : this.ab.constant_decimal_pool.size() + 1, this.ab.constant_decimal_pool, this.ab.constant_utf8_pool.size() == 0 ? 0 : this.ab.constant_utf8_pool.size() + 1, this.ab.constant_utf8_pool, this.ab.constant_mn_pool.size() == 0 ? 0 : this.ab.constant_mn_pool.size() + 1, this.ab.constant_mn_pool, this.ab.constant_nss_pool.size() == 0 ? 0 : this.ab.constant_nss_pool.size() + 1, this.ab.constant_nss_pool, this.ab.constant_ns_pool.size() == 0 ? 0 : this.ab.constant_ns_pool.size() + 1, this.ab.constant_ns_pool, this.ab.methods.size() == 0 ? 0 : this.ab.methods.size(), this.ab.methods, this.ab.metadata.size() == 0 ? 0 : this.ab.metadata.size(), this.ab.metadata, this.ab.classes.size() == 0 ? 0 : this.ab.classes.size(), this.ab.instances, this.ab.classes, this.ab.scripts.size() == 0 ? 0 : this.ab.scripts.size(), this.ab.scripts, this.ab.bodies.size() == 0 ? 0 : this.ab.bodies.size(), this.ab.bodies);
    }

    int getValueIndex(ObjectValue objValue) {
        int value_index = 0;
        String value = objValue.toString();
        TypeValue defaultValueType = objValue.type != null ? objValue.type.getTypeValue() : null;
        NumberUsage numberUsage = objValue.getNumberUsage();
        if (defaultValueType == this.cx.booleanType()) {
            value_index = value.equals("true") ? 11 : 10;
        } else if (defaultValueType == this.cx.stringType()) {
            value_index = this.ab.addUtf8Constant(this.bytecodeFactory.ConstantUtf8Info(value));
        } else if (defaultValueType == this.cx.intType()) {
            TypeValue[] type = new TypeValue[1];
            value_index = this.ab.addIntConstant(this.bytecodeFactory.ConstantIntegerInfo(this.getValueOfNumberLiteral(value, type, numberUsage).intValue()));
        } else if (defaultValueType == this.cx.doubleType() || this.cx.abcVersion(0) && defaultValueType == this.cx.uintType()) {
            TypeValue[] type = new TypeValue[1];
            value_index = this.ab.addDoubleConstant(this.bytecodeFactory.ConstantDoubleInfo(this.getValueOfNumberLiteral(value, type, numberUsage).doubleValue()));
        } else if (defaultValueType == this.cx.uintType()) {
            TypeValue[] type = new TypeValue[1];
            value_index = this.ab.addUintConstant(this.bytecodeFactory.ConstantUintInfo(this.getValueOfNumberLiteral(value, type, numberUsage).uintValue()));
        } else if (this.cx.statics.es4_numerics && defaultValueType == this.cx.decimalType()) {
            TypeValue[] type = new TypeValue[1];
            value_index = this.ab.addDecimalConstant(this.bytecodeFactory.ConstantDecimalInfo(this.getValueOfNumberLiteral(value, type, numberUsage).decimalValue()));
        } else if (defaultValueType == this.cx.nullType()) {
            value_index = 12;
        } else if (defaultValueType == this.cx.voidType()) {
            value_index = 0;
        } else if (this.cx.isNamespace(objValue)) {
            value_index = this.addNamespace(objValue);
        }
        return value_index;
    }

    byte getValueKind(ObjectValue objValue) {
        TypeValue defaultValueType;
        int value_kind = 0;
        String value = objValue.toString();
        TypeValue typeValue = defaultValueType = objValue.type != null ? objValue.type.getTypeValue() : null;
        if (defaultValueType == this.cx.booleanType()) {
            value_kind = value.equals("true") ? 11 : 10;
        } else if (defaultValueType == this.cx.stringType()) {
            value_kind = 1;
        } else if (defaultValueType == this.cx.intType()) {
            value_kind = 3;
        } else if (defaultValueType == this.cx.doubleType() || this.cx.abcVersion(0) && defaultValueType == this.cx.uintType()) {
            value_kind = 6;
        } else if (defaultValueType == this.cx.uintType()) {
            value_kind = 4;
        } else if (this.cx.statics.es4_numerics && defaultValueType == this.cx.decimalType()) {
            value_kind = 2;
        } else if (defaultValueType == this.cx.nullType()) {
            value_kind = 12;
        } else if (defaultValueType == this.cx.voidType()) {
            value_kind = 12;
        } else if (this.cx.isNamespace(objValue)) {
            value_kind = 8;
        }
        return (byte)value_kind;
    }

    @Override
    protected void DefineSlotVariable(Context cx, String name, String func_name, int pos, TypeInfo type, int slotIndex) {
        if (this.emit_debug_info) {
            this.DebugSlot(name, slotIndex, this.debug_info.debug_linenum);
        }
    }

    @Override
    protected void StartMethod() {
        this.StartMethod("", 0, 0, 0, false, 0);
    }

    @Override
    protected void StartMethod(String name, int param_count, int local_count, int temp_count, boolean needs_activation, int needs_arguments) {
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("// ++StartMethod " + name);
        }
        this.max_stack = 0;
        this.cur_stack = 0;
        this.max_scope = 0;
        this.cur_scope = 0;
        this.max_params = param_count + 1;
        this.cur_locals = !needs_activation ? (this.max_locals = param_count + local_count + temp_count + 1) : (this.max_locals = param_count + temp_count + (needs_arguments != 0 ? 1 : 0) + 1);
        this.ab.code = ByteCodeFactory.allocBytes();
        this.last_in = 2;
        if (name.equals("$init")) {
            this.method_infos_map.remove(name);
        }
        this.GetMethodInfo(name);
        this.debug_info.debug_file_dirty = true;
        this.debug_info.debug_linenum_dirty = true;
        this.debug_info.suppress_debug_method = name.indexOf("$iinit") != -1 || name.indexOf("$cinit") != -1;
        this.sets_dxns = false;
    }

    @Override
    protected int FinishMethod(Context cx, String name, TypeInfo type, ObjectList<TypeInfo> types, ObjectValue activation, int needs_arguments, int scope_depth, String debug_name, boolean is_native, boolean is_interface, String[] arg_names) {
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("// --FinishMethod " + name + " " + debug_name);
        }
        this.showLineNumber();
        int method_info = this.GetMethodInfo(name);
        ObjectList<ByteList> traits = new ObjectList<ByteList>();
        if (activation != null) {
            ObjectValue obj = activation;
            this.FinishTraits(obj, traits);
        }
        int flags = 0;
        flags |= needs_arguments;
        flags |= activation != null ? 2 : 0;
        int debug_name_index = this.ab.addUtf8Constant(this.bytecodeFactory.ConstantUtf8Info(this.emit_debug_info ? debug_name : ""));
        if (is_native) {
            flags |= 0x20;
        }
        if (this.sets_dxns) {
            flags |= 0x40;
        }
        int return_type = type != null ? this.addClassName(type.getName(cx)) : 0;
        IntList param_types = null;
        IntList param_values = null;
        ByteList param_kinds = null;
        ObjectValue obj = cx.scope();
        Slots slots = obj.slots;
        if (slots != null) {
            param_types = new IntList(slots.size());
            param_values = new IntList(slots.size());
            param_kinds = new ByteList(slots.size());
            Iterator it = slots.iterator();
            boolean value_required = false;
            for (int i = 1; it.hasNext() && i < this.max_params; ++i) {
                Slot slot = (Slot)it.next();
                int type_index = this.addClassName(slot.getType().getName(cx));
                param_types.add(type_index);
                int value_index = 0;
                int value_kind = 0;
                ObjectValue iv = slot.getInitializerValue();
                if (iv != null) {
                    TypeValue defaultValueType;
                    value_required = true;
                    String value = iv.toString();
                    NumberUsage numberUsage = iv.getNumberUsage();
                    TypeValue typeValue = defaultValueType = slot.getInitializerValue().type != null ? slot.getInitializerValue().type.getTypeValue() : null;
                    if (defaultValueType == cx.booleanType()) {
                        value_index = value.equals("true") ? 11 : 10;
                        value_kind = value.equals("true") ? 11 : 10;
                    } else if (defaultValueType == cx.stringType()) {
                        value_index = this.ab.addUtf8Constant(this.bytecodeFactory.ConstantUtf8Info(value));
                        value_kind = 1;
                    } else if (defaultValueType == cx.intType()) {
                        value_index = this.ab.addIntConstant(this.bytecodeFactory.ConstantIntegerInfo(this.getValueOfNumberLiteral(value, new TypeValue[1], numberUsage).intValue()));
                        value_kind = 3;
                    } else if (defaultValueType == cx.doubleType() || cx.abcVersion(0) && defaultValueType == cx.uintType()) {
                        value_index = this.ab.addDoubleConstant(this.bytecodeFactory.ConstantDoubleInfo(this.getValueOfNumberLiteral(value, new TypeValue[1], numberUsage).doubleValue()));
                        value_kind = 6;
                    } else if (defaultValueType == cx.uintType()) {
                        value_index = this.ab.addUintConstant(this.bytecodeFactory.ConstantUintInfo(this.getValueOfNumberLiteral(value, new TypeValue[1], numberUsage).uintValue()));
                        value_kind = 4;
                    } else if (cx.statics.es4_numerics && defaultValueType == cx.decimalType()) {
                        value_index = this.ab.addDecimalConstant(this.bytecodeFactory.ConstantDecimalInfo(this.getValueOfNumberLiteral(value, new TypeValue[1], numberUsage).decimalValue()));
                        value_kind = 2;
                    } else if (defaultValueType == cx.nullType()) {
                        value_index = 12;
                        value_kind = 12;
                    } else if (defaultValueType == cx.voidType()) {
                        value_index = 0;
                        value_kind = 0;
                    } else if (slot.getInitializerValue() instanceof NamespaceValue) {
                        value_index = this.addNamespace(slot.getInitializerValue());
                        value_kind = 8;
                    }
                }
                if (!value_required) continue;
                param_values.add(value_index);
                param_kinds.add((byte)value_kind);
            }
            if (value_required) {
                flags |= 8;
            }
        }
        IntList param_names = null;
        if (this.emit_debug_info && arg_names != null) {
            flags |= 0x80;
            param_names = new IntList(arg_names.length);
            for (int x = 0; x < arg_names.length; ++x) {
                param_names.add(this.ab.addUtf8Constant(this.bytecodeFactory.ConstantUtf8Info(arg_names[x])));
            }
        }
        this.bytecodeFactory.MethodInfo(this.ab.methods.at(method_info), this.max_params - 1, return_type, param_types, param_values, param_kinds, param_names, debug_name_index, flags, method_info);
        if (!is_native) {
            if (!is_interface) {
                this.ab.addBody(this.bytecodeFactory.MethodBody(ByteCodeFactory.allocBytes(), (short)this.max_stack, this.max_locals, scope_depth, scope_depth + this.max_scope, this.ab.code.size(), this.ab.code, this.ab.exception_count, this.ab.exception_table, traits, method_info));
            }
        } else {
            String constName = debug_name.replace('.', '_');
            constName = constName.replace('/', '_');
            constName = constName.replace(':', '_');
            constName = constName.replace('|', '_');
            constName = constName.replace('$', '_');
            this.header_out.println("const int " + constName + " = " + method_info + ";");
            if (method_info >= this.native_method_count) {
                this.native_method_count = method_info + 1;
            }
        }
        this.max_locals = 0;
        this.cur_locals = 0;
        this.ab.exception_count = 0;
        this.ab.exception_table.clear();
        this.clearPositionInfo();
        return method_info;
    }

    protected void MakeDispatchMethod(Context cx) {
    }

    @Override
    public int GetMethodInfo(String name) {
        Integer id = this.method_infos_map.get(name);
        if (id != null) {
            return id;
        }
        id = this.method_infos.size();
        this.method_infos_map.put(name, id);
        this.method_infos.add(name);
        this.ab.methods.add(ByteCodeFactory.allocBytes());
        if (this.method_infos.size() != this.ab.methods.size()) {
            this.cx.internalError("internal error: internal method name and info out of sync");
        }
        return id;
    }

    public int GetMetadataInfo(String name) {
        Integer id = this.metadata_infos_map.get(name);
        if (id != null) {
            return id;
        }
        id = this.metadata_infos_map.size();
        this.metadata_infos_map.put(name, id);
        this.metadata_infos.add(name);
        this.ab.metadata.add(ByteCodeFactory.allocBytes());
        if (this.metadata_infos.size() != this.ab.metadata.size()) {
            this.cx.internalError("internal error: internal metadata name and info out of sync");
        }
        return id;
    }

    public int GetClassInfo(QName name) {
        int i;
        for (i = 0; i < this.class_infos.size(); ++i) {
            if (!((QName)this.class_infos.get(i)).equals(name)) continue;
            return i;
        }
        this.class_infos.push_back(name);
        this.ab.classes.push_back(ByteCodeFactory.allocBytes());
        this.ab.instances.push_back(ByteCodeFactory.allocBytes());
        if (this.class_infos.size() != this.ab.classes.size()) {
            this.cx.internalError("internal error: internal class name and info out of sync");
        }
        return i;
    }

    public int GetPackageInfo(String name) {
        return this.GetPackageInfo(name, false);
    }

    public int GetPackageInfo(String name, boolean dont_add) {
        int i;
        for (i = 0; i < this.package_infos.size(); ++i) {
            if (!((String)this.package_infos.get(i)).equals(name)) continue;
            return i;
        }
        if (dont_add) {
            return -1;
        }
        this.package_infos.push_back(name);
        this.ab.scripts.push_back(ByteCodeFactory.allocBytes());
        if (this.package_infos.size() != this.ab.scripts.size()) {
            this.cx.internalError("internal error: internal class name and info out of sync");
        }
        return i;
    }

    @Override
    public int GetMethodId(String name, Namespaces unused) {
        int n = this.global_method_names.size();
        for (int i = 0; i < n; ++i) {
            if (!name.equals(this.global_method_names.get(i))) continue;
            return i + 1;
        }
        this.global_method_names.add(name);
        return this.global_method_names.size();
    }

    protected String GetMethodName(int n) {
        if (n > 0 && n <= this.global_method_names.size()) {
            return (String)this.global_method_names.get(n - 1);
        }
        this.cx.internalError("invalid method name");
        return "";
    }

    protected String getBinaryName(int op_index) {
        switch (op_index) {
            case 1: {
                return "BinaryPlusOp_II";
            }
            case 0: {
                return "BinaryPlusOp";
            }
            case 2: {
                return "BinaryMinusOp";
            }
            case 3: {
                return "BinaryMinusOp_II";
            }
            case 4: {
                return "MultiplyOp";
            }
            case 5: {
                return "MultiplyOp_II";
            }
            case 6: {
                return "DivideOp";
            }
            case 8: {
                return "ModulusOp";
            }
            case 10: {
                return "LeftShiftOp";
            }
            case 11: {
                return "LeftShiftOp_II";
            }
            case 12: {
                return "RightShiftOp";
            }
            case 13: {
                return "RightShiftOp_II";
            }
            case 14: {
                return "UnsignedRightShiftOp";
            }
            case 15: {
                return "UnsignedRightShiftOp_II";
            }
            case 16: {
                return "LessThanOp";
            }
            case 18: {
                return "GreaterThanOp";
            }
            case 20: {
                return "LessThanOrEqualOp";
            }
            case 22: {
                return "GreaterThanOrEqualOp";
            }
            case 24: {
                return "InstanceofOp";
            }
            case 25: {
                return "InOp";
            }
            case 29: {
                return "EqualsOp_II";
            }
            case 28: {
                return "EqualsOp";
            }
            case 31: {
                return "NotEqualsOp_II";
            }
            case 30: {
                return "NotEqualsOp";
            }
            case 32: {
                return "StrictEqualsOp";
            }
            case 33: {
                return "StrictEqualsOp_II";
            }
            case 34: {
                return "StrictNotEqualsOp";
            }
            case 35: {
                return "StrictNotEqualsOp_II";
            }
            case 36: {
                return "BitwiseAndOp";
            }
            case 37: {
                return "BitwiseAndOp_II";
            }
            case 38: {
                return "BitwiseXorOp";
            }
            case 39: {
                return "BitwiseXorOp_II";
            }
            case 40: {
                return "BitwiseOrOp";
            }
            case 41: {
                return "BitwiseOrOp_II";
            }
            case 42: {
                return "LogicalAndOp";
            }
            case 43: {
                return "LogicalAndOp_II";
            }
            case 45: {
                return "LogicalOrOp";
            }
            case 46: {
                return "LogicalOrOp_II";
            }
            case 27: {
                return "IsLateOp";
            }
            case 26: {
                return "IsOp";
            }
            case 49: {
                return "AsLateOp";
            }
            case 48: {
                return "AsOp";
            }
        }
        return "N/A";
    }

    private final int unHex(char c) {
        return Character.digit(c, 16);
    }

    private NumberConstant getDecimalValueOrInt(String str, boolean force, TypeValue[] ppType) {
        Decimal128 dval;
        if (str.equals("NaN")) {
            ppType[0] = this.cx.decimalType();
            return new DecimalNumberConstant(Decimal128.NaN);
        }
        if (str.equals("Infinity")) {
            ppType[0] = this.cx.decimalType();
            return new DecimalNumberConstant(Decimal128.INFINITY);
        }
        if (str.equals("-Infinity")) {
            ppType[0] = this.cx.decimalType();
            return new DecimalNumberConstant(Decimal128.NEGINFINITY);
        }
        boolean isInt = false;
        if ((str.indexOf(".") > -1 || str.indexOf("e") > -1 || str.indexOf("E") > -1 || str.length() > 10) && str.indexOf("x") <= -1 && str.indexOf("X") <= -1) {
            dval = new Decimal128(str);
        } else {
            char c0;
            isInt = true;
            int base = 10;
            int startIndex = 0;
            int len = str.length();
            boolean negative = false;
            if (len > 1 && ((c0 = str.charAt(startIndex)) == '-' || c0 == '+')) {
                ++startIndex;
                if (c0 == '-') {
                    negative = true;
                }
            }
            if (len > 2 && str.charAt(startIndex) == '0' && ((c0 = str.charAt(++startIndex)) == 'x' || c0 == 'X')) {
                base = 16;
                ++startIndex;
            }
            while (startIndex < len - 1 && str.charAt(startIndex) == '0') {
                ++startIndex;
            }
            if (base == 10) {
                String str2 = str.substring(startIndex, len);
                dval = new Decimal128(str2);
            } else {
                if (D128_HEXDIGIT == null) {
                    D128_HEXDIGIT = new Decimal128[16];
                    for (int ndx = 0; ndx < 16; ++ndx) {
                        ActionBlockEmitter.D128_HEXDIGIT[ndx] = new Decimal128(ndx);
                    }
                    D128_SIXTEEN = new Decimal128(16);
                }
                dval = Decimal128.ZERO;
                for (int end = startIndex; end < len; ++end) {
                    int newDigit = this.unHex(str.charAt(end));
                    dval = D128_SIXTEEN.multiply(dval).add(D128_HEXDIGIT[newDigit]);
                }
            }
            if (negative) {
                if (dval.equals(Decimal128.ZERO)) {
                    dval = Decimal128.NEGZERO;
                    isInt = false;
                } else {
                    dval = Decimal128.ZERO.subtract(dval);
                }
            }
        }
        if (!force && isInt) {
            long ival = dval.longValue();
            if (Integer.MIN_VALUE <= ival && ival <= Integer.MAX_VALUE) {
                ppType[0] = this.cx.intType();
                return new IntNumberConstant((int)ival);
            }
            if (0L <= ival && ival <= 0xFFFFFFFFL) {
                ppType[0] = this.cx.uintType();
                return new UintNumberConstant(ival);
            }
        }
        ppType[0] = this.cx.decimalType();
        if (dval.isNaN()) {
            dval = Decimal128.NaN;
        } else if (!dval.isFinite()) {
            dval = str.charAt(0) == '-' ? Decimal128.NEGINFINITY : Decimal128.INFINITY;
        }
        return new DecimalNumberConstant(dval);
    }

    private NumberConstant getDoubleValueOrInt(String str, boolean force, TypeValue[] ppType) {
        Double d;
        double sum = 0.0;
        if (str.equals("NaN")) {
            ppType[0] = this.cx.doubleType();
            return new DoubleNumberConstant(Double.NaN);
        }
        if (str.equals("Infinity")) {
            ppType[0] = this.cx.doubleType();
            return new DoubleNumberConstant(Double.POSITIVE_INFINITY);
        }
        if (str.equals("-Infinity")) {
            ppType[0] = this.cx.doubleType();
            return new DoubleNumberConstant(Double.NEGATIVE_INFINITY);
        }
        boolean isInt = false;
        if ((str.indexOf(".") > -1 || str.indexOf("e") > -1 || str.indexOf("E") > -1 || str.length() > 10) && str.indexOf("x") <= -1 && str.indexOf("X") <= -1) {
            d = Double.valueOf(str);
            sum = d;
        } else {
            char c0;
            isInt = true;
            int base = 10;
            int startIndex = 0;
            int len = str.length();
            boolean negative = false;
            if (len > 1 && ((c0 = str.charAt(0)) == '-' || c0 == '+')) {
                ++startIndex;
                if (c0 == '-') {
                    negative = true;
                }
            }
            if (len > 2 && str.charAt(startIndex) == '0' && ((c0 = str.charAt(++startIndex)) == 'x' || c0 == 'X')) {
                base = 16;
                ++startIndex;
            }
            while (startIndex < len - 1 && str.charAt(startIndex) == '0') {
                ++startIndex;
            }
            String str2 = str.substring(startIndex, len);
            len -= startIndex;
            startIndex = 0;
            int newDigit = 0;
            boolean roundUp = false;
            switch (base) {
                case 10: {
                    for (int end = startIndex; end < len; ++end) {
                        newDigit = str2.charAt(end) - 48;
                        sum = sum * (double)base + (double)newDigit;
                    }
                    if (!(sum > 2.147483647E9)) break;
                    d = Double.valueOf(str2);
                    sum = d;
                    break;
                }
                case 16: {
                    int end;
                    for (end = startIndex; end * 4 < 53 && end < len; ++end) {
                        newDigit = this.unHex(str2.charAt(end));
                        sum = sum * (double)base + (double)newDigit;
                    }
                    if (end >= len) break;
                    int bit53 = newDigit & 1;
                    newDigit = this.unHex(str2.charAt(end));
                    int bit54 = (newDigit & 8) >> 3;
                    roundUp = (newDigit & 7) != 0;
                    double factor = base;
                    while (++end < len) {
                        newDigit = this.unHex(str2.charAt(end));
                        roundUp |= newDigit != 0;
                        factor *= (double)base;
                    }
                    roundUp = bit54 != 0 && (bit53 != 0 || roundUp);
                    sum += roundUp ? 1.0 : 0.0;
                    sum *= factor;
                }
            }
            if (negative) {
                if (sum == 0.0) {
                    d = Double.valueOf("-0");
                    sum = d;
                    isInt = false;
                } else {
                    sum = -sum;
                }
            }
        }
        if (!force && isInt) {
            long ival = (long)sum;
            if (Integer.MIN_VALUE <= ival && ival <= Integer.MAX_VALUE) {
                ppType[0] = this.cx.intType();
                return new IntNumberConstant((int)ival);
            }
            if (this.cx.statics.es4_numerics && 0L <= ival && ival <= 0xFFFFFFFFL) {
                ppType[0] = this.cx.uintType();
                return new UintNumberConstant(ival);
            }
        }
        ppType[0] = this.cx.doubleType();
        d = sum;
        if (d.isNaN()) {
            d = Double.NaN;
        } else if (d.isInfinite()) {
            d = str.charAt(0) == '-' ? Double.valueOf(Double.NEGATIVE_INFINITY) : Double.valueOf(Double.POSITIVE_INFINITY);
        }
        return new DoubleNumberConstant(d);
    }

    @Override
    public NumberConstant getValueOfNumberLiteral(String str, TypeValue[] ppType, NumberUsage numberUsage) {
        boolean forceType;
        TypeValue floating_ftype;
        TypeValue ftype;
        block24: {
            if (!this.cx.statics.es4_numerics) {
                return this.getDoubleValueOrInt(str, false, ppType);
            }
            ftype = null;
            if (numberUsage == null) {
                floating_ftype = this.cx.doubleType();
                forceType = false;
            } else {
                floating_ftype = numberUsage.get_floating_usage() == 1 ? this.cx.decimalType() : this.cx.doubleType();
                forceType = true;
                switch (numberUsage.get_usage()) {
                    case 3: {
                        ftype = this.cx.intType();
                        break;
                    }
                    case 2: {
                        ftype = this.cx.doubleType();
                        break;
                    }
                    case 4: {
                        ftype = this.cx.uintType();
                        break;
                    }
                    case 1: {
                        ftype = this.cx.decimalType();
                        break;
                    }
                    default: {
                        forceType = false;
                    }
                }
            }
            int len = str.length();
            switch (str.charAt(len - 1)) {
                case 'i': {
                    ftype = this.cx.intType();
                    break;
                }
                case 'u': {
                    ftype = this.cx.uintType();
                    break;
                }
                case 'm': {
                    ftype = floating_ftype = this.cx.decimalType();
                    break;
                }
                case 'd': {
                    if (str.indexOf(120) == -1 && str.indexOf(88) == -1) {
                        ftype = floating_ftype = this.cx.doubleType();
                        break;
                    }
                    break block24;
                }
                default: {
                    break block24;
                }
            }
            forceType = true;
            str = str.substring(0, len - 1);
        }
        if (forceType) {
            if (ftype == this.cx.doubleType()) {
                return this.getDoubleValueOrInt(str, true, ppType);
            }
            if (ftype == this.cx.decimalType()) {
                return this.getDecimalValueOrInt(str, true, ppType);
            }
        }
        NumberConstant result = floating_ftype == this.cx.decimalType() ? this.getDecimalValueOrInt(str, false, ppType) : this.getDoubleValueOrInt(str, false, ppType);
        if (forceType) {
            ppType[0] = ftype;
            if (ftype == this.cx.intType()) {
                if (!(result instanceof IntNumberConstant)) {
                    result = new IntNumberConstant(result.intValue());
                }
            } else if (!(result instanceof UintNumberConstant)) {
                result = new UintNumberConstant(result.uintValue());
            }
        }
        return result;
    }

    protected String getUnaryName(int op_index) {
        switch (op_index) {
            case 2: {
                return "put";
            }
            case 3: {
                return "get";
            }
            case 4: {
                return "HasMoreNamesOp";
            }
            case 5: {
                return "NextNameOp";
            }
            case 6: {
                return "NextValueOp";
            }
            case 10: {
                return "DeleteOp";
            }
            case 12: {
                return "TypeofOp";
            }
            case 14: {
                return "TypeofOp_I";
            }
            case 18: {
                return "IncrementOp";
            }
            case 20: {
                return "IncrementOp_I";
            }
            case 19: {
                return "IncrementLocalOp";
            }
            case 21: {
                return "IncrementLocalOp_I";
            }
            case 22: {
                return "DecrementOp";
            }
            case 24: {
                return "DecrementOp_I";
            }
            case 23: {
                return "DecrementLocalOp";
            }
            case 25: {
                return "DecrementLocalOp_I";
            }
            case 26: {
                return "UnaryPlusOp";
            }
            case 27: {
                return "UnaryPlusOp_I";
            }
            case 29: {
                return "UnaryMinusOp";
            }
            case 30: {
                return "UnaryMinusOp_I";
            }
            case 31: {
                return "BitwiseNotOp";
            }
            case 32: {
                return "BitwiseNotOp_I";
            }
            case 33: {
                return "LogicalNotOp";
            }
            case 34: {
                return "LogicalNotOp_B";
            }
            case 35: {
                return "LogicalNotOp_I";
            }
            case 36: {
                return "ToXMLString";
            }
            case 37: {
                return "ToXMLAttrString";
            }
            case 38: {
                return "CheckFilterOperand";
            }
        }
        return "N/A";
    }

    protected double stringToDouble(String str) {
        double number;
        block4: {
            boolean isOctal;
            number = 0.0;
            double sign = str.charAt(0) == '-' ? -1.0 : 1.0;
            int startIndex = str.charAt(0) == '+' || str.charAt(0) == '-' ? 1 : 0;
            boolean isHex = str.startsWith("0x", startIndex) || str.startsWith("0X", startIndex);
            boolean isFloat = !isHex && (str.indexOf(46) != -1 || str.indexOf(101) != -1 || str.indexOf(69) != -1);
            boolean bl = isOctal = !isHex && !isFloat && str.startsWith("0", startIndex);
            int radix = isHex ? 16 : (isOctal ? 8 : 10);
            try {
                if (radix != 10) {
                    String subString = isHex ? str.substring(startIndex + 2) : str.substring(startIndex);
                    number = sign * (double)Long.parseLong(subString, radix);
                } else {
                    number = Double.parseDouble(str);
                }
            }
            catch (NumberFormatException ex1) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
        return number;
    }

    @Override
    protected int allocateTemp() {
        int temp = this.cur_locals++;
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("AllocTemp " + temp);
        }
        if (this.cur_locals > this.max_locals) {
            this.max_locals = this.cur_locals;
        }
        return temp - 1;
    }

    @Override
    protected void Kill(int t) {
        ++t;
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("Kill " + t);
        }
        this.Kill(this.ab.code, t);
    }

    @Override
    protected void freeTemp(int t) {
        ++t;
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("FreeTemp " + t);
            if (t != this.cur_locals - 1) {
                this.code_out.write("  out of order");
            }
        }
        this.Kill(this.ab.code, t);
        --this.cur_locals;
    }

    @Override
    protected int getTempCount() {
        return this.cur_locals;
    }

    protected void stack(int size) {
        this.cur_stack += size;
        if (this.cur_stack > this.max_stack) {
            this.max_stack = this.cur_stack;
        }
    }

    protected void scope(int delta) {
        this.cur_scope += delta;
        if (this.cur_scope > this.max_scope) {
            this.max_scope = this.cur_scope;
        }
    }

    protected void saveStackDepth() {
        this.stackDepthStack.add(this.cur_stack);
        this.scopeDepthStack.add(this.cur_scope);
    }

    protected void restoreStackDepth() {
        this.cur_stack = this.stackDepthStack.removeLast();
        this.cur_scope = this.scopeDepthStack.last();
        this.scopeDepthStack.removeLast();
    }

    @Override
    protected int getIP() {
        return this.ab.code != null ? this.ab.code.size() : -1;
    }

    protected void showLineNumber() {
        if (this.show_linenums) {
            int[] ln = new int[1];
            int[] col = new int[1];
            String[] name = new String[1];
            this.getOriginAndPosition(name, ln, col);
            this.code_out.println();
            this.code_out.print("[Ln " + ln[0] + "]");
        }
    }

    public TypeValue getTypeOfNumberLiteral(LiteralNumberNode node) {
        TypeValue[] nuType = new TypeValue[1];
        node.numericValue = this.getValueOfNumberLiteral(node.value, nuType, node.numberUsage);
        node.type = node.value.indexOf(".") > -1 || (node.value.indexOf("e") > -1 || node.value.indexOf("E") > -1) && node.value.indexOf("x") <= -1 && node.value.indexOf("X") <= -1 ? (this.cx.statics.es4_numerics && node.numberUsage != null && node.numberUsage.get_floating_usage() == 1 ? this.cx.decimalType() : this.cx.doubleType()) : nuType[0];
        return node.type;
    }

    @Override
    protected void Break(int loop_index) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("Break target " + loop_index);
        }
        this.flushDebugInfo();
        this.last_in = 2;
        int breakTempCount = this.break_temp_count.get(loop_index);
        for (int i = this.cur_locals - 1; i >= breakTempCount; --i) {
            this.Kill(this.ab.code, i);
        }
        int breakScopeIndex = this.break_scope_depth.get(loop_index) - 1;
        int reg_offset = this.getRegisterOffset(this.cx);
        int cur_scope_index = this.cx.getScopeDepth() - 1;
        for (int i = this.exceptionBlocks.size(); i > 0 && this.exceptionBlocks.at((int)(i - 1)).loop_index >= loop_index; --i) {
            ExceptionBlock exceptionBlock = this.exceptionBlocks.at(i - 1);
            while (cur_scope_index > exceptionBlock.scopeIndex) {
                this.Popscope(this.ab.code);
                int temp_reg = this.cx.scope((int)cur_scope_index).builder.temp_reg;
                if (temp_reg != -1) {
                    this.Kill(this.ab.code, temp_reg + reg_offset);
                }
                --cur_scope_index;
            }
            if (!exceptionBlock.hasFinally) continue;
            this.Label(this.ab.code);
            int finallyIndex = exceptionBlock.finallyAddrs.size();
            this.Pushbyte(this.ab.code, finallyIndex);
            this.Jump(this.ab.code);
            exceptionBlock.fixups.add(this.getIP() - 3);
            this.Label(this.ab.code);
            this.Pop();
            exceptionBlock.finallyAddrs.add(this.getIP());
            this.Label(this.ab.code);
        }
        while (cur_scope_index > breakScopeIndex) {
            this.Popscope(this.ab.code);
            int temp_reg = this.cx.scope((int)cur_scope_index).builder.temp_reg;
            if (temp_reg != -1) {
                this.Kill(this.ab.code, temp_reg + reg_offset);
            }
            --cur_scope_index;
        }
        if (loop_index < this.break_addrs.size()) {
            this.Jump(this.ab.code);
            ((IntList)this.break_addrs.get(loop_index)).add(this.getIP() - 3);
        }
        if (this.show_instructions) {
            this.code_out.write(" [" + this.cur_stack + "]");
        }
    }

    @Override
    protected void CaseLabel(boolean is_default) {
        this.showLineNumber();
        if (this.show_instructions) {
            if (is_default) {
                this.code_out.println();
                this.code_out.print("CaseLabel default");
            } else {
                this.code_out.println();
                this.code_out.print("CaseLabel");
            }
        }
        this.restoreStackDepth();
        this.saveStackDepth();
        boolean need_label = true;
        if (is_default) {
            if (this.seen_default_case.last() == 0) {
                this.default_addrs.add(this.getIP());
                this.case_addrs.last().add(this.getIP());
                this.seen_default_case.set(this.seen_default_case.size() - 1, 1);
            }
        } else {
            if (this.case_addrs.last().size() > 0 && this.case_addrs.last().last() == this.getIP() - 1) {
                need_label = false;
            }
            this.case_addrs.last().add(need_label ? this.getIP() : this.getIP() - 1);
        }
        if (need_label) {
            this.Label(this.ab.code);
        }
        this.last_in = 2;
        if (this.show_instructions) {
            this.code_out.write(" [" + this.cur_stack + "]");
        }
    }

    @Override
    protected void CheckType(QName name) {
        if (name.toString().length() == 0) {
            return;
        }
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("CheckType " + name);
        }
        this.flushDebugInfo();
        if (this.last_in == 3) {
            this.stack(0);
            this.code_out.println();
            this.code_out.write("* ERASING " + (this.ab.code.size() - this.last_ip) + " bytes");
            this.ab.code.remove(this.last_ip, this.ab.code.size() - this.last_ip);
        }
        this.last_ip = this.getIP();
        this.last_in = 3;
        String fullname = name.toString();
        if ("*".equals(fullname)) {
            this.Coerce_a(this.ab.code);
        } else if ("String".equals(fullname)) {
            this.Coerce_s(this.ab.code);
        } else if ("Boolean".equals(fullname)) {
            this.Convert_b(this.ab.code);
        } else if ("Number".equals(fullname)) {
            this.Convert_d(this.ab.code);
        } else if ("int".equals(fullname)) {
            this.Convert_i(this.ab.code);
        } else if ("uint".equals(fullname)) {
            this.Convert_u(this.ab.code);
        } else {
            int class_index = this.addClassName(name);
            this.Coerce(this.ab.code, class_index);
        }
        if (this.show_instructions) {
            this.code_out.write(" [" + this.cur_stack + "]");
        }
    }

    @Override
    protected void Continue(int loop_index) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("Continue " + loop_index);
        }
        this.flushDebugInfo();
        this.last_in = 2;
        int continueScopeIndex = this.continue_scope_depth.get(loop_index) - 1;
        int reg_offset = this.getRegisterOffset(this.cx);
        int cur_scope_index = this.cx.getScopeDepth() - 1;
        for (int i = this.exceptionBlocks.size(); i > 0 && this.exceptionBlocks.at((int)(i - 1)).loop_index >= loop_index; --i) {
            ExceptionBlock exceptionBlock = this.exceptionBlocks.at(i - 1);
            while (cur_scope_index > exceptionBlock.scopeIndex) {
                this.Popscope(this.ab.code);
                int temp_reg = this.cx.scope((int)cur_scope_index).builder.temp_reg;
                if (temp_reg != -1) {
                    this.Kill(this.ab.code, temp_reg + reg_offset);
                }
                --cur_scope_index;
            }
            if (!exceptionBlock.hasFinally) continue;
            this.Label(this.ab.code);
            int finallyIndex = exceptionBlock.finallyAddrs.size();
            this.Pushbyte(this.ab.code, finallyIndex);
            this.Jump(this.ab.code);
            exceptionBlock.fixups.add(this.getIP() - 3);
            this.Label(this.ab.code);
            this.Pop();
            exceptionBlock.finallyAddrs.add(this.getIP());
            this.Label(this.ab.code);
        }
        while (cur_scope_index > continueScopeIndex) {
            this.Popscope(this.ab.code);
            int temp_reg = this.cx.scope((int)cur_scope_index).builder.temp_reg;
            if (temp_reg != -1) {
                this.Kill(this.ab.code, temp_reg + reg_offset);
            }
            --cur_scope_index;
        }
        if (loop_index >= 0 && loop_index < this.continue_addrs.size()) {
            this.Jump(this.ab.code);
            ((IntList)this.continue_addrs.get(loop_index)).add(this.getIP() - 3);
        }
        if (this.show_instructions) {
            this.code_out.write(" [" + this.cur_stack + "]");
        }
    }

    protected void DebugSlot(String name, int slot, int linenum) {
        int index = this.ab.addUtf8Constant(this.bytecodeFactory.ConstantUtf8Info(name));
        this.DebugLocal(this.ab.code, index, slot, linenum < 0 ? 0 : linenum);
    }

    protected void DebugFile(String name) {
        int index = this.ab.addUtf8Constant(this.bytecodeFactory.ConstantUtf8Info(name));
        this.DebugFile(this.ab.code, index);
    }

    protected void DebugLine(int pos) {
        this.DebugLine(this.ab.code, pos);
    }

    private int getVersionFromOldMetadata(String s) {
        int v = -1;
        if (s.equals("9")) {
            v = 660;
        } else if (s.equals("air1")) {
            v = 661;
        } else if (s.equals("10")) {
            v = 662;
        } else if (s.equals("air1.5")) {
            v = 663;
        } else if (s.equals("air1.5.1")) {
            v = 664;
        } else if (s.equals("10.0.32")) {
            v = 665;
        } else if (s.equals("air1.5.2")) {
            v = 666;
        } else if (s.equals("10.1")) {
            v = 667;
        } else if (s.equals("airAthena") || s.equals("air2.0")) {
            v = 668;
        } else if (s.equals("100")) {
            v = 668;
        } else {
            this.cx.internalError("internal error: unrecognized value '" + s + "' in 'Version' metadata");
        }
        return v;
    }

    private TreeSet<Integer> apiVersionsOfSlot(Slot slot, String name, ObjectValue ns) {
        assert (this.doingAPIVersioning);
        TreeSet<Integer> versions = new TreeSet<Integer>();
        ArrayList<MetaData> list = slot.getMetadata();
        if (list != null) {
            for (MetaData md : list) {
                int i;
                if (md.id == "API") {
                    for (i = 0; i < md.count(); ++i) {
                        boolean err = false;
                        try {
                            int v = Integer.parseInt(md.getValue(i));
                            versions.add(v);
                            if (v < APIVersions.min_version_num || v > APIVersions.max_version_num) {
                                err = true;
                            }
                        }
                        catch (Exception x) {
                            err = true;
                        }
                        if (!err) continue;
                        this.cx.internalError("internal error: unrecognized version '" + md.getValue(i) + "' in API metadata");
                    }
                    continue;
                }
                if (md.id != "Version") continue;
                for (i = 0; i < md.count(); ++i) {
                    int v = this.getVersionFromOldMetadata(md.getValue(i));
                    versions.add(v);
                }
            }
        }
        if (versions.size() == 0) {
            versions.add(APIVersions.min_version_num);
        } else if (!this.isVersionedNamespace(ns)) {
            versions.add(APIVersions.min_version_num);
        }
        return versions;
    }

    protected void addSlotTrait(ObjectValue obj, ObjectList<ByteList> traits, String name, Qualifiers quals) {
        Map.Entry qual_it;
        Builder bui = obj.builder;
        IntList namespaces = new IntList(quals.size());
        int prev_var_index = -1;
        int var_index = -1;
        int flags = 0;
        Slot prev_slot = null;
        Iterator i = quals.entrySet().iterator();
        Map.Entry entry = qual_it = i.hasNext() ? i.next() : null;
        while (qual_it != null) {
            int info;
            int kind;
            Slot slot;
            block10: {
                namespaces.clear();
                var_index = -1;
                ObjectValue ns = (ObjectValue)qual_it.getKey();
                int slot_index = obj.getSlotIndex(this.cx, -79, name, ns);
                slot = obj.getSlot(this.cx, slot_index);
                var_index = slot.getVarIndex() + bui.var_offset + 1;
                if (slot.declaredBy != obj) {
                    qual_it = i.hasNext() ? i.next() : null;
                    continue;
                }
                while (true) {
                    if (ns != null) {
                        int ns_index;
                        if (this.doingAPIVersioning) {
                            TreeSet<Integer> versions = this.apiVersionsOfSlot(slot, name, ns);
                            ns_index = this.makeVersionedNamespaceSet(ns, versions);
                        } else {
                            ns_index = this.addNamespace(ns);
                        }
                        namespaces.add(ns_index);
                    } else {
                        this.cx.internalError(this.pos, "internal error: non object value for namespace");
                    }
                    Map.Entry entry2 = qual_it = i.hasNext() ? i.next() : null;
                    if (qual_it == null) break block10;
                    prev_var_index = var_index;
                    prev_slot = slot;
                    ns = (ObjectValue)qual_it.getKey();
                    slot_index = obj.getSlotIndex(this.cx, -79, name, ns);
                    if (slot_index <= 0) continue;
                    slot = obj.getSlot(this.cx, slot_index);
                    var_index = slot.getVarIndex() + bui.var_offset + 1;
                    flags &= slot.isFinal() ? 1 : 0;
                    flags &= slot.isOverride() ? 2 : 0;
                    if (var_index < 0 || var_index != prev_var_index || slot.declaredBy != prev_slot.declaredBy) break;
                }
                var_index = prev_var_index;
                slot = prev_slot;
            }
            int name_index = this.ab.addUtf8Constant(this.bytecodeFactory.ConstantUtf8Info(name));
            int qname_index = this.doingAPIVersioning ? this.ab.addMultiNameConstant(this.bytecodeFactory.ConstantMultiname(name_index, namespaces.back(), false)) : this.ab.addMultiNameConstant(this.bytecodeFactory.ConstantQualifiedName(name_index, namespaces.back(), false));
            ObjectValue objval = slot.getInitializerValue();
            int value_index = 0;
            byte value_kind = 0;
            if (objval != null && (objval.builder instanceof ClassBuilder ? objval.builder : null) != null) {
                kind = 4;
                info = this.GetClassInfo(objval.builder.classname);
            } else {
                int n = kind = slot.isConst() ? 6 : 0;
                if (objval != null) {
                    value_index = this.getValueIndex(objval);
                    value_kind = this.getValueKind(objval);
                }
                QName type_name = slot.getType().getName(this.cx);
                info = this.addClassName(type_name);
            }
            IntList metaDataIndices = this.addMetadata(slot);
            traits.push_back(ByteCodeFactory.allocBytes());
            this.ab.addBytesToTable(traits, this.bytecodeFactory.TraitInfo(traits.back(), qname_index, kind, obj.canEarlyBind() ? var_index : 0, info, value_index, value_kind, metaDataIndices));
        }
    }

    protected IntList addMetadata(Slot slot) {
        if (slot != null) {
            return this.addMetadata(slot.getMetadata());
        }
        return null;
    }

    protected IntList addMetadata(ArrayList<MetaData> metadata) {
        IntList metaDataIndices = null;
        if (metadata != null && metadata.size() > 0) {
            metaDataIndices = new IntList(metadata.size());
            for (MetaData entry : metadata) {
                String id = entry.id;
                Value[] values = entry.values;
                int metaDataIndex = this.addMetadataInfo(id, values);
                metaDataIndices.add(metaDataIndex);
            }
        }
        return metaDataIndices;
    }

    protected int addMetadataInfo(String id, Value[] values) {
        String metaDataKey = id;
        int metaNameIndex = id == null ? 0 : this.ab.addUtf8Constant(this.bytecodeFactory.ConstantUtf8Info(id));
        int metaValuesCount = values == null ? 0 : values.length;
        IntList metaKeys = new IntList(metaValuesCount);
        IntList metaValues = new IntList(metaValuesCount);
        for (int z = 0; z < metaValuesCount; ++z) {
            Value val = values[z];
            String key = null;
            String value = null;
            if (val instanceof MetaDataEvaluator.KeylessValue) {
                key = null;
                value = ((MetaDataEvaluator.KeylessValue)val).obj;
            } else if (val instanceof MetaDataEvaluator.KeyValuePair) {
                MetaDataEvaluator.KeyValuePair pair = (MetaDataEvaluator.KeyValuePair)val;
                key = pair.key;
                value = pair.obj;
            } else {
                value = val.toString();
            }
            if (key != null) {
                metaKeys.add(this.ab.addUtf8Constant(this.bytecodeFactory.ConstantUtf8Info(key)));
                metaDataKey = metaDataKey + key;
            } else {
                metaKeys.add(0);
            }
            metaDataKey = metaDataKey + value;
            metaValues.add(this.ab.addUtf8Constant(this.bytecodeFactory.ConstantUtf8Info(value)));
        }
        int metaDataIndex = this.GetMetadataInfo(metaDataKey);
        if (this.ab.metadata.at(metaDataIndex).size() == 0) {
            this.ab.addBytesToTable(this.ab.metadata, this.bytecodeFactory.MetadataInfo(this.ab.metadata.at(metaDataIndex), metaNameIndex, metaValuesCount, metaKeys, metaValues, metaDataIndex));
        }
        return metaDataIndex;
    }

    protected void addMethodTrait(int kind, ObjectValue obj, ObjectList<ByteList> traits, String name, Qualifiers quals) {
        boolean isInterface;
        if ("$construct".equals(name)) {
            return;
        }
        IntList namespaces = new IntList(quals.size());
        Iterator i = quals.keySet().iterator();
        boolean bl = isInterface = obj.type != null && obj.type.isInterface();
        while (i.hasNext()) {
            ObjectValue ns = (ObjectValue)i.next();
            int slot_kind = kind == 3 ? -99 : -79;
            int slot_index = obj.getSlotIndex(this.cx, slot_kind, name, ns);
            Slot slot = obj.getSlot(this.cx, slot_index);
            if (kind == 1) {
                int implicit_index = obj.getImplicitIndex(this.cx, slot_index, -133);
                slot = obj.getSlot(this.cx, implicit_index);
            }
            if (slot == null || slot.declaredBy != obj || slot.getMethodName().length() == 0) continue;
            ObjectValue slot_value = slot != null ? (slot.getValue() instanceof ObjectValue ? (ObjectValue)slot.getValue() : null) : null;
            ArrayList<MetaData> metaData = slot.getMetadata();
            if (!isInterface && ns.isInterface()) continue;
            boolean is_override = slot.isOverride();
            int flags = 0;
            flags |= slot.isFinal() ? 1 : 0;
            flags |= is_override ? 2 : 0;
            if (ns != null) {
                int ns_index;
                if (this.doingAPIVersioning) {
                    TreeSet<Integer> versions = this.apiVersionsOfSlot(slot, name, ns);
                    ns_index = this.makeVersionedNamespaceSet(ns, versions);
                } else {
                    ns_index = this.addNamespace(ns);
                }
                namespaces.add(ns_index);
            } else {
                this.cx.internalError(this.pos, "internal error: non object value for namespace");
            }
            int method_info = -1;
            int method_id = slot.getMethodID();
            if (method_id >= 0) {
                method_info = this.GetMethodInfo(slot.getMethodName());
            } else if (slot_value != null && slot_value.method_info >= 0) {
                method_info = slot_value.method_info;
            } else {
                this.cx.internalError("internal error");
                continue;
            }
            int name_index = this.ab.addUtf8Constant(this.bytecodeFactory.ConstantUtf8Info(name));
            int qname_index = this.doingAPIVersioning ? this.ab.addMultiNameConstant(this.bytecodeFactory.ConstantMultiname(name_index, namespaces.back(), false)) : this.ab.addMultiNameConstant(this.bytecodeFactory.ConstantQualifiedName(name_index, namespaces.back(), false));
            IntList metaDataIndices = this.addMetadata(metaData);
            if (method_info >= 0) {
                traits.push_back(ByteCodeFactory.allocBytes());
                method_id = method_id < 0 ? 0 : method_id;
                this.ab.addBytesToTable(traits, this.bytecodeFactory.TraitInfo(traits.back(), qname_index, kind, obj.canEarlyBind() ? method_id : 0, method_info, flags, (byte)0, metaDataIndices));
                continue;
            }
            this.cx.internalError("internal error: invalid method info");
        }
    }

    @Override
    protected void FinishProgram(Context cx, String name, int init_info) {
        ObjectValue obj = cx.scope();
        ObjectList<ByteList> traits = new ObjectList<ByteList>();
        this.FinishTraits(obj, traits);
        int package_info = this.GetPackageInfo(name);
        this.ab.addBytesToTable(this.ab.scripts, this.bytecodeFactory.ScriptInfo(this.ab.scripts.at(package_info), init_info, traits, package_info));
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("// --FinishProgram " + this.modulename);
        }
    }

    private void FinishTraits(ObjectValue obj, ObjectList<ByteList> traits) {
        Names names = obj.builder.getNames();
        if (names != null) {
            Qualifiers q = new Qualifiers();
            int i = 0;
            while ((i = names.hasNext(i)) != -1) {
                q.clear();
                int slotId = names.getSlot(i);
                String name = names.getName(i);
                q.put(names.getNamespace(i), 0);
                if (slotId >= 1) {
                    Slot s = obj.getSlot(this.cx, slotId);
                    if (names.getNamespace(i) != ObjectValue.loopLabelNamespace && s != null && s.declaredBy == obj) {
                        if (s instanceof VariableSlot && names.getType(i) != 1) {
                            this.addSlotTrait(obj, traits, name, q);
                        }
                        if (s instanceof MethodSlot) {
                            int methodKind = 1;
                            if (s.isGetter()) {
                                methodKind = 2;
                            }
                            if (names.getType(i) == 1) {
                                methodKind = 3;
                            }
                            this.addMethodTrait(methodKind, obj, traits, name, q);
                        }
                    }
                }
                ++i;
            }
        }
    }

    @Override
    protected void Dup() {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("Dup");
        }
        this.flushDebugInfo();
        this.last_ip = this.getIP();
        this.last_in = 1;
        this.Dup(this.ab.code);
        if (this.show_instructions) {
            this.code_out.write(" [" + this.cur_stack + "]");
        }
    }

    @Override
    protected void Else() {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("Else");
        }
        this.flushDebugInfo();
        this.Jump(this.ab.code);
        this.else_addrs.add(this.getIP() - 3);
        this.last_in = 2;
        if (this.show_instructions) {
            this.code_out.write(" [" + this.cur_stack + "]");
        }
    }

    @Override
    protected void GetProperty(boolean is_qualified, boolean is_super, boolean is_attr, Namespaces used_def_namespaces) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("GetProperty is_qualified=" + is_qualified + " is_super=" + is_super + " is_attr=" + is_attr);
        }
        this.flushDebugInfo();
        this.last_ip = this.getIP();
        int index = -1;
        if (is_qualified) {
            index = this.ab.addMultiNameConstant(this.bytecodeFactory.ConstantRuntimeQualifiedLate(is_attr));
            this.stack(-2);
        } else {
            int namespaces_set = this.makeNamespaceSet(used_def_namespaces);
            index = this.ab.addMultiNameConstant(this.bytecodeFactory.ConstantMultinameLate(namespaces_set, is_attr));
            this.stack(-1);
        }
        if (is_super) {
            this.Getsuper(this.ab.code, index);
        } else {
            this.Getproperty(this.ab.code, index);
        }
        this.last_in = 2;
        if (this.show_instructions) {
            this.code_out.write(" [" + this.cur_stack + "]");
        }
    }

    @Override
    protected void GetProperty(String name, boolean is_super, boolean is_attr) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("GetProperty " + name + " is_super=" + is_super + " is_attr=" + is_attr);
        }
        this.flushDebugInfo();
        this.last_ip = this.getIP();
        int name_index = name.equals("*") ? 0 : this.ab.addUtf8Constant(this.bytecodeFactory.ConstantUtf8Info(name));
        int index = this.ab.addMultiNameConstant(this.bytecodeFactory.ConstantRuntimeQualifiedName(name_index, is_attr));
        if (is_super) {
            this.Getsuper(this.ab.code, index);
        } else {
            this.Getproperty(this.ab.code, index);
        }
        this.stack(-1);
        this.last_in = 2;
        if (this.show_instructions) {
            this.code_out.print(" [" + this.cur_stack + "]");
        }
    }

    private void printNamespaceSet(ObjectList<ObjectValue> namespaces) {
        TreeSet<String> namespace_set = new TreeSet<String>();
        for (ObjectValue ns : namespaces) {
            String ns_name = ns == this.cx.publicNamespace() ? "public" : ns.name;
            switch (ns.getNamespaceKind()) {
                case 3: {
                    ns_name = ns_name + "(protected)";
                    break;
                }
                case 2: {
                    ns_name = ns_name + "(private)";
                    break;
                }
                case 1: {
                    ns_name = ns_name + "(package-internal)";
                    break;
                }
                case 5: {
                    ns_name = ns_name + "(static-protected)";
                }
            }
            namespace_set.add(ns_name);
        }
        this.code_out.print(namespace_set.size() + " {");
        Iterator it = namespace_set.iterator();
        while (it.hasNext()) {
            this.code_out.print(" " + (String)it.next());
        }
        this.code_out.print(" }");
    }

    @Override
    protected void GetProperty(String name, Namespaces qualifiers, boolean is_qualified, boolean is_super, boolean is_attr) {
        int index;
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("GetProperty " + name + " ");
            this.printNamespaceSet(qualifiers);
            this.code_out.print(" is_qualified=" + is_qualified + " is_super=" + is_super + " is_attr=" + is_attr);
        }
        this.flushDebugInfo();
        this.last_ip = this.getIP();
        int name_index = name.equals("*") ? 0 : this.ab.addUtf8Constant(this.bytecodeFactory.ConstantUtf8Info(name));
        if (is_qualified && qualifiers.size() == 1) {
            int namespace = this.addNamespace((ObjectValue)qualifiers.last());
            index = this.ab.addMultiNameConstant(this.bytecodeFactory.ConstantQualifiedName(name_index, namespace, is_attr));
        } else {
            int namespaces_set = this.makeNamespaceSet(qualifiers);
            index = this.ab.addMultiNameConstant(this.bytecodeFactory.ConstantMultiname(name_index, namespaces_set, is_attr));
        }
        if (is_super) {
            this.Getsuper(this.ab.code, index);
        } else {
            this.Getproperty(this.ab.code, index);
        }
        this.last_in = 2;
        if (this.show_instructions) {
            this.code_out.print(" [" + this.cur_stack + "]");
        }
    }

    @Override
    protected void SetProperty(boolean is_qualified, boolean is_super, boolean is_attr, Namespaces used_def_namespaces, boolean is_constinit) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("SetProperty is_qualified=" + is_qualified + " is_super=" + is_super + " is_attr=" + is_attr);
        }
        this.flushDebugInfo();
        this.last_ip = this.getIP();
        int index = -1;
        if (is_qualified) {
            index = this.ab.addMultiNameConstant(this.bytecodeFactory.ConstantRuntimeQualifiedLate(is_attr));
            this.stack(-4);
        } else {
            int namespaces_set = this.makeNamespaceSet(used_def_namespaces);
            index = this.ab.addMultiNameConstant(this.bytecodeFactory.ConstantMultinameLate(namespaces_set, is_attr));
            this.stack(-3);
        }
        if (is_super) {
            this.Setsuper(this.ab.code, index);
        } else if (is_constinit) {
            this.Initproperty(this.ab.code, index);
        } else {
            this.Setproperty(this.ab.code, index);
        }
        this.last_in = 2;
        if (this.show_instructions) {
            this.code_out.write(" [" + this.cur_stack + "]");
        }
    }

    @Override
    protected void SetProperty(String name, boolean is_super, boolean is_attr) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("SetProperty " + name + " is_super=" + is_super + " is_attr=" + is_attr);
        }
        this.flushDebugInfo();
        this.last_ip = this.getIP();
        int name_index = name.equals("*") ? 0 : this.ab.addUtf8Constant(this.bytecodeFactory.ConstantUtf8Info(name));
        int index = this.ab.addMultiNameConstant(this.bytecodeFactory.ConstantRuntimeQualifiedName(name_index, is_attr));
        if (is_super) {
            this.Setsuper(this.ab.code, index);
        } else {
            this.Setproperty(this.ab.code, index);
        }
        this.stack(-3);
        this.last_in = 2;
        if (this.show_instructions) {
            this.code_out.print(" [" + this.cur_stack + "]");
        }
    }

    @Override
    protected void SetProperty(String name, Namespaces qualifiers, boolean is_qualified, boolean is_super, boolean is_attr, boolean is_constinit) {
        int index;
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("SetProperty " + name + " ");
            this.printNamespaceSet(qualifiers);
            this.code_out.print(" is_qualified=" + is_qualified + " is_super=" + is_super + " is_attr=" + is_attr + " is_constinit=" + is_constinit);
        }
        this.flushDebugInfo();
        this.last_ip = this.getIP();
        int name_index = name.equals("*") ? 0 : this.ab.addUtf8Constant(this.bytecodeFactory.ConstantUtf8Info(name));
        if (is_qualified && qualifiers.size() == 1) {
            int namespace = this.addNamespace((ObjectValue)qualifiers.last());
            index = this.ab.addMultiNameConstant(this.bytecodeFactory.ConstantQualifiedName(name_index, namespace, is_attr));
        } else {
            int namespaces_set = this.makeNamespaceSet(qualifiers);
            index = this.ab.addMultiNameConstant(this.bytecodeFactory.ConstantMultiname(name_index, namespaces_set, is_attr));
        }
        if (is_super) {
            this.Setsuper(this.ab.code, index);
        } else if (is_constinit) {
            this.Initproperty(this.ab.code, index);
        } else {
            this.Setproperty(this.ab.code, index);
        }
        this.stack(-2);
        this.last_in = 2;
        if (this.show_instructions) {
            this.code_out.print(" [" + this.cur_stack + "]");
        }
    }

    @Override
    protected void DeleteProperty(boolean is_qualified, boolean is_super, boolean is_attr, Namespaces used_def_namespaces) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("DeleteProperty is_qualified=" + is_qualified + " is_super=" + is_super + " is_attr=" + is_attr);
        }
        this.flushDebugInfo();
        this.last_ip = this.getIP();
        int index = -1;
        if (is_qualified) {
            index = this.ab.addMultiNameConstant(this.bytecodeFactory.ConstantRuntimeQualifiedLate(is_attr));
            this.stack(-2);
        } else {
            int namespaces_set = this.makeNamespaceSet(used_def_namespaces);
            index = this.ab.addMultiNameConstant(this.bytecodeFactory.ConstantMultinameLate(namespaces_set, is_attr));
            this.stack(-1);
        }
        if (!is_super) {
            this.Delproperty(this.ab.code, index);
        }
        this.last_in = 2;
        if (this.show_instructions) {
            this.code_out.write(" [" + this.cur_stack + "]");
        }
    }

    @Override
    protected void DeleteProperty(String name, boolean is_super, boolean is_attr) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("DeleteProperty " + name + " is_super=" + is_super + " is_attr=" + is_attr);
        }
        this.flushDebugInfo();
        this.last_ip = this.getIP();
        int name_index = name.equals("*") ? 0 : this.ab.addUtf8Constant(this.bytecodeFactory.ConstantUtf8Info(name));
        int index = this.ab.addMultiNameConstant(this.bytecodeFactory.ConstantRuntimeQualifiedName(name_index, is_attr));
        if (!is_super) {
            this.Delproperty(this.ab.code, index);
        }
        this.stack(-1);
        this.last_in = 2;
        if (this.show_instructions) {
            this.code_out.print(" [" + this.cur_stack + "]");
        }
    }

    @Override
    protected void DeleteProperty(String name, Namespaces qualifiers, boolean is_qualified, boolean is_super, boolean is_attr) {
        int index;
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("DeleteProperty " + name + " ");
            this.printNamespaceSet(qualifiers);
            this.code_out.print(" is_qualified=" + is_qualified + " is_super=" + is_super + " is_attr=" + is_attr);
        }
        this.flushDebugInfo();
        this.last_ip = this.getIP();
        int name_index = name.equals("*") ? 0 : this.ab.addUtf8Constant(this.bytecodeFactory.ConstantUtf8Info(name));
        if (is_qualified && qualifiers.size() == 1) {
            int namespace = this.addNamespace((ObjectValue)qualifiers.last());
            index = this.ab.addMultiNameConstant(this.bytecodeFactory.ConstantQualifiedName(name_index, namespace, is_attr));
        } else {
            int namespaces_set = this.makeNamespaceSet(qualifiers);
            index = this.ab.addMultiNameConstant(this.bytecodeFactory.ConstantMultiname(name_index, namespaces_set, is_attr));
        }
        if (!is_super) {
            this.Delproperty(this.ab.code, index);
        }
        this.last_in = 2;
        if (this.show_instructions) {
            this.code_out.print(" [" + this.cur_stack + "]");
        }
    }

    @Override
    protected void GetDescendants(boolean is_qualified, boolean is_attr, Namespaces used_def_namespaces) {
        int index;
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("GetDescendants is_qualified=" + is_qualified + " is_attr=" + is_attr);
        }
        this.flushDebugInfo();
        this.last_ip = this.getIP();
        if (is_qualified) {
            index = this.ab.addMultiNameConstant(this.bytecodeFactory.ConstantRuntimeQualifiedLate(is_attr));
            this.stack(-2);
        } else {
            int namespaces_set = this.makeNamespaceSet(used_def_namespaces);
            index = this.ab.addMultiNameConstant(this.bytecodeFactory.ConstantMultinameLate(namespaces_set, is_attr));
            this.stack(-1);
        }
        this.Descendants(this.ab.code, index);
        this.last_in = 2;
        if (this.show_instructions) {
            this.code_out.print(" [" + this.cur_stack + "]");
        }
    }

    @Override
    protected void GetDescendants(String name, boolean is_super, boolean is_attr) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("GetDescendants " + name + " is_super=" + is_super + " is_attr=" + is_attr);
        }
        this.flushDebugInfo();
        this.last_ip = this.getIP();
        int name_index = name.equals("*") ? 0 : this.ab.addUtf8Constant(this.bytecodeFactory.ConstantUtf8Info(name));
        int index = this.ab.addMultiNameConstant(this.bytecodeFactory.ConstantRuntimeQualifiedName(name_index, is_attr));
        if (!is_super) {
            this.Descendants(this.ab.code, index);
        }
        this.stack(-1);
        this.last_in = 2;
        if (this.show_instructions) {
            this.code_out.print(" [" + this.cur_stack + "]");
        }
    }

    @Override
    protected void GetDescendants(String name, Namespaces qualifiers, boolean is_qualified, boolean is_super, boolean is_attr) {
        int index;
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("GetDescendants " + name + " ");
            this.printNamespaceSet(qualifiers);
            this.code_out.print(" is_qualified=" + is_qualified + " is_super=" + is_super + " is_attr=" + is_attr);
        }
        this.flushDebugInfo();
        this.last_ip = this.getIP();
        int name_index = name.equals("*") ? 0 : this.ab.addUtf8Constant(this.bytecodeFactory.ConstantUtf8Info(name));
        if (is_qualified && qualifiers.size() == 1) {
            int namespace = this.addNamespace((ObjectValue)qualifiers.last());
            index = this.ab.addMultiNameConstant(this.bytecodeFactory.ConstantQualifiedName(name_index, namespace, is_attr));
        } else {
            int namespaces_set = this.makeNamespaceSet(qualifiers);
            index = this.ab.addMultiNameConstant(this.bytecodeFactory.ConstantMultiname(name_index, namespaces_set, is_attr));
        }
        if (!is_super) {
            this.Descendants(this.ab.code, index);
        }
        this.last_in = 2;
        if (this.show_instructions) {
            this.code_out.print(" [" + this.cur_stack + "]");
        }
    }

    @Override
    protected void DeleteDescendants(String name, boolean is_super, boolean is_attr) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("DeleteDescendants " + name + " is_super=" + is_super + " is_attr=" + is_attr);
        }
        this.flushDebugInfo();
        this.last_ip = this.getIP();
        int name_index = name.equals("*") ? 0 : this.ab.addUtf8Constant(this.bytecodeFactory.ConstantUtf8Info(name));
        int index = this.ab.addMultiNameConstant(this.bytecodeFactory.ConstantRuntimeQualifiedName(name_index, is_attr));
        if (!is_super) {
            this.Deletedescendants(this.ab.code, index);
        }
        this.stack(-1);
        this.last_in = 2;
        if (this.show_instructions) {
            this.code_out.print(" [" + this.cur_stack + "]");
        }
    }

    @Override
    protected void DeleteDescendants(String name, Namespaces qualifiers, boolean is_qualified, boolean is_super, boolean is_attr) {
        int index;
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("DeleteDescendants " + name + " ");
            this.printNamespaceSet(qualifiers);
            this.code_out.print(" is_qualified=" + is_qualified + " is_super=" + is_super + " is_attr=" + is_attr);
        }
        this.flushDebugInfo();
        this.last_ip = this.getIP();
        int name_index = name.equals("*") ? 0 : this.ab.addUtf8Constant(this.bytecodeFactory.ConstantUtf8Info(name));
        if (is_qualified && qualifiers.size() == 1) {
            int namespace = this.addNamespace((ObjectValue)qualifiers.last());
            index = this.ab.addMultiNameConstant(this.bytecodeFactory.ConstantQualifiedName(name_index, namespace, is_attr));
        } else {
            int namespaces_set = this.makeNamespaceSet(qualifiers);
            index = this.ab.addMultiNameConstant(this.bytecodeFactory.ConstantMultiname(name_index, namespaces_set, is_attr));
        }
        if (!is_super) {
            this.Deletedescendants(this.ab.code, index);
        }
        this.last_in = 2;
        if (this.show_instructions) {
            this.code_out.print(" [" + this.cur_stack + "]");
        }
    }

    @Override
    protected void FindProperty(String name, Namespaces qualifiers, boolean is_strict, boolean is_qualified, boolean is_attr) {
        int index;
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("FindProperty " + name + " ");
            this.printNamespaceSet(qualifiers);
            this.code_out.print(" is_strict=" + is_strict + " is_qualified=" + is_qualified + " is_attr=" + is_attr);
        }
        this.flushDebugInfo();
        this.last_ip = this.getIP();
        this.last_in = 2;
        int name_index = name.equals("*") ? 0 : this.ab.addUtf8Constant(this.bytecodeFactory.ConstantUtf8Info(name));
        if (is_qualified && qualifiers.size() == 1) {
            int namespace = this.addNamespace((ObjectValue)qualifiers.last());
            index = this.ab.addMultiNameConstant(this.bytecodeFactory.ConstantQualifiedName(name_index, namespace, is_attr));
        } else {
            int namespaces_set = this.makeNamespaceSet(qualifiers);
            index = this.ab.addMultiNameConstant(this.bytecodeFactory.ConstantMultiname(name_index, namespaces_set, is_attr));
        }
        if (is_strict) {
            this.Findpropstrict(this.ab.code, index);
        } else {
            this.Findproperty(this.ab.code, index);
        }
        if (this.show_instructions) {
            this.code_out.write(" [" + this.cur_stack + "]");
        }
    }

    @Override
    protected void FindProperty(String name, boolean is_strict, boolean is_attr) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("FindProperty " + name + " is_strict=" + is_strict + " is_attr=" + is_attr);
        }
        this.flushDebugInfo();
        this.stack(-1);
        this.last_ip = this.getIP();
        this.last_in = 2;
        int name_index = "*".equals(name) ? 0 : this.ab.addUtf8Constant(this.bytecodeFactory.ConstantUtf8Info(name));
        int index = this.ab.addMultiNameConstant(this.bytecodeFactory.ConstantRuntimeQualifiedName(name_index, is_attr));
        if (is_strict) {
            this.Findpropstrict(this.ab.code, index);
        } else {
            this.Findproperty(this.ab.code, index);
        }
        if (this.show_instructions) {
            this.code_out.write(" [" + this.cur_stack + "]");
        }
    }

    @Override
    protected void FindProperty(boolean is_strict, boolean is_attr, boolean is_qualified, Namespaces used_def_namespaces) {
        int index;
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("FindProperty  is_strict=" + is_strict + " is_attr=" + is_attr);
        }
        this.flushDebugInfo();
        this.last_ip = this.getIP();
        this.last_in = 2;
        if (is_qualified) {
            index = this.ab.addMultiNameConstant(this.bytecodeFactory.ConstantRuntimeQualifiedLate(is_attr));
            this.stack(-2);
        } else {
            int namespaces_set = this.makeNamespaceSet(used_def_namespaces);
            index = this.ab.addMultiNameConstant(this.bytecodeFactory.ConstantMultinameLate(namespaces_set, is_attr));
            this.stack(-1);
        }
        if (is_strict) {
            this.Findpropstrict(this.ab.code, index);
        } else {
            this.Findproperty(this.ab.code, index);
        }
        if (this.show_instructions) {
            this.code_out.write(" [" + this.cur_stack + "]");
        }
    }

    @Override
    protected void GetGlobalScope() {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("GetGlobalScope");
        }
        this.flushDebugInfo();
        this.last_ip = this.getIP();
        this.last_in = 1;
        this.Getglobalscope(this.ab.code);
        if (this.show_instructions) {
            this.code_out.write(" [" + this.cur_stack + "]");
        }
    }

    @Override
    protected void GetBaseObject(int scope_index) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("GetBaseObject " + scope_index);
        }
        this.flushDebugInfo();
        this.last_ip = this.getIP();
        this.last_in = 1;
        this.Getscopeobject(this.ab.code, scope_index);
        if (this.show_instructions) {
            this.code_out.write(" [" + this.cur_stack + "]");
        }
    }

    @Override
    protected void GetScopeChain() {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("GetScopeChain");
        }
        this.flushDebugInfo();
        this.last_in = 2;
        if (this.show_instructions) {
            this.code_out.write(" [" + this.cur_stack + "]");
        }
    }

    @Override
    protected void GetScopeOnTop() {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("GetScopeOnTop");
        }
        this.flushDebugInfo();
        this.last_in = 2;
        if (this.show_instructions) {
            this.code_out.write(" [" + this.cur_stack + "]");
        }
    }

    @Override
    protected void Try(boolean hasFinally) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("Try");
        }
        ExceptionBlock exceptionBlock = new ExceptionBlock();
        exceptionBlock.try_start = this.getIP();
        exceptionBlock.hasFinally = hasFinally;
        exceptionBlock.scopeIndex = this.cx.getScopeDepth() - 1;
        exceptionBlock.loop_index = this.break_addrs.size() - 1;
        this.exceptionBlocks.add(exceptionBlock);
        this.last_in = 2;
        if (this.show_instructions) {
            this.code_out.write(" [" + this.cur_stack + "]");
        }
        this.flushDebugInfo();
    }

    @Override
    protected void CatchClausesBegin() {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("CatchClausesBegin");
        }
        ExceptionBlock exceptionBlock = this.exceptionBlocks.last();
        exceptionBlock.try_end = this.getIP();
        exceptionBlock.cur_locals = this.cur_locals;
        this.last_in = 2;
        if (this.show_instructions) {
            this.code_out.write(" [" + this.cur_stack + "]");
        }
        this.flushDebugInfo();
    }

    @Override
    protected void CatchClausesEnd() {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("CatchClausesEnd");
        }
        ExceptionBlock exceptionBlock = this.exceptionBlocks.last();
        int target = this.getIP();
        while (!exceptionBlock.fixups.isEmpty()) {
            int jump_index = exceptionBlock.fixups.removeLast();
            int offset = target - jump_index + 1 - 4;
            if (this.bytecodeFactory.show_bytecode) {
                this.code_out.println();
                this.code_out.print("      Jump@" + (jump_index - 1) + " <- " + offset);
            }
            this.ab.code.set(jump_index, (byte)offset);
            this.ab.code.set(jump_index + 1, (byte)(offset >> 8));
            this.ab.code.set(jump_index + 2, (byte)(offset >> 16));
        }
        this.last_in = 2;
        if (this.show_instructions) {
            this.code_out.write(" [" + this.cur_stack + "]");
        }
        this.flushDebugInfo();
    }

    @Override
    protected void CallFinally(int numFinallys) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("CallFinally");
        }
        this.flushDebugInfo();
        int finallysInvoked = 0;
        for (int i = this.exceptionBlocks.size(); i > 0; --i) {
            ExceptionBlock exceptionBlock = this.exceptionBlocks.at(i - 1);
            if (this.cur_locals > exceptionBlock.cur_locals) {
                exceptionBlock.cur_locals = this.cur_locals;
            }
            if (!exceptionBlock.hasFinally) continue;
            int finallyIndex = exceptionBlock.finallyAddrs.size();
            this.Pushbyte(this.ab.code, finallyIndex);
            this.Jump(this.ab.code);
            exceptionBlock.fixups.add(this.getIP() - 3);
            this.Label(this.ab.code);
            this.Pop();
            exceptionBlock.finallyAddrs.add(this.getIP());
            this.Label(this.ab.code);
            if (++finallysInvoked == numFinallys) break;
        }
        this.last_in = 2;
        if (this.show_instructions) {
            this.code_out.write(" [" + this.cur_stack + "]");
        }
    }

    @Override
    protected void FinallyClauseBegin() {
        ExceptionBlock exblock = this.exceptionBlocks.last();
        int temp = exblock.cur_locals;
        exblock.cur_locals = this.cur_locals;
        this.cur_locals = temp;
    }

    @Override
    protected void FinallyClauseEnd() {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("FinallyClauseEnd");
        }
        this.flushDebugInfo();
        this.last_in = 2;
        IntList fixups = this.exceptionBlocks.last().finallyAddrs;
        if (fixups.size() > 0) {
            int start = this.getIP();
            this.Lookupswitch(this.ab.code);
            ByteCodeFactory.Int24(this.ab.code, 0);
            ByteCodeFactory.Int(this.ab.code, fixups.size() - 1);
            int n = fixups.size();
            for (int i = 0; i < n; ++i) {
                ByteCodeFactory.Int24(this.ab.code, fixups.get(i) - start);
            }
            int offset = this.getIP() - start;
            this.ab.code.set(start + 1, (byte)offset);
            this.ab.code.set(start + 2, (byte)(offset >> 8));
            this.ab.code.set(start + 3, (byte)(offset >> 16));
        }
        this.cur_locals = this.exceptionBlocks.last().cur_locals;
        this.exceptionBlocks.removeLast();
        if (this.show_instructions) {
            this.code_out.write(" [" + this.cur_stack + "]");
        }
    }

    @Override
    protected void Catch(TypeValue type, QName name) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("Catch");
        }
        this.flushDebugInfo();
        ExceptionBlock exceptionBlock = this.exceptionBlocks.last();
        this.Jump(this.ab.code);
        exceptionBlock.fixups.add(this.getIP() - 3);
        ByteCodeFactory.Int(this.ab.exception_table, exceptionBlock.try_start);
        ByteCodeFactory.Int(this.ab.exception_table, exceptionBlock.try_end);
        ByteCodeFactory.Int(this.ab.exception_table, this.getIP());
        int class_index = this.addClassName(type.builder.classname);
        ByteCodeFactory.Int(this.ab.exception_table, class_index);
        int name_index = name != null ? this.addClassName(name) : 0;
        ByteCodeFactory.Int(this.ab.exception_table, name_index);
        this.stack(1);
        ++this.ab.exception_count;
        this.last_in = 2;
        if (this.show_instructions) {
            this.code_out.write(" [" + this.cur_stack + "]");
        }
    }

    @Override
    protected void Throw() {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("Throw");
        }
        this.flushDebugInfo();
        this.Throw(this.ab.code);
        this.last_in = 2;
        if (this.show_instructions) {
            this.code_out.write(" [" + this.cur_stack + "]");
        }
    }

    @Override
    protected void If(int kind) {
        this.showLineNumber();
        if (this.show_instructions) {
            String kind_str = "";
            switch (kind) {
                case 0: {
                    kind_str = "false";
                    break;
                }
                case 1: {
                    kind_str = "true";
                    break;
                }
                case 2: {
                    kind_str = "lt";
                    break;
                }
                case 4: {
                    kind_str = "le";
                    break;
                }
                case 5: {
                    kind_str = "gt";
                    break;
                }
                case 6: {
                    kind_str = "ge";
                    break;
                }
                case 8: {
                    kind_str = "eq";
                    break;
                }
                case 9: {
                    kind_str = "ne";
                    break;
                }
                case 10: {
                    kind_str = "stricteq";
                    break;
                }
                case 11: {
                    kind_str = "strictne";
                    break;
                }
                case 12: {
                    kind_str = "nlt";
                    break;
                }
                case 13: {
                    kind_str = "nle";
                    break;
                }
                case 14: {
                    kind_str = "ngt";
                    break;
                }
                case 15: {
                    kind_str = "nge";
                    break;
                }
            }
            this.code_out.println();
            this.code_out.print("If " + kind_str);
        }
        this.flushDebugInfo();
        switch (kind) {
            case 0: {
                this.Iffalse(this.ab.code);
                break;
            }
            case 1: {
                this.Iftrue(this.ab.code);
                break;
            }
            case 2: {
                this.Iflt(this.ab.code);
                break;
            }
            case 4: {
                this.Ifle(this.ab.code);
                break;
            }
            case 5: {
                this.Ifgt(this.ab.code);
                break;
            }
            case 6: {
                this.Ifge(this.ab.code);
                break;
            }
            case 8: {
                this.Ifeq(this.ab.code);
                break;
            }
            case 9: {
                this.Ifne(this.ab.code);
                break;
            }
            case 10: {
                this.Ifstricteq(this.ab.code);
                break;
            }
            case 11: {
                this.Ifstrictne(this.ab.code);
                break;
            }
            case 12: {
                this.Ifnlt(this.ab.code);
                break;
            }
            case 13: {
                this.Ifnle(this.ab.code);
                break;
            }
            case 14: {
                this.Ifngt(this.ab.code);
                break;
            }
            case 15: {
                this.Ifnge(this.ab.code);
                break;
            }
        }
        this.if_addrs.add(this.getIP() - 3);
        this.saveStackDepth();
        this.last_in = 2;
        if (this.show_instructions) {
            this.code_out.write(" [" + this.cur_stack + "]");
        }
    }

    @Override
    protected void InvokeBinary(int op_index, NumberUsage numberUsage) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("InvokeBinary " + this.getBinaryName(op_index));
        }
        this.flushDebugInfo();
        int param = 0;
        boolean useParam = false;
        if (this.cx.statics.es4_numerics && !numberUsage.is_default()) {
            param = numberUsage.encode();
            useParam = true;
        }
        this.last_in = 2;
        switch (op_index) {
            case 1: {
                this.Add_i(this.ab.code);
                break;
            }
            case 0: {
                if (useParam) {
                    this.Add_p(this.ab.code, param);
                    break;
                }
                this.Add(this.ab.code);
                break;
            }
            case 3: {
                this.Subtract_i(this.ab.code);
                break;
            }
            case 2: {
                if (useParam) {
                    this.Subtract_p(this.ab.code, param);
                    break;
                }
                this.Subtract(this.ab.code);
                break;
            }
            case 5: {
                this.Multiply_i(this.ab.code);
                break;
            }
            case 4: {
                if (useParam) {
                    this.Multiply_p(this.ab.code, param);
                    break;
                }
                this.Multiply(this.ab.code);
                break;
            }
            case 6: {
                if (useParam) {
                    this.Divide_p(this.ab.code, param);
                    break;
                }
                this.Divide(this.ab.code);
                break;
            }
            case 8: {
                if (useParam) {
                    this.Modulo_p(this.ab.code, param);
                    break;
                }
                this.Modulo(this.ab.code);
                break;
            }
            case 10: 
            case 11: {
                this.Lshift(this.ab.code);
                break;
            }
            case 12: 
            case 13: {
                this.Rshift(this.ab.code);
                break;
            }
            case 14: 
            case 15: {
                this.Urshift(this.ab.code);
                break;
            }
            case 16: {
                this.Lessthan(this.ab.code);
                break;
            }
            case 18: {
                this.Greaterthan(this.ab.code);
                break;
            }
            case 20: {
                this.Lessequals(this.ab.code);
                break;
            }
            case 22: {
                this.Greaterequals(this.ab.code);
                break;
            }
            case 28: 
            case 29: {
                this.Equals(this.ab.code);
                break;
            }
            case 32: 
            case 33: {
                this.Strictequals(this.ab.code);
                break;
            }
            case 30: 
            case 31: {
                this.Equals(this.ab.code);
                this.Not(this.ab.code);
                break;
            }
            case 34: 
            case 35: {
                this.Strictequals(this.ab.code);
                this.Not(this.ab.code);
                break;
            }
            case 36: 
            case 37: {
                this.Bitand(this.ab.code);
                break;
            }
            case 38: 
            case 39: {
                this.Bitxor(this.ab.code);
                break;
            }
            case 40: 
            case 41: {
                this.Bitor(this.ab.code);
                break;
            }
            case 42: 
            case 43: 
            case 45: 
            case 46: {
                break;
            }
            case 24: {
                this.Instanceof(this.ab.code);
                break;
            }
            case 25: {
                this.In(this.ab.code);
                break;
            }
            case 27: {
                this.Istypelate(this.ab.code);
                break;
            }
            case 49: {
                this.Astypelate(this.ab.code);
            }
        }
        if (this.show_instructions) {
            this.code_out.write(" [" + this.cur_stack + "]");
        }
    }

    @Override
    protected void ApplyType(int size) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("ApplyType " + size);
        }
        this.flushDebugInfo();
        this.ApplyType(this.ab.code, size);
        if (this.show_instructions) {
            this.code_out.write(" [" + this.cur_stack + "]");
        }
    }

    protected void ApplyType(ByteList code, int size) {
        this.stack(1 - size - 1);
        ByteCodeFactory.Byte(code, 83);
        ByteCodeFactory.Int(code, size);
    }

    @Override
    protected void InvokeClosure(boolean asConstruct, int size) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("InvokeClosure " + (asConstruct ? "construct" : "call") + ", " + size);
        }
        this.flushDebugInfo();
        this.last_in = 2;
        this.Callfunction(this.ab.code, asConstruct, size);
        if (this.show_instructions) {
            this.code_out.write(" [" + this.cur_stack + "]");
        }
    }

    @Override
    protected void ConstructProperty(String name, ObjectList<ObjectValue> qualifiers, int size, boolean is_qualified, boolean is_super, boolean is_attr) {
        this.callPropertyCommon(name, qualifiers, size, is_qualified, is_super, is_attr, true, false);
    }

    @Override
    protected void CallProperty(String name, ObjectList<ObjectValue> qualifiers, int size, boolean is_qualified, boolean is_super, boolean is_attr, boolean is_lex) {
        this.callPropertyCommon(name, qualifiers, size, is_qualified, is_super, is_attr, false, is_lex);
    }

    private void callPropertyCommon(String name, ObjectList<ObjectValue> qualifiers, int size, boolean is_qualified, boolean is_super, boolean is_attr, boolean is_new, boolean is_lex) {
        int index;
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            if (is_new) {
                this.code_out.print("ConstructProperty ");
            } else if (is_lex) {
                this.code_out.print("CallPropLex ");
            } else {
                this.code_out.print("CallProperty ");
            }
            this.code_out.print(name + " ");
            this.printNamespaceSet(qualifiers);
            this.code_out.print(" " + size + " is_qualified=" + is_qualified + " is_super=" + is_super + " is_attr=" + is_attr);
        }
        this.flushDebugInfo();
        this.last_ip = this.getIP();
        int name_index = name.equals("*") ? 0 : this.ab.addUtf8Constant(this.bytecodeFactory.ConstantUtf8Info(name));
        if (is_qualified && qualifiers.size() == 1) {
            int namespace = this.addNamespace(qualifiers.last());
            index = this.ab.addMultiNameConstant(this.bytecodeFactory.ConstantQualifiedName(name_index, namespace, is_attr));
        } else {
            int namespaces_set = this.makeNamespaceSet(qualifiers);
            index = this.ab.addMultiNameConstant(this.bytecodeFactory.ConstantMultiname(name_index, namespaces_set, is_attr));
        }
        if (is_super) {
            this.Callsuper(this.ab.code, index, size);
        } else if (is_new) {
            this.Constructproperty(this.ab.code, index, size);
        } else if (is_lex) {
            this.Callproplex(this.ab.code, index, size);
        } else {
            this.Callproperty(this.ab.code, index, size);
        }
        this.last_in = 2;
        if (this.show_instructions) {
            this.code_out.print(" [" + this.cur_stack + "]");
        }
    }

    @Override
    protected void InvokeMethod(boolean localDispatch, int method_id, int size) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("InvokeMethod " + (localDispatch ? "local" : "global") + " " + method_id + " " + size);
        }
        this.flushDebugInfo();
        this.last_in = 2;
        if (localDispatch) {
            this.Callmethod(this.ab.code, method_id, size);
        } else {
            this.Callstatic(this.ab.code, method_id, size);
        }
        if (this.show_instructions) {
            this.code_out.write(" [" + this.cur_stack + "]");
        }
    }

    @Override
    protected void InvokeSuper(boolean construct, int size) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("InvokeSuper " + (construct ? "construct" : "call") + " " + size);
        }
        this.flushDebugInfo();
        this.last_in = 2;
        if (construct) {
            this.Constructsuper(this.ab.code, size);
        } else {
            this.cx.internalError("internal error in InvokeSuper()");
        }
        if (this.show_instructions) {
            this.code_out.print(" [" + this.cur_stack + "]");
        }
    }

    @Override
    protected void InvokeUnary(int operator_id, int size, int data, Namespaces used_def_namespaces, NumberUsage numberUsage) {
        this.showLineNumber();
        int param = 0;
        boolean useParam = false;
        if (this.cx.statics.es4_numerics && numberUsage != null && !numberUsage.is_default()) {
            param = numberUsage.encode();
            useParam = true;
        }
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("InvokeUnary " + this.getUnaryName(operator_id) + " " + size);
            if (data >= 0) {
                this.code_out.write(" " + data);
            }
        }
        this.flushDebugInfo();
        this.last_in = 2;
        switch (operator_id) {
            case 13: {
                int str_index = this.ab.addUtf8Constant(this.bytecodeFactory.ConstantUtf8Info("boolean"));
                this.Pushstring(this.ab.code, str_index);
                break;
            }
            case 14: 
            case 39: {
                int str_index = this.ab.addUtf8Constant(this.bytecodeFactory.ConstantUtf8Info("number"));
                this.Pushstring(this.ab.code, str_index);
                break;
            }
            case 40: {
                int str_index = this.ab.addUtf8Constant(this.bytecodeFactory.ConstantUtf8Info("number"));
                this.Pushstring(this.ab.code, str_index);
                break;
            }
            case 16: {
                int str_index = this.ab.addUtf8Constant(this.bytecodeFactory.ConstantUtf8Info("string"));
                this.Pushstring(this.ab.code, str_index);
                break;
            }
            case 17: {
                int str_index = this.ab.addUtf8Constant(this.bytecodeFactory.ConstantUtf8Info("undefined"));
                this.Pushstring(this.ab.code, str_index);
                break;
            }
            case 12: {
                this.Typeof(this.ab.code);
                break;
            }
            case 18: {
                if (useParam) {
                    this.Increment_p(this.ab.code, param);
                    break;
                }
                this.Increment(this.ab.code);
                break;
            }
            case 20: {
                this.Increment_i(this.ab.code);
                break;
            }
            case 19: {
                if (useParam) {
                    this.Inclocal_p(this.ab.code, data, param);
                    break;
                }
                this.Inclocal(this.ab.code, data);
                break;
            }
            case 21: {
                this.Inclocal_i(this.ab.code, data);
                break;
            }
            case 22: {
                if (useParam) {
                    this.Decrement_p(this.ab.code, param);
                    break;
                }
                this.Decrement(this.ab.code);
                break;
            }
            case 24: {
                this.Decrement_i(this.ab.code);
                break;
            }
            case 23: {
                if (useParam) {
                    this.Declocal_p(this.ab.code, data, param);
                    break;
                }
                this.Declocal(this.ab.code, data);
                break;
            }
            case 25: {
                this.Declocal_i(this.ab.code, data);
                break;
            }
            case 27: {
                break;
            }
            case 26: {
                this.Convert_d(this.ab.code);
                break;
            }
            case 28: {
                this.Convert_m(this.ab.code);
                break;
            }
            case 29: 
            case 30: {
                if (useParam) {
                    this.Negate_p(this.ab.code, param);
                    break;
                }
                this.Negate(this.ab.code);
                break;
            }
            case 34: 
            case 35: {
                this.Not(this.ab.code);
                break;
            }
            case 2: {
                int namespaces_set = this.makeNamespaceSet(used_def_namespaces);
                int index = this.ab.addMultiNameConstant(this.bytecodeFactory.ConstantMultinameLate(namespaces_set, false));
                this.Setproperty(this.ab.code, index);
                break;
            }
            case 3: {
                int namespaces_set = this.makeNamespaceSet(used_def_namespaces);
                int index = this.ab.addMultiNameConstant(this.bytecodeFactory.ConstantMultinameLate(namespaces_set, false));
                this.Getproperty(this.ab.code, index);
                break;
            }
            case 33: {
                this.Not(this.ab.code);
                break;
            }
            case 4: {
                this.Hasnext(this.ab.code);
                break;
            }
            case 10: {
                int namespaces_set = this.makeNamespaceSet(used_def_namespaces);
                int index = this.ab.addMultiNameConstant(this.bytecodeFactory.ConstantMultinameLate(namespaces_set, false));
                this.Delproperty(this.ab.code, index);
                break;
            }
            case 31: 
            case 32: {
                this.Bitnot(this.ab.code);
                break;
            }
            case 5: {
                this.Nextname(this.ab.code);
                break;
            }
            case 6: {
                this.Nextvalue(this.ab.code);
                break;
            }
            case 11: {
                break;
            }
            case 36: {
                this.Esc_xelem(this.ab.code);
                break;
            }
            case 37: {
                this.Esc_xattr(this.ab.code);
                break;
            }
            case 38: {
                this.CheckFilter(this.ab.code);
                break;
            }
        }
        if (this.show_instructions) {
            this.code_out.write(" [" + this.cur_stack + "]");
        }
    }

    @Override
    protected void LoadGlobal(int var_index, int type_id) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("LoadGlobal " + var_index + ", " + RuntimeConstants.typeToString(type_id));
        }
        this.flushDebugInfo();
        this.last_ip = this.getIP();
        this.last_in = 1;
        this.Getglobalscope(this.ab.code);
        this.Getslot(this.ab.code, var_index + 1);
        if (this.show_instructions) {
            this.code_out.write(" [" + this.cur_stack + "]");
        }
    }

    @Override
    protected void LoadGlobal(String name) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("LoadGlobal " + name);
        }
        this.flushDebugInfo();
        this.cx.internalError("LoadGlobal(name) is deprecated");
        if (this.show_instructions) {
            this.code_out.write(" [" + this.cur_stack + "]");
        }
    }

    @Override
    protected void LoadRegister(int reg, int type_id) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("LoadRegister " + reg + ", " + RuntimeConstants.typeToString(type_id));
        }
        this.flushDebugInfo();
        this.last_ip = this.getIP();
        this.last_in = 1;
        this.Getlocal(this.ab.code, reg);
        if (this.show_instructions) {
            this.code_out.write(" [" + this.cur_stack + "]");
        }
    }

    @Override
    protected void LoadThis() {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("LoadThis");
        }
        this.flushDebugInfo();
        this.last_ip = this.getIP();
        this.last_in = 1;
        this.Getlocal(this.ab.code, 0);
        if (this.show_instructions) {
            this.code_out.write(" [" + this.cur_stack + "]");
        }
    }

    @Override
    protected void LoadSuper() {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("LoadSuper");
        }
        this.flushDebugInfo();
        this.last_ip = this.getIP();
        this.cx.internalError("super expressions are not implemented");
        this.last_in = 1;
        if (this.show_instructions) {
            this.code_out.write(" [" + this.cur_stack + "]");
        }
    }

    @Override
    protected void LoadVar(int var_index) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("LoadVar " + var_index);
        }
        this.flushDebugInfo();
        this.last_ip = this.getIP();
        this.Getslot(this.ab.code, var_index + 1);
        this.last_in = 2;
        if (this.show_instructions) {
            this.code_out.write(" [" + this.cur_stack + "]");
        }
    }

    @Override
    protected void LabelStatementBegin() {
        this.break_addrs.add(new IntList());
        this.break_scope_depth.add(this.cx.getScopeDepth());
        this.break_temp_count.add(this.cur_locals);
        this.continue_addrs.add(new IntList());
        this.continue_scope_depth.add(this.cx.getScopeDepth());
    }

    @Override
    protected void LabelStatementEnd(int loop_index) {
        this.PatchBreak(loop_index);
        this.PatchContinue(loop_index);
    }

    @Override
    protected void LoopBegin() {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("LoopBegin");
        }
        this.break_addrs.add(new IntList());
        this.break_scope_depth.add(this.cx.getScopeDepth());
        this.break_temp_count.add(this.cur_locals);
        this.continue_addrs.add(new IntList());
        this.continue_scope_depth.add(this.cx.getScopeDepth());
        this.Jump(this.ab.code);
        this.loopbegin_addrs.add(this.getIP() - 3);
        this.Label(this.ab.code);
        this.last_in = 2;
        if (this.show_instructions) {
            this.code_out.write(" [" + this.cur_stack + "]");
        }
    }

    @Override
    protected void LoopEnd(int kind) {
        this.showLineNumber();
        if (this.show_instructions) {
            String kind_str = "";
            switch (kind) {
                case 0: {
                    kind_str = "false";
                    break;
                }
                case 1: {
                    kind_str = "true";
                    break;
                }
                case 2: {
                    kind_str = "lt";
                    break;
                }
                case 4: {
                    kind_str = "le";
                    break;
                }
                case 5: {
                    kind_str = "gt";
                    break;
                }
                case 6: {
                    kind_str = "ge";
                    break;
                }
                case 8: {
                    kind_str = "eq";
                    break;
                }
                case 9: {
                    kind_str = "ne";
                    break;
                }
                case 10: {
                    kind_str = "stricteq";
                    break;
                }
                case 11: {
                    kind_str = "strictne";
                    break;
                }
                case 12: {
                    kind_str = "nlt";
                    break;
                }
                case 13: {
                    kind_str = "nle";
                    break;
                }
                case 14: {
                    kind_str = "ngt";
                    break;
                }
                case 15: {
                    kind_str = "nge";
                    break;
                }
            }
            this.code_out.println();
            this.code_out.print("LoopEnd " + kind_str);
        }
        this.flushDebugInfo();
        int addr = this.getIP();
        int offset = this.loopbegin_addrs.back() - addr + 2 - 3;
        switch (kind) {
            case 0: {
                this.Iffalse(this.ab.code, offset);
                break;
            }
            case 1: {
                this.Iftrue(this.ab.code, offset);
                break;
            }
            case 2: {
                this.Iflt(this.ab.code, offset);
                break;
            }
            case 4: {
                this.Ifle(this.ab.code, offset);
                break;
            }
            case 5: {
                this.Ifgt(this.ab.code, offset);
                break;
            }
            case 6: {
                this.Ifge(this.ab.code, offset);
                break;
            }
            case 8: {
                this.Ifeq(this.ab.code, offset);
                break;
            }
            case 9: {
                this.Ifne(this.ab.code, offset);
                break;
            }
            case 10: {
                this.Ifstricteq(this.ab.code, offset);
                break;
            }
            case 11: {
                this.Ifstrictne(this.ab.code, offset);
                break;
            }
            case 12: {
                this.Ifnlt(this.ab.code, offset);
                break;
            }
            case 13: {
                this.Ifnle(this.ab.code, offset);
                break;
            }
            case 14: {
                this.Ifngt(this.ab.code, offset);
                break;
            }
            case 15: {
                this.Ifnge(this.ab.code, offset);
                break;
            }
        }
        this.loopbegin_addrs.removeLast();
        this.last_in = 2;
        if (this.show_instructions) {
            this.code_out.write(" [" + this.cur_stack + "]");
        }
    }

    @Override
    protected void NewArray(int size) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("NewArray " + size);
        }
        this.flushDebugInfo();
        this.last_in = 2;
        this.Newarray(this.ab.code, size);
        if (this.show_instructions) {
            this.code_out.write(" [" + this.cur_stack + "]");
        }
    }

    @Override
    protected void NewClassObject(QName name) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("NewClassObject " + name);
        }
        this.flushDebugInfo();
        this.last_ip = this.getIP();
        this.last_in = 2;
        int info = this.GetClassInfo(name);
        this.Newclass(this.ab.code, info);
        if (this.show_instructions) {
            this.code_out.write(" [" + this.cur_stack + "]");
        }
    }

    @Override
    protected void NewFunctionObject(String name) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("NewFunctionObject " + name);
        }
        this.flushDebugInfo();
        this.last_ip = this.getIP();
        this.last_in = 2;
        int method_info = this.GetMethodInfo(name);
        this.Newfunction(this.ab.code, method_info);
        if (this.show_instructions) {
            this.code_out.write(" [" + this.cur_stack + "]");
        }
    }

    @Override
    protected void NewActivation() {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("NewActivation");
        }
        this.flushDebugInfo();
        this.last_in = 2;
        this.Newactivation(this.ab.code);
        if (this.show_instructions) {
            this.code_out.write(" [" + this.cur_stack + "]");
        }
    }

    @Override
    protected void NewCatch(int index) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("NewCatch " + index);
        }
        this.flushDebugInfo();
        this.last_in = 2;
        this.Newcatch(this.ab.code, index);
        if (this.show_instructions) {
            this.code_out.write(" [" + this.cur_stack + "]");
        }
    }

    @Override
    protected void NewObject(int size) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("NewObject " + size);
        }
        this.flushDebugInfo();
        this.last_in = 2;
        this.Newobject(this.ab.code, size);
        if (this.show_instructions) {
            this.code_out.write(" [" + this.cur_stack + "]");
        }
    }

    @Override
    protected void PatchBreak(int loop_index) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("PatchBreak " + loop_index);
        }
        this.flushDebugInfo();
        int target = this.getIP();
        IntList break_addr = this.break_addrs.removeLast();
        while (break_addr.size() != 0) {
            int break_index = break_addr.removeLast();
            int offset = target - break_index + 1 - 4;
            if (this.bytecodeFactory.show_bytecode) {
                this.code_out.println();
                this.code_out.print("      Jump@" + (break_index - 1) + " <- " + offset);
            }
            this.ab.code.set(break_index, (byte)offset);
            this.ab.code.set(break_index + 1, (byte)(offset >> 8));
            this.ab.code.set(break_index + 2, (byte)(offset >> 16));
        }
        this.break_scope_depth.removeLast();
        this.break_temp_count.removeLast();
        this.last_in = 2;
        if (this.show_instructions) {
            this.code_out.write(" [" + this.cur_stack + "]");
        }
    }

    @Override
    protected void PatchContinue(int loop_index) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("PatchContinue " + loop_index);
        }
        this.flushDebugInfo();
        int target = this.getIP();
        IntList continue_addr = this.continue_addrs.removeLast();
        while (continue_addr.size() != 0) {
            int continue_index = continue_addr.removeLast();
            int offset = target - continue_index + 1 - 4;
            if (this.bytecodeFactory.show_bytecode) {
                this.code_out.println();
                this.code_out.print("      Jump@" + (continue_index - 1) + " <- " + offset);
            }
            this.ab.code.set(continue_index, (byte)offset);
            this.ab.code.set(continue_index + 1, (byte)(offset >> 8));
            this.ab.code.set(continue_index + 2, (byte)(offset >> 16));
        }
        this.continue_scope_depth.removeLast();
        this.last_in = 2;
        if (this.show_instructions) {
            this.code_out.write(" [" + this.cur_stack + "]");
        }
    }

    @Override
    protected void PatchElse(int target) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("PatchElse " + this.else_addrs.last());
        }
        this.flushDebugInfo();
        int else_index = this.else_addrs.removeLast();
        int offset = target - else_index + 1 - 4;
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.println();
            this.code_out.print("      Jump@" + (else_index - 1) + " <- " + offset);
        }
        this.ab.code.set(else_index, (byte)offset);
        this.ab.code.set(else_index + 1, (byte)(offset >> 8));
        this.ab.code.set(else_index + 2, (byte)(offset >> 16));
        this.last_in = 2;
        if (this.show_instructions) {
            this.code_out.write(" [" + this.cur_stack + "]");
        }
    }

    @Override
    protected void PatchIf(int target) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("PatchIf " + this.if_addrs.last());
        }
        this.flushDebugInfo();
        this.restoreStackDepth();
        int if_index = this.if_addrs.removeLast();
        int offset = target - if_index + 1 - 4;
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.println();
            this.code_out.print("      If@" + (if_index - 1) + " <- " + offset);
        }
        this.ab.code.set(if_index, (byte)offset);
        this.ab.code.set(if_index + 1, (byte)(offset >> 8));
        this.ab.code.set(if_index + 2, (byte)(offset >> 16));
        this.last_in = 2;
        if (this.show_instructions) {
            this.code_out.write(" [" + this.cur_stack + "]");
        }
    }

    @Override
    protected void PatchLoopBegin(int target) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("PatchLoopBegin " + target);
        }
        this.flushDebugInfo();
        int loopbegin_index = this.loopbegin_addrs.last();
        int offset = target - loopbegin_index + 1 - 4;
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.println();
            this.code_out.print("      Jump@" + (loopbegin_index - 1) + " <- " + offset);
        }
        this.ab.code.set(loopbegin_index, (byte)offset);
        this.ab.code.set(loopbegin_index + 1, (byte)(offset >> 8));
        this.ab.code.set(loopbegin_index + 2, (byte)(offset >> 16));
        this.last_in = 2;
        if (this.show_instructions) {
            this.code_out.write(" [" + this.cur_stack + "]");
        }
    }

    @Override
    protected void PatchSwitchBegin(int addr) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("PatchSwitchBegin " + addr);
        }
        this.flushDebugInfo();
        this.restoreStackDepth();
        int switchbegin_index = this.switchbegin_addrs.removeLast();
        int offset = addr - switchbegin_index + 1 - 4;
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.println();
            this.code_out.print("      Jump@" + (switchbegin_index - 1) + " <- " + offset);
        }
        this.ab.code.set(switchbegin_index, (byte)offset);
        this.ab.code.set(switchbegin_index + 1, (byte)(offset >> 8));
        this.ab.code.set(switchbegin_index + 2, (byte)(offset >> 16));
        this.last_in = 2;
        this.seen_default_case.removeLast();
        if (this.show_instructions) {
            this.code_out.write(" [" + this.cur_stack + "]");
        }
    }

    @Override
    protected void Pop() {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("Pop");
        }
        this.flushDebugInfo();
        this.Pop(this.ab.code);
        this.last_in = 2;
        if (this.show_instructions) {
            this.code_out.write(" [" + this.cur_stack + "]");
        }
    }

    @Override
    protected void PushBoolean(boolean value) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("PushBoolean " + (value ? 1 : 0));
        }
        this.flushDebugInfo();
        this.last_ip = this.getIP();
        this.last_in = 1;
        if (value) {
            this.Pushtrue(this.ab.code);
        } else {
            this.Pushfalse(this.ab.code);
        }
        if (this.show_instructions) {
            this.code_out.write(" [" + this.cur_stack + "]");
        }
    }

    @Override
    protected void PushEmpty() {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("PushEmpty");
        }
        this.flushDebugInfo();
        this.last_ip = this.getIP();
        this.last_in = 1;
        this.Pushnull(this.ab.code);
        if (this.show_instructions) {
            this.code_out.write(" [" + this.cur_stack + "]");
        }
    }

    @Override
    protected void PushCaseIndex(int index) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("PushCaseIndex " + index);
        }
        this.flushDebugInfo();
        this.Pushshort(this.ab.code, index);
        if (this.show_instructions) {
            this.code_out.write(" [" + this.cur_stack + "]");
        }
    }

    @Override
    protected void PushNull() {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("PushNull");
        }
        this.flushDebugInfo();
        this.last_ip = this.getIP();
        this.last_in = 1;
        this.Pushnull(this.ab.code);
        if (this.show_instructions) {
            this.code_out.write(" [" + this.cur_stack + "]");
        }
    }

    @Override
    protected void PushNumber(NumberConstant val, int type_id) {
        this.showLineNumber();
        if (this.show_instructions) {
            String nn;
            this.code_out.println();
            if (val.number_type() == 1) {
                nn = val.decimalValue().toString();
            } else {
                StringBuilder numStr = new StringBuilder();
                ByteCodeFactory.IL_FormatDoubleAsString(val.doubleValue(), numStr);
                nn = numStr.toString();
            }
            this.code_out.print("PushNumber " + nn + ", " + RuntimeConstants.typeToString(type_id));
        }
        this.flushDebugInfo();
        this.last_ip = this.getIP();
        this.last_in = 1;
        if (type_id == 256 || type_id == 512 && this.cx.abcVersion(0)) {
            int ival = val.intValue();
            if ((byte)ival == ival) {
                this.Pushbyte(this.ab.code, ival);
            } else if ((short)ival == ival) {
                this.Pushshort(this.ab.code, ival);
            } else {
                int index = this.ab.addIntConstant(this.bytecodeFactory.ConstantIntegerInfo(ival));
                this.Pushint(this.ab.code, index);
            }
        } else if (type_id == 512) {
            long ival = val.uintValue();
            if ((ival & 0x7FL) == ival) {
                this.Pushbyte(this.ab.code, (int)ival);
            } else if ((ival & 0x7FFFFL) == ival) {
                this.Pushshort(this.ab.code, (int)ival);
            } else {
                int index = this.ab.addUintConstant(this.bytecodeFactory.ConstantUintInfo((int)ival));
                this.Pushuint(this.ab.code, index);
            }
        } else if (type_id == 64) {
            double dval = val.doubleValue();
            if (Double.isNaN(dval)) {
                this.Pushnan(this.ab.code);
            } else if (dval != 0.0 && !Double.isInfinite(dval) && dval == (double)val.intValue()) {
                int ival = val.intValue();
                if ((byte)ival == ival) {
                    this.Pushbyte(this.ab.code, ival);
                } else if ((short)ival == ival) {
                    this.Pushshort(this.ab.code, ival);
                } else {
                    int index = this.ab.addIntConstant(this.bytecodeFactory.ConstantIntegerInfo(ival));
                    this.Pushint(this.ab.code, index);
                }
            } else {
                int index = this.ab.addDoubleConstant(this.bytecodeFactory.ConstantDoubleInfo(dval));
                this.Pushdouble(this.ab.code, index);
            }
        } else if (type_id == 65536) {
            Decimal128 dval = val.decimalValue();
            int index = this.ab.addDecimalConstant(this.bytecodeFactory.ConstantDecimalInfo(dval));
            this.Pushdecimal(this.ab.code, index);
        }
        if (this.show_instructions) {
            this.code_out.write(" [" + this.cur_stack + "]");
        }
    }

    @Override
    protected void NewNamespace(ObjectValue ns) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("NewNamespace " + ns.name);
        }
        this.flushDebugInfo();
        this.last_ip = this.getIP();
        this.last_in = 2;
        this.addNamespace(ns);
        if (this.show_instructions) {
            this.code_out.print(" [" + this.cur_stack + "]");
        }
    }

    @Override
    protected void PushString(String str) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("PushString " + str);
        }
        this.last_ip = this.getIP();
        this.last_in = 1;
        int str_index = this.ab.addUtf8Constant(this.bytecodeFactory.ConstantUtf8Info(str));
        this.Pushstring(this.ab.code, str_index);
        if (this.show_instructions) {
            this.code_out.write(" [" + this.cur_stack + "]");
        }
    }

    @Override
    protected void PushNamespace(ObjectValue ns) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("PushNamespace " + ns.name);
        }
        this.last_ip = this.getIP();
        this.last_in = 1;
        int ns_index = this.addNamespace(ns);
        this.Pushnamespace(this.ab.code, ns_index);
        if (this.show_instructions) {
            this.code_out.write(" [" + this.cur_stack + "]");
        }
    }

    @Override
    protected void PushUndefined() {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("PushUndefined");
        }
        this.flushDebugInfo();
        this.last_ip = this.getIP();
        this.last_in = 1;
        this.Pushundefined(this.ab.code);
        if (this.show_instructions) {
            this.code_out.write(" [" + this.cur_stack + "]");
        }
    }

    @Override
    protected void PushUninitialized() {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("PushUninitialized");
        }
        this.flushDebugInfo();
        this.last_ip = this.getIP();
        this.last_in = 1;
        this.Pushuninitialized(this.ab.code);
        if (this.show_instructions) {
            this.code_out.write(" [" + this.cur_stack + "]");
        }
    }

    @Override
    protected void Return(int type_id) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("Return");
        }
        this.flushDebugInfo();
        if (type_id == 1024) {
            this.Returnvoid(this.ab.code);
        } else {
            this.Returnvalue(this.ab.code);
        }
        this.last_in = 2;
        if (this.show_instructions) {
            this.code_out.write(" [" + this.cur_stack + "]");
        }
    }

    @Override
    protected void StoreGlobal(int var_index, int type_id) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("StoreGlobal " + var_index + ", " + RuntimeConstants.typeToString(type_id));
        }
        this.flushDebugInfo();
        this.last_in = 2;
        this.Getglobalscope(this.ab.code);
        this.Swap(this.ab.code);
        this.Setslot(this.ab.code, var_index + 1);
        if (this.show_instructions) {
            this.code_out.write(" [" + this.cur_stack + "]");
        }
    }

    @Override
    protected void StoreGlobal(String name) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("StoreGlobal " + name);
        }
        this.flushDebugInfo();
        this.cx.internalError("StoreGlobal(name) is deprecated");
        if (this.show_instructions) {
            this.code_out.write(" [" + this.cur_stack + "]");
        }
    }

    @Override
    protected void StoreRegister(int reg, int type, String varName) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("StoreRegister " + reg + ", " + RuntimeConstants.typeToString(type));
        }
        this.flushDebugInfo();
        this.last_in = 2;
        this.Setlocal(this.ab.code, reg);
        if (this.show_instructions) {
            this.code_out.write(" [" + this.cur_stack + "]");
        }
    }

    @Override
    protected void HasNext(int objectRegister, int indexRegister) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("HasNext " + objectRegister + ", " + indexRegister);
        }
        this.flushDebugInfo();
        this.last_in = 2;
        this.Hasnext2(this.ab.code, objectRegister, indexRegister);
        if (this.show_instructions) {
            this.code_out.write(" [" + this.cur_stack + "]");
        }
    }

    @Override
    protected void StoreVar(int var_index) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("StoreVar " + var_index);
        }
        this.flushDebugInfo();
        this.last_in = 2;
        this.Setslot(this.ab.code, var_index + 1);
        if (this.show_instructions) {
            this.code_out.write(" [" + this.cur_stack + "]");
        }
    }

    @Override
    protected void SwitchBegin() {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("SwitchBegin");
        }
        this.seen_default_case.add(0);
        this.case_addrs.add(new IntList());
        this.break_addrs.add(new IntList());
        this.break_scope_depth.add(this.cx.getScopeDepth());
        this.break_temp_count.add(this.cur_locals);
        this.continue_addrs.add(new IntList());
        this.continue_scope_depth.add(this.cx.getScopeDepth());
        this.Jump(this.ab.code);
        this.switchbegin_addrs.add(this.getIP() - 3);
        this.saveStackDepth();
        this.last_in = 2;
        if (this.show_instructions) {
            this.code_out.write(" [" + this.cur_stack + "]");
        }
    }

    @Override
    protected void SwitchTable() {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("SwitchTable");
        }
        this.flushDebugInfo();
        this.last_in = 2;
        int start = this.getIP();
        this.Lookupswitch(this.ab.code);
        int default_addr = this.default_addrs.removeLast();
        ByteCodeFactory.Int24(this.ab.code, default_addr - start);
        IntList case_addr = this.case_addrs.removeLast();
        ByteCodeFactory.Int(this.ab.code, case_addr.size() - 1);
        int n = case_addr.size();
        for (int case_index = 0; case_index < n; ++case_index) {
            ByteCodeFactory.Int24(this.ab.code, case_addr.get(case_index) - start);
        }
        if (this.show_instructions) {
            this.code_out.write(" [" + this.cur_stack + "]");
        }
        IntList switch_continues = this.continue_addrs.removeLast();
        if (this.continue_addrs.size() != 0) {
            IntList outer_continues = this.continue_addrs.last();
            outer_continues.addAll(switch_continues);
        }
        this.continue_scope_depth.removeLast();
    }

    @Override
    protected void ToBoolean(int type_id) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("ToBoolean " + RuntimeConstants.typeToString(type_id));
        }
        this.flushDebugInfo();
        this.last_in = 2;
        this.Convert_b(this.ab.code);
        if (this.show_instructions) {
            this.code_out.write(" [" + this.cur_stack + "]");
        }
    }

    @Override
    protected void ToNativeBool() {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("ToNativeBool");
        }
        this.flushDebugInfo();
    }

    @Override
    protected void ToInt() {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("ToInt");
        }
        this.Convert_i(this.ab.code);
        this.flushDebugInfo();
    }

    @Override
    protected void ToUint() {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("ToUint");
        }
        this.Convert_i(this.ab.code);
        this.flushDebugInfo();
    }

    @Override
    protected void ToDouble(int type_id) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("ToDouble " + RuntimeConstants.typeToString(type_id));
        }
        this.flushDebugInfo();
        this.last_in = 2;
        this.Convert_d(this.ab.code);
        if (this.show_instructions) {
            this.code_out.write(" [" + this.cur_stack + "]");
        }
    }

    @Override
    protected void ToDecimal(int type_id) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("ToDecimal " + RuntimeConstants.typeToString(type_id));
        }
        this.flushDebugInfo();
        this.last_in = 2;
        this.Convert_m(this.ab.code);
        if (this.show_instructions) {
            this.code_out.write(" [" + this.cur_stack + "]");
        }
    }

    @Override
    protected void ToObject() {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("ToObject");
        }
        this.flushDebugInfo();
        this.last_in = 2;
        this.Convert_o(this.ab.code);
        if (this.show_instructions) {
            this.code_out.write(" [" + this.cur_stack + "]");
        }
    }

    @Override
    protected void ToString() {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("ToString");
        }
        this.flushDebugInfo();
        this.last_in = 2;
        this.Convert_s(this.ab.code);
        if (this.show_instructions) {
            this.code_out.write(" [" + this.cur_stack + "]");
        }
    }

    @Override
    protected void PushScope() {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("PushScope");
        }
        this.flushDebugInfo();
        this.Pushscope(this.ab.code);
        this.last_ip = this.getIP();
        if (this.show_instructions) {
            this.code_out.write(" [" + this.cur_stack + "]");
        }
    }

    @Override
    protected void PushWith() {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("PushWith");
        }
        this.flushDebugInfo();
        this.Pushwith(this.ab.code);
        this.last_ip = this.getIP();
        if (this.show_instructions) {
            this.code_out.write(" [" + this.cur_stack + "]");
        }
    }

    @Override
    protected void PopScope() {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("PopScope");
        }
        this.flushDebugInfo();
        this.Popscope(this.ab.code);
        this.last_ip = this.getIP();
        if (this.show_instructions) {
            this.code_out.write(" [" + this.cur_stack + "]");
        }
    }

    @Override
    protected void PopWith() {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("PopWith");
        }
        this.flushDebugInfo();
        this.Popscope(this.ab.code);
        this.last_ip = this.getIP();
        if (this.show_instructions) {
            this.code_out.write(" [" + this.cur_stack + "]");
        }
    }

    @Override
    protected void Swap() {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("Swap");
        }
        this.flushDebugInfo();
        this.Swap(this.ab.code);
        this.last_ip = this.getIP();
        if (this.show_instructions) {
            this.code_out.write(" [" + this.cur_stack + "]");
        }
    }

    @Override
    public void DefaultXMLNamespace() {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("DefaultXMLNamespace");
        }
        this.flushDebugInfo();
        this.Dxnslate(this.ab.code);
        this.sets_dxns = true;
        this.last_in = 2;
        if (this.show_instructions) {
            this.code_out.print(" [" + this.cur_stack + "]");
        }
    }

    @Override
    public void DefaultXMLNamespace(String name) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("DefaultXMLNamespace " + name);
        }
        this.flushDebugInfo();
        int index = this.ab.addUtf8Constant(this.bytecodeFactory.ConstantUtf8Info(name));
        this.Dxns(this.ab.code, index);
        this.sets_dxns = true;
        this.last_in = 2;
        if (this.show_instructions) {
            this.code_out.print(" [" + this.cur_stack + "]");
        }
    }

    protected void Bkpt(ByteList code) {
        this.stack(0);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Bkpt");
        }
        ByteCodeFactory.Byte(code, 1);
    }

    protected void Nop(ByteList code) {
        this.stack(0);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Nop");
        }
        ByteCodeFactory.Byte(code, 2);
    }

    protected void Throw(ByteList code) {
        this.stack(-1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Throw");
        }
        ByteCodeFactory.Byte(code, 3);
    }

    protected void Jump(ByteList code) {
        this.stack(0);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Jump");
        }
        ByteCodeFactory.Byte(code, 16);
        ByteCodeFactory.Int24(code, 0);
    }

    protected void Label(ByteList code) {
        this.stack(0);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Label");
        }
        ByteCodeFactory.Byte(code, 9);
    }

    protected void Iftrue(ByteList code) {
        this.Iftrue(code, 0);
    }

    protected void Iftrue(ByteList code, int offset) {
        this.stack(-1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Iftrue " + offset);
        }
        ByteCodeFactory.Byte(code, 17);
        ByteCodeFactory.Int24(code, offset);
    }

    protected void Iffalse(ByteList code) {
        this.Iffalse(code, 0);
    }

    protected void Iffalse(ByteList code, int offset) {
        this.stack(-1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Iffalse");
        }
        ByteCodeFactory.Byte(code, 18);
        ByteCodeFactory.Int24(code, offset);
    }

    protected void Ifeq(ByteList code) {
        this.Ifeq(code, 0);
    }

    protected void Ifeq(ByteList code, int offset) {
        this.stack(-2);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Ifeq");
        }
        ByteCodeFactory.Byte(code, 19);
        ByteCodeFactory.Int24(code, offset);
    }

    protected void Ifne(ByteList code) {
        this.Ifne(code, 0);
    }

    protected void Ifne(ByteList code, int offset) {
        this.stack(-2);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Ifne");
        }
        ByteCodeFactory.Byte(code, 20);
        ByteCodeFactory.Int24(code, offset);
    }

    protected void Iflt(ByteList code) {
        this.Iflt(code, 0);
    }

    protected void Iflt(ByteList code, int offset) {
        this.stack(-2);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Iflt");
        }
        ByteCodeFactory.Byte(code, 21);
        ByteCodeFactory.Int24(code, offset);
    }

    protected void Ifle(ByteList code) {
        this.Ifle(code, 0);
    }

    protected void Ifle(ByteList code, int offset) {
        this.stack(-2);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Ifle");
        }
        ByteCodeFactory.Byte(code, 22);
        ByteCodeFactory.Int24(code, offset);
    }

    protected void Ifgt(ByteList code) {
        this.Ifgt(code, 0);
    }

    protected void Ifgt(ByteList code, int offset) {
        this.stack(-2);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Ifgt");
        }
        ByteCodeFactory.Byte(code, 23);
        ByteCodeFactory.Int24(code, offset);
    }

    protected void Ifge(ByteList code) {
        this.Ifge(code, 0);
    }

    protected void Ifge(ByteList code, int offset) {
        this.stack(-2);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Ifge");
        }
        ByteCodeFactory.Byte(code, 24);
        ByteCodeFactory.Int24(code, offset);
    }

    protected void Ifstricteq(ByteList code) {
        this.Ifstricteq(code, 0);
    }

    protected void Ifstricteq(ByteList code, int offset) {
        this.stack(-2);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Ifstricteq");
        }
        ByteCodeFactory.Byte(code, 25);
        ByteCodeFactory.Int24(code, offset);
    }

    protected void Ifstrictne(ByteList code) {
        this.Ifstrictne(code, 0);
    }

    protected void Ifstrictne(ByteList code, int offset) {
        this.stack(-2);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Ifstrictne");
        }
        ByteCodeFactory.Byte(code, 26);
        ByteCodeFactory.Int24(code, offset);
    }

    protected void Ifnlt(ByteList code) {
        this.Ifnlt(code, 0);
    }

    protected void Ifnlt(ByteList code, int offset) {
        this.stack(-2);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Ifnlt");
        }
        ByteCodeFactory.Byte(code, 12);
        ByteCodeFactory.Int24(code, offset);
    }

    protected void Ifnle(ByteList code) {
        this.Ifnle(code, 0);
    }

    protected void Ifnle(ByteList code, int offset) {
        this.stack(-2);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Ifnle");
        }
        ByteCodeFactory.Byte(code, 13);
        ByteCodeFactory.Int24(code, offset);
    }

    protected void Ifngt(ByteList code) {
        this.Ifngt(code, 0);
    }

    protected void Ifngt(ByteList code, int offset) {
        this.stack(-2);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Ifngt");
        }
        ByteCodeFactory.Byte(code, 14);
        ByteCodeFactory.Int24(code, offset);
    }

    protected void Ifnge(ByteList code) {
        this.Ifnge(code, 0);
    }

    protected void Ifnge(ByteList code, int offset) {
        this.stack(-2);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Ifnge");
        }
        ByteCodeFactory.Byte(code, 15);
        ByteCodeFactory.Int24(code, offset);
    }

    protected void Lookupswitch(ByteList code) {
        this.stack(-1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Lookupswitch");
        }
        ByteCodeFactory.Byte(code, 27);
    }

    protected void Pushnull(ByteList code) {
        this.stack(1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Pushnull");
        }
        ByteCodeFactory.Byte(code, 32);
    }

    protected void Pushundefined(ByteList code) {
        this.stack(1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Pushundefined");
        }
        ByteCodeFactory.Byte(code, 33);
    }

    protected void Pushuninitialized(ByteList code) {
        this.stack(1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Pushuninitialized ");
        }
        ByteCodeFactory.Byte(code, 34);
    }

    protected void Pushstring(ByteList code, int id) {
        this.stack(1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Pushstring " + id);
        }
        ByteCodeFactory.Byte(code, 44);
        ByteCodeFactory.Int(code, id);
    }

    protected void Pushnamespace(ByteList code, int id) {
        this.stack(1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Pushnamespace " + id);
        }
        ByteCodeFactory.Byte(code, 49);
        ByteCodeFactory.Int(code, id);
    }

    protected void Pushuint(ByteList code, int id) {
        this.stack(1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Pushuint " + id);
        }
        ByteCodeFactory.Byte(code, 46);
        ByteCodeFactory.Int(code, id);
    }

    protected void Pushdouble(ByteList code, int id) {
        this.stack(1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Pushdouble " + id);
        }
        ByteCodeFactory.Byte(code, 47);
        ByteCodeFactory.Int(code, id);
    }

    protected void Pushdecimal(ByteList code, int id) {
        this.stack(1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Pushdouble " + id);
        }
        ByteCodeFactory.Byte(code, 51);
        ByteCodeFactory.Int(code, id);
    }

    protected void Pushint(ByteList code, int id) {
        this.stack(1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Pushint " + id);
        }
        ByteCodeFactory.Byte(code, 45);
        ByteCodeFactory.Int(code, id);
    }

    protected void Pushbyte(ByteList code, int n) {
        this.stack(1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Pushbyte " + n);
        }
        ByteCodeFactory.Byte(code, 36);
        ByteCodeFactory.Byte(code, n);
    }

    protected void Pushshort(ByteList code, int n) {
        this.stack(1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Pushshort " + n);
        }
        ByteCodeFactory.Byte(code, 37);
        ByteCodeFactory.Int(code, n);
    }

    protected void Pushtrue(ByteList code) {
        this.stack(1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Pushtrue");
        }
        ByteCodeFactory.Byte(code, 38);
    }

    protected void Pushfalse(ByteList code) {
        this.stack(1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Pushfalse");
        }
        ByteCodeFactory.Byte(code, 39);
    }

    protected void Pushnan(ByteList code) {
        this.stack(1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Pushnan");
        }
        ByteCodeFactory.Byte(code, 40);
    }

    protected void Pop(ByteList code) {
        this.stack(-1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Pop");
        }
        ByteCodeFactory.Byte(code, 41);
    }

    protected void Dup(ByteList code) {
        this.stack(1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Dup");
        }
        ByteCodeFactory.Byte(code, 42);
    }

    protected void Swap(ByteList code) {
        this.stack(0);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Swap");
        }
        ByteCodeFactory.Byte(code, 43);
    }

    protected void Newfunction(ByteList code, int id) {
        this.stack(1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Newfunction " + id);
        }
        ByteCodeFactory.Byte(code, 64);
        ByteCodeFactory.Int(code, id);
    }

    protected void Newclass(ByteList code, int class_info) {
        this.stack(0);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Newclass " + class_info);
        }
        ByteCodeFactory.Byte(code, 88);
        ByteCodeFactory.Int(code, class_info);
    }

    protected void Callfunction(ByteList code, boolean isnew, int size) {
        if (!isnew) {
            if (this.bytecodeFactory.show_bytecode) {
                this.code_out.write("\n      " + this.getIP() + ":Call " + size);
            }
            this.stack(1 - size - 2);
            ByteCodeFactory.Byte(code, 65);
        } else {
            if (this.bytecodeFactory.show_bytecode) {
                this.code_out.write("\n      " + this.getIP() + ":Construct " + size);
            }
            this.stack(1 - size - 1);
            ByteCodeFactory.Byte(code, 66);
        }
        ByteCodeFactory.Int(code, size);
    }

    protected void Callstatic(ByteList code, int index, int size) {
        this.stack(1 - size - 1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Callstatic " + index + " " + size);
        }
        ByteCodeFactory.Byte(code, 68);
        ByteCodeFactory.Int(code, index);
        ByteCodeFactory.Int(code, size);
    }

    protected void Callmethod(ByteList code, int index, int size) {
        this.stack(1 - size - 1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Callmethod " + index + " " + size);
        }
        ByteCodeFactory.Byte(code, 67);
        ByteCodeFactory.Int(code, index);
        ByteCodeFactory.Int(code, size);
    }

    protected void Callsuper(ByteList code, int index, int size) {
        this.stack(1 - size - 1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Callsuper " + index + " " + size);
        }
        ByteCodeFactory.Byte(code, 69);
        ByteCodeFactory.Int(code, index);
        ByteCodeFactory.Int(code, size);
    }

    protected void Constructsuper(ByteList code, int size) {
        this.stack(0 - size - 1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Constructsuper " + size);
        }
        ByteCodeFactory.Byte(code, 73);
        ByteCodeFactory.Int(code, size);
    }

    protected void Callproperty(ByteList code, int index, int size) {
        this.stack(1 - size - 1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Callproperty " + index + " " + size);
        }
        ByteCodeFactory.Byte(code, 70);
        ByteCodeFactory.Int(code, index);
        ByteCodeFactory.Int(code, size);
    }

    protected void Callproplex(ByteList code, int index, int size) {
        this.stack(1 - size - 1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Callproplex " + index + " " + size);
        }
        ByteCodeFactory.Byte(code, 76);
        ByteCodeFactory.Int(code, index);
        ByteCodeFactory.Int(code, size);
    }

    protected void Constructproperty(ByteList code, int index, int size) {
        this.stack(1 - size - 1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Constructproperty " + index + " " + size);
        }
        ByteCodeFactory.Byte(code, 74);
        ByteCodeFactory.Int(code, index);
        ByteCodeFactory.Int(code, size);
    }

    protected void Returnvoid(ByteList code) {
        this.stack(0);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.print("\n      " + this.getIP() + ":Returnvoid");
        }
        ByteCodeFactory.Byte(code, 71);
    }

    protected void Returnvalue(ByteList code) {
        this.stack(-1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.print("\n      " + this.getIP() + ":Returnvalue");
        }
        ByteCodeFactory.Byte(code, 72);
    }

    protected void Newactivation(ByteList code) {
        this.stack(1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Newactivation");
        }
        ByteCodeFactory.Byte(code, 87);
    }

    protected void Newcatch(ByteList code, int index) {
        this.stack(1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Newcatch " + index);
        }
        ByteCodeFactory.Byte(code, 90);
        ByteCodeFactory.Int(code, index);
    }

    protected void Newobject(ByteList code, int size) {
        this.stack(1 - size * 2);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Newobject " + size);
        }
        ByteCodeFactory.Byte(code, 85);
        ByteCodeFactory.Int(code, size);
    }

    protected void Newarray(ByteList code, int size) {
        this.stack(1 - size);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Newarray " + size);
        }
        ByteCodeFactory.Byte(code, 86);
        ByteCodeFactory.Int(code, size);
    }

    protected void Getlocal(ByteList code, int index) {
        this.stack(1);
        if (index <= 3) {
            if (this.bytecodeFactory.show_bytecode) {
                this.code_out.write("\n      " + this.getIP() + ":Getlocal" + index);
            }
            ByteCodeFactory.Byte(code, 208 + index);
        } else {
            if (this.bytecodeFactory.show_bytecode) {
                this.code_out.write("\n      " + this.getIP() + ":Getlocal " + index);
            }
            ByteCodeFactory.Byte(code, 98);
            ByteCodeFactory.Int(code, index);
        }
    }

    protected void Setlocal(ByteList code, int index) {
        this.stack(-1);
        if (index <= 3) {
            if (this.bytecodeFactory.show_bytecode) {
                this.code_out.write("\n      " + this.getIP() + ":Setlocal" + index);
            }
            ByteCodeFactory.Byte(code, 212 + index);
        } else {
            if (this.bytecodeFactory.show_bytecode) {
                this.code_out.write("\n      " + this.getIP() + ":Setlocal " + index);
            }
            ByteCodeFactory.Byte(code, 99);
            ByteCodeFactory.Int(code, index);
        }
    }

    protected void Getglobalscope(ByteList code) {
        this.stack(1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Getglobalscope");
        }
        ByteCodeFactory.Byte(code, 100);
    }

    protected void Getscopeobject(ByteList code, int index) {
        this.stack(1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Getscopeobject " + index);
        }
        ByteCodeFactory.Byte(code, 101);
        ByteCodeFactory.Byte(code, index);
    }

    protected void Getproperty(ByteList code, int index) {
        this.stack(0);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Getproperty " + index);
        }
        ByteCodeFactory.Byte(code, 102);
        ByteCodeFactory.Int(code, index);
    }

    protected void Getsuper(ByteList code, int index) {
        this.stack(0);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Getsuper " + index);
        }
        ByteCodeFactory.Byte(code, 4);
        ByteCodeFactory.Int(code, index);
    }

    protected void Descendants(ByteList code, int index) {
        this.stack(0);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Descendants " + index);
        }
        ByteCodeFactory.Byte(code, 89);
        ByteCodeFactory.Int(code, index);
    }

    protected void Deletedescendants(ByteList code, int index) {
        this.stack(0);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Deletedescendants " + index);
        }
        ByteCodeFactory.Byte(code, 91);
        ByteCodeFactory.Int(code, index);
    }

    protected void Delproperty(ByteList code, int index) {
        this.stack(0);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Delproperty " + index);
        }
        ByteCodeFactory.Byte(code, 106);
        ByteCodeFactory.Int(code, index);
    }

    protected void Setproperty(ByteList code, int index) {
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Setproperty " + index);
        }
        ByteCodeFactory.Byte(code, 97);
        ByteCodeFactory.Int(code, index);
    }

    protected void Initproperty(ByteList code, int index) {
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Initproperty " + index);
        }
        ByteCodeFactory.Byte(code, 104);
        ByteCodeFactory.Int(code, index);
    }

    protected void Setsuper(ByteList code, int property) {
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Setsuper " + property);
        }
        ByteCodeFactory.Byte(code, 5);
        ByteCodeFactory.Int(code, property);
    }

    protected void Pushwith(ByteList code) {
        this.stack(-1);
        this.scope(1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Pushwith");
        }
        ByteCodeFactory.Byte(code, 28);
    }

    protected void Pushscope(ByteList code) {
        this.stack(-1);
        this.scope(1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Pushscope");
        }
        ByteCodeFactory.Byte(code, 48);
    }

    protected void Popscope(ByteList code) {
        this.stack(0);
        this.scope(-1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Popscope");
        }
        ByteCodeFactory.Byte(code, 29);
    }

    protected void Nextname(ByteList code) {
        this.stack(-1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Nextname");
        }
        ByteCodeFactory.Byte(code, 30);
    }

    protected void Nextvalue(ByteList code) {
        this.stack(-1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Nextvalue");
        }
        ByteCodeFactory.Byte(code, 35);
    }

    protected void Descendants(ByteList code) {
        this.stack(-1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Descendants");
        }
        ByteCodeFactory.Byte(code, 89);
    }

    protected void Hasnext(ByteList code) {
        this.stack(-1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Hasnext");
        }
        ByteCodeFactory.Byte(code, 31);
    }

    protected void Hasnext2(ByteList code, int objectRegister, int indexRegister) {
        this.stack(1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Hasnext2 " + objectRegister + " " + indexRegister);
        }
        ByteCodeFactory.Byte(code, 50);
        ByteCodeFactory.Int(code, objectRegister);
        ByteCodeFactory.Int(code, indexRegister);
    }

    protected void Convert_s(ByteList code) {
        this.stack(0);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Convert.s");
        }
        ByteCodeFactory.Byte(code, 112);
    }

    protected void Esc_xelem(ByteList code) {
        this.stack(0);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Esc.xelem");
        }
        ByteCodeFactory.Byte(code, 113);
    }

    protected void Esc_xattr(ByteList code) {
        this.stack(0);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Esc.xattr");
        }
        ByteCodeFactory.Byte(code, 114);
    }

    protected void CheckFilter(ByteList code) {
        this.stack(0);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":CheckFilter");
        }
        ByteCodeFactory.Byte(code, 120);
    }

    protected void Convert_i(ByteList code) {
        this.stack(0);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Convert.i");
        }
        ByteCodeFactory.Byte(code, 115);
    }

    protected void Convert_u(ByteList code) {
        this.stack(0);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Convert.u");
        }
        ByteCodeFactory.Byte(code, 116);
    }

    protected void Convert_d(ByteList code) {
        this.stack(0);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Convert.d");
        }
        ByteCodeFactory.Byte(code, 117);
    }

    protected void Convert_m(ByteList code) {
        this.stack(0);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Convert.m");
        }
        ByteCodeFactory.Byte(code, 121);
    }

    protected void Convert_m_p(ByteList code, int decimalParams) {
        this.stack(0);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Convert.m_dp(0x" + Integer.toHexString(decimalParams) + ")");
        }
        ByteCodeFactory.Byte(code, 122);
        ByteCodeFactory.Int(code, decimalParams);
    }

    protected void Convert_b(ByteList code) {
        this.stack(0);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Convert.b");
        }
        ByteCodeFactory.Byte(code, 118);
    }

    protected void Convert_o(ByteList code) {
        this.stack(0);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Convert.o");
        }
        ByteCodeFactory.Byte(code, 119);
    }

    protected void Coerce(ByteList code, int name) {
        this.stack(0);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Coerce " + name);
        }
        ByteCodeFactory.Byte(code, 128);
        ByteCodeFactory.Int(code, name);
    }

    protected void Coerce_a(ByteList code) {
        this.stack(0);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Coerce.o");
        }
        ByteCodeFactory.Byte(code, 130);
    }

    protected void Coerce_s(ByteList code) {
        this.stack(0);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Coerce.s");
        }
        ByteCodeFactory.Byte(code, 133);
    }

    protected void Astype(ByteList code, int name) {
        this.stack(0);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Astype " + name);
        }
        ByteCodeFactory.Byte(code, 134);
        ByteCodeFactory.Int(code, name);
    }

    protected void Astypelate(ByteList code) {
        this.stack(-1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Astypelate");
        }
        ByteCodeFactory.Byte(code, 135);
    }

    protected void Negate(ByteList code) {
        this.stack(0);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Negate");
        }
        ByteCodeFactory.Byte(code, 144);
    }

    protected void Negate_i(ByteList code) {
        this.stack(0);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Negate.i");
        }
        ByteCodeFactory.Byte(code, 196);
    }

    protected void Negate_p(ByteList code, int param) {
        this.stack(0);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Negate_p(" + Integer.toHexString(param) + ")");
        }
        ByteCodeFactory.Byte(code, 143);
        ByteCodeFactory.Int(code, param);
    }

    protected void Increment(ByteList code) {
        this.stack(0);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Increment");
        }
        ByteCodeFactory.Byte(code, 145);
    }

    protected void Increment_p(ByteList code, int decimalParams) {
        this.stack(0);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Increment_p(0x" + Integer.toHexString(decimalParams) + ")");
        }
        ByteCodeFactory.Byte(code, 156);
        ByteCodeFactory.Int(code, decimalParams);
    }

    protected void Increment_i(ByteList code) {
        this.stack(0);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Increment.i");
        }
        ByteCodeFactory.Byte(code, 192);
    }

    protected void Inclocal(ByteList code, int index) {
        this.stack(0);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Inclocal " + index);
        }
        ByteCodeFactory.Byte(code, 146);
        ByteCodeFactory.Int(code, index);
    }

    protected void Inclocal_p(ByteList code, int index, int decimalParams) {
        this.stack(0);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Inclocal_p(0x" + Integer.toHexString(decimalParams) + ") " + index);
        }
        ByteCodeFactory.Byte(code, 157);
        ByteCodeFactory.Int(code, decimalParams);
        ByteCodeFactory.Int(code, index);
    }

    protected void Inclocal_i(ByteList code, int index) {
        this.stack(0);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Inclocal.i " + index);
        }
        ByteCodeFactory.Byte(code, 194);
        ByteCodeFactory.Int(code, index);
    }

    protected void Decrement(ByteList code) {
        this.stack(0);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Decrement");
        }
        ByteCodeFactory.Byte(code, 147);
    }

    protected void Decrement_p(ByteList code, int decimalParams) {
        this.stack(0);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Decrement_p(0x" + Integer.toHexString(decimalParams) + ")");
        }
        ByteCodeFactory.Byte(code, 158);
        ByteCodeFactory.Int(code, decimalParams);
    }

    protected void Decrement_i(ByteList code) {
        this.stack(0);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Decrement.i");
        }
        ByteCodeFactory.Byte(code, 193);
    }

    protected void Declocal(ByteList code, int index) {
        this.stack(0);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Declocal " + index);
        }
        ByteCodeFactory.Byte(code, 148);
        ByteCodeFactory.Int(code, index);
    }

    protected void Declocal_p(ByteList code, int index, int decimalParams) {
        this.stack(0);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Declocal_p(0x" + Integer.toHexString(decimalParams) + ") " + index);
        }
        ByteCodeFactory.Byte(code, 159);
        ByteCodeFactory.Int(code, decimalParams);
        ByteCodeFactory.Int(code, index);
    }

    protected void Declocal_i(ByteList code, int index) {
        this.stack(0);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Declocal.i " + index);
        }
        ByteCodeFactory.Byte(code, 195);
        ByteCodeFactory.Int(code, index);
    }

    protected void Typeof(ByteList code) {
        this.stack(0);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Typeof");
        }
        ByteCodeFactory.Byte(code, 149);
    }

    protected void Not(ByteList code) {
        this.stack(0);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Not");
        }
        ByteCodeFactory.Byte(code, 150);
    }

    protected void Add(ByteList code) {
        this.stack(-1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Add");
        }
        ByteCodeFactory.Byte(code, 160);
    }

    protected void Add_p(ByteList code, int decimalParams) {
        this.stack(-1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Add_p(0x" + Integer.toHexString(decimalParams) + ")");
        }
        ByteCodeFactory.Byte(code, 181);
        ByteCodeFactory.Int(code, decimalParams);
    }

    protected void Add_i(ByteList code) {
        this.stack(-1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Add.i");
        }
        ByteCodeFactory.Byte(code, 197);
    }

    protected void Subtract(ByteList code) {
        this.stack(-1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Subtract");
        }
        ByteCodeFactory.Byte(code, 161);
    }

    protected void Subtract_p(ByteList code, int decimalParams) {
        this.stack(-1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Subtract_p(0x" + Integer.toHexString(decimalParams) + ")");
        }
        ByteCodeFactory.Byte(code, 182);
        ByteCodeFactory.Int(code, decimalParams);
    }

    protected void Subtract_i(ByteList code) {
        this.stack(-1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Subtract.i");
        }
        ByteCodeFactory.Byte(code, 198);
    }

    protected void Multiply(ByteList code) {
        this.stack(-1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Multiply");
        }
        ByteCodeFactory.Byte(code, 162);
    }

    protected void Multiply_p(ByteList code, int decimalParams) {
        this.stack(-1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Multiply_p(0x" + Integer.toHexString(decimalParams) + ")");
        }
        ByteCodeFactory.Byte(code, 183);
        ByteCodeFactory.Int(code, decimalParams);
    }

    protected void Multiply_i(ByteList code) {
        this.stack(-1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Multiply.i");
        }
        ByteCodeFactory.Byte(code, 199);
    }

    protected void Divide(ByteList code) {
        this.stack(-1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Divide");
        }
        ByteCodeFactory.Byte(code, 163);
    }

    protected void Divide_p(ByteList code, int decimalParams) {
        this.stack(-1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Divide_dp(0x" + Integer.toHexString(decimalParams) + ")");
        }
        ByteCodeFactory.Byte(code, 184);
        ByteCodeFactory.Int(code, decimalParams);
    }

    protected void Modulo(ByteList code) {
        this.stack(-1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Modulo");
        }
        ByteCodeFactory.Byte(code, 164);
    }

    protected void Modulo_p(ByteList code, int decimalParams) {
        this.stack(-1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Modulo_p(0x" + Integer.toHexString(decimalParams) + ")");
        }
        ByteCodeFactory.Byte(code, 185);
        ByteCodeFactory.Int(code, decimalParams);
    }

    protected void Lshift(ByteList code) {
        this.stack(-1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Lshift");
        }
        ByteCodeFactory.Byte(code, 165);
    }

    protected void Rshift(ByteList code) {
        this.stack(-1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Rshift");
        }
        ByteCodeFactory.Byte(code, 166);
    }

    protected void Urshift(ByteList code) {
        this.stack(-1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Urshift");
        }
        ByteCodeFactory.Byte(code, 167);
    }

    protected void Bitand(ByteList code) {
        this.stack(-1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Bitand");
        }
        ByteCodeFactory.Byte(code, 168);
    }

    protected void Bitor(ByteList code) {
        this.stack(-1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Bitor");
        }
        ByteCodeFactory.Byte(code, 169);
    }

    protected void Bitxor(ByteList code) {
        this.stack(-1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Bitxor");
        }
        ByteCodeFactory.Byte(code, 170);
    }

    protected void Equals(ByteList code) {
        this.stack(-1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Equals");
        }
        ByteCodeFactory.Byte(code, 171);
    }

    protected void Strictequals(ByteList code) {
        this.stack(-1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Strictequals");
        }
        ByteCodeFactory.Byte(code, 172);
    }

    protected void Lessthan(ByteList code) {
        this.stack(-1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Lessthan");
        }
        ByteCodeFactory.Byte(code, 173);
    }

    protected void Lessequals(ByteList code) {
        this.stack(-1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Lessequals");
        }
        ByteCodeFactory.Byte(code, 174);
    }

    protected void Greaterthan(ByteList code) {
        this.stack(-1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Greaterthan");
        }
        ByteCodeFactory.Byte(code, 175);
    }

    protected void Greaterequals(ByteList code) {
        this.stack(-1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Greaterequals");
        }
        ByteCodeFactory.Byte(code, 176);
    }

    protected void Instanceof(ByteList code) {
        this.stack(-1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Instanceof");
        }
        ByteCodeFactory.Byte(code, 177);
    }

    protected void In(ByteList code) {
        this.stack(-1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":In");
        }
        ByteCodeFactory.Byte(code, 180);
    }

    protected void Istype(ByteList code, int type) {
        this.stack(0);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Istype " + type);
        }
        ByteCodeFactory.Byte(code, 178);
        ByteCodeFactory.Int(code, type);
    }

    protected void Istypelate(ByteList code) {
        this.stack(-1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Istypelate");
        }
        ByteCodeFactory.Byte(code, 179);
    }

    protected void finddef(ByteList code, int mname) {
        this.stack(1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Finddef " + mname);
        }
        ByteCodeFactory.Byte(code, 95);
        ByteCodeFactory.Int(code, mname);
    }

    protected void Findpropstrict(ByteList code, int index) {
        this.stack(1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Findpropstrict " + index);
        }
        ByteCodeFactory.Byte(code, 93);
        ByteCodeFactory.Int(code, index);
    }

    protected void Findproperty(ByteList code, int index) {
        this.stack(1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Findproperty " + index);
        }
        ByteCodeFactory.Byte(code, 94);
        ByteCodeFactory.Int(code, index);
    }

    protected void Getslot(ByteList code, int index) {
        this.stack(0);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Getslot " + index);
        }
        ByteCodeFactory.Byte(code, 108);
        ByteCodeFactory.Int(code, index);
    }

    protected void Setslot(ByteList code, int index) {
        this.stack(-2);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Setslot " + index);
        }
        ByteCodeFactory.Byte(code, 109);
        ByteCodeFactory.Int(code, index);
    }

    protected void Bitnot(ByteList code) {
        this.stack(0);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Bitnot");
        }
        ByteCodeFactory.Byte(code, 151);
    }

    protected void DebugLocal(ByteList code, int index, int slot, int linenum) {
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Debug DI_SLOT " + index + " slot " + slot + " line " + linenum);
        }
        ByteCodeFactory.Byte(code, 239);
        ByteCodeFactory.Byte(code, 1);
        ByteCodeFactory.Int(code, index);
        ByteCodeFactory.Byte(code, slot);
        ByteCodeFactory.Int(code, linenum);
    }

    protected void DebugFile(ByteList code, int index) {
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":DebugFile " + index);
        }
        ByteCodeFactory.Byte(code, 241);
        ByteCodeFactory.Int(code, index);
    }

    protected void DebugLine(ByteList code, int linenum) {
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":DebugLine " + linenum);
        }
        ByteCodeFactory.Byte(code, 240);
        ByteCodeFactory.Int(code, linenum);
    }

    protected void Dxnslate(ByteList code) {
        this.stack(-1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Dxnslate");
        }
        ByteCodeFactory.Byte(code, 7);
    }

    protected void Dxns(ByteList code, int index) {
        this.stack(1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Dxns " + index);
        }
        ByteCodeFactory.Byte(code, 6);
        ByteCodeFactory.Int(code, index);
    }

    protected void Kill(ByteList code, int index) {
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write("\n      " + this.getIP() + ":Kill " + index);
        }
        ByteCodeFactory.Byte(code, 8);
        ByteCodeFactory.Int(code, index);
    }

    public int getRegisterOffset(Context cx) {
        int i = cx.getScopes().size();
        while (--i >= 0) {
            Builder builder = cx.scope((int)i).builder;
            if (!builder.hasRegisterOffset()) continue;
            return builder.reg_offset;
        }
        return -1;
    }

    @Override
    public void setOrigin(String origin) {
        super.setOrigin(origin);
        if (this.emit_debug_info) {
            this.debug_info.debug_file = origin;
            this.debug_info.debug_file_dirty = true;
        }
    }

    @Override
    public void setPosition(int lnNum, int colPos, int pos) {
        super.setPosition(lnNum, colPos, pos);
        if (this.emit_debug_info && pos > 0 && this.debug_info.debug_linenum != lnNum) {
            this.debug_info.debug_linenum_dirty = true;
            this.debug_info.debug_linenum = lnNum;
        }
    }

    @Override
    public void clearPositionInfo() {
        if (this.emit_debug_info) {
            this.debug_info.debug_linenum_dirty = false;
            this.debug_info.debug_linenum = -1;
        }
    }

    public void flushDebugInfo() {
        if (this.emit_debug_info && this.debug_info.debug_linenum_dirty && this.debug_info.debug_linenum > -1 && this.ab.code != null && !this.debug_info.suppress_debug_method) {
            if (this.debug_info.debug_file_dirty) {
                this.DebugFile(this.debug_info.debug_file);
                this.debug_info.debug_file_dirty = false;
            }
            this.DebugLine(this.debug_info.debug_linenum);
            this.debug_info.debug_linenum_dirty = false;
        }
    }

    public void apiVersioning() {
        this.doingAPIVersioning = true;
    }

    public void reorderMainScript() {
        this.ab.scripts.add((ByteList)this.ab.scripts.remove(0));
        this.package_infos.add((String)this.package_infos.remove(0));
    }

    public String il_str() {
        StringBuilder out = new StringBuilder();
        if (this.bytecodeFactory.show_bytecode) {
            out.append("constants----------------------------------------------------");
            out.append(this.bytecodeFactory.cpool_out.str());
            out.append("\ndefinitions--------------------------------------------------");
            out.append(this.bytecodeFactory.defns_out.str());
            out.append("\ncode---------------------------------------------------------");
        }
        out.append(this.code_out);
        return out.toString();
    }

    private static String cleanupString(ByteList bl) {
        StringBuilder b = new StringBuilder();
        int n = bl.size();
        for (int i = 0; i < n; ++i) {
            char c = (char)bl.get(i);
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') && c != '_') continue;
            b.append(c);
        }
        return b.toString();
    }

    private String cleanupName(ByteList bl) {
        int ns_index;
        ByteList nsbl;
        BytecodeBuffer nsbc;
        int nskind;
        BytecodeBuffer bc = new BytecodeBuffer(bl.toByteArray(false));
        if (bc.readU8() == 7 && ((nskind = (nsbc = new BytecodeBuffer((nsbl = (ByteList)this.ab.constant_ns_pool.get((ns_index = bc.readU32()) - 1)).toByteArray(false))).readU8()) == 8 || nskind == 22)) {
            int uri_index = nsbc.readU32();
            int name_index = bc.readU32();
            return ActionBlockEmitter.cleanupString((ByteList)this.ab.constant_utf8_pool.get(uri_index - 1)) + "_" + ActionBlockEmitter.cleanupString((ByteList)this.ab.constant_utf8_pool.get(name_index - 1));
        }
        return "";
    }

    public void dumpCpoolVars() {
        String s;
        int i = 1;
        HashSet<String> done = new HashSet<String>();
        for (ByteList bl : this.ab.constant_utf8_pool) {
            s = ActionBlockEmitter.cleanupString(bl);
            if (s.length() > 0 && !done.contains(s)) {
                done.add(s);
                this.header_out.println("const int abcstr_" + s + " = " + i + ";");
            }
            ++i;
        }
        i = 1;
        for (ByteList bl : this.ab.constant_mn_pool) {
            s = this.cleanupName(bl);
            if (s.length() > 0) {
                this.header_out.println("const int abcname_" + s + " = " + i + ";");
            }
            ++i;
        }
    }

    private void dumpPackageInfos() {
        for (int i = 0; i < this.package_infos.size(); ++i) {
            String name = (String)this.package_infos.get(i);
            int package_info = i;
            if (name.length() <= 1) continue;
            String constName = name.replace('.', '_');
            constName = constName.replace('/', '_');
            constName = constName.replace(':', '_');
            constName = constName.replace('|', '_');
            constName = constName.replace('$', '_');
            this.header_out.println("const int abcpackage_" + constName + " = " + package_info + ";");
            if (package_info < this.native_package_count) continue;
            this.native_package_count = package_info + 1;
        }
    }

    public String header_str() {
        this.dumpPackageInfos();
        String out = this.header_out.toString();
        if (out.length() > 0) {
            return out;
        }
        return null;
    }

    public ActionBlockEmitter(Context cx, String scriptname) {
        this(cx, scriptname, null, null, false, true, false, false);
    }

    public ActionBlockEmitter(Context cx, String scriptname, PrintWriter code_out, PrintWriter header_out, boolean show_instructions, boolean show_bytecode, boolean show_linenums, boolean emit_debug_info) {
        this.cx = cx;
        this.scriptname = scriptname;
        this.show_instructions = show_instructions;
        this.code_out = code_out;
        this.header_out = header_out;
        this.show_linenums = show_linenums;
        this.emit_debug_info = emit_debug_info;
        this.show_stacknames = false;
        this.bytecodeFactory = cx.getByteCodeFactory();
        this.bytecodeFactory.show_bytecode = show_bytecode;
        this.ab = new ActionBlock(show_bytecode);
    }

    class ExceptionBlock {
        public int try_start = 0;
        public int try_end = 0;
        public IntList fixups = new IntList();
        public IntList finallyAddrs = new IntList();
        public int scopeIndex = -1;
        public boolean hasFinally = false;
        public int cur_locals = 0;
        public int loop_index = -1;

        ExceptionBlock() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ActionBlock {
        public int minor_version;
        public int major_version;
        public int vars_count;
        public ObjectList<ByteList> vars;
        public int methods_count;
        public ObjectList<ByteList> methods;
        public int metadata_count;
        public ObjectList<ByteList> metadata;
        public int bodies_count;
        public ObjectList<ByteList> bodies;
        public int dispids_count;
        public ObjectList<ByteList> dispids;
        public int classes_count;
        public ObjectList<ByteList> classes;
        public ObjectList<ByteList> instances;
        public int interfaces_count;
        public ObjectList<ByteList> interfaces;
        public int scripts_count;
        public ObjectList<ByteList> scripts;
        public int main_index;
        private Map<ByteList, Integer> bodies_map = new HashMap<ByteList, Integer>();
        private Map<ByteList, Integer> constant_utf8_map = new HashMap<ByteList, Integer>();
        public ObjectList<ByteList> constant_utf8_pool = new ObjectList();
        private Map<ByteList, Integer> constant_mn_map = new HashMap<ByteList, Integer>();
        public ObjectList<ByteList> constant_mn_pool = new ObjectList();
        private Map<ByteList, Integer> constant_nss_map = new HashMap<ByteList, Integer>();
        public ObjectList<ByteList> constant_nss_pool = new ObjectList();
        private Map<ByteList, Integer> constant_ns_map = new HashMap<ByteList, Integer>();
        public ObjectList<ByteList> constant_ns_pool = new ObjectList();
        private Map<ByteList, Integer> constant_double_map = new HashMap<ByteList, Integer>();
        public ObjectList<ByteList> constant_double_pool = new ObjectList();
        private Map<ByteList, Integer> constant_uint_map = new HashMap<ByteList, Integer>();
        public ObjectList<ByteList> constant_uint_pool = new ObjectList();
        private Map<ByteList, Integer> constant_int_map = new HashMap<ByteList, Integer>();
        public ObjectList<ByteList> constant_int_pool = new ObjectList();
        private Map<ByteList, Integer> constant_decimal_map = new HashMap<ByteList, Integer>();
        public ObjectList<ByteList> constant_decimal_pool = new ObjectList();
        public int exception_count;
        public ByteList exception_table;
        public ByteList code;
        public boolean show_bytecode;

        public ActionBlock(boolean show_bytecode) {
            this.minor_version = ((ActionBlockEmitter)ActionBlockEmitter.this).cx.statics.es4_numerics ? 17 : 16;
            this.major_version = 46;
            this.vars_count = 0;
            this.vars = new ObjectList();
            this.methods_count = 0;
            this.methods = new ObjectList();
            this.metadata_count = 0;
            this.metadata = new ObjectList();
            this.bodies_count = 0;
            this.bodies = new ObjectList();
            this.dispids_count = 0;
            this.dispids = new ObjectList();
            this.classes_count = 0;
            this.instances = new ObjectList();
            this.classes = new ObjectList();
            this.interfaces_count = 0;
            this.interfaces = new ObjectList();
            this.scripts_count = 0;
            this.scripts = new ObjectList();
            this.exception_table = ByteCodeFactory.allocBytes();
            this.exception_count = 0;
            this.code = null;
            this.show_bytecode = show_bytecode;
        }

        public int addBody(ByteList bytes) {
            Integer mapcheck = this.bodies_map.get(bytes);
            if (mapcheck != null) {
                return mapcheck + 1;
            }
            this.bodies_map.put(bytes, this.bodies.size());
            this.bodies.push_back(bytes);
            int index = this.bodies.size();
            return index;
        }

        public int addUtf8Constant(ByteList bytes) {
            Integer mapcheck = this.constant_utf8_map.get(bytes);
            if (mapcheck != null) {
                int constant_index = mapcheck;
                return constant_index + 1;
            }
            this.constant_utf8_map.put(bytes, this.constant_utf8_pool.size());
            this.constant_utf8_pool.add(bytes);
            int index = this.constant_utf8_pool.size();
            if (this.show_bytecode) {
                ((ActionBlockEmitter)ActionBlockEmitter.this).bytecodeFactory.cpool_out.write(" -> " + index);
            }
            return index;
        }

        public int addMultiNameConstant(ByteList bytes) {
            Integer mapcheck = this.constant_mn_map.get(bytes);
            if (mapcheck != null) {
                int constant_index = mapcheck;
                return constant_index + 1;
            }
            this.constant_mn_map.put(bytes, this.constant_mn_pool.size());
            this.constant_mn_pool.add(bytes);
            int index = this.constant_mn_pool.size();
            if (this.show_bytecode) {
                ((ActionBlockEmitter)ActionBlockEmitter.this).bytecodeFactory.cpool_out.write(" -> " + index);
            }
            return index;
        }

        public int addNsSetConstant(ByteList bytes) {
            Integer mapcheck = this.constant_nss_map.get(bytes);
            if (mapcheck != null) {
                int constant_index = mapcheck;
                return constant_index + 1;
            }
            this.constant_nss_map.put(bytes, this.constant_nss_pool.size());
            this.constant_nss_pool.add(bytes);
            int index = this.constant_nss_pool.size();
            if (this.show_bytecode) {
                ((ActionBlockEmitter)ActionBlockEmitter.this).bytecodeFactory.cpool_out.write(" -> " + index);
            }
            return index;
        }

        public int addNsConstant(ByteList bytes) {
            Integer mapcheck = this.constant_ns_map.get(bytes);
            if (mapcheck != null) {
                int constant_index = mapcheck;
                return constant_index + 1;
            }
            this.constant_ns_map.put(bytes, this.constant_ns_pool.size());
            this.constant_ns_pool.add(bytes);
            int index = this.constant_ns_pool.size();
            if (this.show_bytecode) {
                ((ActionBlockEmitter)ActionBlockEmitter.this).bytecodeFactory.cpool_out.write(" -> " + index);
            }
            return index;
        }

        public int addDoubleConstant(ByteList bytes) {
            Integer mapcheck = this.constant_double_map.get(bytes);
            if (mapcheck != null) {
                int constant_index = mapcheck;
                return constant_index + 1;
            }
            this.constant_double_map.put(bytes, this.constant_double_pool.size());
            this.constant_double_pool.add(bytes);
            int index = this.constant_double_pool.size();
            if (this.show_bytecode) {
                ((ActionBlockEmitter)ActionBlockEmitter.this).bytecodeFactory.cpool_out.write(" -> " + index);
            }
            return index;
        }

        public int addUintConstant(ByteList bytes) {
            Integer mapcheck = this.constant_uint_map.get(bytes);
            if (mapcheck != null) {
                int constant_index = mapcheck;
                return constant_index + 1;
            }
            this.constant_uint_map.put(bytes, this.constant_uint_pool.size());
            this.constant_uint_pool.add(bytes);
            int index = this.constant_uint_pool.size();
            if (this.show_bytecode) {
                ((ActionBlockEmitter)ActionBlockEmitter.this).bytecodeFactory.cpool_out.write(" -> " + index);
            }
            return index;
        }

        public int addIntConstant(ByteList bytes) {
            Integer mapcheck = this.constant_int_map.get(bytes);
            if (mapcheck != null) {
                int constant_index = mapcheck;
                return constant_index + 1;
            }
            this.constant_int_map.put(bytes, this.constant_int_pool.size());
            this.constant_int_pool.add(bytes);
            int index = this.constant_int_pool.size();
            if (this.show_bytecode) {
                ((ActionBlockEmitter)ActionBlockEmitter.this).bytecodeFactory.cpool_out.write(" -> " + index);
            }
            return index;
        }

        public int addDecimalConstant(ByteList bytes) {
            Integer mapcheck = this.constant_decimal_map.get(bytes);
            if (mapcheck != null) {
                int constant_index = mapcheck;
                return constant_index + 1;
            }
            this.constant_decimal_map.put(bytes, this.constant_decimal_pool.size());
            this.constant_decimal_pool.add(bytes);
            int index = this.constant_decimal_pool.size();
            if (this.show_bytecode) {
                ((ActionBlockEmitter)ActionBlockEmitter.this).bytecodeFactory.cpool_out.write(" -> " + index);
            }
            return index;
        }

        public int addBytesToTable(ObjectList<ByteList> table, ByteList bytes) {
            int idx = 0;
            for (ByteList list : table) {
                int n = list.size();
                if (n == bytes.size()) {
                    int i;
                    for (i = 0; i < n && list.get(i) == bytes.get(i); ++i) {
                    }
                    if (i == n) {
                        return idx + 1;
                    }
                }
                ++idx;
            }
            table.add(bytes);
            int index = table.size();
            return index;
        }
    }
}

