/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.semantics;

import java.util.HashSet;
import macromedia.asc.embedding.ErrorConstants;
import macromedia.asc.parser.ApplyTypeExprNode;
import macromedia.asc.parser.ArgumentListNode;
import macromedia.asc.parser.AttributeListNode;
import macromedia.asc.parser.BinaryClassDefNode;
import macromedia.asc.parser.BinaryExpressionNode;
import macromedia.asc.parser.BinaryFunctionDefinitionNode;
import macromedia.asc.parser.BinaryInterfaceDefinitionNode;
import macromedia.asc.parser.BinaryProgramNode;
import macromedia.asc.parser.BoxNode;
import macromedia.asc.parser.BreakStatementNode;
import macromedia.asc.parser.CallExpressionNode;
import macromedia.asc.parser.CaseLabelNode;
import macromedia.asc.parser.CatchClauseNode;
import macromedia.asc.parser.ClassDefinitionNode;
import macromedia.asc.parser.ClassNameNode;
import macromedia.asc.parser.CoerceNode;
import macromedia.asc.parser.ConditionalExpressionNode;
import macromedia.asc.parser.ConfigNamespaceDefinitionNode;
import macromedia.asc.parser.ContinueStatementNode;
import macromedia.asc.parser.DefaultXMLNamespaceNode;
import macromedia.asc.parser.DefinitionNode;
import macromedia.asc.parser.DeleteExpressionNode;
import macromedia.asc.parser.DoStatementNode;
import macromedia.asc.parser.DocCommentNode;
import macromedia.asc.parser.EmptyElementNode;
import macromedia.asc.parser.EmptyStatementNode;
import macromedia.asc.parser.ErrorNode;
import macromedia.asc.parser.Evaluator;
import macromedia.asc.parser.ExpressionStatementNode;
import macromedia.asc.parser.FinallyClauseNode;
import macromedia.asc.parser.ForStatementNode;
import macromedia.asc.parser.FunctionCommonNode;
import macromedia.asc.parser.FunctionDefinitionNode;
import macromedia.asc.parser.FunctionNameNode;
import macromedia.asc.parser.FunctionSignatureNode;
import macromedia.asc.parser.GetExpressionNode;
import macromedia.asc.parser.HasNextNode;
import macromedia.asc.parser.IdentifierNode;
import macromedia.asc.parser.IfStatementNode;
import macromedia.asc.parser.ImportDirectiveNode;
import macromedia.asc.parser.ImportNode;
import macromedia.asc.parser.IncludeDirectiveNode;
import macromedia.asc.parser.IncrementNode;
import macromedia.asc.parser.InheritanceNode;
import macromedia.asc.parser.InterfaceDefinitionNode;
import macromedia.asc.parser.InvokeNode;
import macromedia.asc.parser.LabeledStatementNode;
import macromedia.asc.parser.ListNode;
import macromedia.asc.parser.LiteralArrayNode;
import macromedia.asc.parser.LiteralBooleanNode;
import macromedia.asc.parser.LiteralFieldNode;
import macromedia.asc.parser.LiteralNullNode;
import macromedia.asc.parser.LiteralNumberNode;
import macromedia.asc.parser.LiteralObjectNode;
import macromedia.asc.parser.LiteralRegExpNode;
import macromedia.asc.parser.LiteralStringNode;
import macromedia.asc.parser.LiteralVectorNode;
import macromedia.asc.parser.LiteralXMLNode;
import macromedia.asc.parser.LoadRegisterNode;
import macromedia.asc.parser.MemberExpressionNode;
import macromedia.asc.parser.MetaDataNode;
import macromedia.asc.parser.NamespaceDefinitionNode;
import macromedia.asc.parser.Node;
import macromedia.asc.parser.NodeFactory;
import macromedia.asc.parser.PackageDefinitionNode;
import macromedia.asc.parser.PackageIdentifiersNode;
import macromedia.asc.parser.PackageNameNode;
import macromedia.asc.parser.ParameterListNode;
import macromedia.asc.parser.ParameterNode;
import macromedia.asc.parser.ParenExpressionNode;
import macromedia.asc.parser.ParenListExpressionNode;
import macromedia.asc.parser.PragmaExpressionNode;
import macromedia.asc.parser.PragmaNode;
import macromedia.asc.parser.ProgramNode;
import macromedia.asc.parser.QualifiedExpressionNode;
import macromedia.asc.parser.QualifiedIdentifierNode;
import macromedia.asc.parser.RegisterNode;
import macromedia.asc.parser.RestExpressionNode;
import macromedia.asc.parser.RestParameterNode;
import macromedia.asc.parser.ReturnStatementNode;
import macromedia.asc.parser.SetExpressionNode;
import macromedia.asc.parser.StatementListNode;
import macromedia.asc.parser.StoreRegisterNode;
import macromedia.asc.parser.SuperExpressionNode;
import macromedia.asc.parser.SuperStatementNode;
import macromedia.asc.parser.SwitchStatementNode;
import macromedia.asc.parser.ThisExpressionNode;
import macromedia.asc.parser.ThrowStatementNode;
import macromedia.asc.parser.ToObjectNode;
import macromedia.asc.parser.TryStatementNode;
import macromedia.asc.parser.TypeExpressionNode;
import macromedia.asc.parser.TypedIdentifierNode;
import macromedia.asc.parser.UnaryExpressionNode;
import macromedia.asc.parser.UntypedVariableBindingNode;
import macromedia.asc.parser.UseDirectiveNode;
import macromedia.asc.parser.UseNumericNode;
import macromedia.asc.parser.UsePrecisionNode;
import macromedia.asc.parser.UseRoundingNode;
import macromedia.asc.parser.VariableBindingNode;
import macromedia.asc.parser.VariableDefinitionNode;
import macromedia.asc.parser.WhileStatementNode;
import macromedia.asc.parser.WithStatementNode;
import macromedia.asc.semantics.Builder;
import macromedia.asc.semantics.ConfigurationBuilder;
import macromedia.asc.semantics.NamespaceValue;
import macromedia.asc.semantics.ObjectValue;
import macromedia.asc.semantics.ReferenceValue;
import macromedia.asc.semantics.Slot;
import macromedia.asc.semantics.TypeInfo;
import macromedia.asc.semantics.TypeValue;
import macromedia.asc.semantics.Value;
import macromedia.asc.util.Context;
import macromedia.asc.util.IntegerPool;
import macromedia.asc.util.Namespaces;
import macromedia.asc.util.NumberConstant;
import macromedia.asc.util.ObjectList;

public class ConfigurationEvaluator
implements Evaluator,
ErrorConstants {
    private boolean fold_expressions = false;
    private ObjectValue true_ov;
    private ObjectValue false_ov;
    private boolean top_level = false;
    private HashSet<String> config_namespaces = new HashSet();
    static final String UNDEFINED = "undefined";
    static final String TRUE = "true";
    static final String FALSE = "false";

    private ObjectValue getBooleanObjectValue(Context cx, boolean b) {
        if (b) {
            if (this.true_ov == null) {
                this.true_ov = new ObjectValue(TRUE, cx.booleanType());
            }
            return this.true_ov;
        }
        if (this.false_ov == null) {
            this.false_ov = new ObjectValue(FALSE, cx.booleanType());
        }
        return this.false_ov;
    }

    public boolean checkFeature(Context cx, Node node) {
        return true;
    }

    public Value evaluate(Context cx, Node node) {
        return null;
    }

    public Value evaluate(Context cx, IncrementNode node) {
        node.expr = this.evalAndFold(cx, node.expr);
        return null;
    }

    public Value evaluate(Context cx, DeleteExpressionNode node) {
        node.expr = this.evalAndFold(cx, node.expr);
        return null;
    }

    public Value evaluate(Context cx, IdentifierNode node) {
        return new ReferenceValue(cx, null, node.name, cx.publicNamespace());
    }

    public Value evaluate(Context cx, InvokeNode node) {
        node.args.evaluate(cx, this);
        node.expr = this.evalAndFold(cx, node.expr);
        return null;
    }

    public Value evaluate(Context cx, ThisExpressionNode node) {
        return null;
    }

    public Value evaluate(Context cx, QualifiedIdentifierNode node) {
        ReferenceValue ref;
        Slot s;
        AttributeListNode attrs;
        ReferenceValue result = null;
        Value val = node.qualifier != null ? node.qualifier.evaluate(cx, this) : null;
        AttributeListNode attributeListNode = attrs = node.qualifier instanceof AttributeListNode ? (AttributeListNode)node.qualifier : null;
        if (attrs != null && attrs.items != null && attrs.items.size() == 1) {
            Slot s2;
            ReferenceValue ref2;
            val = attrs.items.at(0).evaluate(cx, this);
            ReferenceValue referenceValue = ref2 = val instanceof ReferenceValue ? (ReferenceValue)val : null;
            if (ref2 != null && (s2 = ref2.getSlot(cx)) != null && s2.getObjectValue() != null && s2.getObjectValue().isConfigNS()) {
                ReferenceValue temp = new ReferenceValue(cx, null, node.name, s2.getObjectValue());
                temp.setPosition(node.qualifier.getPosition());
                result = temp;
            }
        } else if (val instanceof ReferenceValue && (s = (ref = (ReferenceValue)val).getSlot(cx)) != null && s.getObjectValue() != null && s.getObjectValue().isConfigNS()) {
            ReferenceValue temp = new ReferenceValue(cx, null, node.name, s.getObjectValue());
            temp.setPosition(node.getPosition());
            result = temp;
        }
        return result;
    }

    public Value evaluate(Context cx, QualifiedExpressionNode node) {
        return null;
    }

    public Value evaluate(Context cx, LiteralBooleanNode node) {
        return this.getBooleanObjectValue(cx, node.value);
    }

    public Value evaluate(Context cx, LiteralNumberNode node) {
        TypeValue[] type = new TypeValue[1];
        node.numericValue = cx.getEmitter().getValueOfNumberLiteral(node.value, type, node.numberUsage);
        node.type = type[0];
        return new ObjectValue(node.value, node.type);
    }

    public Value evaluate(Context cx, LiteralStringNode node) {
        return new ObjectValue(node.value, cx.stringType());
    }

    public Value evaluate(Context cx, LiteralNullNode node) {
        return null;
    }

    public Value evaluate(Context cx, LiteralRegExpNode node) {
        return null;
    }

    public Value evaluate(Context cx, LiteralXMLNode node) {
        return null;
    }

    public Value evaluate(Context cx, FunctionCommonNode node) {
        node.signature.evaluate(cx, this);
        ConfigurationBuilder config_bui = new ConfigurationBuilder();
        ObjectValue scope = new ObjectValue(cx, config_bui, null);
        cx.pushScope(scope);
        node.body.evaluate(cx, this);
        cx.popScope();
        return null;
    }

    public Value evaluate(Context cx, ParenExpressionNode node) {
        node.expr = this.evalAndFold(cx, node.expr);
        return null;
    }

    public Value evaluate(Context cx, ParenListExpressionNode node) {
        node.expr = this.evalAndFold(cx, node.expr);
        return null;
    }

    private void evalArrayOrObjectArgList(Context cx, ArgumentListNode list) {
        if (list != null) {
            for (int i = list.size() - 1; i > 0; --i) {
                Value config_val;
                ListNode l;
                Node n = list.items.at(i);
                ListNode listNode = l = n instanceof ListNode ? (ListNode)n : null;
                if (l == null || l.size() != 2 || !l.items.at(0).isConfigurationName() || (config_val = l.items.at(0).evaluate(cx, this)) == null || !config_val.isReference() || !((ReferenceValue)config_val).isConfigRef()) continue;
                ReferenceValue r = (ReferenceValue)config_val;
                Value v = config_val.getValue(cx);
                if (v == null) {
                    cx.error(r.getPosition(), 1120, r.name);
                    continue;
                }
                Boolean b = this.toBoolean(cx, (ObjectValue)r.getValue(cx));
                if (b != null && b.booleanValue()) {
                    list.items.set(i, l.items.at(1));
                    continue;
                }
                list.items.remove(i);
            }
        }
    }

    public Value evaluate(Context cx, LiteralObjectNode node) {
        if (node.fieldlist != null) {
            this.evalArrayOrObjectArgList(cx, node.fieldlist);
            node.fieldlist.evaluate(cx, this);
        }
        return null;
    }

    public Value evaluate(Context cx, LiteralFieldNode node) {
        node.name = this.evalAndFold(cx, node.name);
        node.value = this.evalAndFold(cx, node.value);
        return null;
    }

    public Value evaluate(Context cx, LiteralArrayNode node) {
        if (node.elementlist != null) {
            this.evalArrayOrObjectArgList(cx, node.elementlist);
            node.elementlist.evaluate(cx, this);
        }
        return null;
    }

    public Value evaluate(Context cx, LiteralVectorNode node) {
        node.type.evaluate(cx, this);
        if (node.elementlist != null) {
            this.evalArrayOrObjectArgList(cx, node.elementlist);
            node.elementlist.evaluate(cx, this);
        }
        return null;
    }

    public Value evaluate(Context cx, SuperExpressionNode node) {
        node.expr = this.evalAndFold(cx, node.expr);
        return null;
    }

    public Value evaluate(Context cx, SuperStatementNode node) {
        node.call.evaluate(cx, this);
        return null;
    }

    public Value evaluate(Context cx, MemberExpressionNode node) {
        if (node.base != null) {
            node.base = this.evalAndFold(cx, node.base);
        }
        Value val = node.selector.evaluate(cx, this);
        return val;
    }

    public Value evaluate(Context cx, CallExpressionNode node) {
        if (node.args != null) {
            node.args.evaluate(cx, this);
        }
        return null;
    }

    public Value evaluate(Context cx, GetExpressionNode node) {
        Value val = node.expr.evaluate(cx, this);
        return val;
    }

    public Value evaluate(Context cx, ApplyTypeExprNode node) {
        return null;
    }

    public Value evaluate(Context cx, SetExpressionNode node) {
        node.args.evaluate(cx, this);
        return null;
    }

    private Boolean toBoolean(Context cx, ObjectValue obj) {
        TypeValue tv;
        Boolean ret = null;
        TypeInfo ti = obj.getType(cx);
        TypeValue typeValue = tv = ti != null ? ti.getTypeValue() : null;
        if (tv != null) {
            if (tv == cx.booleanType()) {
                ret = obj.booleanValue() ? Boolean.TRUE : Boolean.FALSE;
            } else if (tv == cx.stringType()) {
                String s = obj.getValue();
                ret = s == null || "".equals(s) ? Boolean.FALSE : Boolean.TRUE;
            } else if (this.isNumericType(cx, tv)) {
                TypeValue[] type = new TypeValue[1];
                double d = cx.getEmitter().getValueOfNumberLiteral(obj.getValue(), type, obj.getNumberUsage()).doubleValue();
                ret = Double.isNaN(d) || d == 0.0 ? Boolean.FALSE : Boolean.TRUE;
            }
        }
        return ret;
    }

    private String toString(Context cx, ObjectValue obj) {
        TypeValue tv;
        String ret = null;
        TypeInfo ti = obj.getType(cx);
        TypeValue typeValue = tv = ti != null ? ti.getTypeValue() : null;
        if (tv != null) {
            if (tv == cx.booleanType()) {
                ret = obj.booleanValue() ? TRUE : FALSE;
            } else if (tv == cx.stringType()) {
                ret = obj.getValue();
            } else if (this.isNumericType(cx, tv)) {
                TypeValue[] type = new TypeValue[1];
                NumberConstant v = cx.getEmitter().getValueOfNumberLiteral(obj.getValue(), type, obj.getNumberUsage());
                ret = v.toString();
            }
        }
        return ret;
    }

    private Double toNumber(Context cx, ObjectValue obj) {
        TypeValue tv;
        Double ret = null;
        TypeInfo ti = obj.getType(cx);
        TypeValue typeValue = tv = ti != null ? ti.getTypeValue() : null;
        if (tv != null) {
            if (tv == cx.booleanType()) {
                ret = new Double(obj.booleanValue() ? 1.0 : 0.0);
            } else if (tv == cx.stringType() || this.isNumericType(cx, tv)) {
                TypeValue[] type = new TypeValue[1];
                try {
                    ret = cx.getEmitter().getValueOfNumberLiteral(obj.getValue(), type, obj.getNumberUsage()).doubleValue();
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
        }
        return ret;
    }

    private Integer toInt(Context cx, ObjectValue obj) {
        Integer i = null;
        Double d = this.toNumber(cx, obj);
        if (d != null) {
            i = d.isInfinite() || d.isNaN() || d == 0.0 ? IntegerPool.getNumber(0) : IntegerPool.getNumber((int)d.doubleValue());
        }
        return i;
    }

    private Long toUInt(Context cx, ObjectValue obj) {
        Long l = null;
        Double d = this.toNumber(cx, obj);
        if (d != null) {
            l = d.isInfinite() || d.isNaN() || d == 0.0 ? new Long(0L) : new Long((long)d.doubleValue());
        }
        return l;
    }

    public Value evaluate(Context cx, UnaryExpressionNode node) {
        ObjectValue val = null;
        if (this.fold_expressions) {
            Value expr_val = node.expr.evaluate(cx, this);
            Node new_expr = this.foldRefValue(cx, expr_val);
            if (new_expr != null) {
                node.expr = new_expr;
                expr_val = node.expr.evaluate(cx, this);
            }
            if (expr_val != null && expr_val.hasValue()) {
                ObjectValue expr_ov = (ObjectValue)expr_val;
                switch (node.op) {
                    case -4: {
                        Boolean b = this.toBoolean(cx, expr_ov);
                        if (b == null) break;
                        val = this.getBooleanObjectValue(cx, b == false);
                    }
                }
            }
        } else {
            node.expr = this.evalAndFold(cx, node.expr);
        }
        return val;
    }

    public Value evaluate(Context cx, BinaryExpressionNode node) {
        ObjectValue val = null;
        if (this.fold_expressions) {
            Value lhs_val = node.lhs.evaluate(cx, this);
            Value rhs_val = node.rhs.evaluate(cx, this);
            Node new_lhs = this.foldRefValue(cx, lhs_val);
            Node new_rhs = this.foldRefValue(cx, rhs_val);
            if (new_lhs != null) {
                node.lhs = new_lhs;
                lhs_val = node.lhs.evaluate(cx, this);
            }
            if (new_rhs != null) {
                node.rhs = new_rhs;
                rhs_val = node.rhs.evaluate(cx, this);
            }
            if (lhs_val != null && rhs_val != null && lhs_val.hasValue() && rhs_val.hasValue()) {
                ObjectValue lhs_ov = (ObjectValue)lhs_val;
                ObjectValue rhs_ov = (ObjectValue)rhs_val;
                TypeValue lt = lhs_ov.getType(cx).getTypeValue();
                TypeValue rt = rhs_ov.getType(cx).getTypeValue();
                switch (node.op) {
                    case -42: {
                        if (this.isNumericType(cx, lt) && this.isNumericType(cx, rt)) {
                            TypeValue[] type = new TypeValue[1];
                            double ld = cx.getEmitter().getValueOfNumberLiteral(lhs_ov.getValue(), type, node.numberUsage).doubleValue();
                            double rd = cx.getEmitter().getValueOfNumberLiteral(rhs_ov.getValue(), type, node.numberUsage).doubleValue();
                            double d = Double.NaN;
                            d = ld + rd;
                            val = new ObjectValue(Double.toString(d), cx.numberType());
                            break;
                        }
                        if (lt != cx.stringType() && rt != cx.stringType()) break;
                        String ls = this.toString(cx, lhs_ov);
                        String rs = this.toString(cx, rhs_ov);
                        val = new ObjectValue(ls + rs, cx.stringType());
                        break;
                    }
                    case -22: 
                    case -15: 
                    case -7: 
                    case -2: {
                        if (this.isNumericType(cx, lt) && this.isNumericType(cx, rt)) {
                            TypeValue[] type = new TypeValue[1];
                            double ld = cx.getEmitter().getValueOfNumberLiteral(lhs_ov.getValue(), type, node.numberUsage).doubleValue();
                            double rd = cx.getEmitter().getValueOfNumberLiteral(rhs_ov.getValue(), type, node.numberUsage).doubleValue();
                            double d = Double.NaN;
                            switch (node.op) {
                                case -2: {
                                    d = ld - rd;
                                    break;
                                }
                                case -15: {
                                    d = ld * rd;
                                    break;
                                }
                                case -22: {
                                    d = ld / rd;
                                    break;
                                }
                                case -7: {
                                    d = ld % rd;
                                }
                            }
                            val = new ObjectValue(Double.toString(d), cx.numberType());
                            break;
                        }
                    }
                    case -37: {
                        Boolean b = this.toBoolean(cx, lhs_ov);
                        Boolean b2 = this.toBoolean(cx, rhs_ov);
                        if (b == null || b2 == null) break;
                        val = this.getBooleanObjectValue(cx, b != false || b2 != false);
                        break;
                    }
                    case -10: {
                        Boolean b = this.toBoolean(cx, lhs_ov);
                        Boolean b2 = this.toBoolean(cx, rhs_ov);
                        if (b == null || b2 == null) break;
                        val = this.getBooleanObjectValue(cx, b != false && b2 != false);
                        break;
                    }
                    case -51: 
                    case -5: {
                        Boolean b = this.compare(cx, lhs_ov, rhs_ov);
                        if (b == null) break;
                        if (node.op == -5) {
                            val = this.getBooleanObjectValue(cx, b == false);
                            break;
                        }
                        val = this.getBooleanObjectValue(cx, b);
                        break;
                    }
                    case -54: 
                    case -45: {
                        String less_result = this.lessthan(cx, lhs_ov, rhs_ov);
                        Boolean b = null;
                        b = node.op == -45 ? (less_result == UNDEFINED || less_result == FALSE ? Boolean.FALSE : Boolean.TRUE) : (less_result == UNDEFINED || less_result == TRUE ? Boolean.FALSE : Boolean.TRUE);
                        if (b == null) break;
                        val = this.getBooleanObjectValue(cx, b);
                        break;
                    }
                    case -53: 
                    case -48: {
                        String less_result = this.lessthan(cx, rhs_ov, lhs_ov);
                        Boolean b = null;
                        b = node.op == -48 ? (less_result == UNDEFINED || less_result == TRUE ? Boolean.FALSE : Boolean.TRUE) : (less_result == UNDEFINED || less_result == FALSE ? Boolean.FALSE : Boolean.TRUE);
                        if (b == null) break;
                        val = this.getBooleanObjectValue(cx, b);
                        break;
                    }
                    case -55: 
                    case -46: {
                        Integer li = this.toInt(cx, lhs_ov);
                        Integer ri = this.toInt(cx, rhs_ov);
                        if (li == null || ri == null) break;
                        ri = ri & 0x1F;
                        if (node.op == -46) {
                            val = new ObjectValue(String.valueOf(li << ri), cx.intType());
                            break;
                        }
                        val = new ObjectValue(String.valueOf(li >> ri), cx.intType());
                        break;
                    }
                    case -57: {
                        Long ll = this.toUInt(cx, lhs_ov);
                        Long rl = this.toUInt(cx, rhs_ov);
                        if (ll == null || rl == null) break;
                        rl = rl & 0x1FL;
                        val = new ObjectValue(String.valueOf(ll >>> (int)rl.longValue()), cx.intType());
                        break;
                    }
                    case -36: 
                    case -31: 
                    case -9: {
                        Integer li = this.toInt(cx, lhs_ov);
                        Integer ri = this.toInt(cx, rhs_ov);
                        if (li == null || ri == null) break;
                        int result = 0;
                        switch (node.op) {
                            case -9: {
                                result = li & ri;
                                break;
                            }
                            case -36: {
                                result = li | ri;
                                break;
                            }
                            case -31: {
                                result = li ^ ri;
                            }
                        }
                        val = new ObjectValue(String.valueOf(result), cx.intType());
                    }
                }
            }
        } else {
            node.lhs = this.evalAndFold(cx, node.lhs);
            node.rhs = this.evalAndFold(cx, node.rhs);
        }
        return val;
    }

    private String lessthan(Context cx, ObjectValue lhs, ObjectValue rhs) {
        Double ld = this.toNumber(cx, lhs);
        Double rd = this.toNumber(cx, rhs);
        if (ld != null && rd != null) {
            if (ld.isNaN() || rd.isNaN()) {
                return UNDEFINED;
            }
            if (ld.doubleValue() == rd.doubleValue()) {
                return FALSE;
            }
            if (ld.isInfinite()) {
                if (ld > 0.0) {
                    return FALSE;
                }
                return TRUE;
            }
            if (rd.isInfinite()) {
                if (rd < 0.0) {
                    return FALSE;
                }
                return TRUE;
            }
            if (ld < rd) {
                return TRUE;
            }
            return FALSE;
        }
        return null;
    }

    private Boolean compare(Context cx, ObjectValue lhs, ObjectValue rhs) {
        if (lhs != null && lhs.hasValue() && rhs != null && rhs.hasValue()) {
            if (lhs == rhs) {
                return Boolean.TRUE;
            }
            TypeValue rhs_type = rhs.getType(cx).getTypeValue();
            TypeValue lhs_type = lhs.getType(cx).getTypeValue();
            if (lhs_type == rhs_type) {
                if (lhs_type == cx.stringType()) {
                    return lhs.getValue().equals(this.toString(cx, rhs));
                }
                if (lhs_type == cx.booleanType()) {
                    Boolean b1 = this.toBoolean(cx, lhs);
                    Boolean b2 = this.toBoolean(cx, rhs);
                    if (b1.booleanValue() == b2.booleanValue()) {
                        return Boolean.TRUE;
                    }
                    return Boolean.FALSE;
                }
                if (this.isNumericType(cx, lhs_type)) {
                    Double d1 = this.toNumber(cx, lhs);
                    Double d2 = this.toNumber(cx, rhs);
                    if (d1.doubleValue() == d2.doubleValue()) {
                        return Boolean.TRUE;
                    }
                    return Boolean.FALSE;
                }
            } else if (this.isNumericType(cx, lhs_type) && this.isNumericType(cx, rhs_type) || this.isNumericType(cx, lhs_type) && rhs_type == cx.stringType() || lhs_type == cx.stringType() && this.isNumericType(cx, rhs_type) || lhs_type == cx.booleanType() || rhs_type == cx.booleanType()) {
                Double d1 = this.toNumber(cx, lhs);
                Double d2 = this.toNumber(cx, rhs);
                if (d1 != null && d2 != null && d1.doubleValue() == d2.doubleValue()) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        }
        return Boolean.FALSE;
    }

    private ObjectValue numberObjVal(Context cx, double d) {
        return new ObjectValue(String.valueOf(d), cx.numberType());
    }

    private boolean isNumericType(Context cx, TypeValue typeval) {
        return typeval == cx.numberType() || typeval == cx.intType() || typeval == cx.uintType();
    }

    public Value evaluate(Context cx, ConditionalExpressionNode node) {
        node.condition = this.evalAndFold(cx, node.condition);
        node.thenexpr = this.evalAndFold(cx, node.thenexpr);
        node.elseexpr = this.evalAndFold(cx, node.elseexpr);
        return null;
    }

    public Value evaluate(Context cx, ArgumentListNode node) {
        int size = node.items.size();
        for (int i = 0; i < size; ++i) {
            Node n = (Node)node.items.get(i);
            Node temp = null;
            if (n == null || (temp = this.evalAndFold(cx, n)) == n) continue;
            node.items.set(i, temp);
        }
        return null;
    }

    public Value evaluate(Context cx, ListNode node) {
        Value val = null;
        int size = node.items.size();
        for (int i = 0; i < size; ++i) {
            Node n = node.items.at(i);
            val = n.evaluate(cx, this);
            Node temp = this.foldRefValue(cx, val);
            if (temp == null) continue;
            node.items.set(i, temp);
            val = temp.evaluate(cx, this);
        }
        return val;
    }

    public Value evaluate(Context cx, StatementListNode node) {
        NodeFactory nodeFactory = cx.getNodeFactory();
        if (node.config_attrs != null) {
            node.config_attrs.evaluate(cx, this);
            if (!node.config_attrs.compileDefinition) {
                node.items.clear();
            }
            node.config_attrs = null;
        }
        int size = node.items.size();
        for (int i = 0; i < size; ++i) {
            Node temp;
            Node n = node.items.at(i);
            if (n != null && n.isDefinition()) {
                DefinitionNode def = (DefinitionNode)n;
                if (def.attrs != null) {
                    def.attrs.evaluate(cx, this);
                    if (!def.attrs.compileDefinition) {
                        node.items.set(i, nodeFactory.emptyStatement());
                        this.removeMetaData(cx, def, node, i);
                        continue;
                    }
                }
                boolean old_toplevel = this.top_level;
                if (!(def instanceof ConfigNamespaceDefinitionNode) && !(def instanceof VariableDefinitionNode)) {
                    this.top_level = false;
                }
                def.evaluate(cx, this);
                this.top_level = old_toplevel;
                if (!(def instanceof VariableDefinitionNode)) continue;
                VariableDefinitionNode vardef = (VariableDefinitionNode)def;
                if (vardef.list.items.size() != 0) continue;
                this.removeMetaData(cx, vardef, node, i);
                node.items.set(i, nodeFactory.emptyStatement());
                continue;
            }
            if (n instanceof StatementListNode) {
                Node temp2;
                StatementListNode stmt = (StatementListNode)n;
                if (stmt.config_attrs != null) {
                    stmt.config_attrs.evaluate(cx, this);
                    if (stmt.config_attrs.compileDefinition) {
                        MetaDataNode metadata;
                        Node temp3;
                        DefinitionNode def = this.startsWithDefinition(cx, stmt);
                        if (def != null) {
                            for (int m = i - 1; m >= 0; --m) {
                                temp3 = node.items.at(m);
                                if (temp3 instanceof MetaDataNode) {
                                    metadata = (MetaDataNode)temp3;
                                    metadata.def = def;
                                    def.addMetaDataNode(metadata);
                                    continue;
                                }
                                if (!(temp3 instanceof IncludeDirectiveNode) && !(temp3 instanceof EmptyStatementNode)) break;
                            }
                        }
                        if (stmt.last() instanceof MetaDataNode && (def = this.findNextDefinition(cx, node, i + 1)) != null) {
                            for (int m = stmt.items.size() - 1; m >= 0; --m) {
                                temp3 = stmt.items.at(m);
                                if (temp3 instanceof MetaDataNode) {
                                    metadata = (MetaDataNode)temp3;
                                    metadata.def = def;
                                    def.addMetaDataNode(metadata);
                                    continue;
                                }
                                if (temp3 instanceof IncludeDirectiveNode || temp3 instanceof EmptyStatementNode) {
                                    continue;
                                }
                                break;
                            }
                        }
                    } else {
                        node.items.set(i, nodeFactory.emptyStatement());
                    }
                    stmt.config_attrs = null;
                }
                if ((temp2 = this.evalAndFold(cx, n = node.items.at(i))) == n) continue;
                node.items.set(i, temp2);
                continue;
            }
            boolean old_topLevel = this.top_level;
            if (!(n instanceof StatementListNode)) {
                this.top_level = false;
            }
            if ((temp = this.evalAndFold(cx, n)) != n) {
                node.items.set(i, temp);
            }
            if (n instanceof StatementListNode) continue;
            this.top_level = old_topLevel;
        }
        return null;
    }

    private void removeMetaData(Context cx, DefinitionNode def, StatementListNode list, int def_index) {
        if (def.metaData != null) {
            NodeFactory nf = cx.getNodeFactory();
            for (int i = def_index - 1; i >= 0; --i) {
                MetaDataNode meta;
                Node temp = list.items.at(i);
                MetaDataNode metaDataNode = meta = temp instanceof MetaDataNode ? (MetaDataNode)temp : null;
                if (meta != null && meta.def == def) {
                    list.items.set(i, nf.emptyStatement());
                    meta.def = null;
                    continue;
                }
                if (!(temp instanceof IncludeDirectiveNode)) break;
            }
            def.metaData = null;
        }
    }

    private DefinitionNode findNextDefinition(Context cx, StatementListNode list, int start) {
        DefinitionNode def = null;
        int l = list.items.size();
        for (int i = start; i < l; ++i) {
            Node n = list.items.at(i);
            if (n instanceof MetaDataNode || n instanceof IncludeDirectiveNode) continue;
            if (!(n instanceof DefinitionNode)) break;
            def = (DefinitionNode)n;
            break;
        }
        return def;
    }

    private DefinitionNode startsWithDefinition(Context cx, StatementListNode list) {
        return this.findNextDefinition(cx, list, 0);
    }

    private Node evalAndFold(Context cx, Node n) {
        Value val;
        Node ret = n;
        if (n != null && (ret = this.foldRefValue(cx, val = n.evaluate(cx, this))) == null) {
            ret = n;
        }
        return ret;
    }

    private Node foldRefValue(Context cx, Value val) {
        ReferenceValue ref_val;
        Node ret = null;
        ReferenceValue referenceValue = ref_val = val instanceof ReferenceValue ? (ReferenceValue)val : null;
        if (ref_val != null && ref_val.isConfigRef()) {
            Value v = ref_val.getValue(cx);
            if (v == null) {
                cx.error(ref_val.getPosition(), 1120, ref_val.name);
            } else {
                ret = this.literalFromValue(cx, ref_val.getValue(cx));
            }
            if (ret != null) {
                ret.evaluate(cx, this);
            }
        }
        return ret;
    }

    private Node literalFromValue(Context cx, Value val) {
        LiteralStringNode ret = null;
        if (val instanceof ObjectValue) {
            ObjectValue obj_val;
            ObjectValue objectValue = obj_val = val instanceof ObjectValue ? (ObjectValue)val : null;
            if (obj_val != null) {
                Node literal_node = null;
                switch (obj_val.getType(cx).getTypeId()) {
                    case 4: {
                        literal_node = cx.getNodeFactory().literalString(obj_val.getValue());
                        break;
                    }
                    case 1: {
                        literal_node = cx.getNodeFactory().literalBoolean(obj_val.booleanValue());
                        break;
                    }
                    case 2: 
                    case 64: 
                    case 256: 
                    case 512: 
                    case 65536: {
                        literal_node = cx.getNodeFactory().literalNumber(obj_val.getValue());
                    }
                }
                ret = literal_node;
            }
        }
        return ret;
    }

    public Value evaluate(Context cx, EmptyElementNode node) {
        return null;
    }

    public Value evaluate(Context cx, EmptyStatementNode node) {
        return null;
    }

    public Value evaluate(Context cx, ExpressionStatementNode node) {
        Value val = node.expr.evaluate(cx, this);
        Node temp = this.foldRefValue(cx, val);
        if (temp != null) {
            node.expr = temp;
            val = temp.evaluate(cx, this);
        }
        return val;
    }

    public Value evaluate(Context cx, LabeledStatementNode node) {
        node.label = this.evalAndFold(cx, node.label);
        node.statement = this.evalAndFold(cx, node.statement);
        return null;
    }

    public Value evaluate(Context cx, IfStatementNode node) {
        node.condition = this.evalAndFold(cx, node.condition);
        node.thenactions = this.evalAndFold(cx, node.thenactions);
        node.elseactions = this.evalAndFold(cx, node.elseactions);
        return null;
    }

    public Value evaluate(Context cx, SwitchStatementNode node) {
        node.expr = this.evalAndFold(cx, node.expr);
        if (node.statements != null) {
            node.statements.evaluate(cx, this);
        }
        return null;
    }

    public Value evaluate(Context cx, CaseLabelNode node) {
        node.label = this.evalAndFold(cx, node.label);
        return null;
    }

    public Value evaluate(Context cx, DoStatementNode node) {
        node.expr = this.evalAndFold(cx, node.expr);
        node.statements = this.evalAndFold(cx, node.statements);
        return null;
    }

    public Value evaluate(Context cx, WhileStatementNode node) {
        node.expr = this.evalAndFold(cx, node.expr);
        node.statement = this.evalAndFold(cx, node.statement);
        return null;
    }

    public Value evaluate(Context cx, ForStatementNode node) {
        node.initialize = this.evalAndFold(cx, node.initialize);
        node.test = this.evalAndFold(cx, node.test);
        node.increment = this.evalAndFold(cx, node.increment);
        node.statement = this.evalAndFold(cx, node.statement);
        return null;
    }

    public Value evaluate(Context cx, WithStatementNode node) {
        node.expr = this.evalAndFold(cx, node.expr);
        node.statement = this.evalAndFold(cx, node.statement);
        return null;
    }

    public Value evaluate(Context cx, ContinueStatementNode node) {
        return null;
    }

    public Value evaluate(Context cx, BreakStatementNode node) {
        return null;
    }

    public Value evaluate(Context cx, ReturnStatementNode node) {
        node.expr = this.evalAndFold(cx, node.expr);
        return null;
    }

    public Value evaluate(Context cx, ThrowStatementNode node) {
        node.expr = this.evalAndFold(cx, node.expr);
        return null;
    }

    public Value evaluate(Context cx, TryStatementNode node) {
        if (node.tryblock != null) {
            node.tryblock.evaluate(cx, this);
        }
        if (node.catchlist != null) {
            node.catchlist.evaluate(cx, this);
        }
        if (node.finallyblock != null) {
            node.finallyblock.evaluate(cx, this);
        }
        return null;
    }

    public Value evaluate(Context cx, CatchClauseNode node) {
        if (node.parameter != null) {
            node.parameter = this.evalAndFold(cx, node.parameter);
        }
        if (node.statements != null) {
            node.statements.evaluate(cx, this);
        }
        return null;
    }

    public Value evaluate(Context cx, FinallyClauseNode node) {
        if (node.default_catch != null) {
            node.default_catch.evaluate(cx, this);
        }
        if (node.statements != null) {
            node.statements.evaluate(cx, this);
        }
        return null;
    }

    public Value evaluate(Context cx, UseDirectiveNode node) {
        return null;
    }

    public Value evaluate(Context cx, IncludeDirectiveNode node) {
        return null;
    }

    public Value evaluate(Context cx, ImportNode node) {
        return null;
    }

    public Value evaluate(Context cx, MetaDataNode node) {
        this.evaluate(cx, node.data);
        return null;
    }

    public Value evaluate(Context cx, DocCommentNode node) {
        return null;
    }

    public Value evaluate(Context cx, ImportDirectiveNode node) {
        return null;
    }

    public Value evaluate(Context cx, AttributeListNode node) {
        ObjectValue obj = null;
        int size = node.items.size();
        for (int i = 0; i < size; ++i) {
            Node n = node.items.at(i);
            Value val1 = n.evaluate(cx, this);
            ObjectValue objectValue = obj = val1 instanceof ObjectValue ? (ObjectValue)val1 : null;
            if (obj == null || i != size - 1 || obj.getType(cx).getTypeValue() != cx.booleanType()) continue;
            node.compileDefinition = obj.booleanValue();
            node.items.removeLast();
        }
        return null;
    }

    public Value evaluate(Context cx, VariableDefinitionNode node) {
        node.list.evaluate(cx, this);
        for (int i = node.list.items.size() - 1; i >= 0; --i) {
            Node n = node.list.items.at(i);
            if (!(n instanceof VariableBindingNode)) continue;
            VariableBindingNode var_bind = (VariableBindingNode)n;
            if (var_bind.ref == null || !var_bind.ref.isConfigRef()) continue;
            node.list.items.removeLast();
        }
        return null;
    }

    public Value evaluate(Context cx, VariableBindingNode node) {
        ReferenceValue ref;
        Value val = node.variable.identifier.evaluate(cx, this);
        ReferenceValue referenceValue = ref = val instanceof ReferenceValue ? (ReferenceValue)val : null;
        if (ref != null && ref.isConfigRef()) {
            if (!this.isTopLevel()) {
                cx.error(node.pos(), 1210);
                return null;
            }
            ObjectValue obj = cx.scope();
            Builder bui = obj.builder;
            Namespaces hasNamespaces = obj.hasNames(cx, -79, ref.name, ref.namespaces);
            if (hasNamespaces == null) {
                int var_id = bui.Variable(cx, obj);
                int slot_id = bui.ExplicitVar(cx, obj, ref.name, ref.namespaces, cx.noType(), -1, -1, var_id);
                Slot slot = obj.getSlot(cx, slot_id);
                if (node.kind != -65) {
                    cx.error(node.attrs.pos(), 1209);
                }
                slot.setConst(true);
                if (node.initializer == null) {
                    cx.error(node.pos(), 1208);
                } else {
                    boolean old_fold = this.fold_expressions;
                    this.fold_expressions = true;
                    Value init_val = node.initializer.evaluate(cx, this);
                    this.fold_expressions = old_fold;
                    if (init_val == null || !init_val.hasValue()) {
                        cx.error(node.initializer.pos(), 1208);
                    }
                    slot.setValue(init_val);
                }
                node.ref = ref;
            } else {
                cx.error(node.variable.identifier.pos(), 1151, ref.name, ((ObjectValue)ref.namespaces.at((int)0)).name);
            }
        } else {
            node.initializer = this.evalAndFold(cx, node.initializer);
        }
        return null;
    }

    public Value evaluate(Context cx, UntypedVariableBindingNode node) {
        return null;
    }

    public Value evaluate(Context cx, TypedIdentifierNode node) {
        return node.identifier.evaluate(cx, this);
    }

    public Value evaluate(Context cx, TypeExpressionNode node) {
        return null;
    }

    public Value evaluate(Context cx, FunctionDefinitionNode node) {
        node.fexpr.evaluate(cx, this);
        return null;
    }

    public Value evaluate(Context cx, BinaryFunctionDefinitionNode node) {
        return null;
    }

    public Value evaluate(Context cx, FunctionNameNode node) {
        return null;
    }

    public Value evaluate(Context cx, FunctionSignatureNode node) {
        if (node.parameter != null) {
            node.parameter.evaluate(cx, this);
        }
        if (node.result != null) {
            node.result.evaluate(cx, this);
        }
        return null;
    }

    public Value evaluate(Context cx, ParameterNode node) {
        node.init = this.evalAndFold(cx, node.init);
        return null;
    }

    public Value evaluate(Context cx, ParameterListNode node) {
        int size = node.items.size();
        for (int i = 0; i < size; ++i) {
            ParameterNode n = node.items.at(i);
            n.evaluate(cx, this);
        }
        return null;
    }

    public Value evaluate(Context cx, RestExpressionNode node) {
        return null;
    }

    public Value evaluate(Context cx, RestParameterNode node) {
        return null;
    }

    public Value evaluate(Context cx, InterfaceDefinitionNode node) {
        return this.evaluate(cx, (ClassDefinitionNode)node);
    }

    public Value evaluate(Context cx, ClassDefinitionNode node) {
        ConfigurationBuilder config_bui = new ConfigurationBuilder();
        ObjectValue scope = new ObjectValue(cx, config_bui, null);
        cx.pushScope(scope);
        if (node.statements != null) {
            node.statements.evaluate(cx, this);
        }
        cx.popScope();
        return null;
    }

    public Value evaluate(Context cx, BinaryClassDefNode node) {
        return null;
    }

    public Value evaluate(Context cx, BinaryInterfaceDefinitionNode node) {
        return null;
    }

    public Value evaluate(Context cx, ClassNameNode node) {
        return null;
    }

    public Value evaluate(Context cx, InheritanceNode node) {
        return null;
    }

    private boolean isTopLevel() {
        return this.top_level;
    }

    public Value evaluate(Context cx, ConfigNamespaceDefinitionNode node) {
        if (!this.isTopLevel()) {
            cx.error(node.pos(), 1210);
            return null;
        }
        Namespaces namespaces = new Namespaces();
        ObjectList<String> namespace_ids = new ObjectList<String>();
        namespaces.push_back(cx.publicNamespace());
        ObjectValue obj = cx.scope();
        Builder bui = obj.builder;
        int slot_id = -1;
        Namespaces hasNamespaces = obj.hasNames(cx, -79, node.name.name, namespaces);
        if (hasNamespaces == null) {
            int var_id = bui.Variable(cx, obj);
            slot_id = bui.ExplicitVar(cx, obj, node.name.name, namespaces, cx.noType(), -1, -1, var_id);
            Slot s = obj.getSlot(cx, slot_id);
            String name = cx.debugName("", node.name.name, namespace_ids, -133);
            ObjectValue ns = cx.getNamespace(name.intern(), (byte)1);
            if (ns instanceof NamespaceValue) {
                ((NamespaceValue)ns).config_ns = true;
            }
            s.setObjectValue(ns);
            s.setConst(true);
            this.config_namespaces.add(node.name.name);
        }
        return null;
    }

    public Value evaluate(Context cx, NamespaceDefinitionNode node) {
        if (this.config_namespaces.contains(node.name.name)) {
            cx.error(node.pos(), 1211, node.name.name);
        }
        return null;
    }

    public Value evaluate(Context cx, PackageDefinitionNode node) {
        return null;
    }

    public Value evaluate(Context cx, PackageIdentifiersNode node) {
        return null;
    }

    public Value evaluate(Context cx, PackageNameNode node) {
        return null;
    }

    public Value evaluate(Context cx, ProgramNode node) {
        ConfigurationBuilder config_bui = new ConfigurationBuilder();
        ObjectValue scope = new ObjectValue(cx, config_bui, null);
        cx.pushScope(scope);
        this.top_level = true;
        node.statements.evaluate(cx, this);
        this.top_level = false;
        cx.popScope();
        return null;
    }

    public Value evaluate(Context cx, BinaryProgramNode node) {
        return null;
    }

    public Value evaluate(Context cx, ErrorNode node) {
        return null;
    }

    public Value evaluate(Context cx, ToObjectNode node) {
        node.expr = this.evalAndFold(cx, node.expr);
        return null;
    }

    public Value evaluate(Context cx, LoadRegisterNode node) {
        return null;
    }

    public Value evaluate(Context cx, StoreRegisterNode node) {
        return null;
    }

    public Value evaluate(Context cx, RegisterNode node) {
        return null;
    }

    public Value evaluate(Context cx, HasNextNode node) {
        return null;
    }

    public Value evaluate(Context cx, BoxNode node) {
        node.expr = this.evalAndFold(cx, node.expr);
        return null;
    }

    public Value evaluate(Context cx, CoerceNode node) {
        node.expr = this.evalAndFold(cx, node.expr);
        return null;
    }

    public Value evaluate(Context cx, PragmaNode node) {
        node.list.evaluate(cx, this);
        return null;
    }

    public Value evaluate(Context cx, PragmaExpressionNode node) {
        return null;
    }

    public Value evaluate(Context cx, DefaultXMLNamespaceNode node) {
        return null;
    }

    public Value evaluate(Context cx, UsePrecisionNode node) {
        return null;
    }

    public Value evaluate(Context cx, UseNumericNode node) {
        return null;
    }

    public Value evaluate(Context cx, UseRoundingNode node) {
        return null;
    }
}

